/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.AddHostMgr;
import COM.ibm.raleigh.ddnssgui.client.DDNSAboutFrame;
import COM.ibm.raleigh.ddnssgui.client.DDNSConfigure;
import COM.ibm.raleigh.ddnssgui.client.DomainObjectMgr;
import COM.ibm.raleigh.ddnssgui.client.DynamicDataPropertiesFrame;
import COM.ibm.raleigh.ddnssgui.client.DynamicFileSaveFrame;
import COM.ibm.raleigh.ddnssgui.client.FileErrorsFrame;
import COM.ibm.raleigh.ddnssgui.client.FileOpenFrame;
import COM.ibm.raleigh.ddnssgui.client.FileSaveDialog;
import COM.ibm.raleigh.ddnssgui.client.FindObjectFrame;
import COM.ibm.raleigh.ddnssgui.client.HelpFrame;
import COM.ibm.raleigh.ddnssgui.client.HostObjectMgr;
import COM.ibm.raleigh.ddnssgui.client.HostRecordsFrame;
import COM.ibm.raleigh.ddnssgui.client.HostTreeView;
import COM.ibm.raleigh.ddnssgui.client.ImportDomainFrame;
import COM.ibm.raleigh.ddnssgui.client.MainFrameLayoutManager;
import COM.ibm.raleigh.ddnssgui.client.NameServerMgr;
import COM.ibm.raleigh.ddnssgui.client.PromptForReinitFrame;
import COM.ibm.raleigh.ddnssgui.client.SeparateDataFrame;
import COM.ibm.raleigh.ddnssgui.client.ServerStatusFrame;
import COM.ibm.raleigh.ddnssgui.client.SetNoHostsFrame;
import COM.ibm.raleigh.ddnssgui.client.SimplePanel;
import COM.ibm.raleigh.ddnssgui.client.TreeViewFrame;
import COM.ibm.raleigh.ddnssgui.common.BorderPanel;
import COM.ibm.raleigh.ddnssgui.common.BusyWaitFrame;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.CommandServer;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.GuiUserSettings;
import COM.ibm.raleigh.ddnssgui.common.MsgBoxListener;
import COM.ibm.raleigh.ddnssgui.common.NetworkHandler;
import COM.ibm.raleigh.ddnssgui.common.NetworkHandlerUser;
import COM.ibm.raleigh.ddnssgui.common.PasswordUser;
import COM.ibm.raleigh.ddnssgui.common.PromptForPassword;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.TcpipLocale;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

class MainFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
MsgBoxListener,
PasswordUser,
KeyListener,
NetworkHandlerUser {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int BUTTON_MOD_NS_INDEX = 0;
    private static final int BUTTON_ADD_PRI_INDEX = 1;
    private static final int BUTTON_ADD_SEC_INDEX = 2;
    private static final int BUTTON_ADD_HOST_INDEX = 3;
    private static final int BUTTON_ADD_ALIAS_INDEX = 4;
    private static final int NUM_BUTTONS = 5;
    private static final String LEFT_TREE = "left";
    private static final String RIGHT_TREE = "right";
    private static final String URL_DELIMITER = "/";
    private static final int NOTEBOOK_UP_MSG = 2;
    private static final int CONFIRM_EXIT_MSG = 3;
    private static final int CONFIRM_NET_EXCEPTION_EXIT_MSG = 4;
    private AppletContext context;
    private NameServerMgr nsView;
    private DomainObjectMgr domView;
    private HostObjectMgr hostView;
    private AddHostMgr multHostView;
    public AppletContext myContext;
    private Applet myCaller;
    public NetworkHandler dataOut;
    public TraceClient tracer;
    public ResourceBundle clientResources;
    private Font buttonFont = new Font("Helvetica", 0, 10);
    private TreeViewFrame leftSideView;
    private HostTreeView rightSideView;
    private Label RightLabel;
    private SimplePanel MainTextPanel;
    private BorderPanel mainBorder;
    private SimplePanel RightTextPanel;
    private BorderPanel rightBorder;
    private ButtonPanel toolBar;
    private String[] buttonLabels;
    private Button[] toolBarButtons;
    private int numberOfHostsToGet;
    private int expirationTime;
    private int extensionTime;
    private int nextIndexToGet;
    private MenuBar theMenu;
    private Menu fileMenu;
    private MenuItem FileNew;
    private MenuItem FileOpen;
    private MenuItem FileSave;
    private MenuItem FileExit;
    private MenuItem EditProps;
    private MenuItem EditAddPDom;
    private MenuItem EditAddSDom;
    private MenuItem EditAddHost;
    private MenuItem EditAddAlias;
    private MenuItem EditMod;
    private MenuItem EditFind;
    private MenuItem EditImport;
    private MenuItem EditDelete;
    private MenuItem ViewExp;
    private MenuItem ViewCol;
    private MenuItem ViewBoot;
    private CheckboxMenuItem ViewNone;
    private CheckboxMenuItem ViewSome;
    private CheckboxMenuItem propertyShowHost;
    private MenuItem ViewNext;
    private MenuItem ViewPrev;
    private MenuItem PropNum;
    private MenuItem menuPropertySignature;
    private MenuItem ViewSOA;
    private MenuItem ViewFileErrors;
    private MenuItem HelpCon;
    private MenuItem HelpGen;
    private MenuItem HelpUse;
    private MenuItem HelpStart;
    private MenuItem HelpInfo;
    private CheckboxMenuItem propertyTrace;
    private CheckboxMenuItem propertyWriteErrors;
    private CheckboxMenuItem propertyOverwriteWarn;
    private Menu restartServer;
    private Menu sepData;
    private CheckboxMenuItem reinitAlways;
    private CheckboxMenuItem reinitNever;
    private CheckboxMenuItem reinitPrompt;
    private CheckboxMenuItem sepDataAlways;
    private CheckboxMenuItem sepDataNever;
    private CheckboxMenuItem sepDataPrompt;
    private MenuItem stopServerItem;
    private MenuItem startServerItem;
    private MenuItem reinitServerItem;
    private MenuItem statusServerItem;
    private Menu helpMenu;
    private Menu editMenu;
    private Menu viewMenu;
    private Menu configMenu;
    private Menu propertyMenu;
    private Menu serverMenu;
    private String lastSelectedTree;
    private String lastSelectedItem;
    private String lastSelectedDomain;
    private DDNSAboutFrame aboutFrame;
    private msgBox confirmExitBox;
    private msgBox alreadyUpBox;
    private boolean msgBoxUp = false;
    private int giveFocusTo;
    private String userSpecifiedServer;
    private DDNSConfigure ncodStarted;
    private boolean exitFlag = false;
    private TcpipLocale theLocaleInUse;
    public static String theFileSeparator;

    public MainFrame(AppletContext appletContext, Applet applet) {
        this.myCaller = applet;
        this.context = appletContext;
        TcpipLocale tcpipLocale = new TcpipLocale(this.myCaller.getParameter("TCPJAVALOCALE"));
        this.initComponents(tcpipLocale);
        this.setTitle(this.clientResources.getString("APP_TITLE"));
        this.addComponentsToGrid();
        this.addComponentsToTreesView();
        this.tracer = new TraceClient("MainFrame", "entering constructor", false, this.myCaller, 7463, null);
        if (!this.tracer.isHandlerCreated()) {
            this.propertyTrace.setEnabled(false);
        }
        this.nsView = new NameServerMgr(this, this.myCaller);
        this.domView = new DomainObjectMgr(this);
        this.hostView = new HostObjectMgr(this);
        this.multHostView = new AddHostMgr(this);
        this.updMenuNothingDefined();
        this.updMenuNoViews();
        ((Component)this).setSize(Integer.parseInt(this.clientResources.getString("MAIN_FRAME_WIDTH")), Integer.parseInt(this.clientResources.getString("MAIN_FRAME_HEIGHT")));
        this.leftSideView.addComponents();
        this.userSpecifiedServer = null;
        this.ncodStarted = null;
        this.exitFlag = false;
    }

    public MainFrame(AppletContext appletContext, Applet applet, DDNSConfigure dDNSConfigure, String string) {
        this.myCaller = applet;
        this.context = appletContext;
        this.ncodStarted = dDNSConfigure;
        TcpipLocale tcpipLocale = new TcpipLocale(string);
        this.initComponents(tcpipLocale);
        this.setTitle(this.clientResources.getString("APP_TITLE"));
        this.addComponentsToGrid();
        this.addComponentsToTreesView();
        this.tracer = new TraceClient("MainFrame", "entering constructor", false, this.myCaller, 7463, null);
        if (!this.tracer.isHandlerCreated()) {
            this.propertyTrace.setEnabled(false);
        }
        this.nsView = new NameServerMgr(this, this.myCaller);
        this.domView = new DomainObjectMgr(this);
        this.hostView = new HostObjectMgr(this);
        this.multHostView = new AddHostMgr(this);
        this.updMenuNothingDefined();
        this.updMenuNoViews();
        ((Component)this).setSize(Integer.parseInt(this.clientResources.getString("MAIN_FRAME_WIDTH")), Integer.parseInt(this.clientResources.getString("MAIN_FRAME_HEIGHT")));
        this.leftSideView.addComponents();
        this.userSpecifiedServer = null;
        this.exitFlag = false;
    }

    public MainFrame(String string, TcpipLocale tcpipLocale) {
        this.myCaller = null;
        this.context = null;
        this.initComponents(tcpipLocale);
        this.setTitle(this.clientResources.getString("APP_TITLE"));
        this.addComponentsToGrid();
        this.addComponentsToTreesView();
        this.tracer = new TraceClient("MainFrame", "entering constructor", false, this.myCaller, 7463, string);
        if (!this.tracer.isHandlerCreated()) {
            this.propertyTrace.setEnabled(false);
        }
        this.nsView = new NameServerMgr(this, string);
        this.domView = new DomainObjectMgr(this);
        this.hostView = new HostObjectMgr(this);
        this.multHostView = new AddHostMgr(this);
        this.updMenuNothingDefined();
        this.updMenuNoViews();
        ((Component)this).setSize(Integer.parseInt(this.clientResources.getString("MAIN_FRAME_WIDTH")), Integer.parseInt(this.clientResources.getString("MAIN_FRAME_HEIGHT")));
        this.leftSideView.addComponents();
        this.userSpecifiedServer = string;
        this.ncodStarted = null;
        this.exitFlag = false;
    }

    public MainFrame(String string, TcpipLocale tcpipLocale, DDNSConfigure dDNSConfigure) {
        this(string, tcpipLocale);
        this.userSpecifiedServer = string;
        this.ncodStarted = dDNSConfigure;
    }

    public void init() {
        this.dataOut = new NetworkHandler(this.myCaller, this, 7462, this.tracer, this.userSpecifiedServer);
        ((Component)this).setVisible(true);
        ((Component)this).setVisible(false);
        if (this.dataOut != null && this.dataOut.socketCreated()) {
            this.dataOut.setSocketTimeout(30000);
            new PromptForPassword(this, this.clientResources.getString("PROMPT_FOR_PASSWORD"), this.clientResources.getString("APP_TITLE"), this.clientResources.getString("BUTTON_PANEL_OK"), this.clientResources.getString("BUTTON_PANEL_CANCEL"), this.dataOut.getSocket());
            return;
        }
        new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("ERROR_CONTACTING_SERVER"), 1, true, this, this);
        this.dispose();
        if (this.myCaller != null) {
            this.myCaller.stop();
            return;
        }
        if (this.ncodStarted == null) {
            System.exit(0);
            return;
        }
        this.ncodStarted.appExited();
    }

    public void init(String string, String string2) {
        this.dataOut = new NetworkHandler(this.myCaller, this, 7462, this.tracer, this.userSpecifiedServer);
        if (this.dataOut != null && this.dataOut.socketCreated()) {
            if (string != null) {
                this.dataOut.sendToServer(string);
            } else {
                this.dataOut.sendToServer("LOCAL_ONLY_ONLY");
            }
            if (string2 != null) {
                this.dataOut.sendToServer(string2);
            } else {
                this.dataOut.sendToServer("LOCAL_ONLY_ONLY");
            }
            DDNSNetworkStringParser dDNSNetworkStringParser = this.dataOut.receiveFromServer();
            if (dDNSNetworkStringParser == null) {
                new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("INVALID_PASSWORD"), 1, true, this, this);
                this.handleExit();
                return;
            }
            this.passwordValidationSucceeded();
            return;
        }
        new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("ERROR_CONTACTING_SERVER"), 1, true, this, this);
        this.dispose();
        if (this.myCaller != null) {
            this.myCaller.stop();
            return;
        }
        if (this.ncodStarted == null) {
            System.exit(0);
            return;
        }
        this.ncodStarted.appExited();
    }

    public void passwordValidationSucceeded() {
        this.dataOut.setSocketTimeout(0);
        Question question = new Question(19);
        theFileSeparator = question.getStringFromString(this.dataOut);
        this.readConfig(null);
        this.ViewSome.setState(true);
        this.HostOn();
        this.getUserSettings();
        this.sendDynamicDataProperties();
        this.expandTrees();
        ((Component)this).setVisible(true);
        this.checkForSeparateDataPrompt();
    }

    public void passwordValidationFailed() {
        new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("INVALID_PASSWORD"), 1, true, this, this);
        this.init();
    }

    public void passwordValidationCancelled() {
        this.dispose();
        if (this.myCaller != null) {
            this.myCaller.stop();
            return;
        }
        if (this.ncodStarted == null) {
            System.exit(0);
            return;
        }
        this.ncodStarted.appExited();
    }

    public void DoPrimaryDomain() {
        if (!this.domView.isShowing()) {
            this.updMenuUpdatingDomain();
            this.domView.CreateNewPrimaryDomain(this.leftSideView.getRootName());
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("DOMAIN_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 2;
        }
        this.domView.requestFocus();
    }

    public void DoSecondaryDomain() {
        if (!this.domView.isShowing()) {
            this.updMenuUpdatingDomain();
            this.domView.CreateNewSecondaryDomain(this.leftSideView.getRootName());
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("DOMAIN_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 2;
        }
        this.domView.requestFocus();
    }

    public void PrimaryDomainSelected(String string) {
        if (!this.domView.isShowing()) {
            this.updMenuUpdatingDomain();
            this.domView.UpdateExistingDomain(this.leftSideView.getRootName(), string, true);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("DOMAIN_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 2;
        }
        this.domView.requestFocus();
    }

    public void UpdateNameServer() {
        this.NameServerSelected(this.leftSideView.getRootName());
    }

    public String getNameServerName() {
        return this.leftSideView.getRootName();
    }

    public void NewDomainSelected(String string) {
        if ((this.propertyShowHost.getState() || this.ViewSome.getState()) && !string.equals(this.rightSideView.getRootName())) {
            Object[] objectArray = new Object[]{new String(string)};
            this.RightTextPanel.setText(MessageFormat.format(this.clientResources.getString("RIGHT_TREE_EXPL"), objectArray));
            this.reBuildHostTree(string, true);
        }
    }

    public void SecondaryDomainSelected(String string) {
        if (!this.domView.isShowing()) {
            this.updMenuUpdatingDomain();
            this.domView.UpdateExistingDomain(this.leftSideView.getRootName(), string, false);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("DOMAIN_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 2;
        }
        this.domView.requestFocus();
    }

    public void NameServerSelected(String string) {
        if (!this.nsView.isShowing()) {
            if (string.equals(this.clientResources.getString("LEFT_TREE_EMPTY"))) {
                this.nsView.CreateNameServer();
            } else {
                this.nsView.UpdateExistingNameServer(string);
            }
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("NAME_SERVER_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 1;
        }
        this.nsView.requestFocus();
    }

    public void requestFocus() {
        if (this.lastSelectedTree != null) {
            if (this.lastSelectedTree.equals(LEFT_TREE)) {
                this.leftSideView.requestFocus();
                return;
            }
            if (this.rightSideView != null) {
                this.rightSideView.requestFocus();
                return;
            }
            super.requestFocus();
            return;
        }
        super.requestFocus();
    }

    public void mainTreeItemSelected(String string) {
        this.rightSideView.unSelectItem();
        this.leftSideView.requestFocus();
        this.lastSelectedTree = LEFT_TREE;
        this.lastSelectedItem = new String(string);
        if (string.equals(this.clientResources.getString("PRIMARY_LABEL")) || string.equals(this.clientResources.getString("SECONDARY_LABEL")) || string.equals(this.clientResources.getString("TREE_NO_NS"))) {
            this.updMenuNoMod();
            this.updMenuNoViews();
            this.setEnabledDelete(false);
            return;
        }
        this.updMenuAllowMod();
        this.updMenuAllowViews();
        if (!string.equals(this.leftSideView.getRootName())) {
            this.setEnabledDelete(true);
            return;
        }
        this.setEnabledDelete(false);
    }

    public void hostTreeItemSelected(String string) {
        this.leftSideView.unSelectItem();
        this.rightSideView.requestFocus();
        this.lastSelectedTree = RIGHT_TREE;
        this.lastSelectedItem = new String(string);
        if (string.equals(this.clientResources.getString("TREE_NO_HOST"))) {
            this.updMenuNoMod();
            this.updMenuNoViews();
            this.setEnabledDelete(false);
            return;
        }
        this.updMenuAllowMod();
        this.updMenuAllowViews();
        this.setEnabledDelete(this.rightSideView.canDeleteSelected());
    }

    public void changed(Object object, String string) {
        if (object instanceof NameServerMgr) {
            if (!string.equals(this.leftSideView.getRootName())) {
                Object[] objectArray = new Object[]{new String(string)};
                this.MainTextPanel.setText(MessageFormat.format(this.clientResources.getString("LEFT_TREE_TITLE"), objectArray));
                this.reBuildTree(string);
            }
            this.updMenuNSDefined();
            return;
        }
        if (object instanceof DomainObjectMgr || object instanceof AddHostMgr) {
            if (this.leftSideView.IsNewToTree(string)) {
                this.reBuildTree(this.leftSideView.getRootName());
                this.expandTrees();
            }
            if ((this.propertyShowHost.getState() || this.ViewSome.getState()) && string.equals(this.rightSideView.getRootName())) {
                this.rightSideView.doTree(string, this.numberOfHostsToGet, this.nextIndexToGet);
            }
            if (object instanceof DomainObjectMgr) {
                this.updMenuDoneUpdatingDomain();
            } else {
                this.updMenuDoneUpdatingHost();
            }
        }
        if (object instanceof TreeViewFrame && (this.propertyShowHost.getState() || this.ViewSome.getState()) && string.equals(this.rightSideView.getRootName())) {
            this.reBuildHostTree(this.clientResources.getString("TREE_NO_HOST"), true);
        }
    }

    public void changed(Object object) {
        if (!(object instanceof NameServerMgr)) {
            if (object instanceof DomainObjectMgr) {
                this.updMenuDoneUpdatingDomain();
                return;
            }
            if (object instanceof HostObjectMgr || object instanceof AddHostMgr) {
                this.updMenuDoneUpdatingHost();
            }
        }
    }

    public void changed(Object object, String string, String string2) {
        if (object instanceof HostObjectMgr || object instanceof AddHostMgr) {
            if ((this.propertyShowHost.getState() || this.ViewSome.getState()) && string2.equals(this.rightSideView.getRootName())) {
                this.rightSideView.doTree(string2, this.numberOfHostsToGet, this.nextIndexToGet);
                if (this.lastSelectedTree.equals(RIGHT_TREE)) {
                    this.updMenuNoMod();
                }
            }
            if (this.leftSideView.IsNewToTree(string2)) {
                Question question = new Question(1, string2);
                if (question.getReturnedTrueOrFalse(this.dataOut)) {
                    this.leftSideView.AddPrimaryDomain(string2);
                } else {
                    this.leftSideView.AddSecondaryDomain(string2);
                }
            }
            this.updMenuDomainsDefined();
            this.updMenuDoneUpdatingHost();
        }
    }

    public void changed(Object object, String string, boolean bl) {
        String string2 = new String(this.leftSideView.getRootName());
        this.reBuildTree(string2);
        if (string.equals(this.rightSideView.getRootName())) {
            this.rightSideView.doTree(string, this.numberOfHostsToGet, this.nextIndexToGet);
        }
        this.expandTrees();
    }

    public void dispose() {
        if (this.domView != null) {
            this.domView.exit();
            this.domView = null;
        }
        if (this.hostView != null) {
            this.hostView.exit();
            this.hostView = null;
        }
        if (this.multHostView != null) {
            this.multHostView.exit();
            this.multHostView = null;
        }
        if (this.nsView != null) {
            this.nsView.exit();
            this.nsView = null;
        }
        if (this.dataOut != null) {
            this.dataOut.closeStreams();
            this.dataOut = null;
        }
        if (this.tracer != null) {
            this.TraceOff();
            this.tracer.close();
            this.tracer = null;
        }
        super.dispose();
    }

    public void AddHost() {
        if (!this.multHostView.isShowing()) {
            this.updMenuUpdatingHost();
            String string = new String(this.leftSideView.getSelected());
            this.multHostView.CreateNewHost(string);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("ADD_HOSTS_WINDOW"), 1, true, this, this, 2);
            this.giveFocusTo = 4;
        }
        this.multHostView.requestFocus();
    }

    public void AddAliasHost() {
        if (!this.hostView.isShowing()) {
            this.updMenuUpdatingHost();
            String string = new String(this.leftSideView.getSelected());
            this.hostView.CreateNewAlias(string);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("HOST_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 3;
        }
        this.hostView.requestFocus();
    }

    public void AddReverseHost(String string) {
        if (!this.hostView.isShowing()) {
            this.updMenuUpdatingHost();
            this.hostView.CreateNewReverse(string);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("HOST_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 3;
        }
        this.hostView.requestFocus();
    }

    public void HostSelected(String string) {
        this.HostSelected(string, new String(this.leftSideView.getSelected()));
    }

    public void HostSelected(String string, String string2) {
        if (!this.hostView.isShowing()) {
            this.updMenuUpdatingHost();
            this.hostView.UpdateExistingHost(string, string2);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("HOST_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 3;
        }
        this.hostView.requestFocus();
    }

    public void AliasSelected(String string) {
        this.AliasSelected(string, new String(this.leftSideView.getSelected()));
    }

    public void AliasSelected(String string, String string2) {
        if (!this.hostView.isShowing()) {
            this.updMenuUpdatingHost();
            this.hostView.UpdateExistingAlias(string, string2);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("HOST_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 3;
        }
        this.hostView.requestFocus();
    }

    public void ReverseHostSelected(String string) {
        this.ReverseHostSelected(string, new String(this.leftSideView.getSelected()));
    }

    public void ReverseHostSelected(String string, String string2) {
        if (!this.hostView.isShowing()) {
            this.updMenuUpdatingHost();
            this.hostView.UpdateExistingReverse(string, string2);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("HOST_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 3;
        }
        this.hostView.requestFocus();
    }

    public void TraceOn() {
        this.tracer.setTraceState(true);
    }

    public void TraceOff() {
        this.tracer.setTraceState(false);
    }

    public void ErrorsOn() {
        CommandServer commandServer = new CommandServer(1, true);
        commandServer.executeCommand(this.dataOut);
    }

    public void ErrorsOff() {
        CommandServer commandServer = new CommandServer(1, false);
        commandServer.executeCommand(this.dataOut);
    }

    public void sendDynamicDataProperties() {
        CommandServer commandServer = new CommandServer(3, this.expirationTime, this.extensionTime);
        commandServer.executeIntCommand(this.dataOut);
    }

    public void HostOn() {
        MainFrameLayoutManager cfr_ignored_0 = (MainFrameLayoutManager)this.getLayout();
        if (this.lastSelectedItem != null) {
            if (this.lastSelectedTree.equals(LEFT_TREE)) {
                this.lastSelectedDomain = new String(this.lastSelectedItem);
            }
            if (!(this.lastSelectedDomain.equals(this.clientResources.getString("PRIMARY_LABEL")) || this.lastSelectedDomain.equals(this.clientResources.getString("SECONDARY_LABEL")) || this.lastSelectedDomain.equals(this.leftSideView.getRootName()))) {
                this.reBuildHostTree(this.lastSelectedDomain, true);
            } else {
                this.reBuildHostTree(this.clientResources.getString("TREE_NO_HOST"), true);
            }
        } else {
            this.reBuildHostTree(this.clientResources.getString("TREE_NO_HOST"), true);
        }
        ((Component)this).setVisible(true);
    }

    public void HostOff() {
        this.remove(this.rightSideView);
        this.RightTextPanel.setText("");
        MainFrameLayoutManager mainFrameLayoutManager = (MainFrameLayoutManager)this.getLayout();
        mainFrameLayoutManager.removeHostTree();
        this.ViewNext.setEnabled(false);
        this.ViewPrev.setEnabled(false);
        ((Component)this).setVisible(true);
    }

    public void handleHelp(String string) {
        if (this.ncodStarted != null) {
            this.ncodStarted.ShowHelp(string);
            return;
        }
        if (this.context != null) {
            URL uRL = this.myCaller.getCodeBase();
            String string2 = new String(String.valueOf(uRL.toString()) + ".." + theFileSeparator + Locale.getDefault().toString() + theFileSeparator + string);
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                this.tracer.traceTime("MainFrame", "Bad URL: " + uRL);
            }
            if (uRL != null) {
                HelpFrame helpFrame = new HelpFrame(uRL);
                return;
            }
        } else {
            HelpFrame helpFrame = new HelpFrame(String.valueOf(this.getDirectory()) + theFileSeparator + ".." + theFileSeparator + "java" + theFileSeparator + Locale.getDefault().toString() + theFileSeparator + string);
        }
    }

    public void convertToAlias(String string, String string2) {
        if (!this.hostView.isShowing()) {
            this.updMenuUpdatingHost();
            String string3 = new String(this.leftSideView.getSelected());
            this.hostView.convertToAlias(string, string3);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("HOST_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 3;
        }
        this.hostView.requestFocus();
    }

    public void convertToHost(String string, String string2) {
        if (!this.hostView.isShowing()) {
            this.updMenuUpdatingHost();
            String string3 = new String(this.leftSideView.getSelected());
            this.hostView.convertToHost(string, string3);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("HOST_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 3;
        }
        this.hostView.requestFocus();
    }

    public void convertToReverse(String string, String string2) {
        if (!this.hostView.isShowing()) {
            this.updMenuUpdatingHost();
            String string3 = new String(this.leftSideView.getSelected());
            this.hostView.convertToReverse(string, string3);
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("HOST_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 3;
        }
        this.hostView.requestFocus();
    }

    public void readConfig(String string) {
        boolean bl = false;
        BusyWaitFrame busyWaitFrame = new BusyWaitFrame(this.clientResources);
        ((Component)busyWaitFrame).setSize(300, 75);
        busyWaitFrame.doLayout();
        ((Component)busyWaitFrame).setVisible(true);
        busyWaitFrame.repaint();
        busyWaitFrame.requestFocus();
        this.nothingConfigured();
        Question question = string != null ? new Question(8, string) : new Question(8);
        if (question.getReturnedTrueOrFalse(this.dataOut)) {
            RequestList requestList = new RequestList(5);
            this.dataOut.sendToServer(requestList.toString());
            DDNSNetworkStringParser dDNSNetworkStringParser = this.dataOut.receiveFromServer();
            String string2 = requestList.getName(dDNSNetworkStringParser.getParsed());
            if (string2 != null) {
                Object[] objectArray = new Object[]{new String(string2)};
                this.MainTextPanel.setText(MessageFormat.format(this.clientResources.getString("LEFT_TREE_TITLE"), objectArray));
                this.reBuildTree(string2);
                this.ViewFileErrors.setEnabled(true);
                this.FileSave.setEnabled(true);
                bl = true;
            }
        }
        if (!bl) {
            this.reBuildTree(this.clientResources.getString("TREE_NO_NS"));
            this.nsView.CreateNameServer();
        }
        busyWaitFrame.dispose();
    }

    public void setNumHosts(int n) {
        this.numberOfHostsToGet = n;
        SetNoHostsFrame.lastNumberUsed = n;
        Object[] objectArray = new Object[]{new Integer(n)};
        this.ViewSome.setLabel(MessageFormat.format(this.clientResources.getString("MENU_VIEW_SOME_HOSTS1"), objectArray));
        this.ViewNext.setLabel(MessageFormat.format(this.clientResources.getString("MENU_VIEW_NEXT_HOSTS"), objectArray));
        this.ViewPrev.setLabel(MessageFormat.format(this.clientResources.getString("MENU_VIEW_PREV_HOSTS"), objectArray));
        if (this.numberOfHostsToGet == 999999) {
            this.ViewSome.setEnabled(false);
            this.ViewNext.setEnabled(false);
            this.ViewPrev.setEnabled(false);
            this.propertyShowHost.setState(true);
            return;
        }
        this.ViewSome.setEnabled(true);
        this.ViewSome.setState(true);
        this.ViewNone.setState(false);
        this.propertyShowHost.setState(false);
    }

    public void setDynamicDataProperties(int n, int n2) {
        this.expirationTime = n;
        this.extensionTime = n2;
        this.sendDynamicDataProperties();
    }

    public void partialTreeRetrieved() {
        int n = this.rightSideView.getTotalNumber();
        int n2 = this.rightSideView.getNumberReceived();
        int n3 = this.rightSideView.getStartingPoint();
        if (n > n2) {
            if (n > n2 + n3) {
                this.ViewNext.setEnabled(true);
            } else {
                this.ViewNext.setEnabled(false);
            }
            if (n3 > 0) {
                this.ViewPrev.setEnabled(true);
            } else {
                this.ViewPrev.setEnabled(false);
            }
        } else {
            this.ViewNext.setEnabled(false);
            this.ViewPrev.setEnabled(false);
        }
        int n4 = n3;
        if (n3 == 0) {
            n4 = 1;
        }
        Object[] objectArray = new Object[]{this.rightSideView.getRootName(), new Integer(n4), new Integer(n3 + n2), new Integer(n)};
        this.RightTextPanel.setText(MessageFormat.format(this.clientResources.getString("RIGHT_TREE_TITLE"), objectArray));
        this.doLayout();
        ((Component)this).setVisible(true);
        this.repaint();
    }

    public void wholeTreeRetrieved() {
        int n = this.rightSideView.getTotalNumber();
        this.ViewNext.setEnabled(false);
        this.ViewPrev.setEnabled(false);
        if (n != 0) {
            Object[] objectArray = new Object[]{this.rightSideView.getRootName(), new Integer(1), new Integer(n), new Integer(n)};
            this.RightTextPanel.setText(MessageFormat.format(this.clientResources.getString("RIGHT_TREE_TITLE"), objectArray));
        } else {
            Object[] objectArray = new Object[]{this.rightSideView.getRootName(), new Integer(0), new Integer(n), new Integer(n)};
            this.RightTextPanel.setText(MessageFormat.format(this.clientResources.getString("RIGHT_TREE_TITLE"), objectArray));
        }
        this.doLayout();
        ((Component)this).setVisible(true);
        this.repaint();
    }

    public void doDelete() {
        if (this.lastSelectedTree.equals(LEFT_TREE)) {
            this.leftSideView.deleteSelectedObject();
            return;
        }
        this.rightSideView.deleteSelectedObject();
    }

    public void setWarnOfOverwrite(boolean bl) {
        this.propertyOverwriteWarn.setState(bl);
    }

    private void ModifySelectedItem() {
        if (this.lastSelectedTree.equals(RIGHT_TREE)) {
            if (this.lastSelectedItem.equals(this.rightSideView.getRootName())) {
                if (!this.domView.isShowing()) {
                    if (this.rightSideView.treeIsPrimary()) {
                        this.PrimaryDomainSelected(this.lastSelectedItem);
                    } else {
                        this.SecondaryDomainSelected(this.lastSelectedItem);
                    }
                } else if (!this.msgBoxUp) {
                    this.msgBoxUp = true;
                    this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("DOMAIN_NOTEBOOK"), 1, true, this, this, 2);
                    this.giveFocusTo = 2;
                }
                this.domView.requestFocus();
                return;
            }
            if (!this.hostView.isShowing()) {
                int n = this.rightSideView.getSelectedNodeType(this.lastSelectedItem);
                if (n == 1) {
                    this.HostSelected(this.lastSelectedItem);
                } else if (n == 2) {
                    this.AliasSelected(this.lastSelectedItem);
                } else if (n == 3) {
                    this.ReverseHostSelected(this.lastSelectedItem);
                }
            } else if (!this.msgBoxUp) {
                this.msgBoxUp = true;
                this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("HOST_NOTEBOOK"), 1, true, this, this, 2);
                this.giveFocusTo = 3;
            }
            this.hostView.requestFocus();
            return;
        }
        if (this.lastSelectedItem.equals(this.leftSideView.getRootName())) {
            if (!this.nsView.isShowing()) {
                this.UpdateNameServer();
            } else if (!this.msgBoxUp) {
                this.msgBoxUp = true;
                this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("NAME_SERVER_NOTEBOOK"), 1, true, this, this, 2);
                this.giveFocusTo = 1;
            }
            this.nsView.requestFocus();
            return;
        }
        if (!this.domView.isShowing()) {
            if (this.leftSideView.entryIsPrimary(this.lastSelectedItem)) {
                this.PrimaryDomainSelected(this.lastSelectedItem);
            } else {
                this.SecondaryDomainSelected(this.lastSelectedItem);
            }
        } else if (!this.msgBoxUp) {
            this.msgBoxUp = true;
            this.alreadyUpBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("DOMAIN_NOTEBOOK"), 1, true, this, this, 2);
            this.giveFocusTo = 2;
        }
        this.domView.requestFocus();
    }

    private void FindParticularItem() {
        FindObjectFrame findObjectFrame = new FindObjectFrame(this);
        findObjectFrame.getMinSize();
        ((Component)findObjectFrame).setVisible(true);
        findObjectFrame.requestFocus();
        findObjectFrame.requestFocus(0);
    }

    private void importDomainFile() {
        ImportDomainFrame importDomainFrame = new ImportDomainFrame(this);
        importDomainFrame.getMinSize();
        ((Component)importDomainFrame).setVisible(true);
        importDomainFrame.requestFocus();
        importDomainFrame.selectAll(0);
        importDomainFrame.requestFocus(0);
    }

    public void importFile(String string, String string2) {
        CommandServer commandServer = new CommandServer(8, string, string2);
        commandServer.executeImportCommand(this.dataOut);
        this.reBuildTree(this.leftSideView.getRootName());
    }

    private void doModifyNumber() {
        SetNoHostsFrame setNoHostsFrame = new SetNoHostsFrame(this);
        setNoHostsFrame.getMinSize();
        ((Component)setNoHostsFrame).setVisible(true);
        setNoHostsFrame.requestFocus();
        setNoHostsFrame.selectAll(0);
        setNoHostsFrame.requestFocus(0);
    }

    private void doDynamicDataProperties() {
        DynamicDataPropertiesFrame dynamicDataPropertiesFrame = new DynamicDataPropertiesFrame(this);
        dynamicDataPropertiesFrame.setExpirationTime(this.expirationTime);
        dynamicDataPropertiesFrame.setExtensionTime(this.extensionTime);
        dynamicDataPropertiesFrame.getMinSize();
        ((Component)dynamicDataPropertiesFrame).setVisible(true);
        dynamicDataPropertiesFrame.requestFocus();
        dynamicDataPropertiesFrame.selectAll(0);
        dynamicDataPropertiesFrame.requestFocus(0);
    }

    private void getNextSetOfHosts() {
        this.rightSideView.getTotalNumber();
        int n = this.rightSideView.getNumberReceived();
        int n2 = this.rightSideView.getStartingPoint() + n;
        this.rightSideView.doTree(this.rightSideView.getRootName(), this.numberOfHostsToGet, n2);
    }

    private void getPrevSetOfHosts() {
        this.rightSideView.getTotalNumber();
        this.rightSideView.getNumberReceived();
        int n = this.rightSideView.getStartingPoint() - this.numberOfHostsToGet;
        if (n < 0) {
            n = 0;
        }
        this.rightSideView.doTree(this.rightSideView.getRootName(), this.numberOfHostsToGet, n);
    }

    private void DoFileOpen() {
        if (this.nsView.isShowing()) {
            this.nsView.setVisible(false);
        }
        FileOpenFrame fileOpenFrame = new FileOpenFrame(this);
        fileOpenFrame.getMinSize();
        ((Component)fileOpenFrame).setVisible(true);
        fileOpenFrame.requestFocus();
        fileOpenFrame.selectAll(0);
        fileOpenFrame.requestFocus(0);
    }

    private void DoFileSave() {
        if (this.propertyOverwriteWarn.getState()) {
            FileSaveDialog fileSaveDialog = new FileSaveDialog(this);
            if (fileSaveDialog.anyFilesExist()) {
                fileSaveDialog.getMinSize();
                ((Component)fileSaveDialog).setVisible(true);
                fileSaveDialog.requestFocus();
                fileSaveDialog.requestFocus(0);
                return;
            }
            this.writeFiles();
            return;
        }
        this.writeFiles();
    }

    public void writeFiles() {
        DynamicFileSaveFrame dynamicFileSaveFrame = new DynamicFileSaveFrame(this);
        if (dynamicFileSaveFrame.anyFilesToBeWritten()) {
            dynamicFileSaveFrame.getMinSize();
            Point point = this.getLocation();
            ((Component)dynamicFileSaveFrame).setLocation(point.x + 125, point.y + 125);
            ((Component)dynamicFileSaveFrame).setVisible(true);
            dynamicFileSaveFrame.requestFocus();
            dynamicFileSaveFrame.requestFocus(0);
            return;
        }
        this.finallyDoTheSave(false);
    }

    public void finallyDoTheSave(boolean bl) {
        this.doSettingsSave();
        BusyWaitFrame busyWaitFrame = new BusyWaitFrame(this.clientResources, this.clientResources.getString("PLEASE_WAIT_SAVE"));
        ((Component)busyWaitFrame).setSize(300, 75);
        busyWaitFrame.doLayout();
        ((Component)busyWaitFrame).setVisible(true);
        busyWaitFrame.repaint();
        CommandServer commandServer = new CommandServer(4, bl);
        commandServer.executeCommand(this.dataOut);
        busyWaitFrame.dispose();
        if (this.reinitAlways.getState()) {
            commandServer = new CommandServer(7, true);
            commandServer.executeCommand(this.dataOut);
            this.checkToExit();
            return;
        }
        if (this.reinitPrompt.getState()) {
            PromptForReinitFrame promptForReinitFrame = new PromptForReinitFrame(this);
            ((Component)promptForReinitFrame).setSize(350, 100);
            promptForReinitFrame.doLayout();
            ((Component)promptForReinitFrame).setVisible(true);
            promptForReinitFrame.requestFocus();
            promptForReinitFrame.requestFocus(0);
            return;
        }
        this.checkToExit();
    }

    private void queryNameServerStatus() {
        ServerStatusFrame serverStatusFrame = new ServerStatusFrame(this);
        serverStatusFrame.getMinSize();
        serverStatusFrame.doLayout();
        ((Component)serverStatusFrame).setVisible(true);
        serverStatusFrame.requestFocus();
        serverStatusFrame.requestFocus(0);
    }

    public void restartTheServer() {
        CommandServer commandServer = new CommandServer(7, true);
        commandServer.executeCommand(this.dataOut);
        this.checkToExit();
    }

    public void startTheServer() {
        CommandServer commandServer = new CommandServer(6, true);
        commandServer.executeCommand(this.dataOut);
    }

    public void stopTheServer() {
        CommandServer commandServer = new CommandServer(5, true);
        commandServer.executeCommand(this.dataOut);
    }

    public void checkToExit() {
        if (this.exitFlag) {
            this.handleExit();
        }
    }

    public TcpipLocale getTcpipLocale() {
        return this.theLocaleInUse;
    }

    private void initComponents(TcpipLocale tcpipLocale) {
        this.theLocaleInUse = tcpipLocale;
        this.clientResources = ResourceBundle.getBundle("COM.ibm.raleigh.ddnssgui.client.DDNSclientResources", TcpipLocale.getLocale());
        this.createMenuItems();
        this.createMenu();
        this.buttonLabels = new String[5];
        this.buttonLabels[0] = this.clientResources.getString("BUTTON_MOD_NS");
        this.buttonLabels[1] = this.clientResources.getString("BUTTON_ADD_PRI");
        this.buttonLabels[2] = this.clientResources.getString("BUTTON_ADD_SEC");
        this.buttonLabels[3] = this.clientResources.getString("BUTTON_ADD_HOST");
        this.buttonLabels[4] = this.clientResources.getString("BUTTON_ADD_ALIAS");
        this.leftSideView = new TreeViewFrame(this.clientResources.getString("TREE_NO_NS"), this, this.myCaller);
        this.initButtonPanel();
        this.MainTextPanel = new SimplePanel(this.clientResources.getString("TREE_NO_NS"));
        this.RightTextPanel = new SimplePanel(this.clientResources.getString("RIGHT_TREE_EMPTY"));
        this.mainBorder = new BorderPanel(Color.black, 1);
        this.mainBorder.setBackground(Color.lightGray);
        this.rightBorder = new BorderPanel(Color.black, 1);
        this.rightBorder.setBackground(Color.lightGray);
        this.addWindowListener(this);
    }

    private void addComponentsToTreesView() {
        this.add(this.MainTextPanel);
        this.add(this.RightTextPanel);
        this.add(this.mainBorder);
        this.add(this.rightBorder);
    }

    private void addComponentsToGrid() {
        MainFrameLayoutManager mainFrameLayoutManager = new MainFrameLayoutManager(this.toolBar, this.MainTextPanel, this.RightTextPanel, this.leftSideView, this.mainBorder, this.rightBorder);
        this.setLayout(mainFrameLayoutManager);
        this.add(this.toolBar);
    }

    private void initButtonPanel() {
        int n = this.buttonLabels.length;
        this.toolBarButtons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.toolBarButtons[n2] = new Button(this.buttonLabels[n2]);
            this.toolBarButtons[n2].addKeyListener(this);
            this.toolBarButtons[n2].addActionListener(this);
            ++n2;
        }
        this.toolBar = new ButtonPanel(this, this.toolBarButtons);
        this.toolBar.setButtonFont(this.buttonFont);
    }

    private void reBuildTree(String string) {
        MainFrameLayoutManager mainFrameLayoutManager = (MainFrameLayoutManager)this.getLayout();
        this.remove(this.leftSideView);
        mainFrameLayoutManager.removeMainTree();
        this.leftSideView = new TreeViewFrame(string, this, this.myCaller);
        this.add(this.leftSideView);
        mainFrameLayoutManager.addMainTree(this.leftSideView);
        this.leftSideView.addComponents();
        if (this.lastSelectedTree != null && this.lastSelectedTree.equals(LEFT_TREE)) {
            this.updMenuNoMod();
        }
        if (!string.equals(this.MainTextPanel.getText())) {
            RequestList requestList = new RequestList(1);
            String[] stringArray = requestList.getReturnedList(this.clientResources, this.dataOut);
            this.leftSideView.AddAllPrimaryDomains(stringArray);
            requestList = new RequestList(2);
            this.leftSideView.AddAllSecondaryDomains(requestList.getReturnedList(this.clientResources, this.dataOut));
            requestList = new RequestList(3);
            stringArray = requestList.getReturnedList(this.clientResources, this.dataOut);
            if (stringArray != null) {
                this.updMenuPDomainsDefined();
            }
            this.updMenuNSDefined();
        }
        this.doLayout();
        ((Component)this).setVisible(true);
    }

    private void reBuildHostTree(String string, boolean bl) {
        this.ViewPrev.setEnabled(false);
        this.ViewNext.setEnabled(false);
        if (string.equals(this.clientResources.getString("TREE_NO_HOST"))) {
            this.RightTextPanel.setText(this.clientResources.getString("RIGHT_TREE_EMPTY"));
        }
        MainFrameLayoutManager mainFrameLayoutManager = (MainFrameLayoutManager)this.getLayout();
        if (bl && this.rightSideView != null) {
            this.remove(this.rightSideView);
            mainFrameLayoutManager.removeHostTree();
        }
        Question question = new Question(1, string);
        if (this.lastSelectedTree != null && this.lastSelectedTree.equals(RIGHT_TREE)) {
            this.updMenuNoMod();
        }
        this.rightSideView = question.getReturnedTrueOrFalse(this.dataOut) ? new HostTreeView(string, this, this.myCaller, true) : new HostTreeView(string, this, this.myCaller, false);
        this.add(this.rightSideView);
        mainFrameLayoutManager.addHostTree(this.rightSideView);
        this.rightSideView.addComponents();
        if (!string.equals(this.clientResources.getString("TREE_NO_HOST"))) {
            this.rightSideView.doTree(string, this.numberOfHostsToGet, this.nextIndexToGet);
        }
        ((Component)this).setVisible(true);
    }

    private void createMenu() {
        this.fileMenu = new Menu(this.clientResources.getString("MENU_FILE"));
        this.editMenu = new Menu(this.clientResources.getString("MENU_EDIT"));
        this.helpMenu = new Menu(this.clientResources.getString("MENU_HELP"));
        this.viewMenu = new Menu(this.clientResources.getString("MENU_VIEW"));
        this.configMenu = new Menu(this.clientResources.getString("MENU_CONFIGURE"));
        this.propertyMenu = new Menu(this.clientResources.getString("MENU_EDIT_PROPERTIES"));
        this.restartServer = new Menu(this.clientResources.getString("MENU_PROPERTIES_REINIT_SERVER"));
        this.sepData = new Menu(this.clientResources.getString("MENU_PROPERTIES_SEP_DATA"));
        this.serverMenu = new Menu(this.clientResources.getString("MENU_SERVER"));
        this.fileMenu.add(this.FileNew);
        this.fileMenu.add(this.FileOpen);
        this.fileMenu.add(this.FileSave);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.FileExit);
        this.FileNew.addActionListener(this);
        this.FileOpen.addActionListener(this);
        this.FileSave.addActionListener(this);
        this.FileExit.addActionListener(this);
        this.editMenu.add(this.propertyMenu);
        this.editMenu.add(this.EditDelete);
        this.editMenu.add(this.EditFind);
        this.configMenu.add(this.EditMod);
        this.configMenu.add(this.EditImport);
        this.configMenu.addSeparator();
        this.configMenu.add(this.EditAddPDom);
        this.configMenu.add(this.EditAddSDom);
        this.configMenu.add(this.EditAddHost);
        this.configMenu.add(this.EditAddAlias);
        this.EditDelete.addActionListener(this);
        this.EditMod.addActionListener(this);
        this.EditFind.addActionListener(this);
        this.EditImport.addActionListener(this);
        this.EditAddPDom.addActionListener(this);
        this.EditAddSDom.addActionListener(this);
        this.EditAddHost.addActionListener(this);
        this.EditAddAlias.addActionListener(this);
        this.viewMenu.add(this.ViewExp);
        this.viewMenu.add(this.ViewCol);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.ViewNone);
        this.viewMenu.add(this.propertyShowHost);
        this.viewMenu.add(this.ViewSome);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.ViewNext);
        this.viewMenu.add(this.ViewPrev);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.ViewBoot);
        this.viewMenu.add(this.ViewSOA);
        this.viewMenu.add(this.ViewFileErrors);
        this.ViewExp.addActionListener(this);
        this.ViewCol.addActionListener(this);
        this.ViewNext.addActionListener(this);
        this.ViewPrev.addActionListener(this);
        this.ViewBoot.addActionListener(this);
        this.ViewSOA.addActionListener(this);
        this.ViewFileErrors.addActionListener(this);
        this.ViewSome.addItemListener(this);
        this.ViewNone.addItemListener(this);
        this.propertyShowHost.addItemListener(this);
        this.helpMenu.add(this.HelpCon);
        this.helpMenu.add(this.HelpGen);
        this.helpMenu.add(this.HelpStart);
        this.helpMenu.add(this.HelpUse);
        this.helpMenu.add(this.HelpInfo);
        this.HelpCon.addActionListener(this);
        this.HelpGen.addActionListener(this);
        this.HelpStart.addActionListener(this);
        this.HelpUse.addActionListener(this);
        this.HelpInfo.addActionListener(this);
        this.propertyMenu.add(this.propertyWriteErrors);
        this.propertyMenu.add(this.propertyOverwriteWarn);
        this.propertyMenu.add(this.PropNum);
        this.propertyMenu.add(this.menuPropertySignature);
        this.propertyMenu.add(this.restartServer);
        this.propertyMenu.add(this.sepData);
        this.propertyMenu.add(this.propertyTrace);
        this.PropNum.addActionListener(this);
        this.menuPropertySignature.addActionListener(this);
        this.propertyWriteErrors.addItemListener(this);
        this.propertyTrace.addItemListener(this);
        this.aboutFrame = new DDNSAboutFrame(this);
        this.theMenu = new MenuBar();
        this.theMenu.add(this.fileMenu);
        this.theMenu.add(this.editMenu);
        this.theMenu.add(this.configMenu);
        this.theMenu.add(this.serverMenu);
        this.theMenu.add(this.viewMenu);
        this.theMenu.add(this.helpMenu);
        this.restartServer.add(this.reinitAlways);
        this.restartServer.add(this.reinitNever);
        this.restartServer.add(this.reinitPrompt);
        this.reinitAlways.addItemListener(this);
        this.reinitNever.addItemListener(this);
        this.reinitPrompt.addItemListener(this);
        this.serverMenu.add(this.stopServerItem);
        this.serverMenu.add(this.startServerItem);
        this.serverMenu.add(this.reinitServerItem);
        this.serverMenu.add(this.statusServerItem);
        this.stopServerItem.addActionListener(this);
        this.startServerItem.addActionListener(this);
        this.reinitServerItem.addActionListener(this);
        this.statusServerItem.addActionListener(this);
        this.sepData.add(this.sepDataAlways);
        this.sepData.add(this.sepDataNever);
        this.sepData.add(this.sepDataPrompt);
        this.sepDataAlways.addItemListener(this);
        this.sepDataNever.addItemListener(this);
        this.sepDataPrompt.addItemListener(this);
        this.setMenuBar(this.theMenu);
        this.EditAddPDom.setEnabled(false);
        this.EditAddSDom.setEnabled(false);
        this.EditAddHost.setEnabled(false);
        this.EditAddAlias.setEnabled(false);
        this.ViewFileErrors.setEnabled(false);
        this.setEnabledDelete(false);
        this.setWarnOfOverwrite(true);
        this.reinitAlways.setState(true);
        this.sepDataPrompt.setState(true);
    }

    public void nothingConfigured() {
        this.updMenuNoDomains();
        this.updMenuNoMod();
        this.FileSave.setEnabled(false);
        this.EditImport.setEnabled(false);
        this.EditFind.setEnabled(false);
    }

    private void updMenuNoDomains() {
        this.EditAddPDom.setEnabled(false);
        this.EditAddSDom.setEnabled(false);
        this.EditAddHost.setEnabled(false);
        this.EditAddAlias.setEnabled(false);
        this.toolBar.setEnabled(false, this.toolBarButtons[1]);
        this.toolBar.setEnabled(false, this.toolBarButtons[2]);
        this.toolBar.setEnabled(false, this.toolBarButtons[3]);
        this.toolBar.setEnabled(false, this.toolBarButtons[4]);
        this.EditFind.setEnabled(false);
    }

    private void updMenuNothingDefined() {
        this.toolBar.setEnabled(false, this.toolBarButtons[0]);
        this.EditMod.setEnabled(false);
        this.EditFind.setEnabled(false);
        this.updMenuNoDomains();
    }

    private void updMenuNSDefined() {
        this.updMenuDomainsDefined();
        this.FileSave.setEnabled(true);
        this.EditImport.setEnabled(true);
    }

    private void updMenuDomainsDefined() {
        if (!this.domView.isShowing()) {
            this.EditAddPDom.setEnabled(true);
            this.EditAddSDom.setEnabled(true);
            this.toolBar.setEnabled(true, this.toolBarButtons[1]);
            this.toolBar.setEnabled(true, this.toolBarButtons[2]);
            this.EditFind.setEnabled(true);
        }
    }

    private void updMenuPDomainsDefined() {
        this.updMenuDomainsDefined();
        if (!this.hostView.isShowing()) {
            this.EditAddAlias.setEnabled(true);
            this.toolBar.setEnabled(true, this.toolBarButtons[4]);
        }
        if (!this.multHostView.isShowing()) {
            this.EditAddHost.setEnabled(true);
            this.toolBar.setEnabled(true, this.toolBarButtons[3]);
        }
    }

    private void updMenuUpdatingDomain() {
        this.toolBar.setEnabled(false, this.toolBarButtons[1]);
        this.toolBar.setEnabled(false, this.toolBarButtons[2]);
        this.EditAddPDom.setEnabled(false);
        this.EditAddSDom.setEnabled(false);
    }

    private void updMenuDoneUpdatingDomain() {
        this.updMenuDomainsDefined();
    }

    private void updMenuUpdatingHost() {
        this.EditAddHost.setEnabled(false);
        this.EditAddAlias.setEnabled(false);
        this.toolBar.setEnabled(false, this.toolBarButtons[3]);
        this.toolBar.setEnabled(false, this.toolBarButtons[4]);
    }

    private void updMenuDoneUpdatingHost() {
        this.EditAddHost.setEnabled(true);
        this.EditAddAlias.setEnabled(true);
        this.toolBar.setEnabled(true, this.toolBarButtons[3]);
        this.toolBar.setEnabled(true, this.toolBarButtons[4]);
    }

    private void updMenuAllowMod() {
        this.toolBar.setEnabled(true, this.toolBarButtons[0]);
        this.EditMod.setEnabled(true);
    }

    private void updMenuNoMod() {
        this.toolBar.setEnabled(false, this.toolBarButtons[0]);
        this.EditMod.setEnabled(false);
    }

    private void setEnabledDelete(boolean bl) {
        this.EditDelete.setEnabled(bl);
    }

    private void updMenuAllowViews() {
        if (this.lastSelectedTree.equals(LEFT_TREE)) {
            if (!this.lastSelectedItem.equals(this.leftSideView.getRootName())) {
                this.ViewSOA.setEnabled(true);
                return;
            }
            this.ViewBoot.setEnabled(true);
            return;
        }
        if (this.lastSelectedItem.equals(this.rightSideView.getRootName())) {
            this.ViewSOA.setEnabled(true);
        }
        this.ViewBoot.setEnabled(false);
    }

    private void updMenuNoViews() {
        this.ViewBoot.setEnabled(false);
        this.ViewSOA.setEnabled(false);
    }

    private void handleCheckbox(CheckboxMenuItem checkboxMenuItem) {
        if (checkboxMenuItem == this.ViewSome) {
            this.ViewSome.setEnabled(true);
            this.ViewSome.setState(true);
            this.propertyShowHost.setState(false);
            this.ViewNone.setState(false);
            this.numberOfHostsToGet = SetNoHostsFrame.lastNumberUsed;
            this.HostOn();
            return;
        }
        if (checkboxMenuItem == this.ViewNone) {
            this.ViewNone.setState(true);
            this.ViewNext.setEnabled(false);
            this.ViewPrev.setEnabled(false);
            this.propertyShowHost.setState(false);
            this.ViewSome.setState(false);
            this.numberOfHostsToGet = 0;
            this.HostOff();
            return;
        }
        if (checkboxMenuItem == this.propertyShowHost) {
            this.propertyShowHost.setState(true);
            this.ViewNext.setEnabled(false);
            this.ViewPrev.setEnabled(false);
            this.ViewNone.setState(false);
            this.ViewSome.setState(false);
            this.numberOfHostsToGet = 999999;
            this.HostOn();
            return;
        }
        if (checkboxMenuItem == this.propertyTrace) {
            if (this.propertyTrace.isEnabled()) {
                if (this.propertyTrace.getState()) {
                    this.TraceOn();
                    return;
                }
                this.TraceOff();
                return;
            }
        } else {
            if (checkboxMenuItem == this.propertyWriteErrors) {
                if (this.propertyWriteErrors.getState()) {
                    this.ErrorsOn();
                    return;
                }
                this.ErrorsOff();
                return;
            }
            if (checkboxMenuItem == this.reinitAlways) {
                this.reinitNever.setState(false);
                this.reinitPrompt.setState(false);
                return;
            }
            if (checkboxMenuItem == this.reinitNever) {
                this.reinitAlways.setState(false);
                this.reinitPrompt.setState(false);
                return;
            }
            if (checkboxMenuItem == this.reinitPrompt) {
                this.reinitAlways.setState(false);
                this.reinitNever.setState(false);
                return;
            }
            if (checkboxMenuItem == this.sepDataAlways) {
                this.sepDataNever.setState(false);
                this.sepDataPrompt.setState(false);
                return;
            }
            if (checkboxMenuItem == this.sepDataNever) {
                this.sepDataAlways.setState(false);
                this.sepDataPrompt.setState(false);
                return;
            }
            if (checkboxMenuItem == this.sepDataPrompt) {
                this.sepDataAlways.setState(false);
                this.sepDataNever.setState(false);
            }
        }
    }

    private void clearConfig() {
        CommandServer commandServer = new CommandServer(2, true);
        commandServer.executeCommand(this.dataOut);
        this.updMenuNothingDefined();
        this.updMenuNoViews();
        this.setEnabledDelete(false);
        this.FileSave.setEnabled(false);
        this.MainTextPanel.setText(this.clientResources.getString("TREE_NO_NS"));
        this.RightTextPanel.setText(this.clientResources.getString("RIGHT_TREE_EMPTY"));
        this.reBuildTree(this.clientResources.getString("LEFT_TREE_EMPTY"));
        this.reBuildHostTree(this.clientResources.getString("TREE_NO_NS"), true);
        this.nsView.CreateNameServer();
    }

    private void getUserSettings() {
        this.dataOut.sendToServer("USRSET=GET,EUSRSET,");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.dataOut.receiveFromServer();
        GuiUserSettings guiUserSettings = new GuiUserSettings(dDNSNetworkStringParser.getParsed());
        this.propertyWriteErrors.setState(guiUserSettings.getWriteErrorsToFile());
        this.propertyOverwriteWarn.setState(guiUserSettings.getWarnBeforeOverwrite());
        this.numberOfHostsToGet = guiUserSettings.getNumberToShow();
        this.setNumHosts(this.numberOfHostsToGet);
        this.expirationTime = guiUserSettings.getSigLease();
        this.extensionTime = guiUserSettings.getSigPad();
        this.reinitAlways.setState(false);
        this.reinitNever.setState(false);
        this.reinitPrompt.setState(false);
        if (guiUserSettings.getReinitServer() == 1) {
            this.reinitAlways.setState(true);
        } else if (guiUserSettings.getReinitServer() == 2) {
            this.reinitNever.setState(true);
        } else if (guiUserSettings.getReinitServer() == 3) {
            this.reinitPrompt.setState(true);
        }
        this.sepDataAlways.setState(false);
        this.sepDataNever.setState(false);
        this.sepDataPrompt.setState(false);
        if (guiUserSettings.getSepData() == 1) {
            this.sepDataAlways.setState(true);
            return;
        }
        if (guiUserSettings.getSepData() == 2) {
            this.sepDataNever.setState(true);
            return;
        }
        if (guiUserSettings.getSepData() == 3) {
            this.sepDataPrompt.setState(true);
        }
    }

    private void doSettingsSave() {
        GuiUserSettings guiUserSettings = new GuiUserSettings();
        guiUserSettings.setWriteErrorsToFile(this.propertyWriteErrors.getState());
        guiUserSettings.setWarnBeforeOverwrite(this.propertyOverwriteWarn.getState());
        guiUserSettings.setNumberToShow(this.numberOfHostsToGet);
        guiUserSettings.setSigLease(this.expirationTime);
        guiUserSettings.setSigPad(this.extensionTime);
        if (this.reinitAlways.getState()) {
            guiUserSettings.setReinitServer(1);
        } else if (this.reinitNever.getState()) {
            guiUserSettings.setReinitServer(2);
        } else if (this.reinitPrompt.getState()) {
            guiUserSettings.setReinitServer(3);
        }
        if (this.sepDataAlways.getState()) {
            guiUserSettings.setSepData(1);
        } else if (this.sepDataNever.getState()) {
            guiUserSettings.setSepData(2);
        } else if (this.sepDataPrompt.getState()) {
            guiUserSettings.setSepData(3);
        }
        this.dataOut.sendToServer(guiUserSettings.toString("SAV"));
        this.dataOut.receiveFromServer();
    }

    private void checkForSeparateDataPrompt() {
        if (this.sepDataPrompt.getState()) {
            SeparateDataFrame separateDataFrame = new SeparateDataFrame(this);
            if (separateDataFrame.anyDomainsExist()) {
                separateDataFrame.getMinSize();
                ((Component)separateDataFrame).setVisible(true);
                separateDataFrame.requestFocus();
                separateDataFrame.requestFocus(0);
                return;
            }
        } else if (this.sepDataAlways.getState()) {
            this.separateDomainData();
        }
    }

    public void separateDomainData() {
        CommandServer commandServer = new CommandServer(9, true);
        commandServer.executeCommand(this.dataOut);
    }

    public void expandTrees() {
        this.leftSideView.expandAllTree();
        if (this.propertyShowHost.getState() || this.ViewSome.getState()) {
            this.rightSideView.expandAllTree();
        }
    }

    public void handleButton(Button button) {
        if (button == this.toolBarButtons[0]) {
            this.ModifySelectedItem();
        }
        if (button == this.toolBarButtons[1]) {
            this.DoPrimaryDomain();
        }
        if (button == this.toolBarButtons[3]) {
            this.AddHost();
        }
        if (button == this.toolBarButtons[2]) {
            this.DoSecondaryDomain();
        }
        if (button == this.toolBarButtons[4]) {
            this.AddAliasHost();
        }
    }

    private void handleMenuItem(MenuItem menuItem) {
        if (menuItem == this.EditAddPDom) {
            this.DoPrimaryDomain();
            return;
        }
        if (menuItem == this.EditAddSDom) {
            this.DoSecondaryDomain();
            return;
        }
        if (menuItem == this.EditAddHost) {
            this.AddHost();
            return;
        }
        if (menuItem == this.EditAddAlias) {
            this.AddAliasHost();
            return;
        }
        if (menuItem == this.EditMod) {
            this.ModifySelectedItem();
            return;
        }
        if (menuItem == this.EditFind) {
            this.FindParticularItem();
            return;
        }
        if (menuItem == this.EditImport) {
            this.importDomainFile();
            return;
        }
        if (menuItem == this.ViewBoot) {
            HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.clientResources);
            hostRecordsFrame.showBootFileData(this.leftSideView.getRootName(), this);
            return;
        }
        if (menuItem == this.ViewFileErrors) {
            FileErrorsFrame fileErrorsFrame = new FileErrorsFrame(this);
            fileErrorsFrame.getMinSize();
            ((Component)fileErrorsFrame).setVisible(true);
            fileErrorsFrame.requestFocus();
            return;
        }
        if (menuItem == this.ViewSOA) {
            if (this.leftSideView.entryIsPrimary(this.lastSelectedItem)) {
                HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.clientResources);
                hostRecordsFrame.showPrimarySOAData(this.lastSelectedItem, this, this.leftSideView.getRootName());
                return;
            }
            HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.clientResources);
            hostRecordsFrame.showSecondarySOAData(this.lastSelectedItem, this, this.leftSideView.getRootName());
            return;
        }
        if (menuItem == this.PropNum) {
            this.doModifyNumber();
            return;
        }
        if (menuItem == this.menuPropertySignature) {
            this.doDynamicDataProperties();
            return;
        }
        if (menuItem == this.FileOpen) {
            this.DoFileOpen();
            return;
        }
        if (menuItem == this.EditDelete) {
            this.doDelete();
            return;
        }
        if (menuItem == this.FileNew) {
            this.clearConfig();
            return;
        }
        if (menuItem == this.ViewNext) {
            this.getNextSetOfHosts();
            return;
        }
        if (menuItem == this.ViewPrev) {
            this.getPrevSetOfHosts();
            return;
        }
        if (menuItem == this.FileSave) {
            this.doSettingsSave();
            this.DoFileSave();
            return;
        }
        if (menuItem == this.HelpCon) {
            this.handleHelp("ddscmst.htm");
            return;
        }
        if (menuItem == this.HelpGen) {
            this.handleHelp("ddscwnm.htm#HDRWNM");
            return;
        }
        if (menuItem == this.HelpUse) {
            this.handleHelp("ddsctsk.htm#HDRTASKS");
            return;
        }
        if (menuItem == this.HelpStart) {
            this.handleHelp("ddscint.htm#HDRINTRO");
            return;
        }
        if (menuItem == this.HelpInfo) {
            this.aboutFrame.getMinSize();
            ((Component)this.aboutFrame).setVisible(true);
            this.aboutFrame.requestFocus();
            this.aboutFrame.requestFocus(0);
            return;
        }
        if (menuItem == this.ViewExp) {
            this.expandTrees();
            return;
        }
        if (menuItem == this.ViewCol) {
            this.leftSideView.collapseAllTree();
            if (this.propertyShowHost.getState() || this.ViewSome.getState()) {
                this.rightSideView.collapseAllTree();
            }
            return;
        }
        if (menuItem == this.FileExit) {
            this.exitApp();
            return;
        }
        if (menuItem == this.stopServerItem) {
            this.stopTheServer();
            return;
        }
        if (menuItem == this.startServerItem) {
            this.startTheServer();
            return;
        }
        if (menuItem == this.reinitServerItem) {
            this.restartTheServer();
            return;
        }
        if (menuItem == this.statusServerItem) {
            this.queryNameServerStatus();
        }
    }

    private void handleExit() {
        this.doSettingsSave();
        this.immediateExit();
    }

    private void immediateExit() {
        ((Component)this).setVisible(false);
        this.dispose();
        if (this.myCaller != null) {
            this.myCaller.stop();
            return;
        }
        if (this.ncodStarted == null) {
            System.exit(0);
            return;
        }
        this.ncodStarted.appExited();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
            return;
        }
        if (object instanceof MenuItem) {
            this.handleMenuItem((MenuItem)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof CheckboxMenuItem) {
            this.handleCheckbox((CheckboxMenuItem)itemSelectable);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doSettingsSave();
        this.confirmExitBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("CONFIRM_EXPLANATION_TEXT"), 2, true, this, this, 3);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void msgBoxSelection(int n, int n2) {
        if (n == 2) {
            this.msgBoxUp = false;
            if (this.giveFocusTo == 1) {
                this.nsView.requestFocus();
            } else if (this.giveFocusTo == 2) {
                this.domView.requestFocus();
            } else if (this.giveFocusTo == 3) {
                this.hostView.requestFocus();
            } else if (this.giveFocusTo == 4) {
                this.multHostView.requestFocus();
            }
            this.alreadyUpBox = null;
        }
        if (n == 3) {
            if (n2 == 3) {
                this.handleExit();
            } else if (n2 == 2) {
                if (!this.leftSideView.getRootName().equals(this.clientResources.getString("TREE_NO_NS"))) {
                    this.exitFlag = true;
                }
                this.DoFileSave();
            }
        }
        if (n == 4) {
            this.immediateExit();
        }
    }

    private void createMenuItems() {
        this.FileNew = new MenuItem(this.clientResources.getString("MENU_FILE_NEW"));
        this.FileOpen = new MenuItem(this.clientResources.getString("MENU_FILE_OPEN"));
        this.FileSave = new MenuItem(this.clientResources.getString("MENU_FILE_SAVE"));
        this.FileExit = new MenuItem(this.clientResources.getString("MENU_FILE_EXIT"));
        this.EditProps = new MenuItem(this.clientResources.getString("MENU_EDIT_PROPERTIES"));
        this.EditAddPDom = new MenuItem(this.clientResources.getString("MENU_EDIT_ADD_PRI"));
        this.EditAddSDom = new MenuItem(this.clientResources.getString("MENU_EDIT_ADD_SEC"));
        this.EditAddHost = new MenuItem(this.clientResources.getString("MENU_EDIT_ADD_HOST"));
        this.EditAddAlias = new MenuItem(this.clientResources.getString("MENU_EDIT_ADD_ALIAS"));
        this.EditMod = new MenuItem(this.clientResources.getString("MENU_EDIT_UPDATE_DOMAIN"));
        this.EditFind = new MenuItem(this.clientResources.getString("MENU_EDIT_FIND"));
        this.EditImport = new MenuItem(this.clientResources.getString("MENU_CONFIGURE_LOAD_DOM_FROM_FILE"));
        this.EditDelete = new MenuItem(this.clientResources.getString("MENU_EDIT_DELETE"));
        this.ViewExp = new MenuItem(this.clientResources.getString("MENU_VIEW_EXPAND"));
        this.ViewCol = new MenuItem(this.clientResources.getString("MENU_VIEW_COLLAPSE"));
        this.ViewBoot = new MenuItem(this.clientResources.getString("MENU_VIEW_BOOT_DATA"));
        this.ViewNone = new CheckboxMenuItem(this.clientResources.getString("MENU_VIEW_ZERO_HOSTS"));
        Object[] objectArray = new Object[]{new Integer(100)};
        this.ViewSome = new CheckboxMenuItem(MessageFormat.format(this.clientResources.getString("MENU_VIEW_SOME_HOSTS1"), objectArray));
        this.propertyShowHost = new CheckboxMenuItem(this.clientResources.getString("MENU_PROPERTIES_HOST"));
        this.ViewNext = new MenuItem(MessageFormat.format(this.clientResources.getString("MENU_VIEW_NEXT_HOSTS"), objectArray));
        this.ViewPrev = new MenuItem(MessageFormat.format(this.clientResources.getString("MENU_VIEW_PREV_HOSTS"), objectArray));
        this.PropNum = new MenuItem(this.clientResources.getString("MENU_PROPERTIES_NUM"));
        this.menuPropertySignature = new MenuItem(this.clientResources.getString("MENU_PROPERTIES_SIGNATURE"));
        this.ViewSOA = new MenuItem(this.clientResources.getString("MENU_VIEW_SOA"));
        this.ViewFileErrors = new MenuItem(this.clientResources.getString("MENU_VIEW_FILE_ERRORS"));
        this.HelpCon = new MenuItem(this.clientResources.getString("MENU_HELP_CON"));
        this.HelpGen = new MenuItem(this.clientResources.getString("MENU_HELP_GEN"));
        this.HelpUse = new MenuItem(this.clientResources.getString("MENU_HELP_USE"));
        this.HelpStart = new MenuItem(this.clientResources.getString("MENU_HELP_START"));
        this.HelpInfo = new MenuItem(this.clientResources.getString("MENU_HELP_INFO"));
        this.propertyTrace = new CheckboxMenuItem(this.clientResources.getString("MENU_PROPERTIES_TRACE"));
        this.propertyWriteErrors = new CheckboxMenuItem(this.clientResources.getString("MENU_PROPERTIES_WRITE_ERRORS"));
        this.propertyOverwriteWarn = new CheckboxMenuItem(this.clientResources.getString("MENU_PROPERTIES_WARN_OVERWRITE"));
        this.reinitAlways = new CheckboxMenuItem(this.clientResources.getString("MENU_REINIT_ALWAYS"));
        this.reinitNever = new CheckboxMenuItem(this.clientResources.getString("MENU_REINIT_NEVER"));
        this.reinitPrompt = new CheckboxMenuItem(this.clientResources.getString("MENU_REINIT_PROMPT_ME"));
        this.sepDataAlways = new CheckboxMenuItem(this.clientResources.getString("MENU_REINIT_ALWAYS"));
        this.sepDataNever = new CheckboxMenuItem(this.clientResources.getString("MENU_REINIT_NEVER"));
        this.sepDataPrompt = new CheckboxMenuItem(this.clientResources.getString("MENU_REINIT_PROMPT_ME"));
        this.stopServerItem = new MenuItem(this.clientResources.getString("MENU_SERVER_STOP"));
        this.startServerItem = new MenuItem(this.clientResources.getString("MENU_SERVER_START"));
        this.reinitServerItem = new MenuItem(this.clientResources.getString("MENU_SERVER_REINIT"));
        this.statusServerItem = new MenuItem(this.clientResources.getString("MENU_SERVER_STATUS"));
    }

    private String getDirectory() {
        try {
            String string = System.getProperty("java.class.path");
            string = string.toLowerCase();
            String string2 = System.getProperty("path.separator");
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.endsWith("ddnssgui.jar")) continue;
                int n = string3.lastIndexOf("ddnssgui.jar");
                try {
                    return string3.substring(0, n - 1);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return ".";
                }
            }
        }
        catch (SecurityException securityException) {
            return ".";
        }
        return ".";
    }

    public void exitApp() {
        this.doSettingsSave();
        this.confirmExitBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("CONFIRM_EXPLANATION_TEXT"), 2, true, this, this, 3);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void networkExceptionOccurred(Exception exception) {
        this.confirmExitBox = new msgBox(this.clientResources, this.clientResources.getString("APP_TITLE"), this.clientResources.getString("CONFIRM_NET_ERROR_EXPLANATION_TEXT"), 1, true, this, this, 4);
        this.immediateExit();
    }

    public Frame getFrame() {
        return this;
    }
}

