/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.DomainCfgPanel;
import COM.ibm.raleigh.ddnssgui.client.DomainObjectMgr;
import COM.ibm.raleigh.ddnssgui.client.DomainOptionsPanel;
import COM.ibm.raleigh.ddnssgui.client.PrimaryNotifyServersPanel;
import COM.ibm.raleigh.ddnssgui.client.TTLPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.ChildNameServerListPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.ListPanelGrid;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.MailExchangeListPanel;
import COM.ibm.raleigh.ddnssgui.common.NameAndIPListPanel;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.ResourceBundle;

class PrimaryDomainFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
TabViewEventListener,
ListPanelUser,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int FIRST_FIELD = 0;
    public static final int DOMAIN_NAME_FIELD = 0;
    public static final int DOMAIN_FILE_NAME_FIELD = 1;
    public static final int STATIC_FILE_NAME_FIELD = 2;
    private static final int TABVIEW_DOMAIN_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int TABVIEW_NAME_SERVERS_INDEX = 1;
    private static final int TABVIEW_NOTIFY_SERVERS_INDEX = 2;
    private static final int TABVIEW_CHILD_SERVERS_INDEX = 3;
    private static final int TABVIEW_OPTIONS_INDEX = 4;
    private static final int TABVIEW_MAIL_INDEX = 5;
    private static final int TABVIEW_FILES_INDEX = 6;
    private static final int TABVIEW_TTL_INDEX = 7;
    private static final int NUM_TABS = 8;
    private static final int CHILD_ROWS = 2;
    private static final int CHILD_COLUMNS = 2;
    private static final int NUM_LIST_ROWS = 4;
    private static final int NUM_BUTTONS = 3;
    private static final int NUM_TEXT_COLUMNS = 20;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private DomainObjectMgr parent;
    private ResourceBundle resources;
    private boolean selectTabForError = false;
    private DomainCfgPanel cfgPanel;
    private NameAndIPListPanel nameServersPanel;
    private PrimaryNotifyServersPanel notifyServersPanel;
    private ChildNameServerListPanel childServersPanel;
    private DomainOptionsPanel optionsPanel;
    private MailExchangeListPanel mailExchangePanel;
    private Panel filePanel;
    private WrappedTextPanel domainFileTextPanel;
    private Label domainFileLabel;
    private TextField domainFileName;
    private Checkbox separateData;
    private Label staticFileLabel;
    private TextField staticFile;
    private Panel ttlPanel;
    private WrappedTextPanel ttlExplanation;
    private Label domainDefaultLabel;
    private TTLPanel soaTTLPanel;
    private TTLPanel nsTTLPanel;
    private TTLPanel mxTTLPanel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);
    private msgBox requiredBox;
    private msgBox invalidDomainNameBox;
    private msgBox invalidOptionBox;

    public PrimaryDomainFrame(DomainObjectMgr domainObjectMgr) {
        this.setResizable(false);
        this.parent = domainObjectMgr;
        this.resources = this.parent.MyParent.clientResources;
        this.setTitle(this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
        this.selectTabForError = false;
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void selectFirstTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[0]);
        }
    }

    public void selectDomainOptionsTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[4]);
        }
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.cfgPanel.requestFocus(0);
                return;
            }
            case 1: {
                this.domainFileName.requestFocus();
                return;
            }
            case 2: {
                this.staticFile.requestFocus();
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                this.cfgPanel.selectAll(0);
                return;
            }
            case 1: {
                this.domainFileName.selectAll();
                return;
            }
            case 2: {
                this.staticFile.selectAll();
                return;
            }
        }
    }

    public String getFullyQualifiedDomainName() {
        return this.cfgPanel.getFullyQualifiedDomainName();
    }

    public void setFullyQualifiedDomainName(String string) {
        if (string != null) {
            this.cfgPanel.setFullyQualifiedDomainName(string);
            String string2 = this.getFullyQualifiedDomainName();
            this.setTitle(String.valueOf(this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME")) + " -- " + string2);
            this.childServersPanel.setDomainName(string2);
        }
    }

    public void setEnabledDomainName(boolean bl) {
        this.cfgPanel.setEnabledDomainName(bl);
    }

    public int getDomainType() {
        return this.cfgPanel.getDomainType();
    }

    public void setDomainType(int n) {
        this.cfgPanel.setDomainType(n);
    }

    public void handleDomainType() {
        int n = this.getDomainType();
        if (n == 1) {
            this.notifyServersPanel.setEnabledDynamicNotifyOptions(true);
            this.separateData.setEnabled(true);
            if (this.getSeparateDataState()) {
                this.setEnabledStaticFile(true);
                return;
            }
        } else if (n == 2) {
            this.notifyServersPanel.setEnabledDynamicNotifyOptions(false);
            this.separateData.setEnabled(false);
            this.setSeparateDataState(false);
        }
    }

    public String getAdminMailAddress() {
        return this.cfgPanel.getAdminMailAddress();
    }

    public void setAdminMailAddress(String string) {
        if (string != null) {
            this.cfgPanel.setAdminMailAddress(string);
        }
    }

    public NameAndIpAddress getNameServer() {
        return this.nameServersPanel.getNameAndIP();
    }

    public void setNameServer(NameAndIpAddress nameAndIpAddress) {
        if (nameAndIpAddress != null) {
            this.nameServersPanel.setNameAndIP(nameAndIpAddress);
        }
    }

    public NameAndIpAddressList getNameServerList() {
        return this.nameServersPanel.getNameAndIPList();
    }

    public void setNameServerList(NameAndIpAddressList nameAndIpAddressList) {
        this.nameServersPanel.removeAll();
        if (nameAndIpAddressList != null) {
            this.nameServersPanel.setNameAndIPList(nameAndIpAddressList);
        }
    }

    public boolean getNotify() {
        return this.notifyServersPanel.getNotifyState();
    }

    public void setNotify(boolean bl) {
        this.notifyServersPanel.setNotifyState(bl);
    }

    public String getNotifyServer() {
        return this.notifyServersPanel.getNotifyServer();
    }

    public void setNotifyServer(String string) {
        if (string != null) {
            this.notifyServersPanel.setNotifyServer(string);
        }
    }

    public String[] getNotifyServerList() {
        return this.notifyServersPanel.getNotifyServerList();
    }

    public void setNotifyServerList(String[] stringArray) {
        this.notifyServersPanel.setNotifyServerList(stringArray);
    }

    public int getNotifyRetryTime() {
        return this.notifyServersPanel.getRetryTime();
    }

    public void setNotifyRetryTime(int n) {
        this.notifyServersPanel.setRetryTime(n);
    }

    public int getNotifyNumRetries() {
        return this.notifyServersPanel.getNumRetries();
    }

    public void setNotifyNumRetries(int n) {
        this.notifyServersPanel.setNumRetries(n);
    }

    public int getNotifyDelayTime() {
        return this.notifyServersPanel.getDelayTime();
    }

    public void setNotifyDelayTime(int n) {
        this.notifyServersPanel.setDelayTime(n);
    }

    public boolean getAutoReverseMapState() {
        return this.optionsPanel.getAutoReverseMapState();
    }

    public void setAutoReverseMapState(boolean bl) {
        this.optionsPanel.setAutoReverseMapState(bl);
    }

    public int getUpdateTime() {
        return this.notifyServersPanel.getUpdateTime();
    }

    public void setUpdateTime(int n) {
        this.notifyServersPanel.setUpdateTime(n);
    }

    public int getUpdateCount() {
        return this.notifyServersPanel.getUpdateCount();
    }

    public void setUpdateCount(int n) {
        this.notifyServersPanel.setUpdateCount(n);
    }

    public void setSerialNumber(int n) {
        this.optionsPanel.setSerialNumber(n);
    }

    public int getRefreshRate() {
        return this.optionsPanel.getRefreshRate();
    }

    public void setRefreshRate(int n) {
        this.optionsPanel.setRefreshRate(n);
    }

    public int getRetryInterval() {
        return this.optionsPanel.getRetryInterval();
    }

    public void setRetryInterval(int n) {
        this.optionsPanel.setRetryInterval(n);
    }

    public int getExpireTime() {
        return this.optionsPanel.getExpireTime();
    }

    public void setExpireTime(int n) {
        this.optionsPanel.setExpireTime(n);
    }

    public int getDefaultTTL() {
        return this.optionsPanel.getDefaultTTL();
    }

    public void setDefaultTTL(int n) {
        this.optionsPanel.setDefaultTTL(n);
        this.handleDefaultTTL();
    }

    public String getDomainFileName() {
        return this.domainFileName.getText().trim();
    }

    public void setDomainFileName(String string) {
        if (string != null) {
            ((TextComponent)this.domainFileName).setText(string.trim());
        }
    }

    public boolean getSeparateDataState() {
        return this.separateData.getState();
    }

    public void setSeparateDataState(boolean bl) {
        this.separateData.setState(bl);
        this.checkStaticFileEnablement();
    }

    public String getStaticFileName() {
        return this.staticFile.getText().trim();
    }

    public void setStaticFileName(String string) {
        ((TextComponent)this.staticFile).setText(string.trim());
        String string2 = this.getStaticFileName();
        this.checkStaticFileEnablement(string2);
    }

    public String getMailHost() {
        return this.mailExchangePanel.getMailHost();
    }

    public void setMailHost(String string) {
        this.mailExchangePanel.setMailHost(string);
    }

    public int getMailPreference() {
        return this.mailExchangePanel.getMailPreference();
    }

    public void setMailPreference(String string) {
        this.mailExchangePanel.setMailPreference(string);
    }

    public String[] getMailList() {
        return this.mailExchangePanel.getMailList();
    }

    public void setMailList(String[] stringArray) {
        this.mailExchangePanel.removeAll();
        this.mailExchangePanel.setMailList(stringArray);
    }

    public int getSOATTL() {
        return this.soaTTLPanel.getTTL();
    }

    public void setSOATTL(int n) {
        this.soaTTLPanel.setTTL(n);
    }

    public int getNSTTL() {
        return this.nsTTLPanel.getTTL();
    }

    public void setNSTTL(int n) {
        this.nsTTLPanel.setTTL(n);
    }

    public int getMXTTL() {
        return this.mxTTLPanel.getTTL();
    }

    public void setMXTTL(int n) {
        this.mxTTLPanel.setTTL(n);
    }

    public Enumeration getChildNameServers() {
        return this.childServersPanel.getServerList();
    }

    public void setChildNameServers(Enumeration enumeration) {
        this.childServersPanel.setServerList(enumeration);
    }

    public void setEnabled(boolean bl) {
        this.cfgPanel.setEnabled(bl);
        this.nameServersPanel.setEnabled(bl);
        this.notifyServersPanel.setEnabled(bl);
        this.childServersPanel.setEnabled(bl);
        this.optionsPanel.setEnabled(bl);
        this.mailExchangePanel.setEnabled(bl);
        this.filePanel.setEnabled(bl);
        this.ttlPanel.setEnabled(bl);
    }

    public void setEnabledButtons(boolean bl) {
        if (bl) {
            this.enableOK();
            this.enableCancel();
            this.enableHelp();
            return;
        }
        this.disableOK();
        this.disableCancel();
        this.disableHelp();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.cfgPanel = new DomainCfgPanel(this, this.resources);
        this.nameServersPanel = new NameAndIPListPanel(this, this.resources, this.resources.getString("NAME_SERVERS_TITLE"), 4, this.resources.getString("NAME_SERVERS_TEXT"));
        this.nameServersPanel.setMultipleMode(false);
        this.notifyServersPanel = new PrimaryNotifyServersPanel(this, this.resources);
        BitSet bitSet = new BitSet(4);
        bitSet.set(0);
        bitSet.set(2);
        bitSet.set(3);
        ListPanelGrid listPanelGrid = new ListPanelGrid(2, 2, bitSet);
        this.childServersPanel = new ChildNameServerListPanel(this, this.resources, 4, listPanelGrid);
        this.mailExchangePanel = new MailExchangeListPanel(this, this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), 4);
        this.optionsPanel = new DomainOptionsPanel(this, this.resources);
        this.filePanel = new Panel();
        this.domainFileTextPanel = new WrappedTextPanel(this.resources.getString("DOMAIN_FILE_EXPLANATION"));
        this.domainFileLabel = new Label(this.resources.getString("DOMAIN_FILE_LABEL"), 0);
        this.domainFileName = new TextField("", 20);
        this.separateData = new Checkbox(this.resources.getString("SEPARATE_DATA_LABEL"));
        this.separateData.addItemListener(this);
        this.separateData.addKeyListener(this);
        this.staticFileLabel = new Label(this.resources.getString("STATIC_FILE_LABEL"), 0);
        this.staticFile = new TextField("", 20);
        this.setSeparateDataState(false);
        this.ttlPanel = new Panel();
        this.ttlExplanation = new WrappedTextPanel(this.resources.getString("PDF_TTL_EXPLANATION_LABEL"));
        Object[] objectArray = new Object[]{new Integer(-1)};
        this.domainDefaultLabel = new Label(MessageFormat.format(this.resources.getString("DOMAIN_DEFAULT_TTL_VALUE_LABEL"), objectArray), 0);
        this.soaTTLPanel = new TTLPanel(this.resources, this.resources.getString("SOA_TTL_LABEL"));
        this.nsTTLPanel = new TTLPanel(this.resources, this.resources.getString("NS_TTL_LABEL"));
        this.mxTTLPanel = new TTLPanel(this.resources, this.resources.getString("MX_TTL_LABEL"));
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("PDF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("PDF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.tabView.addTabViewEventListener((TabViewEventListener)this);
        this.createTabs();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        int n = this.domainFileTextPanel.getNumDividedTextLines();
        int n2 = this.ttlExplanation.getNumDividedTextLines();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        this.filePanel.setLayout(gridBagLayout2);
        this.constrain(this.domainFileTextPanel, gridBagLayout2, gridBagConstraints2, 0, 0, 0, n);
        this.filePanel.add(this.domainFileTextPanel);
        this.constrain(this.domainFileLabel, gridBagLayout2, gridBagConstraints2, 0, n, 1, 1);
        this.filePanel.add(this.domainFileLabel);
        gridBagConstraints2.fill = 2;
        this.constrain(this.domainFileName, gridBagLayout2, gridBagConstraints2, 1, n, 1, 1);
        this.filePanel.add(this.domainFileName);
        gridBagConstraints2.fill = 0;
        this.constrain(this.separateData, gridBagLayout2, gridBagConstraints2, 0, 1 + n, 0, 1);
        this.filePanel.add(this.separateData);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        this.constrain(this.staticFileLabel, gridBagLayout2, gridBagConstraints2, 0, 2 + n, 1, 1);
        this.filePanel.add(this.staticFileLabel);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        this.constrain(this.staticFile, gridBagLayout2, gridBagConstraints2, 1, 2 + n, 0, 1);
        this.filePanel.add(this.staticFile);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        this.ttlPanel.setLayout(gridBagLayout2);
        this.constrain(this.ttlExplanation, gridBagLayout2, gridBagConstraints2, 0, 0, 0, n2);
        this.ttlPanel.add(this.ttlExplanation);
        gridBagConstraints2.fill = 2;
        this.constrain(this.domainDefaultLabel, gridBagLayout2, gridBagConstraints2, 0, n2, 0, 1);
        this.ttlPanel.add(this.domainDefaultLabel);
        this.constrain(this.soaTTLPanel, gridBagLayout2, gridBagConstraints2, 0, 1 + n2, 0, 1);
        this.ttlPanel.add(this.soaTTLPanel);
        this.constrain(this.nsTTLPanel, gridBagLayout2, gridBagConstraints2, 0, 2 + n2, 0, 1);
        this.ttlPanel.add(this.nsTTLPanel);
        this.constrain(this.mxTTLPanel, gridBagLayout2, gridBagConstraints2, 0, 3 + n2, 0, 1);
        this.ttlPanel.add(this.mxTTLPanel);
        this.add((Component)this.tabView, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 1);
    }

    private boolean checkRequiredFields() {
        boolean bl = false;
        String string = new String(this.getFullyQualifiedDomainName());
        if (string != null && string.length() > 0) {
            bl = true;
        }
        return bl;
    }

    private void enableOK() {
        this.buttonPanel.setEnabled(true, this.buttons[0]);
    }

    private void disableOK() {
        this.buttonPanel.setEnabled(false, this.buttons[0]);
    }

    private void enableCancel() {
        this.buttonPanel.setEnabled(true, this.buttons[1]);
    }

    private void disableCancel() {
        this.buttonPanel.setEnabled(false, this.buttons[1]);
    }

    private void enableHelp() {
        this.buttonPanel.setEnabled(true, this.buttons[2]);
    }

    private void disableHelp() {
        this.buttonPanel.setEnabled(false, this.buttons[2]);
    }

    public void handleButton(Button button) {
        NameAndIpAddress nameAndIpAddress;
        int n;
        if (button == this.buttons[0]) {
            n = this.checkRequiredFields();
            if (n == 1 && this.validateFields()) {
                this.parent.SaveAndExit(this);
            } else if (n == 0) {
                this.tabView.selectTab(this.tabNodes[0]);
                this.requiredBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("REQUIRED_BOX_TEXT"), 1, true, this);
            }
        }
        if (button == this.buttons[1]) {
            this.parent.CancelAndExit(this);
        }
        if (button == this.buttons[2]) {
            n = this.tabView.getSelectedTab().getId();
            if (n == 0) {
                this.parent.MyParent.handleHelp("ddscnbpc.htm#HDRNBPTC");
            } else if (n == 1) {
                this.parent.MyParent.handleHelp("ddscnbps.htm#HDRNBPTS");
            } else if (n == 2) {
                this.parent.MyParent.handleHelp("ddscnbpn.htm#HDRNBPTN");
            } else if (n == 3) {
                this.parent.MyParent.handleHelp("ddscnbph.htm#HDRNBPTH");
            } else if (n == 4) {
                this.parent.MyParent.handleHelp("ddscnbpo.htm#HDRNBPTO");
            } else if (n == 5) {
                this.parent.MyParent.handleHelp("ddscnbpm.htm#HDRNBPTM");
            } else if (n == 6) {
                this.parent.MyParent.handleHelp("ddscnbpf.htm#HDRNBPTF");
            } else if (n == 7) {
                this.parent.MyParent.handleHelp("ddscnbpt.htm#HDRNBPTT");
            } else {
                this.parent.MyParent.handleHelp("ddscnbp.htm#HDRNBP");
            }
        }
        if (button == this.cfgPanel.getDynamicOptionsButton()) {
            this.parent.DynamicOptionsSelected();
        }
        if (button == this.nameServersPanel.getAddButton()) {
            NameAndIpAddress nameAndIpAddress2 = this.nameServersPanel.getNameAndIP(this.nameServersPanel.getItemCount() - 1);
            this.notifyServersPanel.addNotifyServer(nameAndIpAddress2.getIpAddress());
        }
        if (button == this.nameServersPanel.getRemoveButton() && this.nameServersPanel.getNumDuplicateAddrs(nameAndIpAddress = this.nameServersPanel.getRemovedNameAndIP()) < 1) {
            this.notifyServersPanel.removeNotifyServer(nameAndIpAddress.getIpAddress());
        }
    }

    private void handleCheckbox(Checkbox checkbox) {
        boolean bl = checkbox.getState();
        if (checkbox == this.separateData) {
            if (bl) {
                this.setEnabledStaticFile(true);
                return;
            }
            this.setSeparateDataState(false);
        }
    }

    private boolean validateFields() {
        boolean bl = true;
        if (!TcpipValidation.IsValidFQTcpipName(this.getFullyQualifiedDomainName())) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidDomainNameBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_DOMAIN_NAME_TEXT"), 1, true, this);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        }
        if (bl && !this.optionsPanel.validateRefreshRate()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[4]);
            this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_REFRESH_RATE_TEXT"), 1, true, this);
            this.optionsPanel.selectAll(1);
            this.optionsPanel.requestFocus(1);
            bl = false;
        }
        if (bl && !this.optionsPanel.validateRetryInterval()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[4]);
            this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_RETRY_INTERVAL_TEXT"), 1, true, this);
            this.optionsPanel.selectAll(2);
            this.optionsPanel.requestFocus(2);
            bl = false;
        }
        if (bl && !this.optionsPanel.validateExpireTime()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[4]);
            this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("PDF_INVALID_EXPIRE_TIME_TEXT"), 1, true, this);
            this.optionsPanel.selectAll(3);
            this.optionsPanel.requestFocus(3);
            bl = false;
        }
        if (bl && !this.optionsPanel.validateDefaultTTL()) {
            this.informUserOfInvalidDefaultTTL();
            bl = false;
        }
        if (this.getNotify()) {
            if (bl && !this.notifyServersPanel.validateRetryTime()) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[2]);
                this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_RETRY_TIME_TEXT"), 1, true, this);
                this.notifyServersPanel.selectAll(2);
                this.notifyServersPanel.requestFocus(2);
                bl = false;
            }
            if (bl && !this.notifyServersPanel.validateNumRetries()) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[2]);
                this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_NUM_RETRIES_TEXT"), 1, true, this);
                this.notifyServersPanel.selectAll(3);
                this.notifyServersPanel.requestFocus(3);
                bl = false;
            }
            if (bl && !this.notifyServersPanel.validateDelayTime()) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[2]);
                this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_DELAY_TIME_TEXT"), 1, true, this);
                this.notifyServersPanel.selectAll(4);
                this.notifyServersPanel.requestFocus(4);
                bl = false;
            }
            if (this.getDomainType() == 1) {
                if (bl && !this.notifyServersPanel.validateUpdateTime()) {
                    this.selectTabForError = true;
                    this.tabView.selectTab(this.tabNodes[2]);
                    this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_UPDATE_TIME_TEXT"), 1, true, this);
                    this.notifyServersPanel.selectAll(5);
                    this.notifyServersPanel.requestFocus(5);
                    bl = false;
                }
                if (bl && !this.notifyServersPanel.validateUpdateCount()) {
                    this.selectTabForError = true;
                    this.tabView.selectTab(this.tabNodes[2]);
                    this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_UPDATE_COUNT_TEXT"), 1, true, this);
                    this.notifyServersPanel.selectAll(6);
                    this.notifyServersPanel.requestFocus(6);
                    bl = false;
                }
            }
        }
        if (bl && !this.soaTTLPanel.isValidTTL()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[7]);
            this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_SOA_TTL_TEXT"), 1, true, this);
            this.soaTTLPanel.selectAll(0);
            this.soaTTLPanel.requestFocus(0);
            bl = false;
        }
        if (bl && !this.nsTTLPanel.isValidTTL()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[7]);
            this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_NS_TTL_TEXT"), 1, true, this);
            this.nsTTLPanel.selectAll(0);
            this.nsTTLPanel.requestFocus(0);
            bl = false;
        }
        if (bl && !this.mxTTLPanel.isValidTTL()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[7]);
            this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_MX_TTL_TEXT"), 1, true, this);
            this.mxTTLPanel.selectAll(0);
            this.mxTTLPanel.requestFocus(0);
            bl = false;
        }
        if (bl && !this.validateDomainFileName()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[6]);
            this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_DOMAIN_FILE_NAME_TEXT"), 1, true, this);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        }
        if (bl && this.getSeparateDataState() && !this.validateStaticFileName()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[6]);
            this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_STATIC_FILE_NAME_TEXT"), 1, true, this);
            this.selectAll(2);
            this.requestFocus(2);
            bl = false;
        }
        return bl;
    }

    private int getNumber(String string) {
        if (TcpipValidation.IsLessThanMaxIntegerValue(string)) {
            try {
                Integer n = new Integer(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    private void informUserOfInvalidDefaultTTL() {
        this.selectTabForError = true;
        this.tabView.selectTab(this.tabNodes[4]);
        this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_DEFAULT_TTL_TEXT"), 1, true, this);
        this.optionsPanel.selectAll(4);
        this.optionsPanel.requestFocus(4);
    }

    private void handleDefaultTTL() {
        if (this.optionsPanel.validateDefaultTTL()) {
            int n = this.getDefaultTTL();
            Object[] objectArray = new Object[]{new Integer(n)};
            this.domainDefaultLabel.setText(MessageFormat.format(this.resources.getString("DOMAIN_DEFAULT_TTL_VALUE_LABEL"), objectArray));
            return;
        }
        if (this.tabView.getSelectedTab().getId() != 4) {
            this.informUserOfInvalidDefaultTTL();
        }
    }

    private boolean validateDomainFileName() {
        boolean bl = true;
        if (this.getDomainFileName().compareTo("") == 0) {
            bl = false;
        }
        return bl;
    }

    private boolean validateStaticFileName() {
        boolean bl = true;
        if (this.getStaticFileName().compareTo("") == 0) {
            bl = false;
        }
        return bl;
    }

    protected void setNotifyList() {
        this.parent.setNotifyList();
    }

    private void checkStaticFileEnablement() {
        if (!this.getSeparateDataState()) {
            this.setEnabledStaticFile(false);
            return;
        }
        this.setEnabledStaticFile(true);
    }

    private void checkStaticFileEnablement(String string) {
        if (!this.getSeparateDataState()) {
            if (string != null && string.compareTo("") == 0) {
                this.setEnabledStaticFile(false);
                return;
            }
            this.setEnabledStaticFile(true);
            return;
        }
        this.setEnabledStaticFile(true);
    }

    private void setEnabledStaticFile(boolean bl) {
        this.staticFileLabel.setEnabled(bl);
        this.staticFile.setEnabled(bl);
        if (!bl) {
            ((Component)this.staticFile).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            return;
        }
        ((Component)this.staticFile).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[8];
        int n = 0;
        while (n < 8) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_DOMAIN_CFG_LABEL"));
        this.tabNodes[0].setPanel((Panel)this.cfgPanel);
        this.tabNodes[1].setText(this.resources.getString("TABVIEW_NAME_SERVERS_LABEL"));
        this.tabNodes[1].setPanel((Panel)this.nameServersPanel);
        this.tabNodes[2].setText(this.resources.getString("TABVIEW_NOTIFY_SERVERS_LABEL"));
        this.tabNodes[2].setPanel((Panel)this.notifyServersPanel);
        this.tabNodes[3].setText(this.resources.getString("TABVIEW_CHILD_SERVERS_LABEL"));
        this.tabNodes[3].setPanel((Panel)this.childServersPanel);
        this.tabNodes[4].setText(this.resources.getString("TABVIEW_OPTIONS_LABEL"));
        this.tabNodes[4].setPanel((Panel)this.optionsPanel);
        this.tabNodes[5].setText(this.resources.getString("TABVIEW_MAIL_LABEL"));
        this.tabNodes[5].setPanel((Panel)this.mailExchangePanel);
        this.tabNodes[6].setText(this.resources.getString("TABVIEW_FILES_LABEL"));
        this.tabNodes[6].setPanel(this.filePanel);
        this.tabNodes[7].setText(this.resources.getString("PDF_TABVIEW_TTL_LABEL"));
        this.tabNodes[7].setPanel(this.ttlPanel);
        int n = 0;
        while (n < 8) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof Checkbox) {
            this.handleCheckbox((Checkbox)itemSelectable);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.CancelAndExit(this);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public boolean preTabSelected(TabView tabView, TabViewNode tabViewNode) {
        this.optionsPanel.setAutoReverseMapState(this.optionsPanel.getAutoReverseMapState());
        String string = this.getFullyQualifiedDomainName();
        if (string.compareTo("") == 0) {
            this.setTitle(this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME"));
        } else {
            this.setTitle(String.valueOf(this.resources.getString("PRIMARY_DOMAIN_FRAME_NAME")) + " -- " + string);
        }
        this.childServersPanel.setDomainName(string);
        this.childServersPanel.setSubdomainName(string);
        return true;
    }

    public void postTabSelected(TabView tabView, TabViewNode tabViewNode) {
        if (!this.selectTabForError) {
            if (tabViewNode == this.tabNodes[0]) {
                this.selectAll(0);
                this.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[1]) {
                this.nameServersPanel.selectAll(0);
                this.nameServersPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[2]) {
                this.notifyServersPanel.selectAll(0);
                this.notifyServersPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[3]) {
                this.childServersPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[4]) {
                this.optionsPanel.selectAll(0);
                this.optionsPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[5]) {
                this.mailExchangePanel.selectAll(0);
                this.mailExchangePanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[6]) {
                this.domainFileName.selectAll();
                this.domainFileName.requestFocus();
                return;
            }
            if (tabViewNode == this.tabNodes[7]) {
                this.soaTTLPanel.selectAll(0);
                this.soaTTLPanel.requestFocus(0);
                return;
            }
            this.selectAll(0);
            this.requestFocus(0);
            return;
        }
        this.selectTabForError = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object instanceof Button) {
                this.handleButton((Button)object);
                return;
            }
            if (object instanceof Checkbox) {
                Checkbox checkbox;
                checkbox.setState(!(checkbox = (Checkbox)object).getState());
                this.handleCheckbox(checkbox);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

