/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.NotifyServersPanel;
import COM.ibm.raleigh.ddnssgui.client.PrimaryDomainFrame;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

class PrimaryNotifyServersPanel
extends NotifyServersPanel
implements ItemListener {
    public static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String appVersion = "Dynamic IP Version 1.0";
    public static final String modVersion = "This Class Version 1.0";
    public static final int UPDATE_TIME_FIELD = 5;
    public static final int UPDATE_COUNT_FIELD = 6;
    private static final int NUM_LIST_ROWS = 4;
    private static final int NUM_TEXT_COLUMNS = 10;
    private ResourceBundle resources;
    private PrimaryDomainFrame parent;
    private Label dynamicSerialLabel;
    private Label updateTimeLabel;
    private TextField updateTime;
    private Label updateCountLabel;
    private TextField updateCount;

    public PrimaryNotifyServersPanel(PrimaryDomainFrame primaryDomainFrame, ResourceBundle resourceBundle) {
        super(resourceBundle);
        this.parent = primaryDomainFrame;
        this.resources = resourceBundle;
        this.initComponents();
        this.addComponentsToGrid();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof Checkbox) {
            this.handleCheckbox((Checkbox)itemSelectable);
        }
    }

    public void requestFocus(int n) {
        switch (n) {
            case 5: {
                this.updateTime.requestFocus();
                return;
            }
            case 6: {
                this.updateCount.requestFocus();
                return;
            }
        }
        super.requestFocus(n);
    }

    public void selectAll(int n) {
        switch (n) {
            case 5: {
                if (!this.updateTime.isEnabled()) break;
                this.updateTime.selectAll();
                return;
            }
            case 6: {
                if (!this.updateCount.isEnabled()) break;
                this.updateCount.selectAll();
                return;
            }
            default: {
                super.selectAll(n);
            }
        }
    }

    public void setNotifyState(boolean bl) {
        this.setNotifyState(bl, false);
    }

    public void setNotifyState(boolean bl, boolean bl2) {
        super.setNotifyState(bl);
        if (!this.getNotifyState()) {
            this.setEnabledDynamicNotifyOptions(false);
        } else if (this.parent.getDomainType() == 1) {
            this.setEnabledDynamicNotifyOptions(true);
        } else {
            this.setEnabledDynamicNotifyOptions(false);
        }
        if (bl2) {
            if (this.getNotifyState()) {
                this.parent.setNotifyList();
                return;
            }
            super.setNotifyServerList(null);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setEnabledDynamicNotifyOptions(bl);
    }

    public void setEnabledDynamicNotifyOptions(boolean bl) {
        this.dynamicSerialLabel.setEnabled(bl);
        this.updateTimeLabel.setEnabled(bl);
        this.updateTime.setEnabled(bl);
        this.updateCountLabel.setEnabled(bl);
        this.updateCount.setEnabled(bl);
        if (!bl) {
            ((Component)this.updateTime).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            ((Component)this.updateCount).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            return;
        }
        ((Component)this.updateTime).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
        ((Component)this.updateCount).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
    }

    public int getUpdateTime() {
        return this.getNumber(this.updateTime.getText().trim());
    }

    public void setUpdateTime(int n) {
        ((TextComponent)this.updateTime).setText(Integer.toString(n).trim());
    }

    public boolean validateUpdateTime() {
        boolean bl = false;
        int n = this.getUpdateTime();
        bl = TcpipValidation.validateInteger(n) ? (this.parent.getDomainType() == 1 ? n < this.parent.getRefreshRate() / 3 : true) : false;
        return bl;
    }

    public int getUpdateCount() {
        return this.getNumber(this.updateCount.getText().trim());
    }

    public void setUpdateCount(int n) {
        ((TextComponent)this.updateCount).setText(Integer.toString(n).trim());
    }

    public boolean validateUpdateCount() {
        return TcpipValidation.validateInteger(this.getUpdateCount());
    }

    private void initComponents() {
        this.dynamicSerialLabel = new Label(this.resources.getString("DYNAMIC_SERIAL_NUMBER_LABEL"), 0);
        this.updateTime = new TextField("", 10);
        this.updateTimeLabel = new Label(this.resources.getString("UPDATE_TIME_LABEL"), 0);
        this.updateCount = new TextField("", 10);
        this.updateCountLabel = new Label(this.resources.getString("UPDATE_COUNT_LABEL"), 0);
    }

    private void addComponentsToGrid() {
        int n = this.lastGridPositionY++;
        this.setLayout(this.gridBag);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.add(this.dynamicSerialLabel, this.gridBag, this.constraints, 0, n, 0, 1);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.add(this.updateTime, this.gridBag, this.constraints, 0, 1 + n, 1, 1);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.add(this.updateTimeLabel, this.gridBag, this.constraints, 1, 1 + n, 0, 1);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.add(this.updateCount, this.gridBag, this.constraints, 0, 2 + n, 1, 1);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.add(this.updateCountLabel, this.gridBag, this.constraints, 1, 2 + n, 0, 1);
        this.invalidate();
        this.validate();
    }

    private void handleCheckbox(Checkbox checkbox) {
        boolean bl = checkbox.getState();
        if (checkbox == this.notifyServer) {
            boolean bl2 = true;
            if (bl) {
                this.setNotifyState(true, bl2);
                return;
            }
            this.setNotifyState(false, bl2);
        }
    }
}

