/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.DomainObjectMgr;
import COM.ibm.raleigh.ddnssgui.client.NotifyServersPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.IPListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

class SecondaryDomainFrame
extends Frame
implements WindowListener,
ActionListener,
TabViewEventListener,
ListPanelUser,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int FIRST_FIELD = 0;
    public static final int DOMAIN_NAME_FIELD = 0;
    public static final int DOMAIN_FILE_NAME_FIELD = 1;
    private static final int TABVIEW_DOMAIN_CFG_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int TABVIEW_NOTIFY_SERVERS_INDEX = 1;
    private static final int TABVIEW_FILES_INDEX = 2;
    private static final int NUM_TABS = 3;
    private static final int NUM_LIST_ROWS = 4;
    private static final int NUM_BUTTONS = 3;
    private static final int NUM_TEXT_COLUMNS = 20;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private DomainObjectMgr parent;
    private ResourceBundle resources;
    private boolean selectTabForError = false;
    private Panel cfgPanel;
    private WrappedTextPanel cfgTextPanel;
    private Label domainNameLabel;
    private TextField domainName;
    private IPListPanel masterServersPanel;
    private NotifyServersPanel notifyServersPanel;
    private Panel filePanel;
    private WrappedTextPanel domainFileTextPanel;
    private Label domainFileLabel;
    private TextField domainFileName;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);
    private msgBox requiredBox;
    private msgBox invalidDomainNameBox;
    private msgBox invalidOptionBox;

    public SecondaryDomainFrame(DomainObjectMgr domainObjectMgr) {
        this.setResizable(false);
        this.parent = domainObjectMgr;
        this.resources = this.parent.MyParent.clientResources;
        this.setTitle(this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
        this.selectTabForError = false;
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void selectFirstTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[0]);
        }
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.domainName.requestFocus();
                return;
            }
            case 1: {
                this.domainFileName.requestFocus();
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                if (!this.domainName.isEnabled()) break;
                this.domainName.selectAll();
                return;
            }
            case 1: {
                if (!this.domainFileName.isEnabled()) break;
                this.domainFileName.selectAll();
                return;
            }
        }
    }

    public String getFullyQualifiedDomainName() {
        return this.domainName.getText().trim().toLowerCase();
    }

    public void setFullyQualifiedDomainName(String string) {
        if (string != null) {
            ((TextComponent)this.domainName).setText(string.trim().toLowerCase());
            if (string.trim().toLowerCase().compareTo("") != 0) {
                this.domainName.setEnabled(false);
            } else {
                this.domainName.setEnabled(true);
            }
            this.setTitle(String.valueOf(this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME")) + " -- " + this.getFullyQualifiedDomainName());
        }
    }

    public String getMasterServer() {
        return this.masterServersPanel.getIPAddr();
    }

    public void setMasterServer(String string) {
        if (string != null) {
            this.masterServersPanel.setIPAddr(string);
        }
    }

    public String[] getMasterServerList() {
        return this.masterServersPanel.getIPAddrList();
    }

    public void setMasterServerList(String[] stringArray) {
        this.masterServersPanel.removeAll();
        if (stringArray != null) {
            this.masterServersPanel.setIPAddrList(stringArray);
        }
        this.checkOK();
    }

    public boolean getNotify() {
        return this.notifyServersPanel.getNotifyState();
    }

    public void setNotify(boolean bl) {
        this.notifyServersPanel.setNotifyState(bl);
    }

    public String getNotifyServer() {
        return this.notifyServersPanel.getNotifyServer();
    }

    public void setNotifyServer(String string) {
        if (string != null) {
            this.notifyServersPanel.setNotifyServer(string);
        }
    }

    public String[] getNotifyServerList() {
        return this.notifyServersPanel.getNotifyServerList();
    }

    public void setNotifyServerList(String[] stringArray) {
        this.notifyServersPanel.setNotifyServerList(stringArray);
    }

    public int getNotifyRetryTime() {
        return this.notifyServersPanel.getRetryTime();
    }

    public void setNotifyRetryTime(int n) {
        this.notifyServersPanel.setRetryTime(n);
    }

    public int getNotifyNumRetries() {
        return this.notifyServersPanel.getNumRetries();
    }

    public void setNotifyNumRetries(int n) {
        this.notifyServersPanel.setNumRetries(n);
    }

    public int getNotifyDelayTime() {
        return this.notifyServersPanel.getDelayTime();
    }

    public void setNotifyDelayTime(int n) {
        this.notifyServersPanel.setDelayTime(n);
    }

    public String getDomainFileName() {
        return this.domainFileName.getText();
    }

    public void setDomainFileName(String string) {
        if (string != null) {
            ((TextComponent)this.domainFileName).setText(string);
        }
    }

    public void setEnabled(boolean bl) {
        this.cfgPanel.setEnabled(bl);
        this.notifyServersPanel.setEnabled(bl);
        this.filePanel.setEnabled(bl);
    }

    public void setEnabledButtons(boolean bl) {
        if (bl) {
            this.checkOK();
            this.enableCancel();
            this.enableHelp();
            return;
        }
        this.disableOK();
        this.disableCancel();
        this.disableHelp();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.cfgPanel = new Panel();
        this.cfgTextPanel = new WrappedTextPanel(this.resources.getString("SDF_DOMAIN_CONFIGURATION_TEXT"));
        this.domainNameLabel = new Label(this.resources.getString("DOMAIN_NAME_LABEL"), 0);
        this.domainName = new TextField("", 20);
        this.masterServersPanel = new IPListPanel(this, this.resources, this.resources.getString("MASTER_SERVERS_TITLE"), 4, this.resources.getString("MASTER_SERVERS_TEXT"));
        this.masterServersPanel.setInvalidAddrText(this.resources.getString("INVALID_IP_ADDR_TEXT"));
        this.notifyServersPanel = new NotifyServersPanel(this.resources);
        this.filePanel = new Panel();
        this.domainFileTextPanel = new WrappedTextPanel(this.resources.getString("DOMAIN_FILE_EXPLANATION"));
        this.domainFileLabel = new Label(this.resources.getString("DOMAIN_FILE_LABEL"), 0);
        this.domainFileName = new TextField("", 20);
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("SDF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("SDF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.tabView.addTabViewEventListener((TabViewEventListener)this);
        this.createTabs();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        int n = this.cfgTextPanel.getNumDividedTextLines();
        int n2 = this.domainFileTextPanel.getNumDividedTextLines();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        this.cfgPanel.setLayout(gridBagLayout2);
        this.constrain(this.cfgTextPanel, gridBagLayout2, gridBagConstraints2, 0, 0, 0, n);
        this.cfgPanel.add(this.cfgTextPanel);
        gridBagConstraints2.fill = 0;
        this.constrain(this.domainNameLabel, gridBagLayout2, gridBagConstraints2, 0, n, 1, 1);
        this.cfgPanel.add(this.domainNameLabel);
        gridBagConstraints2.fill = 2;
        this.constrain(this.domainName, gridBagLayout2, gridBagConstraints2, 1, n, 0, 1);
        this.cfgPanel.add(this.domainName);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        this.constrain(this.masterServersPanel, gridBagLayout2, gridBagConstraints2, 0, 1 + n, 0, 0);
        this.cfgPanel.add(this.masterServersPanel);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        this.filePanel.setLayout(gridBagLayout2);
        this.constrain(this.domainFileTextPanel, gridBagLayout2, gridBagConstraints2, 0, 0, 0, n2);
        this.filePanel.add(this.domainFileTextPanel);
        this.constrain(this.domainFileLabel, gridBagLayout2, gridBagConstraints2, 0, n2, 1, 1);
        this.filePanel.add(this.domainFileLabel);
        this.constrain(this.domainFileName, gridBagLayout2, gridBagConstraints2, 1, n2, 0, 1);
        this.filePanel.add(this.domainFileName);
        this.add((Component)this.tabView, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 1);
    }

    private boolean checkRequiredFields() {
        boolean bl = false;
        String string = new String(this.getFullyQualifiedDomainName());
        if (string != null && string.length() > 0) {
            bl = true;
        }
        return bl;
    }

    private void enableOK() {
        this.buttonPanel.setEnabled(true, this.buttons[0]);
    }

    private void disableOK() {
        this.buttonPanel.setEnabled(false, this.buttons[0]);
    }

    private void enableCancel() {
        this.buttonPanel.setEnabled(true, this.buttons[1]);
    }

    private void disableCancel() {
        this.buttonPanel.setEnabled(false, this.buttons[1]);
    }

    private void enableHelp() {
        this.buttonPanel.setEnabled(true, this.buttons[2]);
    }

    private void disableHelp() {
        this.buttonPanel.setEnabled(false, this.buttons[2]);
    }

    public void handleButton(Button button) {
        int n;
        if (button == this.buttons[0]) {
            n = this.checkRequiredFields();
            if (n == 1 && this.validateFields()) {
                this.parent.SaveAndExit(this);
            } else if (n == 0) {
                this.tabView.selectTab(this.tabNodes[0]);
                this.requiredBox = new msgBox(this.resources, this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME"), this.resources.getString("REQUIRED_BOX_TEXT"), 1, true, this);
            }
        }
        if (button == this.buttons[1]) {
            this.parent.CancelAndExit(this);
        }
        if (button == this.buttons[2]) {
            n = this.tabView.getSelectedTab().getId();
            if (n == 0) {
                this.parent.MyParent.handleHelp("ddscnbsc.htm#HDRNBSTC");
            } else if (n == 1) {
                this.parent.MyParent.handleHelp("ddscnbsn.htm#HDRNBSTN");
            } else if (n == 2) {
                this.parent.MyParent.handleHelp("ddscnbsf.htm#HDRNBSTF");
            } else {
                this.parent.MyParent.handleHelp("ddscnbs.htm#HDRNBS");
            }
        }
        if (button == this.masterServersPanel.getAddButton()) {
            this.checkOK();
        }
        if (button == this.masterServersPanel.getRemoveButton()) {
            this.checkOK();
        }
    }

    private boolean validateFields() {
        boolean bl = true;
        String string = this.getFullyQualifiedDomainName();
        if (!TcpipValidation.IsValidFQTcpipName(string)) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidDomainNameBox = new msgBox(this.resources, this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_DOMAIN_NAME_TEXT"), 1, true, this);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        }
        if (this.getNotify()) {
            if (bl && !this.notifyServersPanel.validateRetryTime()) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[1]);
                this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_RETRY_TIME_TEXT"), 1, true, this);
                this.notifyServersPanel.selectAll(2);
                this.notifyServersPanel.requestFocus(2);
                bl = false;
            }
            if (bl && !this.notifyServersPanel.validateNumRetries()) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[1]);
                this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_NUM_RETRIES_TEXT"), 1, true, this);
                this.notifyServersPanel.selectAll(3);
                this.notifyServersPanel.requestFocus(3);
                bl = false;
            }
            if (bl && !this.notifyServersPanel.validateDelayTime()) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[1]);
                this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_DELAY_TIME_TEXT"), 1, true, this);
                this.notifyServersPanel.selectAll(4);
                this.notifyServersPanel.requestFocus(4);
                bl = false;
            }
        }
        if (bl && !this.validateDomainFileName()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[2]);
            this.invalidOptionBox = new msgBox(this.resources, this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME"), this.resources.getString("INVALID_DOMAIN_FILE_NAME_TEXT"), 1, true, this);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        }
        return bl;
    }

    private boolean validateDomainFileName() {
        boolean bl = true;
        if (this.getDomainFileName().compareTo("") == 0) {
            bl = false;
        }
        return bl;
    }

    private void checkOK() {
        if (this.masterServersPanel.getItemCount() > 0) {
            this.enableOK();
            return;
        }
        this.disableOK();
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[3];
        int n = 0;
        while (n < 3) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_DOMAIN_CFG_LABEL"));
        this.tabNodes[0].setPanel(this.cfgPanel);
        this.tabNodes[1].setText(this.resources.getString("TABVIEW_NOTIFY_SERVERS_LABEL"));
        this.tabNodes[1].setPanel((Panel)this.notifyServersPanel);
        this.tabNodes[2].setText(this.resources.getString("TABVIEW_FILES_LABEL"));
        this.tabNodes[2].setPanel(this.filePanel);
        int n = 0;
        while (n < 3) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
        this.disableOK();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.CancelAndExit(this);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public boolean preTabSelected(TabView tabView, TabViewNode tabViewNode) {
        String string = this.getFullyQualifiedDomainName();
        if (string.compareTo("") == 0) {
            this.setTitle(this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME"));
        } else {
            this.setTitle(String.valueOf(this.resources.getString("SECONDARY_DOMAIN_FRAME_NAME")) + " -- " + string);
        }
        return true;
    }

    public void postTabSelected(TabView tabView, TabViewNode tabViewNode) {
        if (!this.selectTabForError) {
            if (tabViewNode == this.tabNodes[0]) {
                this.selectAll(0);
                this.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[1]) {
                this.notifyServersPanel.selectAll(0);
                this.notifyServersPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[2]) {
                this.domainFileName.selectAll();
                this.domainFileName.requestFocus();
                return;
            }
            this.selectAll(0);
            this.requestFocus(0);
            return;
        }
        this.selectTabForError = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

