/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.common.BorderPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;

class TTLPanel
extends BorderPanel
implements ItemListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int USE_DEFAULT_TTL = -1;
    public static final boolean DOMAIN_DEFAULT_TTL = true;
    public static final boolean NO_DOMAIN_DEFAULT_TTL = false;
    public static final int FIRST_FIELD = 0;
    public static final int TTL_FIELD = 0;
    public static final int USE_DEFAULT_FIELD = 1;
    private static final int NUM_TEXT_COLUMNS = 8;
    private ResourceBundle resources;
    private WrappedTextPanel textPanel;
    private TextField ttl;
    private Label timeRangeLabel;
    private Checkbox useDefaultTTL;

    public TTLPanel(ResourceBundle resourceBundle, String string) {
        this(resourceBundle, string, true, null, 80);
    }

    public TTLPanel(ResourceBundle resourceBundle, String string, boolean bl) {
        this(resourceBundle, string, bl, null, 80);
    }

    public TTLPanel(ResourceBundle resourceBundle, String string, boolean bl, String string2) {
        this(resourceBundle, string, bl, string2, 80);
    }

    public TTLPanel(ResourceBundle resourceBundle, String string, boolean bl, String string2, int n) {
        super(string);
        this.setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.resources = resourceBundle;
        this.initComponents(bl, string2, n);
        this.addComponentsToGrid();
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                if (this.ttl.isEnabled()) {
                    this.ttl.requestFocus();
                    return;
                }
                this.requestFocus(1);
                return;
            }
            case 1: {
                this.useDefaultTTL.requestFocus();
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                if (!this.ttl.isEnabled()) break;
                this.ttl.selectAll();
                return;
            }
        }
    }

    public int getTTL() {
        return this.getTTLValue(this.ttl.getText().trim());
    }

    public void setTTL(int n) {
        this.setTTLValue(n, this.ttl);
    }

    public boolean isValidTTL() {
        boolean bl = true;
        if (!TcpipValidation.IsValidTTL(this.getTTL(), -1)) {
            bl = false;
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enableComponents();
            return;
        }
        this.disableComponents();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void initComponents(boolean bl, String string, int n) {
        this.textPanel = string != null ? new WrappedTextPanel(string, n) : new WrappedTextPanel("");
        this.ttl = new TextField("", 8);
        this.timeRangeLabel = new Label(this.resources.getString("SECONDS_LABEL"), 0);
        if (bl) {
            this.useDefaultTTL = new Checkbox(this.resources.getString("DOMAIN_DEFAULT_TTL_CHECKBOX_LABEL"));
            this.useDefaultTTL.setState(true);
            this.useDefaultTTL.addItemListener(this);
            this.useDefaultTTL.addKeyListener(this);
        } else {
            this.useDefaultTTL = null;
        }
        this.setEnabled(true);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        int n = this.textPanel.getNumDividedTextLines();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        this.add(this.textPanel, gridBagLayout, gridBagConstraints, 0, 0, 0, n);
        this.add(this.ttl, gridBagLayout, gridBagConstraints, 0, n, 1, 1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add(this.timeRangeLabel, gridBagLayout, gridBagConstraints, 1, n, 1, 1);
        if (this.useDefaultTTL != null) {
            this.add(this.useDefaultTTL, gridBagLayout, gridBagConstraints, 2, n, 0, 1);
        }
    }

    private int getTTLValue(String string) {
        int n = Integer.MIN_VALUE;
        n = !string.equals("") ? (this.useDefaultTTL != null ? (!this.useDefaultTTL.getState() ? this.getActualTTLValue(string) : -1) : this.getActualTTLValue(string)) : -1;
        return n;
    }

    private void setTTLValue(int n, TextField textField) {
        if (n <= -1) {
            ((TextComponent)textField).setText("");
            textField.setEnabled(false);
            if (this.useDefaultTTL != null) {
                this.useDefaultTTL.setState(true);
                return;
            }
        } else {
            ((TextComponent)textField).setText(Integer.toString(n).trim());
            textField.setEnabled(true);
            if (this.useDefaultTTL != null) {
                this.useDefaultTTL.setState(false);
            }
        }
    }

    private void handleCheckbox(Checkbox checkbox) {
        boolean bl = checkbox.getState();
        if (this.useDefaultTTL != null && checkbox == this.useDefaultTTL) {
            if (bl) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }

    private int getActualTTLValue(String string) {
        int n = Integer.MIN_VALUE;
        if (TcpipValidation.IsLessThanMaxIntegerValue(string)) {
            try {
                Integer n2 = new Integer(string);
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {
                n = Integer.MIN_VALUE;
                return n;
            }
        } else {
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    private void enableComponents() {
        if (this.useDefaultTTL != null && this.useDefaultTTL.getState()) {
            this.ttl.setEnabled(false);
            ((Component)this.ttl).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            this.timeRangeLabel.setEnabled(false);
        } else {
            this.ttl.setEnabled(true);
            ((Component)this.ttl).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
            this.timeRangeLabel.setEnabled(true);
            this.requestFocus(0);
        }
        if (this.useDefaultTTL != null) {
            this.useDefaultTTL.setEnabled(true);
        }
    }

    private void disableComponents() {
        this.ttl.setEnabled(false);
        ((Component)this.ttl).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
        this.timeRangeLabel.setEnabled(false);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (this.useDefaultTTL != null && itemSelectable == this.useDefaultTTL) {
            this.handleCheckbox((Checkbox)itemSelectable);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Checkbox) {
            Checkbox checkbox;
            checkbox.setState(!(checkbox = (Checkbox)object).getState());
            this.handleCheckbox((Checkbox)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

