/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ChildNameServer;
import COM.ibm.raleigh.ddnssgui.common.ListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelGrid;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChildNameServerListPanel
extends ListPanel
implements ActionListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int CHILD_DOMAIN_FIELD = 0;
    public static final int HOST_FIELD = 1;
    public static final int IP_ADDR_FIELD = 2;
    private static final int NUM_FIELDS = 3;
    private static final String[] fieldLabels = new String[]{"", "", ""};
    private ListPanelUser parent;
    private ResourceBundle resources;
    private String domainName;
    private msgBox invalidEntryBox;

    public ChildNameServerListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, int n, ListPanelGrid listPanelGrid) {
        super((Container)((Object)listPanelUser), resourceBundle, resourceBundle.getString("CHILD_SERVERS_TITLE"), fieldLabels, n, resourceBundle.getString("CHILD_SERVERS_TEXT"), listPanelGrid);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
        this.setFieldLabels();
    }

    public String getSubdomainName() {
        return this.getTextField(0).toLowerCase();
    }

    public void setSubdomainName(String string) {
        if (string != null) {
            this.setTextField(0, string.toLowerCase());
        }
    }

    public String getHostName() {
        return this.getTextField(1).toLowerCase();
    }

    public void setHostName(String string) {
        if (string != null) {
            this.setTextField(1, string.toLowerCase());
        }
    }

    public String getIPAddr() {
        return this.getTextField(2);
    }

    public void setIPAddr(String string) {
        if (string != null) {
            this.setTextField(2, string);
        }
    }

    public Enumeration getServerList() {
        Enumeration enumeration = null;
        Vector<ChildNameServer> vector = new Vector<ChildNameServer>();
        String[] stringArray = this.getItemList();
        ChildNameServer childNameServer = null;
        StringTokenizer stringTokenizer = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            stringTokenizer = new StringTokenizer(stringArray[n], this.getTextSeparator());
            string = null;
            string2 = null;
            string3 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().toLowerCase();
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken().toLowerCase();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
            }
            childNameServer = new ChildNameServer(string2, string3, string);
            vector.addElement(childNameServer);
            ++n;
        }
        enumeration = !vector.isEmpty() ? vector.elements() : null;
        return enumeration;
    }

    public void setServerList(Enumeration enumeration) {
        this.removeAll();
        Vector<ChildNameServer> vector = new Vector<ChildNameServer>();
        ChildNameServer childNameServer = null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                vector.addElement((ChildNameServer)enumeration.nextElement());
            }
            if (!vector.isEmpty()) {
                int n = 0;
                while (n < vector.size()) {
                    childNameServer = (ChildNameServer)vector.elementAt(n);
                    super.addItem(new String(String.valueOf(childNameServer.getDomForNameServer().toLowerCase()) + this.getTextSeparator() + childNameServer.getServerName().toLowerCase() + this.getTextSeparator() + childNameServer.getServerIPaddress()));
                    ++n;
                }
            }
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String string) {
        if (string != null) {
            this.domainName = string.toLowerCase();
        }
    }

    private void handleButton(Button button) {
        if (button == super.getAddButton()) {
            this.handleAdd();
            return;
        }
        if (button == super.getRemoveButton()) {
            super.handleRemove();
        }
    }

    protected void handleAdd() {
        String[] stringArray;
        boolean bl = true;
        String string = new String(this.getSubdomainName());
        String string2 = new String(this.getHostName());
        String string3 = new String(this.getIPAddr());
        if (bl && !this.isValidSubdomain(string)) {
            stringArray = this.getDomainName();
            if (stringArray != null && stringArray.length() > 0) {
                this.invalidEntryBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("INVALID_CHILD_DOMAIN_NAME_TEXT"), 1, true);
                this.selectAll(0);
                this.requestFocus(0);
            } else {
                this.invalidEntryBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("NO_DOMAIN_NAME_TEXT"), 1, true);
            }
            bl = false;
        }
        if (bl && !TcpipValidation.IsValidFQTcpipName(string2)) {
            this.invalidEntryBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("INVALID_HOST_NAME_TEXT"), 1, true);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        }
        if (bl && !TcpipValidation.IsValidTcpipAddr(string3)) {
            this.invalidEntryBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("INVALID_IP_ADDR_TEXT"), 1, true);
            this.selectAll(2);
            this.requestFocus(2);
            bl = false;
        }
        if (bl) {
            stringArray = new String[]{string, string2, string3};
            super.handleAdd(stringArray);
        }
    }

    private boolean isValidSubdomain(String string) {
        boolean bl = true;
        String string2 = this.getDomainName();
        bl = !TcpipValidation.IsValidFQTcpipName(string) ? false : (string2 != null && string2.length() > 0 ? (string.compareTo(string2) == 0 ? false : string.endsWith("." + string2)) : false);
        return bl;
    }

    private void setFieldLabels() {
        String[] stringArray = new String[]{new String(this.resources.getString("CHILD_DOMAIN_FIELD_LABEL")), new String(this.resources.getString("NAME_FIELD_LABEL")), new String(this.resources.getString("IP_ADDRESS_FIELD_LABEL"))};
        super.setFieldLabels(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

