/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.AliasHostObject;
import COM.ibm.raleigh.ddnssgui.common.CacheFile;
import COM.ibm.raleigh.ddnssgui.common.ChildNameServer;
import COM.ibm.raleigh.ddnssgui.common.CommandServer;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.GenerateFileName;
import COM.ibm.raleigh.ddnssgui.common.GuiUserSettings;
import COM.ibm.raleigh.ddnssgui.common.HostList;
import COM.ibm.raleigh.ddnssgui.common.HostObject;
import COM.ibm.raleigh.ddnssgui.common.HostOrAlias;
import COM.ibm.raleigh.ddnssgui.common.LockOutNameServer;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.Platform;
import COM.ibm.raleigh.ddnssgui.common.PlatformList;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.ReservedName;
import COM.ibm.raleigh.ddnssgui.common.ReverseHost;
import COM.ibm.raleigh.ddnssgui.common.SecondaryDomain;
import COM.ibm.raleigh.ddnssgui.common.TheBootFile;
import COM.ibm.raleigh.ddnssgui.common.TheConfigFile;
import COM.ibm.raleigh.ddnssgui.common.TheDomainFile;
import COM.ibm.raleigh.ddnssgui.common.TheRootDomainFile;
import COM.ibm.raleigh.ddnssgui.common.TheSyslogFile;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import COM.ibm.raleigh.ddnssgui.common.TraceServer;
import COM.ibm.raleigh.ddnssgui.common.TreeNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigurationManager {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String DNS_DIRECTORY = "namedb";
    public static final int TRACE_PORT = 7463;
    public static final int REVERSE_DOM_EXISTS = 0;
    public static final int REVERSE_DOM_IS_SECONDARY = 1;
    public static final int REVERSE_DOM_NOT_EXIST = 2;
    private static final String DYHOSTSCH = "dynhostscheme";
    private static final String DYALIASSCH = "dynaliasscheme";
    private static final String STHOSTSCH = "stahostscheme";
    private static final String STALIASSCH = "staaliasscheme";
    private static final String SECHOSTSCH = "sechostscheme";
    private static final String SECALIASSCH = "secaliasscheme";
    private static final String DYREVSCH = "dynrevscheme";
    private static final String SECREVSCH = "secrevscheme";
    private static final String STREVSCH = "starevscheme";
    private static final String RESNMSCH = "reservnamscheme";
    private static final String SECRESNSCH = "secreservnscheme";
    private static final String RRESNMSCH = "revrsrvnamscheme";
    private static final String DDNS_TRACE_FILE_NAME = "ddnssgui";
    private static final int TRACE_FILE_SIZE = 500000;
    Hashtable theNameServers;
    Hashtable theDomains;
    Hashtable theHosts;
    int noOfPriDom;
    int noOfSecDom;
    String lastAction;
    private TraceClient traceClient;
    private String theETCpath;
    private TheBootFile bootFile;
    private CacheFile cacheFile;
    private TraceServer trace;
    private TheConfigFile configFile;
    private TheSyslogFile syslogFile;
    public GenerateFileName theFileGenerator;
    private boolean writeErrorsToFile;
    private int leaseTimeForDyn;
    private int padFactor;
    private LockOutNameServer lsn = new LockOutNameServer();
    private GuiUserSettings userSettings;
    private ResourceBundle theServerResources;
    private int os2SemHandle;
    private String theDirectory;

    public ConfigurationManager(String string, ResourceBundle resourceBundle) {
        this.theETCpath = string;
        this.theServerResources = resourceBundle;
        String string2 = new String(String.valueOf(this.theETCpath) + File.separator + DNS_DIRECTORY + File.separator + DDNS_TRACE_FILE_NAME);
        TraceServer traceServer = new TraceServer(7463, string2, 500000);
        int n = traceServer.getErrorCode();
        if (n == 0) {
            traceServer.start();
        } else {
            Object[] objectArray = new Object[]{new Integer(n)};
            System.out.println(MessageFormat.format(this.theServerResources.getString("TRACE_SERVER_ERROR"), objectArray));
            System.out.flush();
        }
        this.traceClient = new TraceClient("ConfigurationManager", this.theServerResources.getString("cfgMgr_ConstructTrace"), false, 7463, null);
        this.theDirectory = this.getDirectory();
        this.initSelf();
    }

    public void giveANameServer(NameServerObject nameServerObject) {
        this.theNameServers.put(nameServerObject.firstName(), nameServerObject);
    }

    public String[] getBootFileErrors() {
        return this.bootFile.getInvalidLines();
    }

    public String[] getCacheFileErrors() {
        return this.cacheFile.getInvalidCacheItems();
    }

    public void startTrace() {
        this.traceClient.setTraceState(true);
    }

    public void traceThis(String string) {
        this.traceClient.traceTime("ConfigurationManager", string);
    }

    public String recFromNetwork(String string) {
        DDNSNetworkStringParser dDNSNetworkStringParser = new DDNSNetworkStringParser(string, this.traceClient);
        ParsedVector parsedVector = dDNSNetworkStringParser.getParsed();
        ParsedObject parsedObject = parsedVector.getFirstElement();
        if (parsedObject.getKey().equals("NSO")) {
            this.lastAction = NameServerObject.handleActions(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("PDOM")) {
            this.lastAction = PrimaryDomain.handlePrimaryDomainActions(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("SDOM")) {
            this.lastAction = SecondaryDomain.handleSecondaryDomainActions(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("HOST")) {
            this.lastAction = HostObject.handleHostActions(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("ALIAS")) {
            this.lastAction = AliasHostObject.handleAliasActions(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals(ReverseHost.REVH_tag)) {
            this.lastAction = ReverseHost.handleRevHostActions(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("QUEST")) {
            this.lastAction = Question.getResponse(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("CMDSRVR")) {
            this.lastAction = CommandServer.handleCommand(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("REQLIST")) {
            this.lastAction = RequestList.getResponse(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("RN")) {
            this.lastAction = ReservedName.getResponse(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals(HostList.HLIST_tag)) {
            this.lastAction = HostList.handleReqForHostList(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("USRSET")) {
            this.lastAction = GuiUserSettings.handleActions(parsedVector, parsedObject, string, this);
        }
        return this.lastAction;
    }

    public void removeANameServer(String string) {
        this.theNameServers.remove(string);
    }

    public boolean updateANameServer(String string, ParsedVector parsedVector) {
        NameServerObject nameServerObject = (NameServerObject)this.theNameServers.get(string);
        if (nameServerObject != null) {
            nameServerObject.fromString(parsedVector);
            return true;
        }
        return false;
    }

    public boolean updateADomain(String string, ParsedVector parsedVector) {
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        if (domainObject != null) {
            domainObject.fromString(parsedVector);
            return true;
        }
        return false;
    }

    public boolean updateAHost(HostOrAlias hostOrAlias, String string, ParsedVector parsedVector) {
        boolean bl = true;
        HostOrAlias hostOrAlias2 = !string.equals(".") ? (HostOrAlias)this.theHosts.get(String.valueOf(hostOrAlias.getHostName()) + "." + string) : (HostOrAlias)this.theHosts.get(hostOrAlias.getHostName());
        if (hostOrAlias2 != null) {
            if (hostOrAlias instanceof HostObject && hostOrAlias2.isDynamic()) {
                bl = this.doNsupdatesForHost((HostObject)hostOrAlias, string);
            } else if (hostOrAlias instanceof AliasHostObject && hostOrAlias2.isDynamic()) {
                bl = this.doNsupdatesForAlias((AliasHostObject)hostOrAlias, string);
            } else if (hostOrAlias instanceof ReverseHost && hostOrAlias2.isDynamic()) {
                bl = this.doNsupdatesForReverse((ReverseHost)hostOrAlias, string);
            }
            if (bl) {
                hostOrAlias2.fromString(parsedVector);
            }
            return bl;
        }
        return false;
    }

    public NameServerObject getANameServer(String string) {
        return (NameServerObject)this.theNameServers.get(string);
    }

    public boolean isANameServer(String string) {
        NameServerObject nameServerObject = (NameServerObject)this.theNameServers.get(string);
        return nameServerObject != null;
    }

    public NameServerObject getFirstNameServer() {
        Enumeration enumeration = this.theNameServers.keys();
        if (enumeration.hasMoreElements()) {
            return (NameServerObject)this.theNameServers.get(enumeration.nextElement());
        }
        return null;
    }

    public void giveADomain(DomainObject domainObject) {
        this.theDomains.put(domainObject.getDomName(), domainObject);
        if (domainObject instanceof PrimaryDomain) {
            ++this.noOfPriDom;
            this.checkForNameServerNames(domainObject.getDomName());
            this.checkForChildDomains(domainObject.getDomName());
            return;
        }
        ++this.noOfSecDom;
    }

    public void giveADomain(DomainObject domainObject, String string) {
        this.theDomains.put(domainObject.getDomName(), domainObject);
        if (domainObject instanceof PrimaryDomain) {
            ++this.noOfPriDom;
            this.checkForChildDomains(domainObject.getDomName());
            return;
        }
        ++this.noOfSecDom;
    }

    public void createNewDomainFromFile(String string, String string2) {
        PrimaryDomain primaryDomain = new PrimaryDomain();
        primaryDomain.setDomName(string2);
        primaryDomain.setDataFileName(string);
        this.giveADomain(primaryDomain, "from file");
        this.linkDomain(primaryDomain, this.getFirstNameServer());
        TheDomainFile theDomainFile = !primaryDomain.getDomName().equals(".") ? new TheDomainFile(primaryDomain.getDomName(), this.traceClient, this.theServerResources) : new TheRootDomainFile(primaryDomain.getDomName(), this.traceClient, this.theServerResources);
        theDomainFile.readFile(primaryDomain.getDataFileName());
        theDomainFile.loadDataModel(this);
        primaryDomain.storeFile(theDomainFile);
        primaryDomain.saveInitialDynamicData();
        primaryDomain.setReadFromFile();
    }

    public boolean domainIsStatic(String string) {
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        if (domainObject != null) {
            if (domainObject instanceof PrimaryDomain) {
                return !((PrimaryDomain)domainObject).isDynamic();
            }
            return true;
        }
        return false;
    }

    public boolean domainIsPrimary(String string) {
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        if (domainObject != null) {
            return domainObject instanceof PrimaryDomain;
        }
        return false;
    }

    public int shouldWriteDynamicFile(String string) {
        PrimaryDomain primaryDomain;
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        int n = 0;
        if (domainObject != null && domainObject instanceof PrimaryDomain && (primaryDomain = (PrimaryDomain)domainObject).didReadDataFromFile()) {
            if (primaryDomain.soaDataHasChanged()) {
                ++n;
            }
            if (primaryDomain.nameServerDataHasChanged()) {
                n += 10;
            }
            if (primaryDomain.separateDynDataHasChanged()) {
                n += 100;
            }
            if (!primaryDomain.getSeparateDynStatData()) {
                n += 1000;
            }
            if (primaryDomain.mailExchangeDataHasChanged()) {
                n += 10000;
            }
        }
        return n;
    }

    public boolean domainExists(String string) {
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        return domainObject != null;
    }

    public boolean hostExists(String string) {
        HostOrAlias hostOrAlias = (HostOrAlias)this.theHosts.get(string);
        return hostOrAlias != null && hostOrAlias instanceof HostObject;
    }

    public boolean aliasExists(String string) {
        HostOrAlias hostOrAlias = (HostOrAlias)this.theHosts.get(string);
        return hostOrAlias != null && hostOrAlias instanceof AliasHostObject;
    }

    public boolean revHostExists(String string) {
        HostOrAlias hostOrAlias = (HostOrAlias)this.theHosts.get(string);
        return hostOrAlias != null && hostOrAlias instanceof ReverseHost;
    }

    public void setUserSettings(GuiUserSettings guiUserSettings) {
        this.userSettings = guiUserSettings;
    }

    public GuiUserSettings getUserSettings() {
        return this.userSettings;
    }

    public DomainObject getADomain(String string) {
        if (string.equals("123-ROOT-321")) {
            return (DomainObject)this.theDomains.get(".");
        }
        return (DomainObject)this.theDomains.get(string);
    }

    public boolean isUniqueDomainName(String string) {
        Object v = this.theDomains.get(string);
        return v == null;
    }

    public boolean deleteADomain(String string) {
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        if (domainObject != null) {
            Enumeration enumeration = domainObject.getHosts();
            while (enumeration.hasMoreElements()) {
                HostOrAlias hostOrAlias = (HostOrAlias)enumeration.nextElement();
                String string2 = !hostOrAlias.getHostName().equals(".") ? new String(String.valueOf(hostOrAlias.getHostName()) + "." + string) : new String(hostOrAlias.getHostName());
                this.theHosts.remove(string2);
            }
            this.theDomains.remove(domainObject.getDomName());
            this.bootFile.removeDomainFromFile(domainObject.getDomName());
            if (domainObject instanceof PrimaryDomain) {
                --this.noOfPriDom;
            } else {
                --this.noOfSecDom;
            }
            return true;
        }
        return false;
    }

    public Enumeration getAllDomains() {
        Enumeration enumeration = this.theDomains.elements();
        return enumeration;
    }

    public String[] getAllPrimaryDomainNames() {
        int n = 0;
        String[] stringArray = null;
        Enumeration enumeration = this.theDomains.elements();
        stringArray = new String[this.noOfPriDom];
        while (enumeration.hasMoreElements()) {
            try {
                DomainObject domainObject = (DomainObject)enumeration.nextElement();
                if (!(domainObject instanceof PrimaryDomain)) continue;
                stringArray[n] = new String(domainObject.getDomName());
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        return stringArray;
    }

    public String[] getListOfFiles() {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = null;
        NameServerObject nameServerObject = this.getFirstNameServer();
        File file = new File(nameServerObject.getBootFileName());
        if (file.exists()) {
            vector.addElement(file.getAbsolutePath());
        }
        if ((file = new File(DDNSUtility.stripFileName(nameServerObject.getCacheFileName()))).exists()) {
            vector.addElement(file.getAbsolutePath());
        }
        if ((file = new File(this.configFile.getFileName())).exists()) {
            vector.addElement(file.getAbsolutePath());
        }
        if ((file = new File(this.syslogFile.getFileName())).exists()) {
            vector.addElement(file.getAbsolutePath());
        }
        String[] stringArray = this.getAllPrimaryDomainNames();
        int n = 0;
        while (n < stringArray.length) {
            PrimaryDomain primaryDomain = (PrimaryDomain)this.getADomain(stringArray[n]);
            file = new File(primaryDomain.getDataFileName());
            if (file.exists()) {
                vector.addElement(file.getAbsolutePath());
            }
            if (primaryDomain.getSeparateDynStatData() && (file = new File(primaryDomain.getStaticFileName())).exists()) {
                vector.addElement(file.getAbsolutePath());
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getFileErrorsForDomain(String string) {
        DomainObject domainObject = this.getADomain(string);
        if (domainObject == null || domainObject instanceof SecondaryDomain) {
            return null;
        }
        return domainObject.getInvalidFileLines();
    }

    public String[] getAllDynamicPrimaryDomainNames() {
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.theDomains.elements();
        while (enumeration.hasMoreElements()) {
            try {
                DomainObject domainObject = (DomainObject)enumeration.nextElement();
                String string = new String(domainObject.getDomName());
                if (!(domainObject instanceof PrimaryDomain) || !((PrimaryDomain)domainObject).isDynamic()) continue;
                vector.addElement(string);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getAllForwardPrimaryDomainNames() {
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.theDomains.elements();
        while (enumeration.hasMoreElements()) {
            try {
                DomainObject domainObject = (DomainObject)enumeration.nextElement();
                String string = new String(domainObject.getDomName());
                if (!(domainObject instanceof PrimaryDomain) || string.toLowerCase().endsWith("in-addr.arpa")) continue;
                vector.addElement(string);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getAllSecondaryDomainNames() {
        int n = 0;
        String[] stringArray = null;
        Enumeration enumeration = this.theDomains.elements();
        stringArray = new String[this.noOfSecDom];
        while (enumeration.hasMoreElements()) {
            try {
                DomainObject domainObject = (DomainObject)enumeration.nextElement();
                if (!(domainObject instanceof SecondaryDomain)) continue;
                stringArray[n] = new String(domainObject.getDomName());
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        return stringArray;
    }

    public void linkDomain(DomainObject domainObject, NameServerObject nameServerObject) {
        nameServerObject.addDomainToNS(domainObject);
        if (domainObject instanceof PrimaryDomain) {
            this.bootFile.addToFile("PDOM", domainObject.getDomName());
            return;
        }
        this.bootFile.addToFile("SDOM", domainObject.getDomName());
    }

    public void linkDomain(DomainObject domainObject, NameServerObject nameServerObject, TheBootFile theBootFile) {
        nameServerObject.addDomainToNS(domainObject);
    }

    public boolean giveAHost(HostOrAlias hostOrAlias, String string) {
        boolean bl = true;
        String string2 = !string.equals(".") && !string.equals("123-ROOT-321") ? new String(String.valueOf(hostOrAlias.getHostName()) + "." + string) : new String(hostOrAlias.getHostName());
        if (hostOrAlias.isDynamic()) {
            if (hostOrAlias instanceof AliasHostObject) {
                bl = this.doNsupdatesForAlias((AliasHostObject)hostOrAlias, string);
            } else if (hostOrAlias instanceof HostObject) {
                bl = this.doNsupdatesForHost((HostObject)hostOrAlias, string);
            } else if (hostOrAlias instanceof ReverseHost) {
                bl = this.doNsupdatesForReverse((ReverseHost)hostOrAlias, string);
            }
        }
        if (bl) {
            this.theHosts.put(string2, hostOrAlias);
        }
        return bl;
    }

    public boolean giveAHost(HostOrAlias hostOrAlias, String string, String string2) {
        String string3 = !string.equals(".") && !string.equals("123-ROOT-321") ? new String(String.valueOf(hostOrAlias.getHostName()) + "." + string) : new String(hostOrAlias.getHostName());
        this.theHosts.put(string3, hostOrAlias);
        return true;
    }

    public boolean isUniqueHostName(String string, String string2) {
        String string3 = !string2.equals(".") ? new String(String.valueOf(string) + "." + string2) : new String(string);
        Object v = this.theHosts.get(string3);
        return v == null;
    }

    public boolean deleteAHost(String string, String string2) {
        boolean bl = true;
        String string3 = string2.toLowerCase().endsWith("in-addr.arpa") ? new String(ReverseHost.reverseAddr(string, string2)) : new String(string);
        String string4 = !string2.equals(".") ? new String(String.valueOf(string3) + "." + string2) : new String(string3);
        HostOrAlias hostOrAlias = (HostOrAlias)this.theHosts.remove(string4);
        if (hostOrAlias != null) {
            if (hostOrAlias.isDynamic()) {
                bl = this.deleteDynamic(string4, hostOrAlias, string2);
                if (!bl) {
                    this.theHosts.put(string4, hostOrAlias);
                }
            } else {
                DomainObject domainObject = this.getADomain(string2);
                domainObject.removeHostFromDomain(string3);
            }
            return bl;
        }
        return false;
    }

    public boolean deleteAHost(String string, String string2, String string3) {
        String string4 = string2.toLowerCase().endsWith("in-addr.arpa") ? new String(ReverseHost.reverseAddr(string, string2)) : new String(string);
        String string5 = !string2.equals(".") ? new String(String.valueOf(string4) + "." + string2) : new String(string4);
        HostOrAlias hostOrAlias = (HostOrAlias)this.theHosts.remove(string5);
        if (hostOrAlias != null) {
            DomainObject domainObject = this.getADomain(string2);
            domainObject.removeHostFromDomain(string4);
            return true;
        }
        return false;
    }

    public Object getAHost(String string, String string2) {
        if (!string2.equals(".") && !string2.equals("123-ROOT-321")) {
            return this.theHosts.get(String.valueOf(string) + "." + string2);
        }
        return this.theHosts.get(string);
    }

    public Object getAHost(String string) {
        return this.theHosts.get(string);
    }

    public void linkHost(HostOrAlias hostOrAlias, String string) {
        DomainObject domainObject = string.equals("123-ROOT-321") ? this.getADomain(".") : this.getADomain(string);
        domainObject.addHostToDomain(hostOrAlias);
    }

    public String[] getAllStaticHostNamesForDomain(String string) {
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = null;
        if (domainObject != null) {
            Enumeration enumeration = domainObject.getHosts();
            while (enumeration.hasMoreElements()) {
                HostOrAlias hostOrAlias = (HostOrAlias)enumeration.nextElement();
                if (hostOrAlias instanceof ReservedName || hostOrAlias.isDynamic()) continue;
                vector.addElement(hostOrAlias.getHostName());
            }
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        return objectArray;
    }

    public String[] getAllDynamicHostNamesForDomain(String string) {
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = null;
        if (domainObject != null) {
            Enumeration enumeration = domainObject.getHosts();
            while (enumeration.hasMoreElements()) {
                HostOrAlias hostOrAlias = (HostOrAlias)enumeration.nextElement();
                if (hostOrAlias instanceof ReservedName || !hostOrAlias.isDynamic()) continue;
                vector.addElement(hostOrAlias.getHostName());
            }
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        return objectArray;
    }

    public String[] getAllReservedNamesForDomain(String string) {
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = null;
        if (domainObject != null) {
            Enumeration enumeration = domainObject.getHosts();
            while (enumeration.hasMoreElements()) {
                HostOrAlias hostOrAlias = (HostOrAlias)enumeration.nextElement();
                if (!(hostOrAlias instanceof ReservedName)) continue;
                vector.addElement(hostOrAlias.getHostName());
            }
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
        }
        return objectArray;
    }

    public Vector getHostsForDomain(String string) {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        DomainObject domainObject = (DomainObject)this.theDomains.get(string);
        if (domainObject != null) {
            Enumeration enumeration = domainObject.getHosts();
            TreeNode treeNode = null;
            while (enumeration.hasMoreElements()) {
                Object object;
                Object e = enumeration.nextElement();
                if (e instanceof HostObject) {
                    HostObject hostObject = (HostObject)e;
                    object = hostObject.getAllIpAddresses();
                    String string2 = new String(" ");
                    if (object != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n = 0;
                        while (n < ((String[])object).length) {
                            stringBuffer.append(String.valueOf(object[n]) + " ");
                            ++n;
                        }
                        string2 = stringBuffer.toString();
                    }
                    if (domainObject instanceof PrimaryDomain) {
                        treeNode = hostObject.isDynamic() ? new TreeNode(hostObject.getHostName(), string2, DYHOSTSCH) : new TreeNode(hostObject.getHostName(), string2, STHOSTSCH);
                    } else if (domainObject instanceof SecondaryDomain) {
                        treeNode = new TreeNode(hostObject.getHostName(), string2, SECHOSTSCH);
                    }
                    vector.addElement(treeNode);
                    continue;
                }
                if (e instanceof AliasHostObject) {
                    AliasHostObject aliasHostObject = (AliasHostObject)e;
                    if (domainObject instanceof PrimaryDomain) {
                        treeNode = aliasHostObject.isDynamic() ? new TreeNode(aliasHostObject.getHostName(), aliasHostObject.getRealHostName(), DYALIASSCH) : new TreeNode(aliasHostObject.getHostName(), aliasHostObject.getRealHostName(), STALIASSCH);
                    } else if (domainObject instanceof SecondaryDomain) {
                        treeNode = new TreeNode(aliasHostObject.getHostName(), aliasHostObject.getRealHostName(), SECALIASSCH);
                    }
                    vector.addElement(treeNode);
                    continue;
                }
                if (e instanceof ReverseHost) {
                    ReverseHost reverseHost = (ReverseHost)e;
                    object = new String(domainObject.getDomName());
                    String string3 = new String(ReverseHost.getAddressFromHostName(reverseHost.getHostName(), (String)object));
                    if (domainObject instanceof PrimaryDomain) {
                        treeNode = reverseHost.isDynamic() ? new TreeNode(string3, reverseHost.getPTRhostname(), DYREVSCH) : new TreeNode(string3, reverseHost.getPTRhostname(), STREVSCH);
                    } else if (domainObject instanceof SecondaryDomain) {
                        treeNode = new TreeNode(string3, reverseHost.getPTRhostname(), SECREVSCH);
                    }
                    vector.addElement(treeNode);
                    continue;
                }
                if (!(e instanceof ReservedName)) continue;
                ReservedName reservedName = (ReservedName)e;
                treeNode = domainObject instanceof PrimaryDomain && !domainObject.getDomName().toLowerCase().endsWith("in-addr.arpa") ? new TreeNode(reservedName.getHostName(), "", RESNMSCH) : (domainObject instanceof SecondaryDomain ? new TreeNode(reservedName.getHostName(), "", SECRESNSCH) : new TreeNode(String.valueOf(ReverseHost.addrFromReverseDom(domainObject.getDomName())) + "." + reservedName.getHostName(), "", RRESNMSCH));
                vector.addElement(treeNode);
            }
            return vector;
        }
        return null;
    }

    public int reverseDomExist(String string) {
        int n = this.doExistCheck(ReverseHost.reverseDomainFromAddrClassC(string));
        if (n == 2 && (n = this.doExistCheck(ReverseHost.reverseDomainFromAddrClassB(string))) == 2) {
            n = this.doExistCheck(ReverseHost.reverseDomainFromAddrClassA(string));
        }
        return n;
    }

    public int doExistCheck(String string) {
        if (string != null) {
            if (this.theDomains.containsKey(string)) {
                Object v = this.theDomains.get(string);
                if (v instanceof SecondaryDomain) {
                    return 1;
                }
                return 0;
            }
            return 2;
        }
        return 2;
    }

    public String addReverseMapping(String string, String string2, int n, String string3, int n2) {
        Object v = this.theDomains.get(string3);
        if (v == null) {
            return null;
        }
        if (n == 2) {
            PrimaryDomain primaryDomain = (PrimaryDomain)v;
            if (!primaryDomain.isDynamic()) {
                PrimaryDomain primaryDomain2 = new PrimaryDomain();
                primaryDomain2.setDataFileName(this.theFileGenerator.getReverseFileName());
                primaryDomain2.setStaticFileName(this.theFileGenerator.getStaticFileName());
                primaryDomain2.makeStatic();
                primaryDomain2.setDomName(ReverseHost.reverseDomainFromAddrClassC(string));
                this.giveADomain(primaryDomain2);
                this.linkDomain(primaryDomain2, this.getFirstNameServer());
                ReverseHost reverseHost = new ReverseHost(string, string2, primaryDomain2.getDomName());
                reverseHost.setPTRttl(n2);
                if (this.giveAHost(reverseHost, primaryDomain2.getDomName())) {
                    this.linkHost(reverseHost, primaryDomain2.getDomName());
                }
                return primaryDomain2.getDomName();
            }
            PrimaryDomain primaryDomain3 = new PrimaryDomain();
            primaryDomain3.setDataFileName(this.theFileGenerator.getReverseFileName());
            primaryDomain3.setStaticFileName(this.theFileGenerator.getStaticFileName());
            primaryDomain3.setDomName(ReverseHost.reverseDomainFromAddrClassC(string));
            primaryDomain3.setSeparateDynStatData(true);
            this.giveADomain(primaryDomain3);
            this.linkDomain(primaryDomain3, this.getFirstNameServer());
            this.createDomainAdminKey(primaryDomain3.getDomName());
            ReverseHost reverseHost = new ReverseHost(string, string2, primaryDomain3.getDomName());
            reverseHost.setPTRttl(n2);
            if (this.giveAHost(reverseHost, primaryDomain3.getDomName())) {
                this.linkHost(reverseHost, primaryDomain3.getDomName());
            }
            return primaryDomain3.getDomName();
        }
        if (n == 0) {
            DomainObject domainObject = (DomainObject)this.theDomains.get(ReverseHost.reverseDomainFromAddrClassC(string));
            if (domainObject == null) {
                domainObject = (DomainObject)this.theDomains.get(ReverseHost.reverseDomainFromAddrClassB(string));
            }
            if (domainObject == null) {
                domainObject = (DomainObject)this.theDomains.get(ReverseHost.reverseDomainFromAddrClassA(string));
            }
            if (domainObject == null) {
                return null;
            }
            ReverseHost reverseHost = new ReverseHost(string, string2, domainObject.getDomName());
            reverseHost.setPTRttl(n2);
            if (this.isUniqueHostName(reverseHost.getHostName(), domainObject.getDomName())) {
                if (this.giveAHost(reverseHost, domainObject.getDomName())) {
                    this.linkHost(reverseHost, domainObject.getDomName());
                }
                return domainObject.getDomName();
            }
            return null;
        }
        return null;
    }

    public void setETCpath(String string) {
        this.theETCpath = new String(string);
        if (this.theFileGenerator != null) {
            this.theFileGenerator.setDefaultDirectory(String.valueOf(this.theETCpath) + File.separator + DNS_DIRECTORY);
        }
    }

    public String getETCpath() {
        return this.theETCpath;
    }

    public String[] getListOfDomains() {
        Enumeration enumeration = this.theDomains.elements();
        String[] stringArray = new String[this.theDomains.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            DomainObject domainObject = (DomainObject)enumeration.nextElement();
            stringArray[n++] = new String(domainObject.getDomName());
        }
        return stringArray;
    }

    public String[] importCacheFile(String string) {
        NameServerObject nameServerObject = new NameServerObject(this.theETCpath);
        nameServerObject.setCacheFileName(string);
        this.cacheFile = new CacheFile(this.traceClient, this.theServerResources);
        this.cacheFile.readFile(string, nameServerObject);
        NameAndIpAddressList nameAndIpAddressList = nameServerObject.getRootServers();
        if (nameAndIpAddressList != null) {
            String[] stringArray = new String[nameAndIpAddressList.size()];
            Enumeration enumeration = nameAndIpAddressList.elements();
            int n = 0;
            while (n < nameAndIpAddressList.size()) {
                NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
                stringArray[n] = new String(String.valueOf(nameAndIpAddress.getFqName()) + ";" + nameAndIpAddress.getIpAddress());
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public boolean readConfig(String string) {
        NameServerObject nameServerObject;
        this.clearConfig();
        boolean bl = this.bootFile.readFile(string, this);
        if (bl) {
            String string2;
            nameServerObject = this.getFirstNameServer();
            File file = new File(nameServerObject.getBootFileName());
            String string3 = file.getParent();
            if (!string3.equalsIgnoreCase(string2 = new String(String.valueOf(this.theETCpath) + File.separator + DNS_DIRECTORY))) {
                nameServerObject.setBootFileName(String.valueOf(string2) + File.separator + file.getName());
            }
            String string4 = nameServerObject.getCacheFileName();
            this.cacheFile.readFile(string4, nameServerObject);
        }
        if (bl) {
            this.readDomFiles();
        }
        if (bl) {
            this.configFile.readFile(this.theETCpath);
        } else {
            this.configFile.setETCvariable(this.theETCpath);
        }
        this.syslogFile.readFile(this.theETCpath);
        this.saveInitialDomainData();
        nameServerObject = this.getFirstNameServer();
        if (nameServerObject != null) {
            nameServerObject.saveInitialNameServerNames();
        }
        return bl;
    }

    public boolean writeConfig(boolean bl) {
        boolean bl2 = this.serverIsUp();
        if (bl) {
            this.stopServer(true);
        }
        NameServerObject nameServerObject = this.getFirstNameServer();
        boolean bl3 = this.bootFile.writeFile(this, nameServerObject, this.writeErrorsToFile);
        String string = nameServerObject.getCacheFileName();
        this.cacheFile.writeFile(string, nameServerObject, this.writeErrorsToFile);
        String[] stringArray = this.getAllPrimaryDomainNames();
        int n = 0;
        while (n < stringArray.length) {
            PrimaryDomain primaryDomain = (PrimaryDomain)this.getADomain(stringArray[n]);
            TheDomainFile theDomainFile = primaryDomain.getStoredFile();
            if (theDomainFile == null) {
                theDomainFile = !primaryDomain.getDomName().equals(".") ? new TheDomainFile(primaryDomain.getDomName(), this.traceClient, this.theServerResources) : new TheRootDomainFile(primaryDomain.getDomName(), this.traceClient, this.theServerResources);
            }
            if (primaryDomain.isDynamic()) {
                PrimaryDomain primaryDomain2 = primaryDomain.didReadDataFromFile() ? this.mergeDomainFileData(primaryDomain) : primaryDomain;
                if (primaryDomain2.getSeparateDynStatData()) {
                    if (bl || !primaryDomain2.didReadDataFromFile()) {
                        theDomainFile.writeTwoDomainFiles(this, primaryDomain2.getDataFileName(), stringArray[n], this.writeErrorsToFile);
                    } else {
                        theDomainFile.writeStaticDomainFileOnly(this, primaryDomain2.getDataFileName(), stringArray[n], this.writeErrorsToFile);
                    }
                } else {
                    theDomainFile.writeOneDomainFile(this, primaryDomain2.getDataFileName(), stringArray[n], this.writeErrorsToFile);
                }
            } else {
                theDomainFile.writeOneDomainFile(this, primaryDomain.getDataFileName(), stringArray[n], this.writeErrorsToFile);
            }
            ++n;
        }
        this.configFile.writeFile();
        this.syslogFile.writeFile();
        if (bl) {
            if (bl2) {
                this.restartServer(true);
            } else if (this.os2SemHandle != 0) {
                this.lsn.releaseNameServerLock(this.os2SemHandle);
            }
        }
        return bl3;
    }

    public void setWriteErrorsToFile(boolean bl) {
        this.writeErrorsToFile = bl;
    }

    public void setDynamicValues(int n, int n2) {
        this.leaseTimeForDyn = n;
        this.padFactor = n2;
    }

    public String[] doGenerateKeys(ParsedVector parsedVector) {
        Object object;
        String[] stringArray = parsedVector.getKeys();
        Vector<String> vector = new Vector<String>();
        NameServerObject nameServerObject = this.getFirstNameServer();
        PrimaryDomain primaryDomain = null;
        ReservedName reservedName = null;
        Vector<Object> vector2 = new Vector<Object>();
        ParsedObject parsedObject = parsedVector.getElement("dir");
        String string = (String)parsedObject.getValue();
        File file = new File(string);
        file.mkdirs();
        parsedObject = parsedVector.getElement("name");
        String string2 = (String)parsedObject.getValue();
        primaryDomain = (PrimaryDomain)this.getADomain(string2);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("host")) {
                vector = new Vector();
                vector.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
                vector.addElement("-d " + string2 + " ");
                vector.addElement("-p " + nameServerObject.firstName() + " ");
                vector.addElement("-g ");
                parsedObject = parsedVector.get(n);
                object = (String)parsedObject.getValue();
                vector.addElement("-h " + (String)object + " ");
                String string3 = null;
                string3 = ((String)object).length() >= 8 ? new String(((String)object).substring(0, 7)) : new String((String)object);
                if (!string.endsWith(File.separator)) {
                    vector.addElement("-k " + string + File.separator + string3 + ".key");
                } else {
                    vector.addElement("-k " + string + string3 + ".key");
                }
                boolean bl = this.issueNsupdate(vector, true);
                if (bl) {
                    Vector<String> vector3 = new Vector<String>();
                    vector3.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
                    vector3.addElement("-a -d " + string2 + " ");
                    vector3.addElement("-x " + this.theETCpath + File.separator + "ddns.dat ");
                    vector3.addElement("-p " + nameServerObject.firstName() + " ");
                    vector3.addElement("-h " + (String)object + " ");
                    if (!string.endsWith(File.separator)) {
                        vector3.addElement("-k " + string + File.separator + string3 + ".key");
                    } else {
                        vector3.addElement("-k " + string + string3 + ".key");
                    }
                    vector3.addElement("-s\"a;KEY;s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
                    bl = this.issueNsupdate(vector3, true);
                    if (bl && this.giveAHost(reservedName = new ReservedName((String)object), string2, "PresecuredName")) {
                        this.linkHost(reservedName, string2);
                    }
                }
                if (!bl) {
                    vector2.addElement(object);
                }
                vector = new Vector();
            }
            ++n;
        }
        if (!vector2.isEmpty()) {
            object = new String[vector2.size()];
            vector2.copyInto((Object[])object);
            return object;
        }
        return null;
    }

    public void createDomainAdminKey(String string) {
        Vector<String> vector = new Vector<String>();
        NameServerObject nameServerObject = this.getFirstNameServer();
        String string2 = String.valueOf(this.theETCpath) + File.separator + "ddns.dat";
        vector.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
        vector.addElement("-h " + string + " ");
        vector.addElement("-p " + nameServerObject.firstName() + " ");
        vector.addElement("-g");
        vector.addElement(" -k " + string2);
        this.issueNsupdate(vector, true);
        PrimaryDomain primaryDomain = (PrimaryDomain)this.getADomain(string);
        if (primaryDomain != null) {
            this.setDomainKey(primaryDomain, string2, nameServerObject.firstName());
        }
    }

    public void initSelf() {
        this.clearConfig();
        this.theFileGenerator = new GenerateFileName(String.valueOf(this.theETCpath) + File.separator + DNS_DIRECTORY, this);
        this.writeErrorsToFile = true;
        this.leaseTimeForDyn = 3600;
        this.padFactor = 3110400;
    }

    public String[] getUnseparatedDynamicDomains() {
        Enumeration enumeration = this.theDomains.elements();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            DomainObject domainObject = (DomainObject)enumeration.nextElement();
            if (!(domainObject instanceof PrimaryDomain) || !((PrimaryDomain)domainObject).isDynamic() || ((PrimaryDomain)domainObject).getSeparateDynStatData()) continue;
            vector.addElement(domainObject.getDomName());
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void separateDynamicDomains() {
        String[] stringArray = this.getUnseparatedDynamicDomains();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                PrimaryDomain primaryDomain = (PrimaryDomain)this.getADomain(stringArray[n]);
                if (primaryDomain != null) {
                    primaryDomain.setStaticFileName(this.theFileGenerator.getStaticFileName());
                    primaryDomain.setSeparateDynStatData(true);
                }
                ++n;
            }
        }
    }

    public String[] getBootFileData() {
        return this.bootFile.writeFileToDisplay(this, this.getFirstNameServer());
    }

    public void clearConfig() {
        this.theNameServers = new Hashtable();
        this.theDomains = new Hashtable();
        this.theHosts = new Hashtable();
        this.noOfPriDom = 0;
        this.noOfSecDom = 0;
        this.lastAction = "";
        this.bootFile = new TheBootFile(this.traceClient, this.theServerResources);
        this.cacheFile = new CacheFile(this.traceClient, this.theServerResources);
        this.configFile = new TheConfigFile(this, this.traceClient, this.theServerResources);
        this.configFile.setETCvariable(this.theETCpath);
        this.syslogFile = new TheSyslogFile(this, this.traceClient, this.theServerResources);
        this.syslogFile.setETCvariable(this.theETCpath);
        this.userSettings = null;
    }

    public boolean serverIsUp() {
        this.os2SemHandle = this.lsn.getNameServerLock();
        if (this.os2SemHandle != 0) {
            this.lsn.releaseNameServerLock(this.os2SemHandle);
            this.os2SemHandle = 0;
            return false;
        }
        return true;
    }

    public void stopServer(boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[]{new String(this.getNSsigCmd()), new String(" -KILL")};
        try {
            Process process = runtime.exec(stringArray);
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {}
        if (bl) {
            this.os2SemHandle = this.lsn.getNameServerLock();
        }
    }

    public void restartServer(boolean bl) {
        if (this.os2SemHandle != 0) {
            this.lsn.releaseNameServerLock(this.os2SemHandle);
        }
        if (bl) {
            Runtime runtime = Runtime.getRuntime();
            String[] stringArray = new String[2];
            NameServerObject nameServerObject = this.getFirstNameServer();
            stringArray[0] = new String(this.getNamedCmd());
            stringArray[1] = "-b " + nameServerObject.getBootFileName();
            try {
                runtime.exec(stringArray);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public void reinitServer() {
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[]{new String(this.getNSsigCmd()), new String(" -HUP")};
        try {
            Process process = runtime.exec(stringArray);
            try {
                process.waitFor();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private boolean readDomFiles() {
        Enumeration enumeration = this.getAllDomains();
        while (enumeration.hasMoreElements()) {
            try {
                DomainObject domainObject = (DomainObject)enumeration.nextElement();
                TheDomainFile theDomainFile = !domainObject.getDomName().equals(".") ? new TheDomainFile(domainObject.getDomName(), this.traceClient, this.theServerResources) : new TheRootDomainFile(domainObject.getDomName(), this.traceClient, this.theServerResources);
                theDomainFile.readFile(domainObject.getDataFileName());
                theDomainFile.loadDataModel(this);
                domainObject.storeFile(theDomainFile);
                if (!(domainObject instanceof PrimaryDomain)) continue;
                ((PrimaryDomain)domainObject).saveInitialDynamicData();
                ((PrimaryDomain)domainObject).setReadFromFile();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.traceClient.traceTime("error reading domain file");
            }
        }
        return true;
    }

    private void saveInitialDomainData() {
        Enumeration enumeration = this.getAllDomains();
        while (enumeration.hasMoreElements()) {
            DomainObject domainObject = (DomainObject)enumeration.nextElement();
            if (!(domainObject instanceof PrimaryDomain)) continue;
            ((PrimaryDomain)domainObject).saveInitialDynamicData();
            ((PrimaryDomain)domainObject).setReadFromFile();
        }
    }

    private boolean deleteDynamic(String string, HostOrAlias hostOrAlias, String string2) {
        NameServerObject nameServerObject = this.getFirstNameServer();
        Vector<String> vector = new Vector<String>();
        vector.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
        vector.addElement(" -h " + string + " ");
        vector.addElement(" -p " + nameServerObject.firstName() + " -a" + " ");
        vector.addElement(" -s\"d;MX;*;d;TXT;*;d;CNAME;*;d;PTR;*;d;A;*;d;HINFO;*;s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
        boolean bl = this.issueNsupdate(vector, true);
        if (bl) {
            ReservedName reservedName = new ReservedName(hostOrAlias.getHostName());
            reservedName.setComments(hostOrAlias.getComments());
            reservedName.setSIGRecs(hostOrAlias.getSIGRecs());
            reservedName.setKEYRecs(hostOrAlias.getKEYRecs());
            if (this.giveAHost(reservedName, string2, "noNsupdatesNeeded")) {
                this.linkHost(reservedName, string2);
            }
        }
        return bl;
    }

    private String getNSupdateCmd() {
        int n = this.theETCpath.lastIndexOf(File.separator);
        StringBuffer stringBuffer = n >= 0 ? new StringBuffer(this.theETCpath.substring(0, n)) : new StringBuffer(this.theETCpath);
        stringBuffer.append(String.valueOf(File.separator) + "bin" + File.separator + "nsupdate.exe");
        return stringBuffer.toString();
    }

    private String getNSsigCmd() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.theDirectory) + File.separator + "nssig.exe");
        return stringBuffer.toString();
    }

    private String getNamedCmd() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.theDirectory) + File.separator + "named.exe");
        return stringBuffer.toString();
    }

    private String getDirectory() {
        StringBuffer stringBuffer = new StringBuffer(this.getETCpath());
        stringBuffer.append(File.separator);
        stringBuffer.append(".." + File.separator + "bin");
        try {
            String string = System.getProperty("java.class.path");
            string = string.toLowerCase();
            String string2 = System.getProperty("path.separator");
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.endsWith("ddnssgui.jar")) continue;
                int n = string3.lastIndexOf("ddnssgui.jar");
                try {
                    return String.valueOf(string3.substring(0, n - 1)) + File.separator + ".." + File.separator + "bin";
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return stringBuffer.toString();
                }
            }
        }
        catch (SecurityException securityException) {
            return stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    private boolean doNsupdatesForHost(HostObject hostObject, String string) {
        int n;
        String[] stringArray;
        int n2;
        Object object;
        Object object2;
        int n3;
        boolean bl = true;
        NameServerObject nameServerObject = this.getFirstNameServer();
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer("");
        vector.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
        vector.addElement("-d " + string + " ");
        vector.addElement(" -h " + hostObject.getHostName() + " ");
        vector.addElement(" -p " + nameServerObject.firstName() + " -a" + " ");
        int n4 = hostObject.getMXTTL();
        if (n4 < 0) {
            stringBuffer.append(" -s\"d;MX;*;");
        } else {
            stringBuffer.append(" -s\"d;MX;*;t;" + n4 + ";");
        }
        String[] stringArray2 = hostObject.getMailExchange();
        if (stringArray2 != null && stringArray2.length > 0) {
            n3 = 0;
            while (n3 < stringArray2.length) {
                object2 = new StringBuffer("a;MX;");
                object = new StringTokenizer(stringArray2[n3]);
                if (((StringTokenizer)object).hasMoreElements()) {
                    ((StringBuffer)object2).append(String.valueOf(((StringTokenizer)object).nextToken()) + ";");
                }
                if (((StringTokenizer)object).hasMoreElements()) {
                    ((StringBuffer)object2).append(String.valueOf(((StringTokenizer)object).nextToken()) + ";");
                }
                stringBuffer.append(((StringBuffer)object2).toString());
                ++n3;
            }
        }
        stringBuffer.append("s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
        vector.addElement(stringBuffer.toString());
        bl = this.issueNsupdate(vector, true);
        vector = new Vector();
        vector.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
        vector.addElement("-d " + string + " ");
        vector.addElement(" -h " + hostObject.getHostName() + " ");
        vector.addElement(" -p " + nameServerObject.firstName() + " -a" + " ");
        n3 = hostObject.getHINFOTTL();
        stringBuffer = new StringBuffer("");
        if (n3 < 0) {
            stringBuffer.append(" -s\"d;HINFO;*;");
        } else {
            stringBuffer.append(" -s\"d;HINFO;*;t;" + n3 + ";");
        }
        object2 = hostObject.getCpuOpSys();
        if (object2 != null && ((PlatformList)object2).size() > 0) {
            n2 = 0;
            while (n2 < ((PlatformList)object2).size()) {
                stringArray = new StringBuffer("a;HINFO;");
                object = ((PlatformList)object2).getPlatform(n2);
                stringArray.append(String.valueOf(((Platform)object).getCPU()) + ";");
                stringArray.append(String.valueOf(((Platform)object).getOS()) + ";");
                stringBuffer.append(stringArray.toString());
                ++n2;
            }
        }
        stringBuffer.append("s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
        vector.addElement(stringBuffer.toString());
        if (bl) {
            bl = this.issueNsupdate(vector, true);
        }
        vector = new Vector();
        vector.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
        vector.addElement("-d " + string + " ");
        vector.addElement(" -h " + hostObject.getHostName() + " ");
        vector.addElement(" -p " + nameServerObject.firstName() + " -a" + " ");
        n2 = hostObject.getATTL();
        stringBuffer = new StringBuffer("");
        if (n2 < 0) {
            stringBuffer.append(" -s\"d;A;*;");
        } else {
            stringBuffer.append(" -s\"d;A;*;t;" + n2 + ";");
        }
        stringArray = hostObject.getAllIpAddresses();
        if (stringArray != null && stringArray.length > 0) {
            n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("a;A;" + stringArray[n] + ";");
                ++n;
            }
        }
        stringBuffer.append("s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
        vector.addElement(stringBuffer.toString());
        if (bl) {
            bl = this.issueNsupdate(vector, true);
        }
        vector = new Vector();
        vector.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
        vector.addElement("-d " + string + " ");
        vector.addElement(" -h " + hostObject.getHostName() + " ");
        vector.addElement(" -p " + nameServerObject.firstName() + " -a" + " ");
        n = hostObject.getTXTTTL();
        stringBuffer = new StringBuffer("");
        if (n < 0) {
            stringBuffer.append(" -s\"d;TXT;*;");
        } else {
            stringBuffer.append(" -s\"d;TXT;*;t;" + n + ";");
        }
        String[] stringArray3 = hostObject.getTextEntry();
        if (stringArray3 != null && stringArray3.length > 0) {
            int n5 = 0;
            while (n5 < stringArray3.length) {
                StringBuffer stringBuffer2 = new StringBuffer("a;TXT;");
                stringBuffer2.append(String.valueOf(stringArray3[n5]) + ";");
                stringBuffer.append(stringBuffer2.toString());
                ++n5;
            }
        }
        stringBuffer.append("s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
        vector.addElement(stringBuffer.toString());
        if (bl) {
            bl = this.issueNsupdate(vector, true);
        }
        return bl;
    }

    private boolean issueNsupdate(Vector vector, boolean bl) {
        block9: {
            Runtime runtime = Runtime.getRuntime();
            int n = -1;
            if (vector == null || vector.isEmpty()) break block9;
            try {
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    stringBuffer.append(" " + (String)objectArray[n2]);
                    ++n2;
                }
                this.traceClient.traceTime("issuing nsupdate command: " + stringBuffer.toString());
                Process process = runtime.exec((String[])objectArray);
                if (bl) {
                    try {
                        n = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                    try {
                        if (n != 0) {
                            this.traceClient.traceTime("return code from nsupdate is " + n);
                            return false;
                        }
                        return true;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        break block9;
                    }
                }
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private boolean doNsupdatesForAlias(AliasHostObject aliasHostObject, String string) {
        NameServerObject nameServerObject = this.getFirstNameServer();
        Vector<String> vector = new Vector<String>();
        vector.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
        vector.addElement("-d " + string);
        vector.addElement(" -h " + aliasHostObject.getHostName());
        vector.addElement(" -p " + nameServerObject.firstName() + " -a");
        StringBuffer stringBuffer = new StringBuffer(" -s\"d;CNAME;*;");
        int n = aliasHostObject.getCNAMEttl();
        if (n < 0) {
            stringBuffer.append(";a;CNAME;" + aliasHostObject.getRealHostName() + "." + ";s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
        } else {
            stringBuffer.append("t;" + n + ";a;CNAME;" + aliasHostObject.getRealHostName() + "." + ";s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
        }
        vector.addElement(stringBuffer.toString());
        return this.issueNsupdate(vector, true);
    }

    private boolean doNsupdatesForReverse(ReverseHost reverseHost, String string) {
        String string2 = new String(String.valueOf(ReverseHost.addrFromReverseDom(string)) + "." + reverseHost.getHostName());
        NameServerObject nameServerObject = this.getFirstNameServer();
        Vector<String> vector = new Vector<String>();
        vector.addElement(String.valueOf(this.getNSupdateCmd()) + " ");
        vector.addElement("-d " + string);
        vector.addElement("-r " + string2);
        vector.addElement("-p " + nameServerObject.firstName() + " -a");
        StringBuffer stringBuffer = new StringBuffer("-s\"d;PTR;*;");
        int n = reverseHost.getPTRttl();
        if (n < 0) {
            stringBuffer.append("a;PTR;" + reverseHost.getPTRhostname() + "." + ";s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
        } else {
            stringBuffer.append("t;" + n + ";a;PTR;" + reverseHost.getPTRhostname() + "." + "s;" + this.leaseTimeForDyn + ";" + this.padFactor + ";" + "q\"");
        }
        vector.addElement(stringBuffer.toString());
        return this.issueNsupdate(vector, true);
    }

    /*
     * Unable to fully structure code
     */
    private void checkForNameServerNames(String var1_1) {
        var2_2 = this.getFirstNameServer();
        var3_3 = var2_2.getFQNames();
        var4_4 = var3_3.elements();
        if (!var1_1.toLowerCase().endsWith("in-addr.arpa")) ** GOTO lbl31
        while (var4_4.hasMoreElements()) {
            var7_7 = (NameAndIpAddress)var4_4.nextElement();
            var5_5 = var7_7.getIpAddress();
            var11_10 = ReverseHost.reverseDomainFromAddrClassC(var5_5);
            if (!var11_10.equalsIgnoreCase(var1_1)) {
                var11_10 = ReverseHost.reverseDomainFromAddrClassB(var5_5);
            }
            if (!var11_10.equalsIgnoreCase(var1_1)) {
                var11_10 = ReverseHost.reverseDomainFromAddrClassA(var5_5);
            }
            if (!var11_10.equalsIgnoreCase(var1_1) || !this.giveAHost(var10_9 = new ReverseHost(var5_5, var7_7.getFqName(), var1_1), var1_1)) continue;
            this.linkHost(var10_9, var1_1);
        }
        return;
lbl-1000:
        // 1 sources

        {
            var7_8 = (NameAndIpAddress)var4_4.nextElement();
            var5_6 = var7_8.getFqName();
            var6_11 = var5_6.indexOf(var1_1);
            if (var6_11 <= 0) continue;
            var8_12 = var5_6.substring(0, var6_11 - 1);
            if (var8_12.indexOf(".") < 0) {
                var9_13 = new HostObject();
                var9_13.setHostName(var8_12);
                var9_13.setIpAddress(var7_8.getIpAddress());
                if (this.giveAHost(var9_13, var1_1)) {
                    this.linkHost(var9_13, var1_1);
                }
            }
            if ((var12_14 = (PrimaryDomain)this.getADomain(var1_1)) == null || !var12_14.getReverseMappingState() || this.reverseDomExist(var7_8.getIpAddress()) != 2) continue;
            this.addReverseMapping(var7_8.getIpAddress(), var5_6, 2, var1_1, var12_14.getTTL());
lbl31:
            // 4 sources

            ** while (var4_4.hasMoreElements())
        }
lbl32:
        // 1 sources

    }

    private void checkForChildDomains(String string) {
        String string2;
        int n;
        DomainObject domainObject;
        NameServerObject nameServerObject = this.getFirstNameServer();
        NameAndIpAddressList nameAndIpAddressList = nameServerObject.getFQNames();
        Enumeration enumeration = this.theDomains.elements();
        while (enumeration.hasMoreElements()) {
            domainObject = (DomainObject)enumeration.nextElement();
            if (!string.endsWith(domainObject.getDomName()) || (n = string.lastIndexOf("." + domainObject.getDomName())) <= 0 || (string2 = string.substring(0, n)).indexOf(".") >= 0) continue;
            this.addChildNameServerToDomain(domainObject.getDomName(), string, nameAndIpAddressList);
        }
        enumeration = this.theDomains.elements();
        while (enumeration.hasMoreElements()) {
            domainObject = (DomainObject)enumeration.nextElement();
            if (!domainObject.getDomName().endsWith(string) || (n = domainObject.getDomName().lastIndexOf("." + string)) <= 0 || (string2 = domainObject.getDomName().substring(0, n)).indexOf(".") >= 0) continue;
            this.addChildNameServerToDomain(string, domainObject.getDomName(), nameAndIpAddressList);
        }
    }

    private void addChildNameServerToDomain(String string, String string2, NameAndIpAddressList nameAndIpAddressList) {
        DomainObject domainObject = this.getADomain(string);
        if (domainObject == null || domainObject instanceof SecondaryDomain) {
            return;
        }
        String string3 = domainObject.getChildNameServerAddrFor(string2);
        if (string3 == null) {
            Enumeration enumeration = nameAndIpAddressList.elements();
            while (enumeration.hasMoreElements()) {
                NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
                domainObject.addChildNameServer(new ChildNameServer(nameAndIpAddress.getFqName(), nameAndIpAddress.getIpAddress(), string2));
            }
        }
    }

    private PrimaryDomain mergeDomainFileData(PrimaryDomain primaryDomain) {
        HostOrAlias hostOrAlias;
        Vector<HostOrAlias> vector = new Vector<HostOrAlias>();
        Enumeration enumeration = primaryDomain.getHosts();
        while (enumeration.hasMoreElements()) {
            hostOrAlias = (HostOrAlias)enumeration.nextElement();
            if (hostOrAlias.isDynamic()) continue;
            vector.addElement(hostOrAlias);
        }
        this.deleteDomainForMerge(primaryDomain);
        PrimaryDomain primaryDomain2 = new PrimaryDomain();
        primaryDomain.copyInto(primaryDomain2);
        this.giveADomain(primaryDomain2, "merge");
        this.linkDomain(primaryDomain2, this.getFirstNameServer());
        TheDomainFile theDomainFile = !primaryDomain2.getDomName().equals(".") ? new TheDomainFile(primaryDomain2.getDomName(), this.traceClient, this.theServerResources) : new TheRootDomainFile(primaryDomain2.getDomName(), this.traceClient, this.theServerResources);
        theDomainFile.readFile(primaryDomain2.getDataFileName());
        theDomainFile.loadDataModel(this);
        Enumeration enumeration2 = primaryDomain2.getHosts();
        while (enumeration2.hasMoreElements()) {
            hostOrAlias = (HostOrAlias)enumeration2.nextElement();
            if (hostOrAlias.isDynamic()) continue;
            this.deleteAHostForMerge(hostOrAlias.getHostName(), primaryDomain2.getDomName());
        }
        Enumeration enumeration3 = vector.elements();
        while (enumeration3.hasMoreElements()) {
            hostOrAlias = (HostOrAlias)enumeration3.nextElement();
            if (this.theHostNowExists(hostOrAlias.getHostName(), primaryDomain2.getDomName()) || !this.giveAHost(hostOrAlias, primaryDomain2.getDomName())) continue;
            this.linkHost(hostOrAlias, primaryDomain2.getDomName());
        }
        primaryDomain2.setNameServerTTL(primaryDomain.getNameServerTTL());
        primaryDomain2.setSoaTTL(primaryDomain.getSoaTTL());
        primaryDomain2.setRefreshRt(primaryDomain.getRefreshRt());
        primaryDomain2.setRetryInterval(primaryDomain.getRetryInterval());
        primaryDomain2.setExpirationTime(primaryDomain.getExpirationTime());
        primaryDomain2.setNameServerSetforDomain(new NameAndIpAddressList(primaryDomain.getNameServerSetforDomain()));
        primaryDomain2.setAdminEmail(primaryDomain.getAdminEmail());
        primaryDomain2.setMailExchange(primaryDomain.getMailExchange());
        primaryDomain2.storeFile(theDomainFile);
        primaryDomain2.setChildNameServers(primaryDomain.getChildNameServers());
        primaryDomain2.saveInitialDynamicData();
        primaryDomain2.setReadFromFile();
        return primaryDomain2;
    }

    public void deleteDomainForMerge(DomainObject domainObject) {
        Enumeration enumeration = domainObject.getHosts();
        while (enumeration.hasMoreElements()) {
            HostOrAlias hostOrAlias = (HostOrAlias)enumeration.nextElement();
            String string = !domainObject.getDomName().equals(".") ? new String(String.valueOf(hostOrAlias.getHostName()) + "." + domainObject.getDomName()) : new String(hostOrAlias.getHostName());
            this.theHosts.remove(string);
        }
        this.theDomains.remove(domainObject.getDomName());
        this.bootFile.removeDomainFromFile(domainObject.getDomName());
        --this.noOfPriDom;
    }

    public boolean deleteAHostForMerge(String string, String string2) {
        String string3 = !string2.equals(".") ? new String(String.valueOf(string) + "." + string2) : new String(string);
        Object v = this.theHosts.remove(string3);
        if (v != null) {
            DomainObject domainObject = this.getADomain(string2);
            domainObject.removeHostFromDomain(string);
            return true;
        }
        return false;
    }

    public boolean theHostNowExists(String string, String string2) {
        String string3 = !string2.equals(".") ? new String(String.valueOf(string) + "." + string2) : new String(string);
        Object v = this.theHosts.get(string3);
        return v != null;
    }

    private void setDomainKey(PrimaryDomain primaryDomain, String string, String string2) {
        String string3 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            try {
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
                    if (stringTokenizer.hasMoreTokens() && primaryDomain.getDomName().equalsIgnoreCase(stringTokenizer.nextToken()) && stringTokenizer.hasMoreTokens() && string2.equalsIgnoreCase(stringTokenizer.nextToken())) {
                        if (stringTokenizer.hasMoreTokens()) {
                            String string5 = stringTokenizer.nextToken();
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            string3 = "80 0 1 " + stringTokenizer.nextToken();
                        }
                    }
                    string4 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {}
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (string3 != null) {
            primaryDomain.addKEYRec(" IN KEY " + string3);
        }
    }
}

