/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ChildNameServer;
import COM.ibm.raleigh.ddnssgui.common.FileItem;
import COM.ibm.raleigh.ddnssgui.common.HostOrAlias;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.TheDomainFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DomainObject
extends FileItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String DOM_tag = "DOM";
    public static final String EDOM_tag = "EDOM";
    public static final String nSetl_tag = "NSetL";
    public static final String enSetl_tag = "ENSetL";
    private static final String fQDN_tag = "FQDN";
    private static final String servers_tag = "Servers";
    private static final String notify_tag = "Notify";
    private static final String nSet_tag = "NSet";
    private static final String serialNo_tag = "SerialNo";
    private static final String rRate_tag = "RRate";
    private static final String retry_tag = "Retry";
    private static final String exTime_tag = "ExTime";
    private static final String tTL_tag = "TTL";
    private static final String domFile_tag = "DomFile";
    private static final String numHosts_tag = "NumHosts";
    private static final String hosts_tag = "Hosts";
    private static final String nRetry_tag = "NotRetry";
    private static final String nDelay_tag = "NotDelay";
    private static final String retryNum_tag = "RetryNum";
    private static final String numMx_tag = "NumMx";
    private static final String mX_tag = "MX";
    private static final String mTTL_tag = "MTTL";
    private static final String sOAttl_tag = "SOAttl";
    private static final String nSttl_tag = "NSttl";
    private static final String notifyIP_tag = "NotifyIp";
    protected String fQDomainName;
    protected NameAndIpAddressList nameServersForDomain;
    protected boolean notifyOrNot;
    protected Vector notifySetForDomain;
    protected int domainSerialNumber;
    protected int refreshRate;
    protected int retryInterval;
    protected int expirationTime;
    protected int timeToLive;
    protected Hashtable myHosts;
    protected String domainDataFile;
    protected Vector childServers;
    protected TheDomainFile fileReadIn;
    protected String administratorEmail;
    protected int notifyDelayTime;
    protected int notifyRetryTime;
    protected int notifyRetryNum;
    protected Vector mailExchange;
    protected int mailTTL;
    protected int nameServerTTL;
    protected int domainSoaTTL;

    public DomainObject() {
        this.setDefaults();
    }

    public DomainObject(ParsedVector parsedVector) {
        this.setDefaults();
        this.fromString(parsedVector);
    }

    public String getDomName() {
        return this.fQDomainName;
    }

    public void setDomName(String string) {
        if (string != null) {
            this.fQDomainName = string;
            return;
        }
        this.fQDomainName = new String("");
    }

    public void setNotifySetforDomain(String[] stringArray) {
        this.notifySetForDomain = new Vector();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                this.notifySetForDomain.addElement(stringArray[n]);
                ++n;
            }
        }
    }

    public String[] getNotifySetforDomain() {
        if (this.notifySetForDomain.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[this.notifySetForDomain.size()];
        this.notifySetForDomain.copyInto(objectArray);
        return objectArray;
    }

    public void setNameServerSetforDomain(NameAndIpAddressList nameAndIpAddressList) {
        if (nameAndIpAddressList != null) {
            this.nameServersForDomain = nameAndIpAddressList;
            return;
        }
        this.nameServersForDomain = new NameAndIpAddressList();
    }

    public void addNameServerforDomain(String string, String string2) {
        this.nameServersForDomain.addAPair(string, string2);
    }

    public NameAndIpAddressList getNameServerSetforDomain() {
        if (this.nameServersForDomain.isEmpty()) {
            return null;
        }
        return this.nameServersForDomain;
    }

    public boolean getNotify() {
        return this.notifyOrNot;
    }

    public void setNotify(boolean bl) {
        this.notifyOrNot = bl;
    }

    public void addHostToDomain(HostOrAlias hostOrAlias) {
        try {
            this.myHosts.put(hostOrAlias.getHostName(), hostOrAlias);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public void removeHostFromDomain(String string) {
        this.myHosts.remove(string);
    }

    public boolean isHostInDomain(String string) {
        Object v = this.myHosts.get(string);
        return v != null;
    }

    public void setNotifyDelayTime(int n) {
        this.notifyDelayTime = n;
    }

    public int getNotifyDelayTime() {
        return this.notifyDelayTime;
    }

    public void setNotifyRetryTime(int n) {
        this.notifyRetryTime = n;
    }

    public int getNotifyRetryTime() {
        return this.notifyRetryTime;
    }

    public void setNotifyRetryNum(int n) {
        this.notifyRetryNum = n;
    }

    public int getNotifyRetryNum() {
        return this.notifyRetryNum;
    }

    public void setMailTTL(int n) {
        this.mailTTL = n;
    }

    public void setGreaterMailTTL(int n) {
        if (this.mailTTL < n) {
            this.mailTTL = n;
        }
    }

    public int getMailTTL() {
        return this.mailTTL;
    }

    public void setNameServerTTL(int n) {
        this.nameServerTTL = n;
    }

    public void setGreaterNameServerTTL(int n) {
        if (n > this.nameServerTTL) {
            this.nameServerTTL = n;
        }
    }

    public int getNameServerTTL() {
        return this.nameServerTTL;
    }

    public void setSoaTTL(int n) {
        this.domainSoaTTL = n;
    }

    public int getSoaTTL() {
        return this.domainSoaTTL;
    }

    public Enumeration getHosts() {
        return this.myHosts.elements();
    }

    public void setMailExchange(String[] stringArray) {
        this.mailExchange = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.mailExchange.addElement(stringArray[n]);
                ++n;
            }
        }
    }

    public void addMailExchange(String string) {
        this.mailExchange.addElement(string);
    }

    public String[] getMailExchange() {
        Object[] objectArray = null;
        if (this.mailExchange.isEmpty()) {
            return null;
        }
        objectArray = new String[this.mailExchange.size()];
        this.mailExchange.copyInto(objectArray);
        return objectArray;
    }

    public String[] getNonSecondaryAddrsAddedToNotifyList() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.notifySetForDomain.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.addrIsInList(this.nameServersForDomain, string)) continue;
            vector.addElement(string);
        }
        if (!vector.isEmpty()) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public String[] getSecondaryAddrsRemovedFromNotifyList() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.nameServersForDomain.elements();
        while (enumeration.hasMoreElements()) {
            NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
            if (this.addrIsInList(this.notifySetForDomain, nameAndIpAddress.getIpAddress())) continue;
            vector.addElement(nameAndIpAddress.getIpAddress());
        }
        if (!vector.isEmpty()) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public String makeBootFileEntry() {
        return "base class called";
    }

    public void addToNotifyList(String string) {
        this.notifySetForDomain.addElement(string);
    }

    public void removeFromNotifyList(String string) {
        if (this.notifySetForDomain != null) {
            Enumeration enumeration = this.notifySetForDomain.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.equals(string)) continue;
                this.notifySetForDomain.removeElement(string2);
                return;
            }
        }
    }

    public String getNameServerAddrFor(String string) {
        String string2 = null;
        Enumeration enumeration = this.nameServersForDomain.elements();
        while (enumeration.hasMoreElements()) {
            NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
            if (!string.equalsIgnoreCase(nameAndIpAddress.getFqName())) continue;
            string2 = nameAndIpAddress.getIpAddress();
            break;
        }
        return string2;
    }

    public String getChildNameServerAddrFor(String string) {
        String string2 = null;
        Enumeration enumeration = this.childServers.elements();
        while (enumeration.hasMoreElements()) {
            ChildNameServer childNameServer = (ChildNameServer)enumeration.nextElement();
            if (!string.equalsIgnoreCase(childNameServer.getServerName())) continue;
            string2 = childNameServer.getServerIPaddress();
            break;
        }
        return string2;
    }

    public String[] writeSOARec(String string, boolean bl) {
        StringBuffer stringBuffer = this.domainSoaTTL < 0 ? new StringBuffer("@     IN     SOA " + string + ". ") : new StringBuffer("@     " + this.domainSoaTTL + " IN     SOA " + string + ". ");
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = new String[1];
        StringBuffer stringBuffer2 = new StringBuffer("     ");
        int n = 0;
        while (n < this.fQDomainName.length()) {
            stringBuffer2.append(" ");
            ++n;
        }
        if (!this.administratorEmail.equals("")) {
            stringBuffer.append(String.valueOf(this.administratorEmail) + ".");
        }
        stringBuffer.append(" (");
        vector.addElement(stringBuffer.toString());
        if (this instanceof PrimaryDomain && bl) {
            int n2 = this.domainSerialNumber + 1;
            stringBuffer = new StringBuffer(String.valueOf(stringBuffer2.toString()) + n2);
        } else {
            stringBuffer = new StringBuffer(String.valueOf(stringBuffer2.toString()) + String.valueOf(this.domainSerialNumber));
        }
        vector.addElement(stringBuffer.toString());
        stringBuffer = new StringBuffer(String.valueOf(stringBuffer2.toString()) + String.valueOf(this.refreshRate));
        vector.addElement(stringBuffer.toString());
        stringBuffer = new StringBuffer(String.valueOf(stringBuffer2.toString()) + String.valueOf(this.retryInterval));
        vector.addElement(stringBuffer.toString());
        stringBuffer = new StringBuffer(String.valueOf(stringBuffer2.toString()) + String.valueOf(this.expirationTime));
        vector.addElement(stringBuffer.toString());
        stringBuffer = new StringBuffer(String.valueOf(stringBuffer2) + String.valueOf(this.timeToLive));
        vector.addElement(String.valueOf(stringBuffer.toString()) + " )");
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] writeDynamicRecs() {
        String string;
        int n;
        Vector<String> vector = new Vector<String>();
        if (!this.sIGRecords.isEmpty()) {
            n = 0;
            while (n < this.sIGRecords.size()) {
                try {
                    string = (String)this.sIGRecords.elementAt(n);
                    if (!this.getDomName().equals(".")) {
                        vector.addElement(String.valueOf(this.getDomName()) + "." + " " + string);
                    } else {
                        vector.addElement(String.valueOf(this.getDomName()) + " " + string);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.kEYRecords.isEmpty()) {
            n = 0;
            while (n < this.kEYRecords.size()) {
                try {
                    string = (String)this.kEYRecords.elementAt(n);
                    if (!this.getDomName().equals(".")) {
                        vector.addElement(String.valueOf(this.getDomName()) + "." + " " + string);
                    } else {
                        vector.addElement(String.valueOf(this.getDomName()) + " " + string);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setDataFileName(String string) {
        if (string != null) {
            this.domainDataFile = string;
            return;
        }
        this.domainDataFile = new String("");
    }

    public String getDataFileName() {
        return this.domainDataFile;
    }

    public int getSerialNo() {
        return this.domainSerialNumber;
    }

    public int getRefreshRt() {
        return this.refreshRate;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getExpirationTime() {
        return this.expirationTime;
    }

    public int getTTL() {
        return this.timeToLive;
    }

    public void setSerialNo(int n) {
        this.domainSerialNumber = n;
    }

    public void setRefreshRt(int n) {
        this.refreshRate = n;
    }

    public void setRetryInterval(int n) {
        this.retryInterval = n;
    }

    public void setExpirationTime(int n) {
        this.expirationTime = n;
    }

    public void setTTL(int n) {
        this.timeToLive = n;
    }

    public void dump() {
    }

    public void addChildNameServer(String string, String string2, String string3, Vector vector) {
        this.childServers.addElement(new ChildNameServer(string, string2, string3, vector));
    }

    public void addChildNameServer(ChildNameServer childNameServer) {
        this.childServers.addElement(childNameServer);
    }

    public Enumeration getChildNameServers() {
        return this.childServers.elements();
    }

    public void setChildNameServers(Enumeration enumeration) {
        if (enumeration != null) {
            this.childServers = new Vector();
            while (enumeration.hasMoreElements()) {
                ChildNameServer childNameServer = (ChildNameServer)enumeration.nextElement();
                this.childServers.addElement(childNameServer);
            }
            return;
        }
        this.childServers = new Vector();
    }

    public boolean isAChildDomain(String string) {
        Enumeration enumeration = this.childServers.elements();
        boolean bl = false;
        while (!bl && enumeration.hasMoreElements()) {
            ChildNameServer childNameServer = (ChildNameServer)enumeration.nextElement();
            if (!string.equals(childNameServer.getDomForNameServer())) continue;
            bl = true;
        }
        return bl;
    }

    public void dumpMyHosts() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(DOM_tag);
        stringBuffer.append(",FQDN=" + this.fQDomainName);
        if (!this.nameServersForDomain.isEmpty()) {
            stringBuffer.append(",Servers");
            stringBuffer.append("," + this.nameServersForDomain.toString());
        } else {
            stringBuffer.append(",Servers");
        }
        if (this.notifyOrNot) {
            stringBuffer.append(",Notify=t");
        } else {
            stringBuffer.append(",Notify=f");
        }
        if (!this.notifySetForDomain.isEmpty()) {
            stringBuffer.append(",NSet");
            stringBuffer.append(",NSetL");
            Enumeration enumeration = this.notifySetForDomain.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(",NotifyIp=" + (String)enumeration.nextElement());
            }
            stringBuffer.append(",ENSetL");
        } else {
            stringBuffer.append(",NSet");
        }
        stringBuffer.append(",SerialNo=" + String.valueOf(this.domainSerialNumber));
        stringBuffer.append(",RRate=" + String.valueOf(this.refreshRate));
        stringBuffer.append(",Retry=" + String.valueOf(this.retryInterval));
        stringBuffer.append(",ExTime=" + String.valueOf(this.expirationTime));
        stringBuffer.append(",TTL=" + String.valueOf(this.timeToLive));
        stringBuffer.append(",DomFile=" + this.domainDataFile);
        stringBuffer.append(",NotRetry=" + String.valueOf(this.notifyRetryTime));
        stringBuffer.append(",NotDelay=" + String.valueOf(this.notifyDelayTime));
        stringBuffer.append(",RetryNum=" + String.valueOf(this.notifyRetryNum));
        stringBuffer.append(",SOAttl=" + String.valueOf(this.domainSoaTTL));
        stringBuffer.append(",NSttl=" + String.valueOf(this.nameServerTTL));
        stringBuffer.append(",MTTL=" + String.valueOf(this.mailTTL));
        if (!this.mailExchange.isEmpty()) {
            stringBuffer.append(",NumMx=" + String.valueOf(this.mailExchange.size()));
            int n = 0;
            while (n < this.mailExchange.size()) {
                try {
                    String string = (String)this.mailExchange.elementAt(n);
                    stringBuffer.append(",MX=" + string);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        } else {
            stringBuffer.append(",NumMx=0");
        }
        stringBuffer.append(",EDOM");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            ParsedVector parsedVector2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(fQDN_tag)) {
                parsedObject = parsedVector.getElement(fQDN_tag);
                string = (String)parsedObject.getValue();
                this.fQDomainName = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(servers_tag)) {
                parsedObject = parsedVector.getElement(servers_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.nameServersForDomain = parsedVector2 != null ? new NameAndIpAddressList(parsedVector2) : new NameAndIpAddressList();
            } else if (stringArray[n].equals(notify_tag)) {
                parsedObject = parsedVector.getElement(notify_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.notifyOrNot = string.equals("t");
                }
            } else if (stringArray[n].equals(nSet_tag)) {
                parsedObject = parsedVector.getElement(nSet_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.getNotifyAddrs(parsedVector2);
            } else if (stringArray[n].equals(serialNo_tag)) {
                parsedObject = parsedVector.getElement(serialNo_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.domainSerialNumber = n2;
                }
            } else if (stringArray[n].equals(rRate_tag)) {
                parsedObject = parsedVector.getElement(rRate_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.refreshRate = n2;
                }
            } else if (stringArray[n].equals(mTTL_tag)) {
                parsedObject = parsedVector.getElement(mTTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.mailTTL = n2;
                }
            } else if (stringArray[n].equals(retry_tag)) {
                parsedObject = parsedVector.getElement(retry_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.retryInterval = n2;
                }
            } else if (stringArray[n].equals(exTime_tag)) {
                parsedObject = parsedVector.getElement(exTime_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.expirationTime = n2;
                }
            } else if (stringArray[n].equals(tTL_tag)) {
                parsedObject = parsedVector.getElement(tTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.timeToLive = n2;
                }
            } else if (stringArray[n].equals(sOAttl_tag)) {
                parsedObject = parsedVector.getElement(sOAttl_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.domainSoaTTL = n2;
                }
            } else if (stringArray[n].equals(nSttl_tag)) {
                parsedObject = parsedVector.getElement(nSttl_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.nameServerTTL = n2;
                }
            } else if (stringArray[n].equals(nRetry_tag)) {
                parsedObject = parsedVector.getElement(nRetry_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.notifyRetryTime = n2;
                }
            } else if (stringArray[n].equals(nDelay_tag)) {
                parsedObject = parsedVector.getElement(nDelay_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.notifyDelayTime = n2;
                }
            } else if (stringArray[n].equals(retryNum_tag)) {
                parsedObject = parsedVector.getElement(retryNum_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.notifyRetryNum = n2;
                }
            } else if (stringArray[n].equals(domFile_tag)) {
                parsedObject = parsedVector.getElement(domFile_tag);
                string = (String)parsedObject.getValue();
                this.domainDataFile = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(numMx_tag)) {
                parsedObject = parsedVector.getElement(numMx_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    int n3 = n2;
                    if (n3 > 0) {
                        this.mailExchange = new Vector(n3);
                        int n4 = 1;
                        while (n4 <= n3) {
                            parsedObject = parsedVector.get(n + n4);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.mailExchange.addElement(new String(string));
                            }
                            ++n4;
                        }
                    } else {
                        this.mailExchange = new Vector();
                    }
                } else {
                    this.mailExchange = new Vector();
                }
            }
            ++n;
        }
    }

    private void setDefaults() {
        this.fQDomainName = new String("");
        this.domainSerialNumber = 1;
        this.refreshRate = 10800;
        this.retryInterval = 3600;
        this.expirationTime = 604800;
        this.timeToLive = 86400;
        this.notifyOrNot = true;
        this.myHosts = new Hashtable();
        this.domainDataFile = new String("named.dom");
        this.nameServersForDomain = new NameAndIpAddressList();
        this.notifySetForDomain = new Vector();
        this.childServers = new Vector();
        this.administratorEmail = new String("");
        this.notifyDelayTime = 60;
        this.notifyRetryTime = 30;
        this.notifyRetryNum = 3;
        this.mailTTL = -1;
        this.nameServerTTL = -1;
        this.domainSoaTTL = -1;
        this.mailExchange = new Vector();
    }

    public void storeFile(TheDomainFile theDomainFile) {
        this.fileReadIn = theDomainFile;
    }

    public TheDomainFile getStoredFile() {
        return this.fileReadIn;
    }

    public String[] getInvalidFileLines() {
        if (this.fileReadIn == null) {
            return null;
        }
        Vector vector = this.fileReadIn.getInvalidLines();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean addrIsInList(NameAndIpAddressList nameAndIpAddressList, String string) {
        Enumeration enumeration = nameAndIpAddressList.elements();
        while (enumeration.hasMoreElements()) {
            NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
            if (!nameAndIpAddress.getIpAddress().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean addrIsInList(Vector vector, String string) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void getNotifyAddrs(ParsedVector parsedVector) {
        this.notifySetForDomain = new Vector();
        if (parsedVector != null) {
            String[] stringArray = parsedVector.getKeys();
            int n = 0;
            while (n < stringArray.length) {
                ParsedObject parsedObject;
                String string;
                if (stringArray[n].equals(notifyIP_tag) && (string = (String)(parsedObject = parsedVector.get(n)).getValue()) != null) {
                    this.notifySetForDomain.addElement(string);
                }
                ++n;
            }
        }
    }
}

