/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.FileItem;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class FileEntry
extends FileItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String fe_tag = "FE";
    public static final String A_REC = "A";
    public static final String CNAME_REC = "CNAME";
    public static final String HINFO_REC = "HINFO";
    public static final String WKS_REC = "WKS";
    public static final String MX_REC = "MX";
    public static final String NS_REC = "NS";
    public static final String TXT_REC = "TXT";
    public static final String SIG_REC = "SIG";
    public static final String KEY_REC = "KEY";
    public static final String SOA_REC = "SOA";
    public static final String PTR_REC = "PTR";
    public static final String OTHER_REC = "OTHER";
    public static final String ORIGIN_REC = "$ORIGIN";
    public static final String INCLUDE_REC = "$INCLUDE";
    public static final String COMMENT_REC = "CMT";
    public static final String RECORD_SEPARATOR = "  ";
    public static final String INTERNET_CLASS = "IN";
    protected String theOwnerName;
    protected int theTTL = -1;
    protected String theRecType;
    protected String recordData;
    protected boolean spanMultipleLines = false;
    protected boolean endOfMultLines = false;
    protected String theOrigin;
    protected static String lastRecordOwner = null;
    protected static String theRecord;
    protected String originOnInclude;
    protected ResourceBundle theStrings;

    public FileEntry(String string, String string2, ResourceBundle resourceBundle) {
        this.theStrings = resourceBundle;
        if (string2 != null) {
            this.theOrigin = string2.trim();
            if (this.theOrigin.endsWith(".")) {
                this.theOrigin = this.theOrigin.substring(0, this.theOrigin.length() - 1);
            }
        } else {
            this.theOrigin = new String("");
        }
        if (string.trim().equals("")) {
            this.theRecType = COMMENT_REC;
            this.recordData = ";";
            return;
        }
        if (!(this.isComment(string) || this.isOrigin(string) || this.isInclude(string))) {
            String string3 = null;
            String string4 = this.stripComment(string);
            String string5 = this.getStartOfData(string4);
            String string6 = this.getEndOfData(string4.trim());
            if (string6 != null) {
                this.buildRecordData(this.setRecordType(string6.trim()));
            } else {
                this.buildRecordData(string4.trim());
                this.theRecType = OTHER_REC;
            }
            string3 = this.parseOwnerName(string5);
            if (!this.areErrors() && !this.theRecType.equals(COMMENT_REC)) {
                if (this.theOwnerName == null) {
                    this.theOwnerName = new String(lastRecordOwner);
                } else {
                    lastRecordOwner = new String(this.theOwnerName);
                }
                if (string3 != null) {
                    this.parseTTLval(string3);
                }
                if (this.theTTL >= 0 && (this.theRecType.equals(KEY_REC) || this.theRecType.equals(SIG_REC))) {
                    this.recordData = new String(String.valueOf(this.theTTL) + "  IN " + this.theRecType + " " + this.recordData);
                    return;
                }
                if (this.theRecType.equals(KEY_REC) || this.theRecType.equals(SIG_REC)) {
                    this.recordData = new String("  IN " + this.theRecType + " " + this.recordData);
                }
            }
        }
    }

    public String getOwnerName() {
        return this.theOwnerName;
    }

    public void setOwnerName(String string) {
        this.theOwnerName = new String(string.toLowerCase());
    }

    public int getTTL() {
        return this.theTTL;
    }

    public String getRecType() {
        return this.theRecType;
    }

    public String getRecordData() {
        return this.recordData;
    }

    public void setRecordData(String string) {
        if (string != null) {
            this.recordData = string;
        }
    }

    public boolean doesSpanLines() {
        return this.spanMultipleLines;
    }

    public void setSpanLines(boolean bl) {
        this.spanMultipleLines = bl;
    }

    public boolean isEndOfMultLines() {
        return this.endOfMultLines;
    }

    private boolean isComment(String string) {
        if (string == null || string.equals("")) {
            this.theRecType = COMMENT_REC;
            this.recordData = ";";
            return true;
        }
        try {
            if (string.charAt(0) == ';') {
                this.theRecType = COMMENT_REC;
                this.recordData = string.trim();
                return true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.addError(String.valueOf(this.theStrings.getString("ERROR_PARSE_COMMENT")) + string);
        }
        return false;
    }

    private boolean isOrigin(String string) {
        if (string.startsWith(ORIGIN_REC)) {
            this.theRecType = ORIGIN_REC;
            this.recordData = new String(string.substring(ORIGIN_REC.length()));
            this.recordData = this.recordData.trim();
            return true;
        }
        return false;
    }

    public String getOriginFromInclude(String string) {
        if (this.originOnInclude != null) {
            return this.originOnInclude;
        }
        return string;
    }

    private boolean isInclude(String string) {
        if (string.startsWith(INCLUDE_REC)) {
            this.theRecType = INCLUDE_REC;
            this.recordData = new String(string.substring(INCLUDE_REC.length()));
            this.recordData = this.recordData.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(this.recordData);
            if (stringTokenizer.hasMoreElements()) {
                this.recordData = (String)stringTokenizer.nextElement();
                if (stringTokenizer.hasMoreElements()) {
                    this.originOnInclude = (String)stringTokenizer.nextElement();
                }
            }
            return true;
        }
        return false;
    }

    protected void buildRecordData(String string) {
        this.recordData = new String(string.trim());
        if (this.theRecType == CNAME_REC || this.theRecType == NS_REC || this.theRecType == PTR_REC || this.theRecType == MX_REC) {
            if (!this.recordData.endsWith(".")) {
                if (!this.theOrigin.equals("")) {
                    this.recordData = new String(String.valueOf(this.recordData) + "." + this.theOrigin);
                }
            } else {
                this.recordData = new String(this.recordData.substring(0, this.recordData.length() - 1));
            }
        }
        if (this.theRecType == OTHER_REC) {
            StringBuffer stringBuffer = this.theTTL >= 0 ? new StringBuffer(" " + this.theTTL + " IN " + theRecord) : new StringBuffer("  IN " + theRecord);
            stringBuffer.append(" " + this.recordData);
            this.recordData = new String(stringBuffer.toString());
        }
        if (this.recordData.indexOf("(") >= 0) {
            this.spanMultipleLines = true;
        }
        if (this.recordData.indexOf(")") >= 0) {
            this.endOfMultLines = true;
        }
    }

    private String stripComment(String string) {
        block2: {
            int n = string.lastIndexOf(";");
            if (n <= 0 || n - 1 <= 0 || string.charAt(n - 1) == '\\') break block2;
            this.AddComment(new String(string.substring(n)));
            try {
                string = string.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.addError(String.valueOf(this.theStrings.getString("ERROR_STRIP_COMMENT")) + string);
            }
        }
        return string;
    }

    private String getEndOfData(String string) {
        String string2 = null;
        int n = string.indexOf(INTERNET_CLASS);
        if (n < 0) {
            return null;
        }
        string2 = n == 0 ? new String(string.substring(2)) : new String(string.substring(n + 2));
        return string2;
    }

    private String setRecordType(String string) {
        theRecord = null;
        if (string.startsWith(SIG_REC)) {
            this.theRecType = SIG_REC;
            theRecord = SIG_REC;
        } else if (string.startsWith(CNAME_REC)) {
            this.theRecType = CNAME_REC;
            theRecord = CNAME_REC;
        } else if (string.startsWith(HINFO_REC)) {
            this.theRecType = HINFO_REC;
            theRecord = HINFO_REC;
        } else if (string.startsWith(MX_REC)) {
            this.theRecType = MX_REC;
            theRecord = MX_REC;
        } else if (string.startsWith(NS_REC)) {
            this.theRecType = NS_REC;
            theRecord = NS_REC;
        } else if (string.startsWith(TXT_REC)) {
            this.theRecType = TXT_REC;
            theRecord = TXT_REC;
        } else if (string.startsWith(KEY_REC)) {
            this.theRecType = KEY_REC;
            theRecord = KEY_REC;
        } else if (string.startsWith(A_REC)) {
            this.theRecType = A_REC;
            theRecord = A_REC;
        } else if (string.startsWith(SOA_REC)) {
            this.theRecType = SOA_REC;
            theRecord = SOA_REC;
        } else if (string.startsWith(PTR_REC)) {
            this.theRecType = PTR_REC;
            theRecord = PTR_REC;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreElements()) {
                try {
                    theRecord = new String((String)stringTokenizer.nextElement());
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.addError(String.valueOf(this.theStrings.getString("ERR_DOMAIN_PARSE")) + string);
                }
            } else {
                theRecord = OTHER_REC;
            }
            this.theRecType = OTHER_REC;
        }
        int n = string.indexOf(theRecord);
        return new String(string.substring(n + theRecord.length()));
    }

    private String getStartOfData(String string) {
        String string2 = null;
        int n = string.indexOf(INTERNET_CLASS);
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return "";
        }
        try {
            string2 = string.substring(0, n - 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.addError(String.valueOf(this.theStrings.getString("ERR_DOMAIN_PARSE")) + string);
        }
        return string2;
    }

    protected String parseOwnerName(String string) {
        String string2;
        if (string == null || string.equals("")) {
            this.theOwnerName = null;
            return string;
        }
        if (Character.isWhitespace(string.charAt(0))) {
            this.theOwnerName = null;
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            try {
                string2 = (String)stringTokenizer.nextElement();
                if (!string2.equals("@")) {
                    if (!string2.equals(".")) {
                        if (!string2.endsWith(".")) {
                            if (this.theOrigin.equals("")) {
                                this.addError(this.theStrings.getString("UNQUAL_NAME"));
                            } else {
                                string2 = new String(String.valueOf(string2) + "." + this.theOrigin);
                            }
                        } else {
                            string2 = new String(string2.substring(0, string2.length() - 1));
                        }
                    }
                    if (TcpipValidation.IsValidFQTcpipName(string2) || string2.equals(".")) {
                        this.theOwnerName = new String(string2.toLowerCase());
                    } else {
                        this.addError(String.valueOf(this.theStrings.getString("INVAL_NAME")) + string);
                    }
                } else {
                    this.theOwnerName = new String("@");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.addError(String.valueOf(this.theStrings.getString("ERR_DOMAIN_PARSE")) + string);
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            try {
                string2 = (String)stringTokenizer.nextElement();
                return string2;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.addError(String.valueOf(this.theStrings.getString("ERR_DOMAIN_PARSE")) + string);
            }
        }
        return null;
    }

    public String getUnqualifiedOwnerName(String string) {
        if (this.theOwnerName.equals("@")) {
            return string;
        }
        int n = this.theOwnerName.indexOf(string.toLowerCase());
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return string;
        }
        return new String(this.theOwnerName.substring(0, n - 1));
    }

    public String getUnqualifiedRecordData(String string) {
        if (this.recordData.equals("@")) {
            return string;
        }
        int n = this.recordData.indexOf(string);
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return "";
        }
        return new String(this.recordData.substring(0, n - 1));
    }

    private void parseTTLval(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim());
        if (stringTokenizer.hasMoreElements()) {
            try {
                String string2 = (String)stringTokenizer.nextElement();
                if (Character.isDigit(string2.charAt(0))) {
                    try {
                        Integer n = Integer.valueOf(string2);
                        this.theTTL = n;
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.addError(String.valueOf(this.theStrings.getString("INVAL_TTL")) + string2);
                        return;
                    }
                }
                this.addError(String.valueOf(this.theStrings.getString("PARSE_TTL")) + string);
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.addError(String.valueOf(this.theStrings.getString("PARSE_TTL")) + string);
                return;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.theRecType.equals(COMMENT_REC)) {
            stringBuffer.append(this.recordData);
        } else if (this.theRecType.equals(ORIGIN_REC)) {
            stringBuffer.append(this.theRecType);
            stringBuffer.append(RECORD_SEPARATOR);
            stringBuffer.append(this.recordData);
        } else {
            if (this.theRecType.equals(INCLUDE_REC)) {
                stringBuffer.append(this.theRecType);
                stringBuffer.append(RECORD_SEPARATOR);
                stringBuffer.append(this.recordData);
            }
            if (this.theRecType.equals(OTHER_REC)) {
                stringBuffer.append(this.recordData);
            } else {
                stringBuffer.append(this.theOwnerName);
                stringBuffer.append(RECORD_SEPARATOR);
                if (this.theTTL >= 0) {
                    stringBuffer.append(this.theTTL);
                    stringBuffer.append(RECORD_SEPARATOR);
                }
                stringBuffer.append(INTERNET_CLASS);
                stringBuffer.append(RECORD_SEPARATOR);
                stringBuffer.append(this.theRecType);
                stringBuffer.append(RECORD_SEPARATOR);
                stringBuffer.append(this.recordData);
            }
        }
        return stringBuffer.toString();
    }
}

