/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.DDNSStringTranslator;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import java.util.Enumeration;
import java.util.Vector;

public class FileItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cmt_tag = new String("cmt");
    Vector FileComments = new Vector();
    Vector ErrorLog = new Vector();
    Vector BootFileComments = new Vector();
    protected Vector sIGRecords = new Vector();
    protected Vector kEYRecords = new Vector();
    protected boolean dynamicData = false;

    public void addError(String string) {
        this.ErrorLog.addElement(string);
    }

    public String[] getErrors() {
        if (!this.ErrorLog.isEmpty()) {
            Object[] objectArray = new String[this.ErrorLog.size()];
            this.ErrorLog.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public boolean areErrors() {
        return !this.ErrorLog.isEmpty();
    }

    public void setDataDynamic(boolean bl) {
        this.dynamicData = bl;
    }

    public boolean isDynamic() {
        return this.dynamicData;
    }

    public void AddComment(String string) {
        this.FileComments.addElement(string);
    }

    public void addBootComment(String string) {
        this.BootFileComments.addElement(string);
    }

    public void clearComments() {
        this.FileComments = new Vector();
    }

    public Vector getAllComments() {
        return this.FileComments;
    }

    public void setComments(String[] stringArray) {
        this.FileComments = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.FileComments.addElement(stringArray[n]);
                ++n;
            }
        }
    }

    public void addComments(Vector vector) {
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                try {
                    this.FileComments.addElement(vector.elementAt(n));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                ++n;
            }
        }
    }

    public String[] getComments() {
        Object[] objectArray = null;
        if (!this.FileComments.isEmpty()) {
            objectArray = new String[this.FileComments.size()];
            this.FileComments.copyInto(objectArray);
        }
        return objectArray;
    }

    public String[] getBootComments() {
        Object[] objectArray = null;
        if (!this.BootFileComments.isEmpty()) {
            objectArray = new String[this.BootFileComments.size()];
            this.BootFileComments.copyInto(objectArray);
        }
        return objectArray;
    }

    public String fileCommentsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.FileComments.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DDNSStringTranslator dDNSStringTranslator = new DDNSStringTranslator(string);
            stringBuffer.append("," + cmt_tag + "=" + "\"" + dDNSStringTranslator.toEscapedString() + "\"");
        }
        return stringBuffer.toString();
    }

    public boolean getReturnCode(ParsedObject parsedObject) {
        String string = (String)parsedObject.getValue();
        return !string.equals("NACK");
    }

    public void Dump() {
    }

    public void addSIGRec(String string) {
        this.sIGRecords.addElement(string);
        this.setDataDynamic(true);
    }

    public void addKEYRec(String string) {
        this.kEYRecords.addElement(string);
        this.setDataDynamic(true);
    }

    public void setSIGRecs(String[] stringArray) {
        this.sIGRecords = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.sIGRecords.addElement(stringArray[n]);
                ++n;
            }
        }
        this.setDataDynamic(true);
    }

    public String[] getSIGRecs() {
        String[] stringArray = null;
        if (!this.sIGRecords.isEmpty()) {
            stringArray = new String[this.sIGRecords.size()];
            int n = 0;
            while (n < this.sIGRecords.size()) {
                try {
                    stringArray[n] = new String((String)this.sIGRecords.elementAt(n));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        return stringArray;
    }

    public void setKEYRecs(String[] stringArray) {
        this.kEYRecords = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.kEYRecords.addElement(stringArray[n]);
                ++n;
            }
        }
        this.setDataDynamic(true);
    }

    public String[] getKEYRecs() {
        String[] stringArray = null;
        if (!this.kEYRecords.isEmpty()) {
            stringArray = new String[this.kEYRecords.size()];
            int n = 0;
            while (n < this.kEYRecords.size()) {
                try {
                    stringArray[n] = new String((String)this.kEYRecords.elementAt(n));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        return stringArray;
    }
}

