/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.DDNSStringTranslator;
import COM.ibm.raleigh.ddnssgui.common.FileItem;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import java.util.Vector;

public class HostOrAlias
extends FileItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String HOA_tag = "HOA";
    public static final String EHOA_tag = "EHOA";
    private static final String hostName_tag = "HostName";
    private static final String dyn_tag = "Dyn";
    private static final String numSIG_tag = "NumSIG";
    private static final String sIGR_tag = "SIGR";
    private static final String numKEY_tag = "NumKey";
    private static final String kEYR_tag = "KEYR";
    private static final String numOther_tag = "NumOther";
    private static final String otherR_tag = "OtherR";
    protected String hostName = new String();
    protected Vector otherRecords;

    public HostOrAlias() {
        this.dynamicData = false;
        this.otherRecords = new Vector();
    }

    public HostOrAlias(boolean bl) {
        this.dynamicData = bl;
        this.otherRecords = new Vector();
    }

    public void setHostName(String string) {
        this.hostName = new String(string);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void addOtherRec(String string) {
        this.otherRecords.addElement(string);
    }

    public String[] getOtherRecs() {
        Object[] objectArray = null;
        if (!this.otherRecords.isEmpty()) {
            objectArray = new String[this.otherRecords.size()];
            this.otherRecords.copyInto(objectArray);
        }
        return objectArray;
    }

    public void setOtherRecs(String[] stringArray) {
        this.otherRecords = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.otherRecords.addElement(stringArray[n]);
                ++n;
            }
        }
    }

    public String[] writeDataRecords() {
        return null;
    }

    public void Dump() {
    }

    public String toString() {
        DDNSStringTranslator dDNSStringTranslator;
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer(HOA_tag);
        stringBuffer.append(",HostName=" + this.hostName);
        stringBuffer.append(this.fileCommentsToString());
        if (this.dynamicData) {
            stringBuffer.append(",Dyn=t");
        } else {
            stringBuffer.append(",Dyn=f");
        }
        if (!this.sIGRecords.isEmpty()) {
            stringBuffer.append(",NumSIG=" + String.valueOf(this.sIGRecords.size()));
            n = 0;
            while (n < this.sIGRecords.size()) {
                try {
                    string = (String)this.sIGRecords.elementAt(n);
                    dDNSStringTranslator = new DDNSStringTranslator(string);
                    stringBuffer.append(",SIGR=\"" + dDNSStringTranslator.toEscapedString() + "\"");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.kEYRecords.isEmpty()) {
            stringBuffer.append(",NumKey=" + String.valueOf(this.kEYRecords.size()));
            n = 0;
            while (n < this.kEYRecords.size()) {
                try {
                    string = (String)this.kEYRecords.elementAt(n);
                    dDNSStringTranslator = new DDNSStringTranslator(string);
                    stringBuffer.append(",KEYR=\"" + dDNSStringTranslator.toEscapedString() + "\"");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.otherRecords.isEmpty()) {
            stringBuffer.append(",NumOther=" + String.valueOf(this.otherRecords.size()));
            n = 0;
            while (n < this.otherRecords.size()) {
                try {
                    string = (String)this.otherRecords.elementAt(n);
                    stringBuffer.append(",OtherR=\"" + string + "\"");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        stringBuffer.append(",EHOA");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        this.clearComments();
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            DDNSStringTranslator dDNSStringTranslator;
            int n2;
            int n3;
            Integer n4;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(hostName_tag)) {
                parsedObject = parsedVector.getElement(hostName_tag);
                string = (String)parsedObject.getValue();
                this.hostName = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(dyn_tag)) {
                parsedObject = parsedVector.getElement(dyn_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.dynamicData = string.equals("t");
                }
            } else if (stringArray[n].equals(numSIG_tag)) {
                parsedObject = parsedVector.getElement(numSIG_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n3 = n4;
                    if (n3 > 0) {
                        this.sIGRecords = new Vector(n3);
                        n2 = 1;
                        while (n2 <= n3) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            dDNSStringTranslator = new DDNSStringTranslator(string);
                            if (string != null) {
                                this.sIGRecords.addElement(dDNSStringTranslator.fromEscapedString());
                            }
                            ++n2;
                        }
                    } else {
                        this.sIGRecords = new Vector();
                    }
                }
            } else if (stringArray[n].equals(numKEY_tag)) {
                parsedObject = parsedVector.getElement(numKEY_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n3 = n4;
                    if (n3 > 0) {
                        this.kEYRecords = new Vector(n3);
                        n2 = 1;
                        while (n2 <= n3) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            dDNSStringTranslator = new DDNSStringTranslator(string);
                            if (string != null) {
                                this.kEYRecords.addElement(dDNSStringTranslator.fromEscapedString());
                            }
                            ++n2;
                        }
                    } else {
                        this.kEYRecords = new Vector();
                    }
                }
            } else if (stringArray[n].equals(numOther_tag)) {
                parsedObject = parsedVector.getElement(numOther_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n3 = n4;
                    if (n3 > 0) {
                        this.otherRecords = new Vector(n3);
                        n2 = 1;
                        while (n2 <= n3) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.otherRecords.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.otherRecords = new Vector();
                    }
                }
            } else if (stringArray[n].equals(FileItem.cmt_tag)) {
                Object[] objectArray = parsedVector.getValues();
                string = (String)objectArray[n];
                dDNSStringTranslator = new DDNSStringTranslator(string);
                if (string != null) {
                    this.AddComment(dDNSStringTranslator.fromEscapedString());
                }
            }
            ++n;
        }
    }

    public String[] getKeyAndSigRecs() {
        String[] stringArray = this.getKEYRecs();
        String[] stringArray2 = this.getSIGRecs();
        int n = 0;
        int n2 = 0;
        if (stringArray != null) {
            n = stringArray.length;
            n2 = stringArray.length;
        }
        if (stringArray2 != null) {
            n += stringArray2.length;
        }
        String[] stringArray3 = new String[n];
        int n3 = 0;
        while (n3 < n2) {
            stringArray3[n3] = "KEY: " + stringArray[n3];
            ++n3;
        }
        int n4 = 0;
        int n5 = n2;
        while (n5 < n) {
            stringArray3[n5] = "SIG: " + stringArray2[n4++];
            ++n5;
        }
        return stringArray3;
    }
}

