/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class NameAndIpAddressList {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String NAIL_tag = "NAIL";
    public static final String ENAIL_tag = "ENAIL";
    private static final String numPair_tag = "NumPair";
    private Vector theList = new Vector();

    public NameAndIpAddressList() {
    }

    public NameAndIpAddressList(ParsedVector parsedVector) {
        this.fromString(parsedVector);
    }

    public NameAndIpAddressList(NameAndIpAddressList nameAndIpAddressList) {
        if (nameAndIpAddressList != null && !nameAndIpAddressList.isEmpty()) {
            int n = 0;
            while (n < nameAndIpAddressList.size()) {
                NameAndIpAddress nameAndIpAddress = nameAndIpAddressList.getAPair(n);
                if (nameAndIpAddress != null) {
                    this.addAPair(nameAndIpAddress.getFqName(), nameAndIpAddress.getIpAddress());
                }
                ++n;
            }
        }
    }

    public Enumeration elements() {
        return this.theList.elements();
    }

    public boolean equals(NameAndIpAddressList nameAndIpAddressList) {
        NameAndIpAddress nameAndIpAddress;
        if (this.isEmpty() && nameAndIpAddressList.isEmpty()) {
            return true;
        }
        if (this.isEmpty() && !nameAndIpAddressList.isEmpty() || !this.isEmpty() && nameAndIpAddressList.isEmpty()) {
            return false;
        }
        Enumeration enumeration = nameAndIpAddressList.elements();
        while (enumeration.hasMoreElements()) {
            nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
            if (this.hasAPairLike(nameAndIpAddress)) continue;
            return false;
        }
        enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
            if (nameAndIpAddressList.hasAPairLike(nameAndIpAddress)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAPairLike(NameAndIpAddress nameAndIpAddress) {
        if (this.isEmpty()) {
            return false;
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            NameAndIpAddress nameAndIpAddress2 = (NameAndIpAddress)enumeration.nextElement();
            if (!nameAndIpAddress.getFqName().equalsIgnoreCase(nameAndIpAddress2.getFqName()) || !nameAndIpAddress.getIpAddress().equalsIgnoreCase(nameAndIpAddress2.getIpAddress())) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.theList.size();
    }

    public boolean isEmpty() {
        return this.theList.isEmpty();
    }

    public void addAPair(String string, String string2) {
        NameAndIpAddress nameAndIpAddress = new NameAndIpAddress(string, string2);
        this.theList.addElement(nameAndIpAddress);
    }

    public void deleteAPair(String string) {
        Enumeration enumeration = this.theList.elements();
        while (enumeration.hasMoreElements()) {
            NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
            if (!nameAndIpAddress.getFqName().equalsIgnoreCase(string)) continue;
            this.theList.removeElement(nameAndIpAddress);
        }
    }

    public NameAndIpAddress getAPair(int n) {
        NameAndIpAddress nameAndIpAddress = new NameAndIpAddress();
        try {
            nameAndIpAddress = (NameAndIpAddress)this.theList.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        return nameAndIpAddress;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(NAIL_tag);
        stringBuffer.append(",NumPair=" + String.valueOf(this.theList.size()));
        Enumeration enumeration = this.theList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
                stringBuffer.append("," + nameAndIpAddress.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append(",ENAIL");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        Object[] objectArray = parsedVector.getValues();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(numPair_tag) && stringArray[n].equals(NameAndIpAddress.NAI_tag)) {
                NameAndIpAddress nameAndIpAddress = new NameAndIpAddress();
                n += nameAndIpAddress.fromString(stringArray, objectArray, n);
                this.theList.addElement(nameAndIpAddress);
            }
            ++n;
        }
    }
}

