/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.FileItem;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class NameServerObject
extends FileItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String NSO_tag = "NSO";
    public static final String ENSO_tag = "ENSO";
    public static final int NUM_LOG_LEVELS = 8;
    public static final int SYS_UNUSABLE = 0;
    public static final int IMMEDIATE = 1;
    public static final int CRITICAL = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int NORMAL = 5;
    public static final int INFORM = 6;
    public static final int DEBUG = 7;
    private static final String numOfDoms_tag = "NumOfDoms";
    private static final String names_tag = "Names";
    private static final String dbgLevel_tag = "DbgLevel";
    private static final String roots_tag = "Roots";
    private static final String numLogFile_tag = "NumLogFile";
    private static final String logSize_tag = "LogSize";
    private static final String logFile_tag = "LogFile";
    private static final String cacheFile_tag = "CacheFile";
    private static final String bootFile_tag = "BootFile";
    private static final String slave_tag = "Slave";
    private static final String numForward_tag = "NumForward";
    private static final String forward_tag = "Forward";
    private static final String rootTTL_tag = "RootTTL";
    private Hashtable myKnownDomains;
    private NameAndIpAddressList fQNameAndIpAddresses;
    private boolean debugLevel;
    private NameAndIpAddressList rootServerNamesAndIpAddresses;
    private int noOfLogFiles;
    private int sizeOfLogFile;
    private String nameOfLogFile;
    private String cacheFileName;
    private String bootFileName;
    private boolean slaveNameServer;
    private Vector forwardersIpAddresses;
    private int rootNSTTL;
    private NameAndIpAddressList initialMyNames;

    public static String handleActions(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        NameServerObject nameServerObject;
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        if (parsedObject.getValue().equals("ADD")) {
            NameServerObject nameServerObject2 = new NameServerObject(parsedVector);
            configurationManager.giveANameServer(nameServerObject2);
            bl = true;
        } else if (parsedObject.getValue().equals("MOD")) {
            NameServerObject nameServerObject3 = new NameServerObject(parsedVector);
            String[] stringArray = nameServerObject3.getJustFQNames();
            NameServerObject nameServerObject4 = null;
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    nameServerObject4 = configurationManager.getANameServer(stringArray[n]);
                    if (nameServerObject4 != null) break;
                    ++n;
                }
            }
            if (nameServerObject4 != null) {
                bl = configurationManager.updateANameServer(nameServerObject4.firstName(), parsedVector);
            }
        } else if (parsedObject.getValue().equals("DEL")) {
            parsedObject = parsedVector.getElement("name");
            if (parsedObject != null) {
                configurationManager.removeANameServer((String)parsedObject.getValue());
                bl = true;
            }
        } else if (parsedObject.getValue().equals("GET") && (parsedObject = parsedVector.getElement("name")) != null && (nameServerObject = configurationManager.getANameServer((String)parsedObject.getValue())) != null) {
            stringBuffer = new StringBuffer(nameServerObject.toString("GET"));
            bl = true;
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    public NameServerObject(String string) {
        this.setDefaults();
        this.cacheFileName = new String(String.valueOf(string) + File.separator + "namedb" + File.separator + this.cacheFileName);
        this.bootFileName = new String(String.valueOf(string) + File.separator + "namedb" + File.separator + this.bootFileName);
    }

    public NameServerObject(ParsedVector parsedVector) {
        this.setDefaults();
        this.fromString(parsedVector);
    }

    public void addFQName(String string, String string2) {
        if (string != null && string2 != null) {
            this.fQNameAndIpAddresses.addAPair(string, string2);
        }
    }

    public void addRootServer(String string, String string2) {
        if (string != null && string2 != null) {
            this.rootServerNamesAndIpAddresses.addAPair(string, string2);
        }
    }

    public void setDebugLevel(boolean bl) {
        this.debugLevel = bl;
    }

    public boolean getDebugLevel() {
        return this.debugLevel;
    }

    public boolean isMyNameServerName(String string) {
        if (this.fQNameAndIpAddresses.isEmpty()) {
            return false;
        }
        Enumeration enumeration = this.fQNameAndIpAddresses.elements();
        while (enumeration.hasMoreElements()) {
            NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
            if (!string.equalsIgnoreCase(nameAndIpAddress.getFqName())) continue;
            return true;
        }
        return false;
    }

    public String[] getJustFQNames() {
        String[] stringArray = new String[this.fQNameAndIpAddresses.size()];
        if (this.fQNameAndIpAddresses.isEmpty()) {
            return null;
        }
        int n = 0;
        while (n < this.fQNameAndIpAddresses.size()) {
            String string;
            NameAndIpAddress nameAndIpAddress = this.fQNameAndIpAddresses.getAPair(n);
            stringArray[n] = string = new String(nameAndIpAddress.getFqName());
            ++n;
        }
        return stringArray;
    }

    public NameAndIpAddressList getFQNames() {
        if (this.fQNameAndIpAddresses.isEmpty()) {
            return null;
        }
        return this.fQNameAndIpAddresses;
    }

    public void setFQNames(NameAndIpAddressList nameAndIpAddressList) {
        if (nameAndIpAddressList != null && !nameAndIpAddressList.isEmpty()) {
            this.fQNameAndIpAddresses = new NameAndIpAddressList(nameAndIpAddressList);
            return;
        }
        this.fQNameAndIpAddresses = new NameAndIpAddressList();
    }

    public NameAndIpAddressList getRootServers() {
        if (this.rootServerNamesAndIpAddresses.isEmpty()) {
            return null;
        }
        return new NameAndIpAddressList(this.rootServerNamesAndIpAddresses);
    }

    public void setFQNames(String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null) {
            this.fQNameAndIpAddresses = this.makeVectorOfStrings(stringArray, stringArray2);
        }
    }

    public void setRootNames(NameAndIpAddressList nameAndIpAddressList) {
        if (nameAndIpAddressList != null && !nameAndIpAddressList.isEmpty()) {
            this.rootServerNamesAndIpAddresses = new NameAndIpAddressList(nameAndIpAddressList);
            return;
        }
        this.rootServerNamesAndIpAddresses = new NameAndIpAddressList();
    }

    public void setRootNames(String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null) {
            this.rootServerNamesAndIpAddresses = this.makeVectorOfStrings(stringArray, stringArray2);
        }
    }

    public String firstName() {
        if (!this.fQNameAndIpAddresses.isEmpty()) {
            NameAndIpAddress nameAndIpAddress = this.fQNameAndIpAddresses.getAPair(0);
            return new String(nameAndIpAddress.getFqName());
        }
        return null;
    }

    public void addDomainToNS(DomainObject domainObject) {
        this.myKnownDomains.put(domainObject.getDomName(), domainObject);
    }

    public void removeDomainFromNS(String string) {
        this.myKnownDomains.remove(string);
    }

    public Enumeration getMyDomains() {
        return this.myKnownDomains.elements();
    }

    public boolean isDomainOf(String string) {
        DomainObject domainObject = (DomainObject)this.myKnownDomains.get(string);
        return domainObject != null;
    }

    public void setLogFileNum(int n) {
        this.noOfLogFiles = n;
    }

    public int getLogFileNum() {
        return this.noOfLogFiles;
    }

    public void setSizeOfLogFile(int n) {
        this.sizeOfLogFile = n;
    }

    public int getSizeOfLogFile() {
        return this.sizeOfLogFile;
    }

    public void setNameOfLogFile(String string) {
        if (string != null) {
            this.nameOfLogFile = new String(string);
            return;
        }
        this.nameOfLogFile = new String("");
    }

    public String getNameOfLogFile() {
        if (this.nameOfLogFile != null) {
            return new String(this.nameOfLogFile);
        }
        return null;
    }

    public void setCacheFileName(String string) {
        if (string != null) {
            this.cacheFileName = new String(string);
            return;
        }
        this.cacheFileName = new String("");
    }

    public String getCacheFileName() {
        if (this.cacheFileName != null) {
            return new String(this.cacheFileName);
        }
        return null;
    }

    public void setBootFileName(String string) {
        if (string != null) {
            this.bootFileName = new String(string);
            return;
        }
        this.bootFileName = new String("");
    }

    public String getBootFileName() {
        if (this.bootFileName != null) {
            return new String(this.bootFileName);
        }
        return null;
    }

    public void setSlaveNameServer(boolean bl) {
        this.slaveNameServer = bl;
    }

    public boolean getSlaveNameServer() {
        return this.slaveNameServer;
    }

    public void addForwarder(String string) {
        this.forwardersIpAddresses.addElement(string);
    }

    public void setForwardIp(String[] stringArray) {
        if (stringArray != null) {
            this.forwardersIpAddresses = new Vector(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.forwardersIpAddresses.addElement(new String(stringArray[n]));
                ++n;
            }
            return;
        }
        this.forwardersIpAddresses = new Vector();
    }

    public String[] getForwardIp() {
        Object[] objectArray = new String[this.forwardersIpAddresses.size()];
        if (this.forwardersIpAddresses.isEmpty()) {
            return null;
        }
        this.forwardersIpAddresses.copyInto(objectArray);
        return objectArray;
    }

    public void setRootNSTTL(int n) {
        this.rootNSTTL = n;
    }

    public int getRootNSTTL() {
        return this.rootNSTTL;
    }

    public boolean nameServerNamesHaveChanged() {
        return !this.initialMyNames.equals(this.fQNameAndIpAddresses);
    }

    public void saveInitialNameServerNames() {
        this.initialMyNames = new NameAndIpAddressList(this.fQNameAndIpAddresses);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("NSO=" + string);
        stringBuffer.append(",NumOfDoms=0");
        if (!this.fQNameAndIpAddresses.isEmpty()) {
            stringBuffer.append(",Names");
            stringBuffer.append("," + this.fQNameAndIpAddresses.toString());
        } else {
            stringBuffer.append(",Names");
        }
        if (this.debugLevel) {
            stringBuffer.append(",DbgLevel=t");
        } else {
            stringBuffer.append(",DbgLevel=f");
        }
        if (!this.rootServerNamesAndIpAddresses.isEmpty()) {
            stringBuffer.append(",Roots");
            stringBuffer.append("," + this.rootServerNamesAndIpAddresses.toString());
        } else {
            stringBuffer.append(",Roots");
        }
        stringBuffer.append(",NumLogFile=" + String.valueOf(this.noOfLogFiles));
        stringBuffer.append(",LogSize=" + String.valueOf(this.sizeOfLogFile));
        stringBuffer.append(",LogFile=" + this.nameOfLogFile);
        stringBuffer.append(",CacheFile=" + this.cacheFileName);
        stringBuffer.append(",BootFile=" + this.bootFileName);
        if (this.slaveNameServer) {
            stringBuffer.append(",Slave=t");
        } else {
            stringBuffer.append(",Slave=f");
        }
        if (!this.forwardersIpAddresses.isEmpty()) {
            int n = this.forwardersIpAddresses.size();
            stringBuffer.append(",NumForward=" + String.valueOf(n));
            Enumeration enumeration = this.forwardersIpAddresses.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    stringBuffer.append(",Forward=" + enumeration.nextElement());
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
            }
        } else {
            stringBuffer.append(",NumForward=" + String.valueOf(0));
        }
        stringBuffer.append(",RootTTL=" + String.valueOf(this.rootNSTTL));
        stringBuffer.append(",ENSO,");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            ParsedVector parsedVector2;
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(logSize_tag)) {
                parsedObject = parsedVector.getElement(logSize_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.sizeOfLogFile = n2;
                }
            } else if (stringArray[n].equals(numLogFile_tag)) {
                parsedObject = parsedVector.getElement(numLogFile_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.noOfLogFiles = n2;
                }
            } else if (stringArray[n].equals(logFile_tag)) {
                parsedObject = parsedVector.getElement(logFile_tag);
                string = (String)parsedObject.getValue();
                this.nameOfLogFile = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(cacheFile_tag)) {
                parsedObject = parsedVector.getElement(cacheFile_tag);
                string = (String)parsedObject.getValue();
                this.cacheFileName = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(bootFile_tag)) {
                parsedObject = parsedVector.getElement(bootFile_tag);
                string = (String)parsedObject.getValue();
                this.bootFileName = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(slave_tag)) {
                parsedObject = parsedVector.getElement(slave_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.slaveNameServer = string.equals("t");
                }
            } else if (stringArray[n].equals(dbgLevel_tag)) {
                parsedObject = parsedVector.getElement(dbgLevel_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.debugLevel = string.equals("t");
                }
            } else if (stringArray[n].equals(numForward_tag)) {
                parsedObject = parsedVector.getElement(numForward_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    int n3 = n2;
                    if (n3 > 0) {
                        this.forwardersIpAddresses = new Vector(n3);
                        int n4 = 1;
                        while (n4 <= n3) {
                            parsedObject = parsedVector.get(n + n4);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.forwardersIpAddresses.addElement(new String(string));
                            }
                            ++n4;
                        }
                    } else {
                        this.forwardersIpAddresses = new Vector();
                    }
                }
            } else if (stringArray[n].equals(rootTTL_tag)) {
                parsedObject = parsedVector.getElement(rootTTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.rootNSTTL = n2;
                }
            } else if (stringArray[n].equals(names_tag)) {
                parsedObject = parsedVector.getElement(names_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.fQNameAndIpAddresses = parsedVector2 != null ? new NameAndIpAddressList(parsedVector2) : new NameAndIpAddressList();
            } else if (stringArray[n].equals(roots_tag)) {
                parsedObject = parsedVector.getElement(roots_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.rootServerNamesAndIpAddresses = parsedVector2 != null ? new NameAndIpAddressList(parsedVector2) : new NameAndIpAddressList();
            }
            ++n;
        }
    }

    private NameAndIpAddressList makeVectorOfStrings(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        NameAndIpAddressList nameAndIpAddressList = new NameAndIpAddressList();
        int n2 = 0;
        while (n2 < n) {
            nameAndIpAddressList.addAPair(new String(stringArray[n2]), new String(stringArray2[n2]));
            ++n2;
        }
        return nameAndIpAddressList;
    }

    private void setDefaults() {
        this.fQNameAndIpAddresses = new NameAndIpAddressList();
        this.rootServerNamesAndIpAddresses = new NameAndIpAddressList();
        this.debugLevel = false;
        this.myKnownDomains = new Hashtable();
        this.noOfLogFiles = 4;
        this.sizeOfLogFile = 20;
        this.nameOfLogFile = new String("syslog");
        this.cacheFileName = new String("named.ca");
        this.bootFileName = new String("named.bt");
        this.slaveNameServer = false;
        this.forwardersIpAddresses = new Vector();
        this.rootNSTTL = 608000;
        this.initialMyNames = new NameAndIpAddressList();
    }
}

