/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.NetworkHandlerUser;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;

public class NetworkHandler {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String URL_DELIMITER = "/";
    private final int MAX_RETRIES = 10;
    DataOutputStream toTheNet;
    DataInputStream fromTheNet;
    Socket theSocketItself;
    TraceClient theTrace;
    private NetworkHandlerUser netUser;

    public NetworkHandler(Applet applet, NetworkHandlerUser networkHandlerUser, int n, TraceClient traceClient, String string) {
        this.theTrace = traceClient;
        this.netUser = networkHandlerUser;
        if (applet != null) {
            URL uRL = applet.getCodeBase();
            InetAddress[] inetAddressArray = null;
            try {
                inetAddressArray = InetAddress.getAllByName(uRL.getHost());
                try {
                    this.theSocketItself = new Socket(inetAddressArray[0], n);
                    this.toTheNet = new DataOutputStream(this.theSocketItself.getOutputStream());
                    this.fromTheNet = new DataInputStream(new BufferedInputStream(this.theSocketItself.getInputStream()));
                    return;
                }
                catch (IOException iOException) {
                    traceClient.traceTime(">>>> Couldn't create socket to connect to " + uRL.getHost());
                    return;
                }
            }
            catch (UnknownHostException unknownHostException) {
                traceClient.traceTime(">>>> Couldn't get hostnames for connection to server");
                return;
            }
        }
        InetAddress inetAddress = null;
        InetAddress[] inetAddressArray = null;
        if (string == null) {
            try {
                InetAddress inetAddress2 = InetAddress.getLocalHost();
                String string2 = inetAddress2.getHostAddress();
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                traceClient.traceTime("NetworkHandler, localHost threw an UnknownHostException");
            }
        }
        try {
            if (inetAddress != null && string == null) {
                inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            } else if (string != null) {
                inetAddressArray = InetAddress.getAllByName(string);
            }
            if (inetAddressArray != null) {
                int n2 = 0;
                while (n2 < 10) {
                    try {
                        this.theSocketItself = new Socket(inetAddressArray[0], n);
                        this.toTheNet = new DataOutputStream(this.theSocketItself.getOutputStream());
                        this.fromTheNet = new DataInputStream(new BufferedInputStream(this.theSocketItself.getInputStream()));
                        return;
                    }
                    catch (IOException iOException) {
                        traceClient.traceTime("Couldn't create socket with server");
                        ++n2;
                    }
                }
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            traceClient.traceTime("Couldn't get hostnames for the server");
            return;
        }
    }

    public NetworkHandler(NetworkHandlerUser networkHandlerUser, int n, TraceClient traceClient, String string) {
        InetAddress inetAddress = null;
        this.theTrace = traceClient;
        this.netUser = networkHandlerUser;
        InetAddress[] inetAddressArray = null;
        try {
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            String string2 = inetAddress2.getHostAddress();
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            traceClient.traceTime("NetworkHandler, localHost threw an UnknownHostException");
        }
        try {
            if (inetAddress != null && string == null) {
                inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            } else if (string != null) {
                inetAddressArray = InetAddress.getAllByName(string);
            }
            if (inetAddressArray != null) {
                int n2 = 0;
                while (n2 < 10) {
                    try {
                        this.theSocketItself = new Socket(inetAddressArray[0], n);
                        this.toTheNet = new DataOutputStream(this.theSocketItself.getOutputStream());
                        this.fromTheNet = new DataInputStream(new BufferedInputStream(this.theSocketItself.getInputStream()));
                        return;
                    }
                    catch (IOException iOException) {
                        traceClient.traceTime(">>> Couldn't create socket with the server");
                        ++n2;
                    }
                }
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            traceClient.traceTime(">>>> Couldn't get hostnames for the server");
        }
    }

    public boolean socketCreated() {
        return this.theSocketItself != null;
    }

    public Socket getSocket() {
        return this.theSocketItself;
    }

    public void sendToServer(String string) {
        try {
            this.toTheNet.writeUTF(string);
            return;
        }
        catch (Exception exception) {
            this.netUser.networkExceptionOccurred(exception);
            return;
        }
    }

    public DDNSNetworkStringParser receiveFromServer() {
        try {
            String string = this.fromTheNet.readUTF();
            DDNSNetworkStringParser dDNSNetworkStringParser = new DDNSNetworkStringParser(string, this.theTrace);
            return dDNSNetworkStringParser;
        }
        catch (Exception exception) {
            this.netUser.networkExceptionOccurred(exception);
            return null;
        }
    }

    public String receiveFromServer(boolean bl) {
        try {
            String string = this.fromTheNet.readUTF();
            return string;
        }
        catch (Exception exception) {
            this.netUser.networkExceptionOccurred(exception);
            return null;
        }
    }

    public void closeStreams() {
        try {
            if (this.toTheNet != null) {
                this.toTheNet.close();
                this.toTheNet = null;
            }
            if (this.fromTheNet != null) {
                this.fromTheNet.close();
                this.fromTheNet = null;
            }
            if (this.theSocketItself != null) {
                this.theSocketItself.close();
                this.theSocketItself = null;
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean setSocketTimeout(int n) {
        if (this.theSocketItself != null) {
            try {
                this.theSocketItself.setSoTimeout(n);
                return true;
            }
            catch (SocketException socketException) {
                return false;
            }
        }
        return false;
    }

    public int getSocketTimeout() {
        if (this.theSocketItself != null) {
            try {
                return this.theSocketItself.getSoTimeout();
            }
            catch (SocketException socketException) {
                return 0;
            }
        }
        return 0;
    }
}

