/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgMessage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.HelpHandle;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;

public class BaseDialog
extends Dialog
implements ActionListener,
FocusListener,
KeyListener,
Cfg2Defines {
    private ResourceBundle myBundle;
    public static final int ADD_DIALOG = 0;
    public static final int CHANGE_DIALOG = 1;
    public static final int DELETE_DIALOG = 2;
    private int myReason = 0;
    private DlgMessage messageDialog;
    private Container myOwner;
    public static final int ACTION_OK = 0;
    public static final int ACTION_CANCEL = 1;
    public static final int ACTION_HELP = 2;
    public static final int ACTION_PENDING = 3;
    private int status = 3;
    private Component myFocusComponent;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public BaseDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.myBundle = ClientMsg.getBundle();
        this.addFocusListener(this);
    }

    public BaseDialog(Frame frame, String string, boolean bl, Container container) {
        super(frame, string, bl);
        this.myOwner = container;
        this.myBundle = ClientMsg.getBundle();
        this.addFocusListener(this);
    }

    protected void showErrorDialog(String string, boolean bl, MessageListener messageListener) {
        this.messageDialog = new DlgMessage(bl, string, messageListener);
        Window window = null;
        if (bl) {
            window = FocusKeeper.getFocusWindow();
            FocusKeeper.setFocusWindow(this.messageDialog);
        }
        this.messageDialog.setVisible(true);
        if (bl) {
            FocusKeeper.setFocusWindow(window);
            FocusKeeper.giveWindowFocus();
        }
        this.messageDialog.getStatus();
    }

    protected void showErrorDialog(String string, boolean bl, MessageListener messageListener, Dimension dimension) {
        this.messageDialog = new DlgMessage(bl, string, messageListener);
        Window window = null;
        if (bl) {
            window = FocusKeeper.getFocusWindow();
            FocusKeeper.setFocusWindow(this.messageDialog);
        }
        if (Utility.isDoubleByteLocale()) {
            ((Component)this.messageDialog).setSize(dimension);
        }
        this.messageDialog.setVisible(true);
        if (bl) {
            FocusKeeper.setFocusWindow(window);
            FocusKeeper.giveWindowFocus();
        }
        this.messageDialog.getStatus();
    }

    public void getCursorFocus() {
        if (this.myFocusComponent == null) {
            return;
        }
        this.myFocusComponent.requestFocus();
    }

    public void setCursorFocus(Component component) {
        this.myFocusComponent = component;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.getCursorFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void getHelp(String string) {
        HelpHandle.getHelp(string);
    }

    public int getReason() {
        return this.myReason;
    }

    public void setReason(int n) {
        this.myReason = n;
    }

    public int getStatus() {
        return this.status;
    }

    protected boolean isNoEntries(MulColumn mulColumn) {
        if (mulColumn.getItemCount() == 0) {
            return false;
        }
        String[] stringArray = mulColumn.getItem(0);
        return stringArray[0].compareTo(this.myBundle.getString("GLO_NO_ENTRIES")) == 0;
    }

    protected boolean isNoEntries(MulColumn mulColumn, int n) {
        if (mulColumn.getItemCount() == 0) {
            return false;
        }
        String[] stringArray = mulColumn.getItem(0);
        return stringArray[n].compareTo(this.myBundle.getString("GLO_NO_ENTRIES")) == 0;
    }

    protected void listenToButtons(ButtonPanel buttonPanel) {
        Button[] buttonArray = buttonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].addActionListener(this);
            buttonArray[n].addKeyListener(this);
            ++n;
        }
    }

    protected void refreshContainer(Container container) {
        container.invalidate();
        container.getParent().validate();
        container.repaint();
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
            return;
        }
        System.out.println("BasePage.actionPreformed() must be overriden by this page.");
    }

    public void handleButton(Button button) {
        System.out.println("BasePage.handleButton() must be overriden by this page.");
    }

    public void handleCheckbox(Checkbox checkbox) {
        System.out.println("BasePage.handleCheckbox() must be overriden by this page.");
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object instanceof Button) {
                this.handleButton((Button)object);
                return;
            }
            if (object instanceof Checkbox) {
                Checkbox checkbox;
                checkbox.setState(!(checkbox = (Checkbox)object).getState());
                this.handleCheckbox(checkbox);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

