/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

public class BorderPanel
extends Panel {
    public static final String CStmt1 = new String("(C) Copyright Taligent, Inc. 1996-All Rights Reserved.");
    public static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String CStmt3 = new String("Permission is granted to copy, use, modify, and merge this");
    public static final String CStmt4 = new String("software into your applications  and to permit others to do");
    public static final String CStmt5 = new String("any of the foregoing. You must include this permission and");
    public static final String CStmt6 = new String("copyright notice in all copies and modified versions of this");
    public static final String CStmt7 = new String("software, and include attribution to Taligent in all splash");
    public static final String CStmt8 = new String("screens included in any application using this software.");
    public static final int SOLID = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int IN = 3;
    public static final int OUT = 4;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEFAULT_STYLE = 3;
    public static final int DEFAULT_THICKNESS = 10;
    public static final int DEFAULT_SOLID_THICKNESS = 4;
    public static final int DEFAULT_RAISED_THICKNESS = 2;
    public static final int DEFAULT_LOWERED_THICKNESS = 2;
    public static final int DEFAULT_IN_THICKNESS = 10;
    public static final int DEFAULT_OUT_THICKNESS = 10;
    public static final int DEFAULT_GAP = 3;
    public static final Color DEFAULT_COLOR = Color.black;
    public static final Font DEFAULT_FONT = new Font("TimesRoman", 1, 12);
    public static final int DEFAULT_ALIGNMENT = 0;
    private int style = 3;
    private int thickness = 10;
    private int gap = 3;
    private Color color = DEFAULT_COLOR;
    private Font font = DEFAULT_FONT;
    private String text = null;
    private int alignment = 0;

    public BorderPanel() {
    }

    public BorderPanel(String string) {
        this();
        this.style = 3;
        this.text = string;
    }

    public BorderPanel(Color color, int n) {
        this();
        this.style = 0;
        this.color = color;
        this.thickness = n;
    }

    public BorderPanel(int n) {
        this();
        int n2;
        switch (n) {
            case 0: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 10;
                break;
            }
            case 4: {
                n2 = 10;
                break;
            }
            default: {
                n2 = 10;
            }
        }
        this.style = n;
        this.thickness = n2;
    }

    public BorderPanel(int n, int n2) {
        this();
        this.style = n;
        this.thickness = n2;
    }

    public Insets getInsets() {
        int n;
        int n2 = 0;
        if ((this.style == 3 || this.style == 4) && this.text != null && this.text.length() > 0) {
            try {
                n = this.getGraphics().getFontMetrics(this.font).getHeight();
                if (n > this.thickness) {
                    n2 = n - this.thickness;
                }
            }
            catch (Exception exception) {}
        }
        n = this.thickness + this.gap;
        return new Insets(n + n2, n, n, n);
    }

    public BorderPanel setStyle(int n) {
        this.style = n;
        this.doLayout();
        this.repaint();
        return this;
    }

    public int getStyle() {
        return this.style;
    }

    public BorderPanel setThickness(int n) {
        if (n > 0) {
            this.thickness = n;
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public int getThickness() {
        return this.thickness;
    }

    public BorderPanel setGap(int n) {
        if (n > -1) {
            this.gap = n;
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public int getGap() {
        return this.gap;
    }

    public BorderPanel setColor(Color color) {
        this.color = color;
        if (this.style == 0 || this.style == 3 || this.style == 4) {
            this.repaint();
        }
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public BorderPanel setTextFont(Font font) {
        if (font != null) {
            this.font = font;
            if (this.style == 3 || this.style == 4) {
                this.doLayout();
                this.repaint();
            }
        }
        return this;
    }

    public Font getTextFont() {
        return this.font;
    }

    public BorderPanel setText(String string) {
        this.text = string;
        if (this.style == 3 || this.style == 4) {
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public String getText() {
        return this.text;
    }

    public BorderPanel setAlignment(int n) {
        this.alignment = n;
        if (this.style == 3 || this.style == 4) {
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Color color = this.getBackground().brighter().brighter().brighter();
        Color color2 = this.getBackground().darker().darker().darker();
        switch (this.style) {
            case 1: 
            case 2: {
                Color color3 = null;
                Color color4 = null;
                if (this.style == 1) {
                    color3 = color;
                    color4 = color2;
                } else {
                    color3 = color2;
                    color4 = color;
                }
                graphics.setColor(color3);
                int n3 = 0;
                while (n3 < this.thickness) {
                    graphics.drawLine(n3, n3, n - n3 - 2, n3);
                    graphics.drawLine(n3, n3 + 1, n3, n2 - n3 - 1);
                    ++n3;
                }
                graphics.setColor(color4);
                n3 = 0;
                while (n3 < this.thickness) {
                    graphics.drawLine(n3 + 1, n2 - n3 - 1, n - n3 - 1, n2 - n3 - 1);
                    graphics.drawLine(n - n3 - 1, n3, n - n3 - 1, n2 - n3 - 2);
                    ++n3;
                }
                return;
            }
            case 3: 
            case 4: {
                int n4 = 0;
                int n5 = 0;
                Font font = graphics.getFont();
                graphics.setFont(this.font);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n6 = fontMetrics.getAscent();
                if (this.style == 3) {
                    n4 = 1;
                } else {
                    n5 = 1;
                }
                int n7 = 0;
                if (this.text != null && this.text.length() > 0 && n6 > this.thickness) {
                    n7 = (n6 - this.thickness) / 2;
                }
                int n8 = this.thickness / 2;
                int n9 = this.thickness / 2 + n7;
                int n10 = n - this.thickness - 1;
                int n11 = n2 - this.thickness - 1 - n7;
                graphics.setColor(color);
                graphics.drawRect(n8 + n4, n9 + n4, n10, n11);
                graphics.setColor(color2);
                graphics.drawRect(n8 + n5, n9 + n5, n10, n11);
                if (this.text != null && this.text.length() > 0) {
                    int n12;
                    int n13;
                    int n14 = fontMetrics.getHeight();
                    int n15 = fontMetrics.stringWidth(this.text);
                    if (n15 > (n13 = n - 2 * (this.thickness + 5))) {
                        n15 = n13;
                    }
                    switch (this.alignment) {
                        case 1: {
                            n12 = (n - n15) / 2;
                            break;
                        }
                        case 2: {
                            n12 = n - n15 - this.thickness - 5;
                            break;
                        }
                        default: {
                            n12 = this.thickness + 5;
                        }
                    }
                    graphics.clearRect(n12 - 5, 0, n15 + 10, n14);
                    graphics.clipRect(n12, 0, n15, n14);
                    graphics.setColor(this.color);
                    graphics.drawString(this.text, n12, n6);
                    graphics.clipRect(0, 0, n, n2);
                }
                graphics.setFont(font);
                return;
            }
        }
        graphics.setColor(this.color);
        int n16 = 0;
        while (n16 < this.thickness) {
            graphics.drawRect(n16, n16, n - 2 * n16 - 1, n2 - 2 * n16 - 1);
            ++n16;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("BorderPanel[");
        stringBuffer.append("style=");
        switch (this.style) {
            case 0: {
                stringBuffer.append("SOLID");
                break;
            }
            case 1: {
                stringBuffer.append("RAISED");
                break;
            }
            case 2: {
                stringBuffer.append("LOWERED");
                break;
            }
            case 3: {
                stringBuffer.append("IN");
                break;
            }
            case 4: {
                stringBuffer.append("OUT");
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        stringBuffer.append(",");
        stringBuffer.append("thickness=");
        stringBuffer.append(this.thickness);
        stringBuffer.append(",");
        stringBuffer.append("gap=");
        stringBuffer.append(this.gap);
        stringBuffer.append(",");
        stringBuffer.append(this.color);
        stringBuffer.append(",");
        stringBuffer.append(this.font);
        stringBuffer.append(",");
        stringBuffer.append("text=");
        stringBuffer.append(this.text);
        stringBuffer.append(",");
        stringBuffer.append("alignment=");
        switch (this.alignment) {
            case 0: {
                stringBuffer.append("LEFT");
                break;
            }
            case 1: {
                stringBuffer.append("CENTER");
                break;
            }
            case 2: {
                stringBuffer.append("RIGHT");
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

