/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;

public class DlgAuthorize
extends BaseDialog
implements ActionListener,
Cfg2Defines,
KeyListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblUserID;
    private Label lblPassword;
    private Label lblHostName;
    private TextField tfUserID;
    private TextField tfPassword;
    private TextField metfHostName;
    private Panel centerPanel;
    private Frame myFrame;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private GridBagLayout gridBag = new GridBagLayout();
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgAuthorize(Applet applet) {
        super(new Frame(), "", true, applet);
        this.myBundle = ClientMsg.getBundle();
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(1));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgAuthorize.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgAuthorize.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgAuthorize.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        ((Component)this).setBackground(Utility.NOTEBOOK_COLOR);
        this.setTitle(this.myBundle.getString("DSC_TITLE"));
        this.tfUserID = new TextField();
        this.tfPassword = new TextField();
        this.tfPassword.addKeyListener(this);
        this.metfHostName = new TextField();
        this.tfPassword.setEchoChar('*');
        this.lblUserID = new Label(this.myBundle.getString("DSC_USERID"));
        this.lblPassword = new Label(this.myBundle.getString("DSC_PASSWORD"));
        this.lblHostName = new Label(this.myBundle.getString("DSC_HOSTNAME"));
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblHostName, 0, 0, -1, 1, 2, 13, 1.0, 1.0, 0, 30, 20, 0);
        Utility.constrain(this.centerPanel, this.metfHostName, 1, 0, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 20, 30);
        Utility.constrain(this.centerPanel, this.lblPassword, 0, 2, -1, 1, 2, 13, 1.0, 1.0, 0, 30, 20, 0);
        Utility.constrain(this.centerPanel, this.tfPassword, 1, 2, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 20, 30);
        Utility.constrain(this, this.centerPanel, 0, 2, 0, 1, 2, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 3, 5);
        this.setCursorFocus(this.metfHostName);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.tfUserID.setEnabled(bl);
        this.tfPassword.setEnabled(bl);
        this.metfHostName.setEnabled(bl);
    }

    private void doHelpButton() {
        this.getHelp("TCNBLOGI.htm");
    }

    public String getUserID() {
        return this.tfUserID.getText();
    }

    public String getPassword() {
        return this.tfPassword.getText();
    }

    public String getHostName() {
        return this.metfHostName.getText();
    }

    public void setProtectedHost(String string) {
        ((TextComponent)this.metfHostName).setText(string);
        this.metfHostName.setEditable(false);
        this.setCursorFocus(this.tfPassword);
    }

    private boolean validateDialog() {
        if (Utility.isEmptyTextField(this.tfPassword) || Utility.isEmptyTextField(this.metfHostName)) {
            this.showErrorDialog(this.myBundle.getString("DSC_FIELDS_RQD"), true, this);
            this.setCursorFocus(this.tfPassword);
            return false;
        }
        return true;
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                this.dispose();
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Utility.getDimension(1);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension2.width / 2 - dimension.width / 2;
        int n2 = dimension2.height / 2 - dimension.height / 2;
        ((Component)this).setBounds(n, n2, dimension.width, dimension.height);
        super.setVisible(bl);
        this.getCursorFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof TextField && object == this.tfPassword) {
            Button[] buttonArray = myButtonPanel.getButtons();
            this.handleButton(buttonArray[0]);
        }
        super.keyPressed(keyEvent);
    }
}

