/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.HelpHandle;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MultiLineLabel;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Validation;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.ResourceBundle;

public class DlgCreateRoute
extends BaseDialog
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private MulColumn myList;
    private String[] netRouteArray;
    private String myIPaddress;
    private boolean defNetRouteCreated = false;
    private Panel centerPanel;
    private MultiLineLabel lblSubTitle;
    private TextField metfIPaddress;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private Component myOwner;
    private GridBagLayout gridBag = new GridBagLayout();
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgCreateRoute(Container container, MulColumn mulColumn) {
        super(new Frame(), "", false, container);
        this.myOwner = container;
        this.myList = mulColumn;
        this.myBundle = ClientMsg.getBundle();
        this.createGUI();
        this.setSize(Utility.getDimension(2));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgCreateRoute.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgCreateRoute.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgCreateRoute.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        ((Component)this).setBackground(Utility.NOTEBOOK_COLOR);
        this.setTitle(this.myBundle.getString("DCR1_TITLE"));
        this.lblSubTitle = new MultiLineLabel(this.myBundle.getString("DCR1_SUBTITLE"));
        this.metfIPaddress = new TextField("");
        this.centerPanel = new Panel();
        this.setLayout(this.gridBag);
        this.centerPanel.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblSubTitle, 0, 1, 0, 1, 2, 10, 1.0, 0.2, 0, 30, 0, 0);
        Utility.constrain(this.centerPanel, this.metfIPaddress, 0, 2, 0, 1, 2, 10, 1.0, 1.0, 0, 40, 0, 40);
        this.addButtonGUI(0, 3, 5);
        Utility.constrain(this, this.centerPanel, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.setCursorFocus(this.metfIPaddress);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.metfIPaddress.setEnabled(bl);
    }

    private void doHelpButton() {
        HelpHandle.getHelp("TCNBROUT.htm");
    }

    public String getIPaddress() {
        return this.metfIPaddress.getText();
    }

    public void setIPaddress(String string) {
        ((TextComponent)this.metfIPaddress).setText(string);
    }

    public String[] getDefNetRoute() {
        return this.netRouteArray;
    }

    public boolean isDefNetRouteCreated() {
        return this.defNetRouteCreated;
    }

    private boolean validateDialog() {
        if (this.getReason() == 2) {
            return true;
        }
        if (Utility.isEmptyTextField(this.metfIPaddress)) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DCR1_ENTER_IP_ADDRESS"), true, this);
            this.setCursorFocus(this.metfIPaddress);
            return false;
        }
        if (!Cfg2Validation.IsValidHost_IPName(this.metfIPaddress.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DCR1_ENTER_IP_ADDRESS"), true, this);
            this.setCursorFocus(this.metfIPaddress);
            return false;
        }
        this.myIPaddress = this.metfIPaddress.getText();
        boolean bl = false;
        if (!bl) {
            InetAddress inetAddress;
            String string = this.metfIPaddress.getText();
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (Exception exception) {
                this.enableGUI(false);
                this.showErrorDialog(this.myBundle.getString("DCR1_UNKNOWN_HOST"), true, this, Utility.getDimension(3));
                this.setCursorFocus(this.metfIPaddress);
                return false;
            }
            String string2 = inetAddress.toString();
            this.myIPaddress = string2 = string2.substring(string.length() + 1);
        }
        this.createDefRoute();
        if (this.isDuplicate()) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("GLO_DUPLICATE_ENTRY"), true, this);
            this.setCursorFocus(this.metfIPaddress);
            return false;
        }
        return true;
    }

    private void createDefRoute() {
        int n = this.myList.getItemCount();
        this.netRouteArray = new String[5];
        this.netRouteArray[0] = "net";
        this.netRouteArray[4] = "";
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = new String[5];
            stringArray = this.myList.getItem(n2);
            if (stringArray[0].compareTo("default") == 0) {
                this.netRouteArray[2] = stringArray[2];
                this.netRouteArray[3] = stringArray[3];
            }
            ++n2;
        }
        int n3 = Utility.getClassRange(this.myIPaddress);
        switch (n3) {
            case 0: {
                this.netRouteArray[1] = Utility.getOctet(1, this.myIPaddress);
                break;
            }
            case 1: {
                this.netRouteArray[1] = String.valueOf(Utility.getOctet(1, this.myIPaddress)) + "." + Utility.getOctet(2, this.myIPaddress);
                break;
            }
            case 2: {
                this.netRouteArray[1] = String.valueOf(Utility.getOctet(1, this.myIPaddress)) + "." + Utility.getOctet(2, this.myIPaddress) + "." + Utility.getOctet(3, this.myIPaddress);
                break;
            }
            case 3: {
                this.netRouteArray[1] = String.valueOf(Utility.getOctet(1, this.myIPaddress)) + "." + Utility.getOctet(2, this.myIPaddress) + "." + Utility.getOctet(3, this.myIPaddress) + "." + Utility.getOctet(4, this.myIPaddress);
                break;
            }
            default: {
                this.netRouteArray[1] = "";
            }
        }
        this.defNetRouteCreated = true;
    }

    public boolean isDuplicate() {
        String[] stringArray;
        int n = this.myList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.myList.getItem(n2);
            if (stringArray[2].compareTo(this.netRouteArray[2]) == 0 && stringArray[0].compareTo(this.netRouteArray[0]) == 0 && stringArray[1].compareTo(this.netRouteArray[1]) == 0 && stringArray[3].compareTo(this.netRouteArray[3]) == 0 && stringArray[4].compareTo(this.netRouteArray[4]) == 0) {
                return true;
            }
            ++n2;
        }
        String string = Utility.getOctet(1, this.metfIPaddress.getText());
        int n3 = 0;
        while (n3 < n) {
            stringArray = this.myList.getItem(n3);
            if (stringArray[0].compareTo("net") == 0 && stringArray[1].compareTo(string) == 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                if (this.getReason() == 2) {
                    this.dispose();
                    return;
                }
                this.setVisible(false);
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.setStatus(2);
                this.doHelpButton();
            }
        }
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        int n = (int)((double)dimension.width * 0.8);
        int n2 = (int)((double)dimension.height * 0.5);
        this.lblSubTitle.setSize(n, n2);
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
        super.setVisible(bl);
        FocusKeeper.setFocusWindow(this);
        this.getCursorFocus();
    }
}

