/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MultiLineLabel;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class DlgError
extends BaseDialog
implements ActionListener {
    private ResourceBundle myBundle;
    private static final Font DEFAULT_FONT = new Font("TimesRoman", 1, 12);
    private MultiLineLabel lblError;
    private Label lblErrorTitle;
    private TcpError myError;
    private int myCurrentNumShown;
    private int myTotalNumShown;
    private Panel centerPanel;
    private BorderPanel errorPanel;
    private Frame myFrame;
    private static ButtonPanel myButtonPanel = null;
    private String[] buttonLabels = new String[]{null, null};
    private boolean makeItAcancelButton = false;
    private final int MAX_BUTTONS_IN_ROW = 5;
    private static final int OK_BUTTON = 0;
    private static final int OK_TO_ALL_BUTTON = 1;
    public static final int OK_BUTTON_HIT = 0;
    public static final int OK_TO_ALL_BUTTON_HIT = 1;
    private static int myStatus;
    private Container myOwner;
    private GridBagLayout gridBag = new GridBagLayout();
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    DlgError(TcpError tcpError, Frame frame) {
        super(frame, "", true);
        this.myFrame = frame;
        this.myBundle = ClientMsg.getBundle();
        this.myError = tcpError;
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(2));
    }

    DlgError(TcpError tcpError, Container container) {
        super(Utility.getFrame(container), "", true);
        this.myFrame = Utility.getFrame(container);
        this.myBundle = ClientMsg.getBundle();
        this.myError = tcpError;
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(2));
    }

    DlgError(TcpError tcpError, Container container, boolean bl) {
        super(Utility.getFrame(container), "", true);
        this.makeItAcancelButton = bl;
        this.myFrame = Utility.getFrame(container);
        this.myBundle = ClientMsg.getBundle();
        this.myError = tcpError;
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(2));
    }

    DlgError(TcpError tcpError, Container container, boolean bl, Dimension dimension) {
        this(tcpError, container, bl);
        ((Component)this).setSize(Utility.getDimension(3));
    }

    private Dimension getMinSize() {
        super.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    private void addButtonGUI(int n, int n2, int n3) {
        this.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        this.buttonLabels[1] = this.makeItAcancelButton ? this.myBundle.getString("GLO_CANCEL") : this.myBundle.getString("DLGERROR_OK_TO_ALL");
        myButtonPanel = new ButtonPanel(this, this.buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
        Button[] buttonArray = myButtonPanel.getButtons();
        this.setCursorFocus(buttonArray[0]);
    }

    private void createGUI() {
        if (Utility.isTraceOn()) {
            System.out.println("in DlgError.createGUI(), myError.getText() = " + this.myError.getText());
        }
        ((Component)this).setBackground(Utility.NOTEBOOK_COLOR);
        this.setTitle(this.myBundle.getString("DLGERROR_TITLE"));
        this.lblError = new MultiLineLabel(this.myError.getText());
        switch (this.myError.getType()) {
            case 0: {
                this.lblErrorTitle = new Label(this.myBundle.getString("DLGERROR_SEVERE_ERROR"));
                break;
            }
            case 1: {
                this.lblErrorTitle = new Label(this.myBundle.getString("DLGERROR_WARNING_ERROR"));
                break;
            }
            case 2: {
                this.lblErrorTitle = new Label(this.myBundle.getString("DLGERROR_INFORMATION_ERROR"));
                break;
            }
            case 3: {
                this.lblErrorTitle = new Label(this.myBundle.getString("DLGERROR_FATAL_ERROR"));
                break;
            }
            default: {
                this.lblErrorTitle = new Label(this.myBundle.getString("DLGERROR_INFORMATION_ERROR"));
            }
        }
        this.errorPanel = new BorderPanel();
        this.errorPanel.setLayout(this.gridBag);
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this, this.lblErrorTitle, 0, 0, 0, 1, 0, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.errorPanel, this.lblError, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this, this.errorPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 2, 5);
        this.lblError.setSize(Utility.MEDIUM_MULTI_WIDTH, Utility.MEDIUM_MULTI_HEIGHT);
    }

    private void doHelpButton() {
        this.getHelp("TCNBSTAR.htm");
    }

    public void setCurrentNumShown(int n) {
        this.myCurrentNumShown = n;
        this.resetTitle();
    }

    public void setError(TcpError tcpError) {
        this.myError = tcpError;
        this.lblError.setLabel(this.myError.getText());
    }

    public void setTotalNumShown(int n) {
        this.myTotalNumShown = n;
        this.resetTitle();
    }

    private void resetTitle() {
        switch (this.myError.getType()) {
            case 0: {
                this.lblErrorTitle.setText(String.valueOf(this.myBundle.getString("DLGERROR_SEVERE_ERROR")) + this.myCurrentNumShown + this.myBundle.getString("DLGERROR_OF") + this.myTotalNumShown);
                return;
            }
            case 1: {
                this.lblErrorTitle.setText(String.valueOf(this.myBundle.getString("DLGERROR_WARNING_ERROR")) + this.myCurrentNumShown + this.myBundle.getString("DLGERROR_OF") + this.myTotalNumShown);
                return;
            }
            case 2: {
                this.lblErrorTitle.setText(String.valueOf(this.myBundle.getString("DLGERROR_INFORMATION_ERROR")) + this.myCurrentNumShown + this.myBundle.getString("DLGERROR_OF") + this.myTotalNumShown);
                return;
            }
            case 3: {
                this.lblErrorTitle.setText(String.valueOf(this.myBundle.getString("DLGERROR_FATAL_ERROR")) + this.myCurrentNumShown + this.myBundle.getString("DLGERROR_OF") + this.myTotalNumShown);
                return;
            }
        }
        this.lblErrorTitle.setText(String.valueOf(this.myBundle.getString("DLGERROR_INFORMATION_ERROR")) + this.myCurrentNumShown + this.myBundle.getString("DLGERROR_OF") + this.myTotalNumShown);
    }

    public int getStatus() {
        if (Utility.isTraceOn()) {
            System.out.println("In DlgError.getStatus() = " + myStatus);
        }
        return myStatus;
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Utility.getDimension(2);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension2.width / 2 - dimension.width / 2;
        int n2 = dimension2.height / 2 - dimension.height / 2;
        ((Component)this).setBounds(n, n2, dimension.width, dimension.height);
        super.setVisible(bl);
        this.getCursorFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            this.setVisible(false);
            if (Utility.isTraceOn()) {
                System.out.println("Setting status to  OK_BUTTON_HIT = " + 0);
            }
            myStatus = 0;
            return;
        }
        if (button == buttonArray[1]) {
            if (Utility.isTraceOn()) {
                System.out.println("Setting status to  OK_TO_ALL_BUTTON_HIT = " + 1);
            }
            this.setVisible(false);
            myStatus = 1;
            return;
        }
    }
}

