/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DlgSOCKS2ACD
extends BaseDialog
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private MulColumn myList;
    private Label lblIPaddress;
    private Label lblSubnetMask;
    private TextField tfIPaddress;
    private TextField tfSubnetMask;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private Component myOwner;
    private GridBagLayout gridBag = new GridBagLayout();
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgSOCKS2ACD(int n, Container container, MulColumn mulColumn) {
        super(new Frame(), "", false, container);
        this.setReason(n);
        this.myOwner = container;
        this.myList = mulColumn;
        this.myBundle = ClientMsg.getBundle();
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(1));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgSOCKS2ACD.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgSOCKS2ACD.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgSOCKS2ACD.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        this.setTitle(this.myBundle.getString("DS2_UPDATE_TITLE"));
        this.tfIPaddress = new TextField("");
        this.tfSubnetMask = new TextField("");
        this.lblSubnetMask = new Label(this.myBundle.getString("PS2_SUBNET_MASK"));
        this.lblIPaddress = new Label(this.myBundle.getString("PS2_DEST_IP_ADDR"));
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblIPaddress, 0, 1, 0, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.tfIPaddress, 0, 2, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 10, 10);
        Utility.constrain(this.centerPanel, this.lblSubnetMask, 0, 3, 0, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.tfSubnetMask, 0, 4, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        this.addButtonGUI(0, 5, 5);
        Utility.constrain(this, this.centerPanel, 0, 0, 0, 1, 2, 17, 1.0, 1.0, 0, 10, 0, 0);
        if (this.getReason() == 2) {
            this.tfIPaddress.setEnabled(false);
            this.tfSubnetMask.setEnabled(false);
            this.setTitle(this.myBundle.getString("DS2_DELETE_TITLE"));
            this.tfIPaddress.setEnabled(false);
            this.tfSubnetMask.setEnabled(false);
        }
        this.setCursorFocus(this.tfIPaddress);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.tfIPaddress.setEnabled(bl);
        this.tfSubnetMask.setEnabled(bl);
    }

    private void doHelpButton() {
        this.getHelp("TCNBC2SO.htm");
    }

    public String getIPaddress() {
        return this.tfIPaddress.getText();
    }

    public void setIPaddress(String string) {
        ((TextComponent)this.tfIPaddress).setText(string);
    }

    public String getSubnetMask() {
        return this.tfSubnetMask.getText();
    }

    public void setSubnetMask(String string) {
        ((TextComponent)this.tfSubnetMask).setText(string);
    }

    private boolean validateDialog() {
        if (this.getReason() == 2) {
            return true;
        }
        if (Utility.isEmptyTextField(this.tfIPaddress) || Utility.isEmptyTextField(this.tfSubnetMask)) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DS2_FIELDS_RQD"), true, this);
            this.setCursorFocus(this.tfIPaddress);
            return false;
        }
        if (!TcpipValidation.IsValidTcpipAddr((String)this.tfIPaddress.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("IP_INVALID"), true, this);
            this.setCursorFocus(this.tfIPaddress);
            return false;
        }
        if (!TcpipValidation.IsValidTcpipAddr((String)this.tfSubnetMask.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("SUBNET_INVALID"), true, this);
            this.setCursorFocus(this.tfSubnetMask);
            return false;
        }
        if (this.isDuplicate()) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("GLO_DUPLICATE_ENTRY"), true, this);
            this.setCursorFocus(this.tfIPaddress);
            return false;
        }
        if (Utility.isNoEntries(this.tfIPaddress)) {
            Object[] objectArray = new Object[]{this.myBundle.getString("GLO_NO_ENTRIES")};
            String string = MessageFormat.format(this.myBundle.getString("GLO_BAD_NO_ENTRIES"), objectArray);
            this.enableGUI(false);
            this.showErrorDialog(string, true, this);
            this.setCursorFocus(this.tfIPaddress);
            return false;
        }
        return true;
    }

    public boolean isDuplicate() {
        boolean bl = false;
        int n = this.myList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = this.myList.getItem(n2);
            if (stringArray[0].compareTo(this.tfIPaddress.getText()) == 0 && stringArray[1].compareTo(this.tfSubnetMask.getText()) == 0) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
        super.setVisible(bl);
        FocusKeeper.setFocusWindow(this);
        this.getCursorFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                this.setVisible(false);
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }
}

