/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Validation;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DlgSecurity2ACD
extends BaseDialog
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private MulColumn myList;
    private Label lblHostname;
    private Label lblDomainname;
    private Label lblUser;
    private TextField htfHostname;
    private TextField tfDomainname;
    private TextField tfUser;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private Component myOwner;
    private GridBagLayout gridBag = new GridBagLayout();
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgSecurity2ACD(int n, Container container) {
        super(new Frame(), "", false, container);
        this.setReason(n);
        this.myBundle = ClientMsg.getBundle();
        this.myOwner = container;
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(2));
    }

    public DlgSecurity2ACD(int n, Container container, MulColumn mulColumn) {
        super(new Frame(), "", false, container);
        this.setReason(n);
        this.myBundle = ClientMsg.getBundle();
        this.myOwner = container;
        this.myList = mulColumn;
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(2));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgSecurity2ACD.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgSecurity2ACD.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgSecurity2ACD.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        this.setTitle(this.myBundle.getString("DSC2ACD_TITLE"));
        this.htfHostname = new TextField();
        this.tfDomainname = new TextField();
        this.tfUser = new TextField();
        this.lblHostname = new Label(this.myBundle.getString("DSC2ACD_HOST_NAME"));
        this.lblDomainname = new Label(this.myBundle.getString("DSC2ACD_DOMAIN_NAME"));
        this.lblUser = new Label(this.myBundle.getString("DSC2ACD_USER"));
        if (this.getReason() == 2) {
            this.htfHostname.setEnabled(false);
            this.tfDomainname.setEnabled(false);
            this.tfUser.setEnabled(false);
            this.lblHostname.setEnabled(false);
            this.lblDomainname.setEnabled(false);
            this.lblUser.setEnabled(false);
        }
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblHostname, 0, 1, 0, 1, 2, 17, 1.0, 0.0, 0, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.htfHostname, 0, 2, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblDomainname, 0, 3, 0, 1, 2, 17, 1.0, 0.0, 0, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.tfDomainname, 0, 4, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblUser, 0, 5, 0, 1, 2, 17, 1.0, 0.0, 0, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.tfUser, 0, 6, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this, this.centerPanel, 0, 0, 0, 1, 2, 17, 1.0, 1.0, 0, 10, 0, 0);
        this.addButtonGUI(0, 1, 5);
        this.setCursorFocus(this.htfHostname);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.htfHostname.setEnabled(bl);
        this.tfDomainname.setEnabled(bl);
        this.tfUser.setEnabled(bl);
    }

    private void doHelpButton() {
        this.getHelp("TCNBCRS.htm");
    }

    public String getDomainname() {
        return this.tfDomainname.getText();
    }

    public void setDomainname(String string) {
        ((TextComponent)this.tfDomainname).setText(string);
    }

    public String getHostname() {
        return this.htfHostname.getText();
    }

    public void setHostname(String string) {
        ((TextComponent)this.htfHostname).setText(string);
    }

    public String getUser() {
        return this.tfUser.getText();
    }

    public void setUser(String string) {
        ((TextComponent)this.tfUser).setText(string);
    }

    private boolean validateDialog() {
        if (this.getReason() == 2) {
            return true;
        }
        if (Utility.isEmptyTextField(this.htfHostname) || Utility.isEmptyTextField(this.tfDomainname)) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DSC2ACD_FIELDS_RQD"), true, this);
            this.setCursorFocus(this.htfHostname);
            return false;
        }
        if (!Cfg2Validation.IsValidHost_IPName(this.htfHostname.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("HOST_INVALID"), true, this);
            this.setCursorFocus(this.htfHostname);
            return false;
        }
        if (!Cfg2Validation.IsValidDomain_IPName(this.tfDomainname.getText())) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DOMAIN_INVALID"), true, this);
            this.setCursorFocus(this.tfDomainname);
            return false;
        }
        if (this.isDuplicate()) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("GLO_DUPLICATE_ENTRY"), true, this);
            this.setCursorFocus(this.htfHostname);
            return false;
        }
        if (Utility.isNoEntries(this.htfHostname)) {
            Object[] objectArray = new Object[]{this.myBundle.getString("GLO_NO_ENTRIES")};
            String string = MessageFormat.format(this.myBundle.getString("GLO_BAD_NO_ENTRIES"), objectArray);
            this.enableGUI(false);
            this.showErrorDialog(string, true, this);
            this.setCursorFocus(this.htfHostname);
            return false;
        }
        return true;
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
        super.setVisible(bl);
        FocusKeeper.setFocusWindow(this);
        this.getCursorFocus();
    }

    public boolean isDuplicate() {
        boolean bl = false;
        int n = this.myList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = this.myList.getItem(n2);
            if (stringArray[0].compareTo(this.htfHostname.getText()) == 0 && stringArray[1].compareTo(this.tfDomainname.getText()) == 0 && stringArray[2].compareTo(this.tfUser.getText()) == 0) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                if (this.getReason() == 2) {
                    this.dispose();
                    return;
                }
                this.setVisible(false);
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }
}

