/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BaseDialog;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.FocusKeeper;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DlgSecurity4ACD
extends BaseDialog
implements ActionListener,
ItemListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblDirectory;
    private Label lblAlias;
    private TextField tfDirectory;
    private TextField tfAlias;
    private CheckboxGroup cbGroup;
    private Checkbox cbAllow;
    private Checkbox cbDeny;
    private MulColumn myList;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null};
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private GridBagLayout gridBag = new GridBagLayout();
    private Component myOwner;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public DlgSecurity4ACD(int n, Container container, MulColumn mulColumn) {
        super(new Frame(), "", false, container);
        this.setReason(n);
        this.myBundle = ClientMsg.getBundle();
        this.myList = mulColumn;
        this.myOwner = container;
        this.createGUI();
        ((Component)this).setSize(Utility.getDimension(2));
    }

    private void addButtonGUI(int n, int n2, int n3) {
        DlgSecurity4ACD.buttonLabels[0] = this.myBundle.getString("GLO_OK");
        DlgSecurity4ACD.buttonLabels[1] = this.myBundle.getString("GLO_CANCEL");
        DlgSecurity4ACD.buttonLabels[2] = this.myBundle.getString("GLO_HELP");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createGUI() {
        this.tfDirectory = new TextField();
        this.tfAlias = new TextField();
        this.cbGroup = new CheckboxGroup();
        this.setTitle(this.myBundle.getString("DSC4ACD_TITLE"));
        this.cbAllow = new Checkbox(this.myBundle.getString("DSC4ACD_ALLOW"), this.cbGroup, true);
        this.cbDeny = new Checkbox(this.myBundle.getString("DSC4ACD_DENY"), this.cbGroup, false);
        this.cbAllow.addKeyListener(this);
        this.cbDeny.addKeyListener(this);
        this.cbAllow.addItemListener(this);
        this.cbDeny.addItemListener(this);
        this.lblDirectory = new Label(this.myBundle.getString("DSC4ACD_DIRECTORY"));
        this.lblAlias = new Label(this.myBundle.getString("DSC4ACD_ALIAS"));
        if (this.getReason() == 2) {
            this.tfDirectory.setEnabled(false);
            this.tfAlias.setEnabled(false);
            this.cbAllow.setEnabled(false);
            this.cbDeny.setEnabled(false);
            this.lblDirectory.setEnabled(false);
        }
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        this.setLayout(this.gridBag);
        Utility.constrain(this.centerPanel, this.lblDirectory, 0, 1, 0, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.tfDirectory, 0, 2, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblAlias, 0, 3, 0, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.tfAlias, 0, 4, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.cbAllow, 0, 5, 0, 1, 2, 10, 1.0, 1.0, 0, 10, 0, 10);
        Utility.constrain(this.centerPanel, this.cbDeny, 0, 6, 0, 1, 2, 10, 1.0, 1.0, 0, 10, 0, 10);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 10, 0, 0);
        this.addButtonGUI(0, 2, 5);
        this.setCursorFocus(this.tfDirectory);
    }

    public void enableGUI(boolean bl) {
        Button[] buttonArray = myButtonPanel.getButtons();
        int n = 0;
        while (n < buttonArray.length) {
            buttonArray[n].setEnabled(bl);
            ++n;
        }
        this.tfDirectory.setEnabled(bl);
        this.tfAlias.setEnabled(bl);
        this.cbAllow.setEnabled(bl);
        this.cbDeny.setEnabled(bl);
    }

    private void doHelpButton() {
        this.getHelp("TCNBCTAU.htm");
    }

    public String getDirectory() {
        return this.tfDirectory.getText();
    }

    public void setDirectory(String string) {
        ((TextComponent)this.tfDirectory).setText(string);
    }

    public String getAlias() {
        return this.tfAlias.getText();
    }

    public void setAlias(String string) {
        ((TextComponent)this.tfAlias).setText(string);
    }

    public boolean isAllow() {
        return this.cbAllow.getState();
    }

    public void setAllow(boolean bl) {
        this.cbAllow.setState(bl);
    }

    public boolean isDeny() {
        return this.cbDeny.getState();
    }

    public void setDeny(boolean bl) {
        this.cbDeny.setState(bl);
    }

    private boolean validateDialog() {
        if (this.getReason() == 2) {
            return true;
        }
        if (Utility.isEmptyTextField(this.tfDirectory)) {
            this.enableGUI(false);
            this.showErrorDialog(this.myBundle.getString("DSC4ACD_FIELDS_RQD"), true, this);
            this.setCursorFocus(this.tfDirectory);
            return false;
        }
        int n = this.myList.getItemCount();
        String[] stringArray = null;
        String string = this.cbAllow.getState() ? this.myBundle.getString("GLO_ALLOW") : this.myBundle.getString("GLO_DENY");
        if (!this.isNoEntries(this.myList, 1) && this.myList.getItemCount() > 0) {
            int n2 = 0;
            while (n2 < n) {
                stringArray = this.myList.getItem(n2);
                ++n2;
            }
        }
        if (Utility.isNoEntries(this.tfDirectory)) {
            Object[] objectArray = new Object[]{this.myBundle.getString("GLO_NO_ENTRIES")};
            String string2 = MessageFormat.format(this.myBundle.getString("GLO_BAD_NO_ENTRIES"), objectArray);
            this.enableGUI(false);
            this.showErrorDialog(string2, true, this);
            this.setCursorFocus(this.tfDirectory);
            return false;
        }
        String string3 = this.getAlias();
        int n3 = (string3 = string3.trim()).indexOf(" ");
        if (n3 > -1) {
            this.showErrorDialog(this.myBundle.getString("DSC4ACD_SINGLE_ALIAS"), true, this);
            this.setCursorFocus(this.tfAlias);
            return false;
        }
        return true;
    }

    public void messageFinished(int n) {
        this.enableGUI(true);
        this.requestFocus();
        this.getCursorFocus();
    }

    public void setVisible(boolean bl) {
        Frame frame = Utility.getFrame((Container)this.myOwner);
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension.width / 2 - dimension2.width / 2;
        int n2 = point.y + dimension.height / 2 - dimension2.height / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
        super.setVisible(bl);
        FocusKeeper.setFocusWindow(this);
        this.getCursorFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            if (this.validateDialog()) {
                this.setStatus(0);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(0);
                if (this.getReason() == 2) {
                    this.dispose();
                    return;
                }
                this.setVisible(false);
                return;
            }
        } else {
            if (button == buttonArray[1]) {
                this.setStatus(1);
                ((DialogListener)((Object)this.myOwner)).dialogFinished(1);
                this.dispose();
                return;
            }
            if (button == buttonArray[2]) {
                this.doHelpButton();
            }
        }
    }

    public void handleCheckbox(Checkbox checkbox) {
        if (checkbox == this.cbAllow) {
            if (this.cbAllow.getState()) {
                this.tfAlias.setEnabled(true);
                return;
            }
            this.tfAlias.setEnabled(false);
            return;
        }
        if (this.cbDeny.getState()) {
            this.tfAlias.setEnabled(false);
            return;
        }
        this.tfAlias.setEnabled(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            this.handleCheckbox((Checkbox)object);
        }
    }

    public void setCheckbox(boolean bl) {
        if (bl) {
            this.tfAlias.setEnabled(bl);
            return;
        }
        this.tfAlias.setEnabled(bl);
    }
}

