/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.ListContainer;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumnCallback;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class MulColumn
extends Panel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
ListContainer {
    MulColumnCallback callback;
    String[] title;
    int[] cpos;
    float[] cwidth;
    Vector[] list;
    Scrollbar sb;
    int width;
    int height;
    Insets in;
    int sbwidth;
    int th;
    Image bim;
    Graphics bg;
    FontMetrics fnm;
    int coldrag = -1;
    int sel = -1;
    int top;
    long last;
    Dimension myDimension = new Dimension(1, 1);
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    MulColumn(String[] stringArray) {
        this.title = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.title[n] = stringArray[n];
            ++n;
        }
        this.list = new Vector[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.list[n2] = new Vector();
            ++n2;
        }
        this.cwidth = new float[stringArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.cwidth[n3] = 1.0f / (float)stringArray.length;
            ++n3;
        }
        this.cpos = new int[stringArray.length + 1];
        this.setLayout(null);
        this.sb = new Scrollbar();
        this.add(this.sb);
        this.sb.addAdjustmentListener(this);
        this.sb.addMouseListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    MulColumn(String[] stringArray, int[] nArray) {
        this.title = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.title[n] = stringArray[n];
            ++n;
        }
        this.list = new Vector[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.list[n2] = new Vector();
            ++n2;
        }
        this.cwidth = new float[stringArray.length];
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            n3 += nArray[n4];
            ++n4;
        }
        int n5 = 0;
        while (n5 < stringArray.length) {
            this.cwidth[n5] = (float)nArray[n5] / (float)n3;
            ++n5;
        }
        this.cpos = new int[stringArray.length + 1];
        this.setLayout(null);
        this.sb = new Scrollbar();
        this.add(this.sb);
        this.sb.addAdjustmentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    MulColumn(String[] stringArray, MulColumnCallback mulColumnCallback) {
        this(stringArray);
        this.callback = mulColumnCallback;
    }

    MulColumn(String[] stringArray, int[] nArray, MulColumnCallback mulColumnCallback) {
        this(stringArray, nArray);
        this.callback = mulColumnCallback;
    }

    void replaceItem(String[] stringArray, int n) {
        int n2 = 0;
        while (n2 < this.title.length) {
            this.list[n2].setElementAt(stringArray[n2], n);
            ++n2;
        }
        this.repaint();
    }

    void add(String[] stringArray) {
        int n = 0;
        while (n < this.title.length) {
            this.list[n].addElement(stringArray[n]);
            ++n;
        }
        this.repaint();
        this.compscroll();
    }

    void insertItem(String[] stringArray, int n) {
        int n2 = this.getSelectedIndex();
        int n3 = this.getItemCount();
        if (n2 == -1) {
            this.add(stringArray);
            return;
        }
        int n4 = n3;
        while (n4 > n2) {
            if (n4 < n3) {
                this.replaceItem(this.getItem(n4 - 1), n4);
            } else {
                this.add(this.getItem(n4 - 1));
            }
            --n4;
        }
        this.replaceItem(stringArray, n);
        this.repaint();
        this.compscroll();
    }

    void addItems(String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < this.title.length) {
                this.list[n2].addElement(stringArray[n][n2]);
                ++n2;
            }
            ++n;
        }
        this.repaint();
        this.compscroll();
    }

    String[] getItem(int n) {
        String[] stringArray = new String[this.title.length];
        int n2 = 0;
        while (n2 < this.title.length) {
            stringArray[n2] = (String)this.list[n2].elementAt(n);
            ++n2;
        }
        return stringArray;
    }

    String[] getSelectedItem() {
        if (this.sel == -1) {
            return null;
        }
        return this.getItem(this.sel);
    }

    int getItemCount() {
        return this.list[0].size();
    }

    public void deselect(int n) {
        this.sel = -1;
        this.repaint();
    }

    int getSelectedIndex() {
        return this.sel;
    }

    void select(int n) {
        this.sel = n;
        this.repaint();
    }

    public void remove(int n) {
        int n2 = 0;
        while (n2 < this.title.length) {
            this.list[n2].removeElementAt(n);
            ++n2;
        }
        if (n == this.sel) {
            this.sel = -1;
        }
        if (this.top != 0) {
            --this.top;
        }
        this.repaint();
        this.compscroll();
    }

    public void removeAll() {
        int n = 0;
        while (n < this.title.length) {
            this.list[n].removeAllElements();
            ++n;
        }
        this.sel = -1;
        this.repaint();
        this.sb.setValues(0, 1, 0, 0);
    }

    void setWidths(float[] fArray) {
        int n = 0;
        while (n < this.title.length) {
            this.cwidth[n] = fArray[n];
            ++n;
        }
        this.respace();
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 != this.width + this.sbwidth || n4 != this.height) {
            this.in = this.getInsets();
            this.sbwidth = this.sb.getMinimumSize().width;
            this.width = n3 - this.sbwidth - (this.in.left + this.in.right);
            this.height = n4 - (this.in.top + this.in.bottom);
            this.sb.setBounds(this.width + this.in.left, this.in.top, this.sbwidth, this.height);
            this.respace();
            this.bim = null;
            this.repaint();
            this.compscroll();
        }
        super.setBounds(n, n2, n3, n4);
    }

    void respace() {
        this.cpos[0] = 0;
        int n = 0;
        while (n < this.title.length) {
            this.cpos[n + 1] = this.cpos[n] + (int)((float)this.width * this.cwidth[n]);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        try {
            if (this.bim == null) {
                this.bim = this.createImage(this.width, this.height);
                this.bg = this.bim.getGraphics();
                this.bg.setFont(new Font("timesRoman", 0, 12));
                this.fnm = this.bg.getFontMetrics();
                this.th = this.fnm.getHeight() + 4;
                this.render();
                this.compscroll();
            }
            graphics.drawImage(this.bim, this.in.left, this.in.top, this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void update(Graphics graphics) {
        if (this.fnm != null) {
            this.render();
            this.paint(graphics);
        }
    }

    void render() {
        int n = this.fnm.getDescent();
        this.fnm.getAscent();
        this.fnm.getLeading();
        int n2 = this.fnm.getHeight();
        int n3 = Math.min(this.top + this.rows() - 1, this.list[0].size() - 1);
        this.bg.setColor(Utility.NOTEBOOK_COLOR);
        this.bg.fillRect(0, 0, this.width, this.th);
        this.bg.setColor(Color.white);
        this.bg.fillRect(0, this.th, this.width, this.height - this.th);
        if (this.sel >= this.top && this.sel <= n3) {
            this.bg.setColor(Utility.NOTEBOOK_COLOR);
            this.bg.fillRect(0, this.th + (this.sel - this.top) * n2, this.width, n2);
        }
        int n4 = 0;
        while (n4 < this.title.length) {
            int n5 = this.cpos[n4];
            int n6 = this.cpos[n4 + 1] - n5 - 1;
            this.bg.setColor(Color.white);
            this.bg.drawLine(n5, 0, n5 + n6, 0);
            this.bg.drawLine(n5, 1, n5 + n6 - 1, 1);
            this.bg.drawLine(n5, 0, n5, this.th - 1);
            this.bg.drawLine(n5 + 1, 0, n5 + 1, this.th - 2);
            this.bg.setColor(Color.black);
            this.bg.drawLine(n5, this.th - 1, n5 + n6, this.th - 1);
            this.bg.drawLine(n5, this.th - 2, n5 + n6 - 1, this.th - 2);
            this.bg.drawLine(n5 + n6, this.th - 1, n5 + n6, 0);
            this.bg.drawLine(n5 + n6 - 1, this.th - 1, n5 + n6 - 1, 1);
            int n7 = this.fnm.stringWidth(this.title[n4]);
            this.bg.drawString(this.title[n4], n5 + (n6 - n7) / 2, this.th - n - 2);
            this.bg.setColor(Utility.NOTEBOOK_COLOR);
            this.bg.drawLine(n5 + n6 - 1, this.th, n5 + n6 - 1, this.height);
            this.bg.setColor(Color.black);
            this.bg.drawLine(n5 + n6, this.th, n5 + n6, this.height);
            int n8 = this.top;
            while (n8 <= n3) {
                String string = (String)this.list[n4].elementAt(n8);
                while (this.fnm.stringWidth(string) > n6 - 3) {
                    string = string.substring(0, string.length() - 1);
                }
                this.bg.drawString(string, n5 + 1, this.th + (n8 + 1 - this.top) * n2 - n);
                ++n8;
            }
            ++n4;
        }
    }

    private void compscroll() {
        if (this.fnm == null) {
            return;
        }
        int n = this.rows();
        int n2 = this.list[0].size();
        this.sb.setValues(this.top, n == 0 ? 1 : n, 0, n2 < 0 ? 0 : n2);
        this.sb.setBlockIncrement(n);
    }

    public int getColumnCount() {
        return this.list[0].size();
    }

    private int rows() {
        return Math.min((this.height - 1) / this.fnm.getHeight() - 1, this.list[0].size());
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object instanceof Scrollbar) {
            this.top = this.sb.getValue();
            this.compscroll();
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.getSource();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.coldrag = -1;
        if ((n2 -= this.in.top) < this.th || (n -= this.in.left) > this.width) {
            if (n2 < this.th) {
                int n3 = 1;
                while (n3 < this.title.length) {
                    if (Math.abs(this.cpos[n3] - n) < 3) {
                        this.coldrag = n3;
                    }
                    ++n3;
                }
                return;
            }
        } else {
            int n4 = (n2 - this.th) / this.fnm.getHeight() + this.top;
            if (n4 < this.list[0].size()) {
                boolean bl = false;
                if (mouseEvent.getClickCount() > 1) {
                    bl = true;
                }
                this.sel = n4;
                this.repaint();
                if (this.callback != null) {
                    if (bl) {
                        this.callback.doubleClick(this, n4);
                        return;
                    }
                    this.callback.singleClick(this, n4);
                    return;
                }
                this.getParent().dispatchEvent(new ActionEvent(this, 1001, bl ? "Double" : "Single"));
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent.getSource();
        mouseEvent.getX();
        mouseEvent.getY();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        n2 -= this.in.top;
        if (this.coldrag != -1 && (n -= this.in.left) > this.cpos[this.coldrag - 1] + 3 && n < this.cpos[this.coldrag + 1] - 3) {
            this.cpos[this.coldrag] = n;
            this.cwidth[this.coldrag - 1] = (float)(this.cpos[this.coldrag] - this.cpos[this.coldrag - 1]) / (float)this.width;
            this.cwidth[this.coldrag] = (float)(this.cpos[this.coldrag + 1] - this.cpos[this.coldrag]) / (float)this.width;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        return this.myDimension;
    }

    public Dimension getMinimumSize() {
        return this.myDimension;
    }
}

