/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgHostname2ACD;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConfigData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.HostsData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.HostsEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgHostname2
extends BasePage
implements ActionListener,
DialogListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblListTitle;
    private BorderPanel bottomPanel;
    private MulColumn lHostname;
    private Checkbox cbSearchHostsList;
    private ButtonPanel myButtons1;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private int dialogCommand = -1;
    private boolean myTrace = false;
    private String originalConfigString = new String();
    private String originalHostsString = new String();
    private boolean undoTheUpdate = true;
    private boolean undoTheHostsUpdate = true;
    private BaseProxy myServerProxy;
    private ConfigData myConfigData;
    private HostsData myHostsData;
    GridBagLayout gridBag = new GridBagLayout();
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static final int HOSTNAME_LIST_MAX_COLUMNS = 4;
    private DlgHostname2ACD nameResDialog;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgHostname2(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgHostname2.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgHostname2.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgHostname2.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgHostname2.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PH2_TITLE"));
        String[] stringArray = new String[]{this.myBundle.getString("PH2_IP_ADDRESS"), this.myBundle.getString("PH2_HOST_NAME"), this.myBundle.getString("PH2_ALIAS"), this.myBundle.getString("PH2_COMMENTS")};
        int[] nArray = new int[]{18, 30, 15, 37};
        this.lHostname = new MulColumn(stringArray, nArray);
        this.bottomPanel = new BorderPanel(this.myBundle.getString("PH2_HOSTNAME_CONFIG"));
        this.cbSearchHostsList = new Checkbox(this.myBundle.getString("PH2_HOSTS_LIST"));
        this.cbSearchHostsList.addKeyListener(this);
        this.setLayout(this.gridBag);
        this.bottomPanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.bottomPanel, this.lHostname, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 10, 0, 10);
        Utility.constrain(this.bottomPanel, this.cbSearchHostsList, 0, 2, 0, 1, 2, 17, 1.0, 0.0, 0, 10, 0, 0);
        Utility.constrain(this, this.bottomPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 2, 5);
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalConfigString = this.toStringConfig();
            this.myConfigData.setUpdated(false);
        }
        if (this.undoTheHostsUpdate) {
            this.originalHostsString = this.toStringHosts();
            this.myHostsData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.myConfigData = this.myServerProxy.getNotebookProfileDataHandle().getConfigDataHandle();
        this.myHostsData = this.myServerProxy.getNotebookProfileDataHandle().getHostsDataHandle();
    }

    public void setDataFromGUI() {
        this.myConfigData.setSearchHostsListState(this.cbSearchHostsList.getState());
        this.myHostsData.deleteHostsList();
        HostsEntry hostsEntry = null;
        int n = this.isNoEntries(this.lHostname) ? 0 : this.lHostname.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = this.lHostname.getItem(n2);
            hostsEntry = new HostsEntry(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
            this.myHostsData.addHostsEntry(hostsEntry);
            ++n2;
        }
        if (this.myTrace) {
            System.out.println("PgHostname2 COMPARING Original Config string = " + this.originalConfigString);
            System.out.println("PgHostname2 COMPARING Current  Config string = " + this.toStringConfig());
        }
        if (this.originalConfigString.compareTo(this.toStringConfig()) != 0) {
            if (this.myTrace) {
                System.out.println("PgHostname2 config.sys has changed!!!");
            }
            this.myConfigData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgHostname2 config.sys has NOT changed!!!");
        }
        this.originalConfigString = null;
        if (this.myConfigData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgHostname2 config.sys been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
        if (this.myTrace) {
            System.out.println("PgHostname1 COMPARING Original Hosts string = " + this.originalConfigString);
            System.out.println("PgHostname1 COMPARING Current  Hosts string = " + this.toStringConfig());
        }
        if (this.originalHostsString.compareTo(this.toStringHosts()) != 0) {
            if (this.myTrace) {
                System.out.println("PgHostname1 hosts has changed!!!");
            }
            this.myHostsData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgHostname1 hosts has NOT changed!!!");
        }
        this.originalHostsString = null;
        if (this.myHostsData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgHostname1 hosts been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheHostsUpdate = false;
        }
    }

    public void setGUIfromData() {
        this.cbSearchHostsList.setState(this.myConfigData.getSearchHostsListState());
        int n = this.myHostsData.getHostsEntryListSize();
        this.lHostname.removeAll();
        String[] stringArray = new String[4];
        if (n == 0) {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            stringArray[1] = "";
            stringArray[2] = "";
            stringArray[3] = "";
            this.lHostname.add(stringArray);
        } else {
            int n2 = 0;
            while (n2 < n) {
                HostsEntry hostsEntry = this.myHostsData.getHostsEntry(n2);
                stringArray[0] = hostsEntry.getIPAddress();
                stringArray[1] = hostsEntry.getHostname();
                stringArray[2] = hostsEntry.getAlias();
                stringArray[3] = hostsEntry.getComment();
                this.lHostname.add(stringArray);
                ++n2;
            }
        }
        this.lHostname.select(0);
        this.originalConfigString = this.toStringConfig();
        if (this.myTrace) {
            System.out.println("PgHostname2 Original config string = " + this.originalConfigString);
        }
        if (this.myConfigData.isUpdated()) {
            this.undoTheUpdate = false;
        }
        this.originalHostsString = this.toStringHosts();
        if (this.myTrace) {
            System.out.println("PgHostname2 Original hosts string = " + this.originalHostsString);
        }
        if (this.myHostsData.isUpdated()) {
            this.undoTheHostsUpdate = false;
        }
    }

    public boolean validatePage() {
        if (this.cbSearchHostsList.getState() && this.isNoEntries(this.lHostname)) {
            this.showMessageDialog(this.myBundle.getString("PH2_ENTER_A_HOST"), this);
            return false;
        }
        return true;
    }

    private void doOKdlgACDadd() {
        if (this.isNoEntries(this.lHostname)) {
            this.removeNoEntries(this.lHostname);
        }
        String[] stringArray = new String[]{this.nameResDialog.getIPAddress(), this.nameResDialog.getHostname(), this.nameResDialog.getAlias(), this.nameResDialog.getComment()};
        this.lHostname.add(stringArray);
        this.lHostname.select(this.lHostname.getItemCount() - 1);
        this.nameResDialog.dispose();
    }

    private void doOKdlgACDchange() {
        int n = this.lHostname.getSelectedIndex();
        String[] stringArray = new String[]{this.nameResDialog.getIPAddress(), this.nameResDialog.getHostname(), this.nameResDialog.getAlias(), this.nameResDialog.getComment()};
        this.lHostname.replaceItem(stringArray, n);
        this.lHostname.select(n);
        this.nameResDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        int n = this.lHostname.getSelectedIndex();
        this.lHostname.remove(n);
        int n2 = this.lHostname.getItemCount();
        if (n2 < 1) {
            String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES"), "", "", ""};
            this.lHostname.add(stringArray);
            n = 0;
        } else if (n == n2) {
            --n;
        }
        this.lHostname.select(n);
    }

    private void populateDlgACD() {
        String[] stringArray = this.lHostname.getSelectedItem();
        this.nameResDialog.setIPAddress(stringArray[0]);
        this.nameResDialog.setHostname(stringArray[1]);
        this.nameResDialog.setAlias(stringArray[2]);
        this.nameResDialog.setComment(stringArray[3]);
    }

    private void showACDdialog(int n) {
        this.nameResDialog = null;
        switch (n) {
            case 0: {
                this.nameResDialog = new DlgHostname2ACD(0, this, this.lHostname);
                break;
            }
            case 1: {
                this.nameResDialog = new DlgHostname2ACD(1, this, this.lHostname);
                this.populateDlgACD();
                break;
            }
            case 2: {
                this.nameResDialog = new DlgHostname2ACD(2, this, this.lHostname);
                this.populateDlgACD();
                break;
            }
            default: {
                this.nameResDialog = new DlgHostname2ACD(0, this, this.lHostname);
            }
        }
        this.myOwner.setEnabled(false);
        this.nameResDialog.setVisible(true);
    }

    public void messageFinished(int n) {
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleCheckbox(Checkbox checkbox) {
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            if (this.isChangeDeleteOk(this.lHostname, this)) {
                this.showACDdialog(1);
                this.dialogCommand = 1;
                return;
            }
        } else if (button == buttonArray[2]) {
            if (this.isChangeDeleteOk(this.lHostname, this)) {
                this.dialogCommand = 2;
                this.showACDdialog(2);
                return;
            }
        } else if (button == buttonArray[3] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringConfig() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cbSearchHostsList.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        return stringBuffer.toString();
    }

    public String toStringHosts() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[4];
        int n = this.lHostname.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.lHostname.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            stringBuffer.append(String.valueOf(stringArray[1]) + " ");
            stringBuffer.append(String.valueOf(stringArray[2]) + " ");
            stringBuffer.append(String.valueOf(stringArray[3]) + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

