/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgNFS1ACD;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgNFS1s;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSDirEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;

public class PgNFS1
extends BasePage
implements ActionListener,
DialogListener,
MessageListener,
ItemListener,
MouseListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private PgNFS1s pgNFS1s;
    private MulColumn lDir;
    private Panel dirPanel;
    private BorderPanel hostPanel;
    private Panel choicePanel;
    private static ButtonPanel myButtonPanel = null;
    private Checkbox cbMakePublic;
    private Checkbox cbSpecifyHost;
    private Checkbox cbReadOnly;
    private Checkbox cbReadWrite;
    private CheckboxGroup cbg;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private int dialogCommand = -1;
    private String originalNFSString = new String();
    private boolean undoTheUpdate = true;
    private NFSDirEntry myNFSDirEntry;
    private NFSData myNFSData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static final int NFS_LIST_MAX_COLUMNS = 3;
    private DlgNFS1ACD nfsDialog;
    int prevSel = -1;
    private boolean myTrace = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgNFS1(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgNFS1.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgNFS1.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgNFS1.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgNFS1.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PF1_TITLE"));
        this.pgNFS1s = new PgNFS1s(this.myOwner);
        this.hostPanel = new BorderPanel(this.myBundle.getString("PSC3_HOST_LIST"));
        this.hostPanel.setLayout(this.gridBag);
        this.dirPanel = new Panel();
        this.dirPanel.setLayout(this.gridBag);
        this.choicePanel = new Panel();
        this.choicePanel.setLayout(this.gridBag);
        this.cbMakePublic = new Checkbox(this.myBundle.getString("PF1_MAKE_PUBLIC"));
        this.cbSpecifyHost = new Checkbox(this.myBundle.getString("PF1_SPECIFY_HOSTS"));
        this.cbReadOnly = new Checkbox(this.myBundle.getString("PF1_ALL_HOSTS_READ_ONLY"));
        this.cbReadWrite = new Checkbox(this.myBundle.getString("PF1_ALL_HOSTS_READ_WRITE"));
        this.cbg = new CheckboxGroup();
        this.cbSpecifyHost.setCheckboxGroup(this.cbg);
        this.cbReadOnly.setCheckboxGroup(this.cbg);
        this.cbReadWrite.setCheckboxGroup(this.cbg);
        this.cbSpecifyHost.setState(true);
        this.cbMakePublic.addItemListener(this);
        this.cbSpecifyHost.addItemListener(this);
        this.cbReadOnly.addItemListener(this);
        this.cbReadWrite.addItemListener(this);
        this.cbMakePublic.addKeyListener(this);
        this.cbSpecifyHost.addKeyListener(this);
        this.cbReadOnly.addKeyListener(this);
        this.cbReadWrite.addKeyListener(this);
        String[] stringArray = new String[]{this.myBundle.getString("DSC3ACD_DIRECTORY"), this.myBundle.getString("PH2_ALIAS"), this.myBundle.getString("PH2_COMMENTS")};
        int[] nArray = new int[]{30, 30, 40};
        this.lDir = new MulColumn(stringArray, nArray);
        this.lDir.addMouseListener(this);
        this.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.dirPanel, this.lDir, 0, 0, -1, 1, 1, 10, 1.0, 1.0, 0, 5, 0, 5);
        Utility.constrain(this.hostPanel, this.pgNFS1s, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 0, 5, 0, 5);
        Utility.constrain(this.choicePanel, this.cbMakePublic, 0, 0, 1, 1, 2, 13, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.choicePanel, this.cbSpecifyHost, 1, 0, 1, 1, 2, 13, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.choicePanel, this.cbReadOnly, 0, 1, 1, 1, 2, 13, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.choicePanel, this.cbReadWrite, 1, 1, 1, 1, 2, 13, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this, this.hostPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 5, 0);
        Utility.constrain(this, this.dirPanel, 0, 3, 0, 1, 1, 10, 1.0, 2.0, 5, 10, 10, 10);
        Utility.constrain(this, this.choicePanel, 0, 2, 0, 1, 2, 10, 1.0, 0.0, 10, 10, 0, 0);
        this.addButtonGUI(0, 4, 5);
    }

    private void doUndoButton() {
        this.myNFSData.deCommit();
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalNFSString = this.toStringNFS();
            this.myNFSData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    public void commit() {
        this.myNFSData.commit();
        this.undoTheUpdate = false;
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.myNFSData = this.myServerProxy.getNotebookProfileDataHandle().getNFSDataHandle();
    }

    public void loadGuiPage(int n) {
        NFSDirEntry nFSDirEntry;
        if (this.myTrace) {
            System.out.println("in PgNFS1.loadGuiPage()");
        }
        if ((nFSDirEntry = this.myNFSData.getNFSDirEntry(n)).getReadHostListSize() > 0 || nFSDirEntry.getReadWriteHostListSize() > 0) {
            this.pgNFS1s.setGUIfromData(nFSDirEntry);
        } else {
            this.pgNFS1s.setEmptyList();
            this.pgNFS1s.okToAdd(true);
        }
        this.cbMakePublic.setState(nFSDirEntry.isPublic());
        this.cbSpecifyHost.setState(nFSDirEntry.isSpecifyHosts());
        this.cbReadOnly.setState(nFSDirEntry.isReadOnly());
        this.cbReadWrite.setState(nFSDirEntry.isReadWrite());
        this.prevSel = n;
        String[] stringArray = new String[3];
        stringArray[0] = nFSDirEntry.getDirectory();
        this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + stringArray[0]);
        this.originalNFSString = this.toStringNFS();
        if (this.myTrace) {
            System.out.println("PgNFS1 Original string = " + this.originalNFSString);
        }
    }

    private void saveListSelection(int n) {
        if (this.myTrace) {
            System.out.println("in PgNFS1.saveListSelection()");
        }
        String[] stringArray = this.lDir.getItem(n);
        NFSDirEntry nFSDirEntry = this.myNFSData.getNFSDirEntry(n);
        nFSDirEntry.setDirectory(stringArray[0]);
        nFSDirEntry.setAlias(stringArray[1]);
        nFSDirEntry.setComments(stringArray[2]);
        nFSDirEntry.setPublic(this.cbMakePublic.getState());
        nFSDirEntry.setSpecifyHosts(this.cbSpecifyHost.getState());
        nFSDirEntry.setReadOnly(this.cbReadOnly.getState());
        nFSDirEntry.setReadWrite(this.cbReadWrite.getState());
        this.pgNFS1s.setDataFromGUI(nFSDirEntry);
        if (this.myTrace) {
            System.out.println("PgNFS1 COMPARING Original string = " + this.originalNFSString);
            System.out.println("PgNFS1 COMPARING Current  string = " + this.toStringNFS());
        }
        if (this.myTrace) {
            System.out.println("PgNFS1 NFSData has changed!!!");
        }
        this.myNFSData.setUpdated(true);
    }

    public void setDataFromGUI() {
        if (this.myTrace) {
            System.out.println("in PgNFS1.setDataFromGUI()");
        }
        if (!this.isNoEntries(this.lDir)) {
            this.saveListSelection(this.lDir.getSelectedIndex());
        }
        if (this.myNFSData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgNFS1 NFSData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        if (this.myTrace) {
            System.out.println("in PgNFS1.setGUIfromData()");
        }
        this.lDir.removeAll();
        Button[] buttonArray = myButtonPanel.getButtons();
        buttonArray[1].setEnabled(true);
        buttonArray[2].setEnabled(true);
        buttonArray[3].setEnabled(true);
        String[] stringArray = new String[3];
        int n = this.myNFSData.getNFSDirEntryListSize();
        if (n < 1) {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            stringArray[1] = "";
            stringArray[2] = "";
            this.lDir.add(stringArray);
            this.lblPageTitle.setText(this.myBundle.getString("PF1_TITLE"));
            this.cbMakePublic.setState(false);
            this.cbSpecifyHost.setState(true);
            this.pgNFS1s.setEmptyList();
            this.pgNFS1s.okToAdd(false);
            buttonArray[1].setEnabled(false);
            buttonArray[2].setEnabled(false);
            this.hostPanel.setText(this.myBundle.getString("PSC3_HOST_LIST"));
        } else {
            NFSDirEntry nFSDirEntry;
            int n2 = 0;
            while (n2 < n) {
                nFSDirEntry = this.myNFSData.getNFSDirEntry(n2);
                stringArray[0] = nFSDirEntry.getDirectory();
                stringArray[1] = nFSDirEntry.getAlias();
                stringArray[2] = nFSDirEntry.getComments();
                this.lDir.add(stringArray);
                if (n2 == 0) {
                    this.pgNFS1s.setGUIfromData(nFSDirEntry);
                    this.cbMakePublic.setState(nFSDirEntry.isPublic());
                    this.cbSpecifyHost.setState(nFSDirEntry.isSpecifyHosts());
                    this.cbReadOnly.setState(nFSDirEntry.isReadOnly());
                    this.cbReadWrite.setState(nFSDirEntry.isReadWrite());
                }
                ++n2;
            }
            nFSDirEntry = this.myNFSData.getNFSDirEntry(0);
            String[] stringArray2 = new String[3];
            stringArray2[0] = nFSDirEntry.getDirectory();
            this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + stringArray2[0]);
        }
        this.lDir.select(0);
        this.prevSel = 0;
    }

    public boolean validatePage() {
        int n = this.lDir.getSelectedIndex();
        String[] stringArray = new String[3];
        stringArray = this.lDir.getItem(n);
        if ((!Utility.hasValue(stringArray[0]) || this.isNoEntries(this.lDir)) && this.pgNFS1s.hasEntries()) {
            this.showMessageDialog(this.myBundle.getString("PF1_DIRECTORY_REQUIRED"), this);
            return false;
        }
        if (!this.isNoEntries(this.lDir)) {
            this.saveListSelection(this.lDir.getSelectedIndex());
        } else {
            this.myNFSData.setUpdated(true);
        }
        int n2 = this.myNFSData.getNFSDirEntryListSize();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                NFSDirEntry nFSDirEntry;
                if (!(n3 == n || Utility.hasValue((nFSDirEntry = this.myNFSData.getNFSDirEntry(n3)).getDirectory()) || nFSDirEntry.getReadHostListSize() <= 0 && nFSDirEntry.getReadWriteHostListSize() <= 0)) {
                    this.lDir.select(n3);
                    this.prevSel = n3;
                    this.loadGuiPage(n3);
                    this.showMessageDialog(this.myBundle.getString("PF1_DIRECTORY_REQUIRED"), this);
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    private void doOKdlgACDadd() {
        Object[] objectArray;
        if (this.isNoEntries(this.lDir)) {
            this.lDir.remove(0);
            objectArray = myButtonPanel.getButtons();
            objectArray[1].setEnabled(true);
            ((Component)objectArray[2]).setEnabled(true);
        } else {
            this.saveListSelection(this.lDir.getSelectedIndex());
        }
        objectArray = new String[]{this.nfsDialog.getDirectory(), this.nfsDialog.getAlias(), this.nfsDialog.getComments()};
        this.lDir.add((String[])objectArray);
        this.lDir.select(this.lDir.getItemCount() - 1);
        this.prevSel = this.lDir.getItemCount() - 1;
        NFSDirEntry nFSDirEntry = new NFSDirEntry();
        nFSDirEntry.setDirectory((String)objectArray[0]);
        nFSDirEntry.setAlias((String)objectArray[1]);
        nFSDirEntry.setComments((String)objectArray[2]);
        this.cbMakePublic.setState(nFSDirEntry.isPublic());
        this.cbSpecifyHost.setState(nFSDirEntry.isSpecifyHosts());
        this.cbReadOnly.setState(nFSDirEntry.isReadOnly());
        this.cbReadWrite.setState(nFSDirEntry.isReadWrite());
        this.myNFSData.addNFSDirEntry(nFSDirEntry);
        this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + (String)objectArray[0]);
        this.pgNFS1s.setEmptyList();
        this.pgNFS1s.okToAdd(true);
        this.nfsDialog.dispose();
    }

    private void doOKdlgACDchange() {
        int n = this.lDir.getSelectedIndex();
        String[] stringArray = this.lDir.getItem(n);
        stringArray[0] = this.nfsDialog.getDirectory();
        stringArray[1] = this.nfsDialog.getAlias();
        stringArray[2] = this.nfsDialog.getComments();
        this.lDir.replaceItem(stringArray, n);
        this.lDir.select(n);
        NFSDirEntry nFSDirEntry = this.myNFSData.getNFSDirEntry(n);
        nFSDirEntry.setDirectory(stringArray[0]);
        nFSDirEntry.setAlias(stringArray[1]);
        nFSDirEntry.setComments(stringArray[2]);
        this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + stringArray[0]);
        this.nfsDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        int n = this.lDir.getSelectedIndex();
        this.lDir.remove(n);
        this.myNFSData.deleteNFSDirEntry(n);
        int n2 = this.lDir.getItemCount();
        if (n2 < 1) {
            String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES"), "", ""};
            this.cbMakePublic.setState(false);
            this.cbSpecifyHost.setState(true);
            this.cbReadOnly.setState(false);
            this.cbReadWrite.setState(false);
            this.lDir.add(stringArray);
            this.lDir.select(0);
            this.hostPanel.setText(this.myBundle.getString("PSC3_HOST_LIST"));
            Button[] buttonArray = myButtonPanel.getButtons();
            buttonArray[1].setEnabled(false);
            buttonArray[2].setEnabled(false);
            this.pgNFS1s.setEmptyList();
            this.pgNFS1s.okToAdd(false);
            return;
        }
        if (n > 0) {
            --n;
        }
        this.lDir.select(n);
        this.loadGuiPage(n);
    }

    private void populateDlgACD() {
        int n = this.lDir.getSelectedIndex();
        String[] stringArray = this.lDir.getItem(n);
        this.nfsDialog.setDirectory(stringArray[0]);
        this.nfsDialog.setAlias(stringArray[1]);
        this.nfsDialog.setComments(stringArray[2]);
    }

    private void showACDdialog(int n) {
        switch (n) {
            case 0: {
                this.nfsDialog = new DlgNFS1ACD(0, this, this.lDir);
                break;
            }
            case 1: {
                this.nfsDialog = new DlgNFS1ACD(1, this, this.lDir);
                this.populateDlgACD();
                break;
            }
            case 2: {
                this.nfsDialog = new DlgNFS1ACD(2, this, this.lDir);
                this.populateDlgACD();
                break;
            }
            default: {
                this.nfsDialog = new DlgNFS1ACD(0, this, this.lDir);
            }
        }
        this.myOwner.setEnabled(false);
        this.nfsDialog.setVisible(true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof MulColumn && object == this.lDir && this.prevSel != this.lDir.getSelectedIndex() && !this.isNoEntries(this.lDir)) {
            int n = this.lDir.getSelectedIndex();
            String[] stringArray = this.lDir.getItem(n);
            this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + stringArray[0]);
            this.saveListSelection(this.prevSel);
            this.loadGuiPage(n);
            this.prevSel = n;
            return;
        }
    }

    public void messageFinished(int n) {
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            this.handleCheckbox((Checkbox)object);
        }
    }

    public void handleCheckbox(Checkbox checkbox) {
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            if (this.isChangeDeleteOk(this.lDir, this)) {
                this.dialogCommand = 1;
                this.showACDdialog(1);
                return;
            }
        } else if (button == buttonArray[2]) {
            if (this.isChangeDeleteOk(this.lDir, this)) {
                this.dialogCommand = 2;
                this.showACDdialog(2);
                return;
            }
        } else if (button == buttonArray[3] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringNFS() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[3];
        int n = this.lDir.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.lDir.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            stringBuffer.append(String.valueOf(stringArray[1]) + " ");
            stringBuffer.append(String.valueOf(stringArray[2]) + " ");
            ++n2;
        }
        stringBuffer.append(this.pgNFS1s.toStringNFS1s());
        return stringBuffer.toString();
    }
}

