/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.LanInterface;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SetupData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class PgNetwork1
extends BasePage
implements ActionListener,
ItemListener,
MouseListener,
MessageListener {
    private boolean DHCP_Checked = false;
    private LanInterface checkedLi;
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblInterface;
    private Label lblOptions;
    private Label lblEnable;
    private Label lblIPaddress;
    private Label lblSubnetMask;
    private MulColumn lInterface;
    private Checkbox cbEnableInterface;
    private Checkbox cbUsingDHCP;
    private Checkbox cbMobile;
    private Checkbox cbUsingDDNS;
    private Checkbox cbManual;
    private CheckboxGroup cbg;
    private TextField itfIPAddress;
    private TextField tfSubnetMask;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null};
    private static final int UNDO_BUTTON = 0;
    private static final int MAX_BUTTONS_IN_ROW = 2;
    private Panel leftPanel;
    private Panel rightPanel;
    private BorderPanel configurePanel;
    private String originalSetupString = new String();
    private boolean undoTheUpdate = true;
    private SetupData mySetupData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private int prevSel = -1;
    private static final int INTERFACE_LIST_MAX_COLUMNS = 1;
    private static final String NOIP = "nil";
    private boolean myTrace = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgNetwork1(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgNetwork1.buttonLabels[0] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PN1_TITLE"));
        this.lblIPaddress = new Label(this.myBundle.getString("PN1_IP_ADDRESS"));
        this.lblSubnetMask = new Label(this.myBundle.getString("PN1_SUBNET_MASK"));
        String[] stringArray = new String[]{this.myBundle.getString("PN1_INTERFACE")};
        int[] nArray = new int[]{100};
        this.lInterface = new MulColumn(stringArray, nArray);
        this.lInterface.addMouseListener(this);
        this.cbEnableInterface = new Checkbox(this.myBundle.getString("PN1_ENABLE_INTERFACE"));
        this.cbManual = new Checkbox(this.myBundle.getString("PN1_MANUAL"));
        this.cbUsingDHCP = new Checkbox(this.myBundle.getString("PN1_AUTOMATIC_DHCP"));
        this.cbMobile = new Checkbox(this.myBundle.getString("PN1_MOBILE"));
        this.cbUsingDDNS = new Checkbox(this.myBundle.getString("PN1_AUTOMATIC_DDNS"));
        this.cbg = new CheckboxGroup();
        this.cbUsingDHCP.setCheckboxGroup(this.cbg);
        this.cbManual.setCheckboxGroup(this.cbg);
        this.cbEnableInterface.addItemListener(this);
        this.cbManual.addItemListener(this);
        this.cbUsingDHCP.addItemListener(this);
        this.cbMobile.addItemListener(this);
        this.cbUsingDDNS.addItemListener(this);
        this.cbEnableInterface.addKeyListener(this);
        this.cbManual.addKeyListener(this);
        this.cbUsingDHCP.addKeyListener(this);
        this.cbMobile.addKeyListener(this);
        this.cbUsingDDNS.addKeyListener(this);
        this.itfIPAddress = new TextField();
        this.tfSubnetMask = new TextField();
        this.leftPanel = new Panel();
        this.rightPanel = new Panel();
        this.configurePanel = new BorderPanel(this.myBundle.getString("PN1_OPTIONS"));
        this.setLayout(this.gridBag);
        this.leftPanel.setLayout(this.gridBag);
        this.rightPanel.setLayout(this.gridBag);
        this.configurePanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.leftPanel, this.lInterface, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 10, 0, 5);
        Utility.constrain(this, this.leftPanel, 0, 1, -1, 1, 1, 10, 1.0, 1.0, 10, 0, 10, 0);
        Utility.constrain(this.configurePanel, this.cbEnableInterface, 0, 0, 0, 1, 2, 13, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.configurePanel, this.cbUsingDHCP, 0, 1, 0, 1, 2, 13, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.configurePanel, this.cbMobile, 0, 2, 0, 1, 2, 13, 1.0, 1.0, 0, 50, 0, 0);
        Utility.constrain(this.configurePanel, this.cbUsingDDNS, 0, 3, 0, 1, 2, 13, 1.0, 1.0, 0, 50, 0, 0);
        Utility.constrain(this.configurePanel, this.cbManual, 0, 4, 0, 1, 2, 13, 1.0, 1.0, 0, 10, 0, 0);
        Utility.constrain(this.configurePanel, this.lblIPaddress, 0, 5, 0, 1, 2, 10, 1.0, 1.0, 0, 50, 0, 0);
        Utility.constrain(this.configurePanel, this.itfIPAddress, 0, 6, 0, 1, 2, 17, 1.0, 1.0, 0, 50, 0, 25);
        Utility.constrain(this.configurePanel, this.lblSubnetMask, 0, 7, 0, 1, 2, 10, 1.0, 1.0, 0, 50, 0, 0);
        Utility.constrain(this.configurePanel, this.tfSubnetMask, 0, 8, 0, 1, 2, 17, 1.0, 1.0, 0, 50, 0, 25);
        Utility.constrain(this.rightPanel, this.configurePanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this, this.rightPanel, 1, 1, 0, 1, 1, 10, 0.5, 1.0, 10, 0, 10, 0);
        this.addButtonGUI(0, 2, 2);
        this.refreshContainer(this.configurePanel);
    }

    private void doHelpButton() {
    }

    private void doUndoButton() {
        this.mySetupData.deCommit();
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalSetupString = this.toStringSetup();
            this.mySetupData.setUpdated(false);
        }
    }

    public void commit() {
        this.mySetupData.commit();
        this.undoTheUpdate = false;
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.mySetupData = this.myServerProxy.getNotebookProfileDataHandle().getSetupDataHandle();
    }

    private void loadGuiPage(int n) {
        LanInterface lanInterface = this.mySetupData.getLanInterface(n);
        this.mySetupData.setLanSelectedIndex(n);
        if (lanInterface.getIPaddress().compareTo(NOIP) == 0) {
            ((TextComponent)this.itfIPAddress).setText("");
        } else {
            ((TextComponent)this.itfIPAddress).setText(lanInterface.getIPaddress());
        }
        ((TextComponent)this.tfSubnetMask).setText(lanInterface.getSubnetMask());
        this.configurePanel.setText(String.valueOf(this.myBundle.getString("PN1_OPTIONS")) + lanInterface.getInterfaceName());
        this.cbManual.setState(true);
        this.cbUsingDHCP.setState(false);
        this.lblIPaddress.setEnabled(true);
        this.lblSubnetMask.setEnabled(true);
        this.itfIPAddress.setEnabled(true);
        this.tfSubnetMask.setEnabled(true);
        this.cbUsingDDNS.setEnabled(false);
        this.cbMobile.setEnabled(false);
        if (this.DHCP_Checked) {
            if (lanInterface == this.checkedLi) {
                this.cbUsingDHCP.setEnabled(true);
                this.cbUsingDDNS.setEnabled(true);
                this.cbMobile.setEnabled(true);
                this.cbUsingDHCP.setState(true);
                this.cbManual.setState(false);
            } else {
                this.cbUsingDHCP.setEnabled(false);
                this.cbMobile.setEnabled(false);
                this.cbUsingDDNS.setEnabled(false);
                this.cbManual.setEnabled(true);
                this.cbManual.setState(true);
            }
        } else {
            this.cbUsingDHCP.setState(false);
            this.cbUsingDHCP.setEnabled(true);
        }
        if (lanInterface.isEnabled()) {
            this.cbEnableInterface.setState(true);
        } else {
            this.cbEnableInterface.setState(false);
        }
        if (lanInterface.isUsingDHCP()) {
            this.cbUsingDHCP.setState(true);
            this.cbManual.setState(false);
            this.lblIPaddress.setEnabled(false);
            this.lblSubnetMask.setEnabled(false);
            this.itfIPAddress.setEnabled(false);
            this.tfSubnetMask.setEnabled(false);
            this.cbUsingDDNS.setEnabled(true);
            this.cbMobile.setEnabled(true);
        }
        if (lanInterface.isUsingDDNS()) {
            this.cbUsingDDNS.setState(true);
        } else {
            this.cbUsingDDNS.setState(false);
        }
        if (lanInterface.isMobile()) {
            this.cbMobile.setState(true);
        } else {
            this.cbMobile.setState(false);
        }
        if (lanInterface.getInterfaceName().compareTo(Cfg2Defines.LOOPBACK_tag) == 0) {
            this.cbEnableInterface.setState(true);
            this.cbEnableInterface.setEnabled(false);
            this.tfSubnetMask.setEnabled(true);
            this.cbUsingDHCP.setEnabled(false);
            this.cbMobile.setEnabled(false);
            this.cbUsingDDNS.setEnabled(false);
            this.configurePanel.setText(String.valueOf(this.myBundle.getString("PN1_OPTIONS")) + Cfg2Defines.LOOPBACK_tag);
        } else {
            this.cbEnableInterface.setEnabled(true);
        }
        this.refreshContainer(this.configurePanel);
        this.originalSetupString = this.toStringSetup();
        if (this.myTrace) {
            System.out.println("PgNetwork1 Original string = " + this.originalSetupString);
        }
    }

    private void saveListSelection(int n) {
        this.lInterface.getItem(n);
        LanInterface lanInterface = this.mySetupData.getLanInterface(n);
        lanInterface.setEnabled(this.cbEnableInterface.getState());
        lanInterface.setUsingDHCP(this.cbUsingDHCP.getState());
        lanInterface.setUsingDDNS(this.cbUsingDDNS.getState());
        lanInterface.setMobile(this.cbMobile.getState());
        lanInterface.setUsingDDNS(this.cbUsingDDNS.getState());
        lanInterface.setManual(this.cbManual.getState());
        if (!Utility.hasValue(this.itfIPAddress.getText())) {
            lanInterface.setIPaddress(NOIP);
        } else {
            lanInterface.setIPaddress(this.itfIPAddress.getText());
        }
        lanInterface.setSubnetMask(this.tfSubnetMask.getText());
        if (this.myTrace) {
            System.out.println("PgNetwork1 COMPARING Original string = " + this.originalSetupString);
            System.out.println("PgNetwork1 COMPARING Current  string = " + this.toStringSetup());
        }
        if (this.originalSetupString.compareTo(this.toStringSetup()) != 0) {
            if (this.myTrace) {
                System.out.println("PgNetwork1 SetupData has changed!!!");
            }
            this.mySetupData.setUpdated(true);
            return;
        }
        if (this.myTrace) {
            System.out.println("PgNetwork1 SetupData has NOT changed!!!");
        }
    }

    private void saveListSelection() {
        int n = this.lInterface.getSelectedIndex();
        this.saveListSelection(n);
    }

    public void setDataFromGUI() {
        this.saveListSelection();
        if (this.mySetupData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgNetwork1 SetupData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
        this.originalSetupString = null;
    }

    public void setGUIfromData() {
        this.DHCP_Checked = false;
        this.lInterface.removeAll();
        int n = this.mySetupData.getLanInterfaceListSize();
        String[] stringArray = new String[1];
        if (n == 0) {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            this.lInterface.add(stringArray);
        } else {
            int n2 = 0;
            while (n2 < n) {
                LanInterface lanInterface = this.mySetupData.getLanInterface(n2);
                boolean bl = lanInterface.isUsingDHCP();
                if (bl && !this.DHCP_Checked) {
                    this.DHCP_Checked = true;
                    this.checkedLi = lanInterface;
                }
                stringArray[0] = lanInterface.getInterfaceName();
                this.lInterface.add(stringArray);
                ++n2;
            }
            this.loadGuiPage(this.mySetupData.getLanSelectedIndex());
        }
        this.lInterface.select(this.mySetupData.getLanSelectedIndex());
        this.prevSel = this.mySetupData.getLanSelectedIndex();
    }

    public boolean validatePage() {
        String[] stringArray;
        int n = this.lInterface.getItemCount();
        LanInterface lanInterface = null;
        String string = null;
        this.saveListSelection(this.lInterface.getSelectedIndex());
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            lanInterface = this.mySetupData.getLanInterface(n2);
            if (lanInterface.isEnabled()) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            this.showMessageDialog(this.myBundle.getString("PN1_INTERFACE_NOT_ENABLED"), this);
            return false;
        }
        if (this.cbEnableInterface.getState() && this.cbManual.getState()) {
            stringArray = this.lInterface.getSelectedItem();
            if (!Utility.hasValue(this.itfIPAddress.getText())) {
                if (stringArray[0].compareTo(Cfg2Defines.LOOPBACK_tag) != 0) {
                    this.showMessageDialog(this.myBundle.getString("PN1_MANUAL_IP_REQ"), this);
                    return false;
                }
                Object[] objectArray = new Object[]{this.myBundle.getString("PN1_IP_ADDRESS")};
                string = MessageFormat.format(this.myBundle.getString("IP_INVALID_SUB"), objectArray);
                this.showMessageDialog(string, this);
                return false;
            }
            if (!Utility.hasValue(this.tfSubnetMask.getText()) && stringArray[0].compareTo(Cfg2Defines.LOOPBACK_tag) != 0) {
                this.showMessageDialog(this.myBundle.getString("PN1_MANUAL_IP_REQ"), this);
                return false;
            }
        }
        if (this.cbEnableInterface.getState() && this.cbManual.getState()) {
            if (!TcpipValidation.IsValidTcpipAddr((String)this.itfIPAddress.getText())) {
                this.showMessageDialog(this.myBundle.getString("IP_INVALID"), this);
                return false;
            }
            stringArray = this.lInterface.getSelectedItem();
            if (!TcpipValidation.IsValidTcpipAddr((String)this.tfSubnetMask.getText()) && stringArray[0].compareTo(Cfg2Defines.LOOPBACK_tag) != 0) {
                this.showMessageDialog(this.myBundle.getString("SUBNET_INVALID"), this);
                return false;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            lanInterface = this.mySetupData.getLanInterface(n3);
            if (lanInterface.isManual() && lanInterface.isEnabled()) {
                if (!TcpipValidation.IsValidTcpipAddr((String)lanInterface.getIPaddress())) {
                    this.lInterface.select(n3);
                    this.prevSel = n3;
                    this.loadGuiPage(n3);
                    if (lanInterface.getInterfaceName().compareTo(Cfg2Defines.LOOPBACK_tag) != 0) {
                        this.showMessageDialog(this.myBundle.getString("PN1_MANUAL_IP_REQ"), this);
                        return false;
                    }
                    Object[] objectArray = new Object[]{this.myBundle.getString("PN1_IP_ADDRESS")};
                    string = MessageFormat.format(this.myBundle.getString("IP_INVALID_SUB"), objectArray);
                    this.showMessageDialog(string, this);
                    return false;
                }
                if (lanInterface.getInterfaceName().compareTo(Cfg2Defines.LOOPBACK_tag) != 0 && !TcpipValidation.IsValidTcpipAddr((String)lanInterface.getSubnetMask())) {
                    this.lInterface.select(n3);
                    this.prevSel = n3;
                    this.loadGuiPage(n3);
                    this.showMessageDialog(this.myBundle.getString("PN1_MANUAL_IP_REQ"), this);
                    return false;
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            lanInterface = this.mySetupData.getLanInterface(n4);
            if (lanInterface.isManual() && lanInterface.isEnabled()) {
                if (!Utility.hasValue(lanInterface.getIPaddress())) {
                    this.prevSel = n4;
                    this.lInterface.select(n4);
                    this.loadGuiPage(n4);
                    if (lanInterface.getInterfaceName().compareTo(Cfg2Defines.LOOPBACK_tag) != 0) {
                        this.showMessageDialog(this.myBundle.getString("PN1_MANUAL_IP_REQ"), this);
                        return false;
                    }
                    Object[] objectArray = new Object[]{this.myBundle.getString("PN1_IP_ADDRESS")};
                    string = MessageFormat.format(this.myBundle.getString("IP_INVALID_SUB"), objectArray);
                    this.showMessageDialog(string, this);
                    return false;
                }
                if (lanInterface.getInterfaceName().compareTo(Cfg2Defines.LOOPBACK_tag) != 0 && !Utility.hasValue(lanInterface.getSubnetMask())) {
                    this.prevSel = n4;
                    this.lInterface.select(n4);
                    this.loadGuiPage(n4);
                    this.showMessageDialog(this.myBundle.getString("PN1_MANUAL_IP_REQ"), this);
                    return false;
                }
            }
            ++n4;
        }
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            this.handleCheckbox((Checkbox)object);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof MulColumn && object == this.lInterface && this.prevSel != this.lInterface.getSelectedIndex() && !this.isNoEntries(this.lInterface)) {
            this.saveListSelection(this.prevSel);
            this.loadGuiPage(this.lInterface.getSelectedIndex());
            this.prevSel = this.lInterface.getSelectedIndex();
            return;
        }
    }

    public void messageFinished(int n) {
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleCheckbox(Checkbox checkbox) {
        if (checkbox == this.cbUsingDHCP) {
            this.DHCP_Checked = true;
            this.checkedLi = this.mySetupData.getLanInterface(this.lInterface.getSelectedIndex());
            this.lblIPaddress.setEnabled(false);
            this.lblSubnetMask.setEnabled(false);
            this.itfIPAddress.setEnabled(false);
            this.tfSubnetMask.setEnabled(false);
            this.cbUsingDDNS.setEnabled(true);
            this.cbMobile.setEnabled(true);
        } else if (checkbox == this.cbManual) {
            if (this.DHCP_Checked && this.checkedLi == this.mySetupData.getLanInterface(this.lInterface.getSelectedIndex())) {
                this.DHCP_Checked = false;
                this.checkedLi = null;
                this.cbUsingDHCP.setEnabled(true);
                this.cbUsingDDNS.setEnabled(true);
                this.cbMobile.setEnabled(true);
            }
            this.lblIPaddress.setEnabled(true);
            this.lblSubnetMask.setEnabled(true);
            this.itfIPAddress.setEnabled(true);
            this.tfSubnetMask.setEnabled(true);
            this.cbUsingDDNS.setEnabled(false);
            this.cbMobile.setEnabled(false);
            this.lblIPaddress.setEnabled(true);
            this.lblSubnetMask.setEnabled(true);
        }
        if (checkbox == this.cbManual && this.cbManual.getState()) {
            this.itfIPAddress.setEnabled(true);
            this.tfSubnetMask.setEnabled(true);
        }
        this.refreshContainer(this.configurePanel);
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringSetup() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cbEnableInterface.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbUsingDHCP.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbMobile.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbUsingDDNS.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        if (this.cbManual.getState()) {
            stringBuffer.append("t ");
        } else {
            stringBuffer.append("f ");
        }
        stringBuffer.append(String.valueOf(this.itfIPAddress.getText()) + " ");
        stringBuffer.append(this.tfSubnetMask.getText());
        return stringBuffer.toString();
    }
}

