/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Validation;
import COM.ibm.raleigh.tcp.tcpcfg2.common.LanInterface;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookProfile;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SetupData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class PgNetwork2
extends BasePage
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblBroadcastAddress;
    private Label lblDestinationAddress;
    private Label lblMetricCount;
    private Label lblMTU;
    private TextField itfBroadcastAddress;
    private TextField itfDestinationAddress;
    private TextField ntfMetricCount;
    private TextField ntfMTU;
    private Panel centerPanel;
    private Panel leftPanel;
    private Panel rightPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null};
    public static final int UNDO_BUTTON = 0;
    public static final int MAX_BUTTONS_IN_ROW = 2;
    public static final int DUMMY_METRIC = 0;
    public static final int DUMMY_MTU = 0;
    public static final String DUMMY_METRIC_C = "0";
    public static final String DUMMY_MTU_C = "0";
    private String originalSetupString = new String();
    private boolean undoTheUpdate = true;
    private NotebookProfile myNotebookProfile;
    private SetupData mySetupData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgNetwork2(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgNetwork2.buttonLabels[0] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(String.valueOf(this.myBundle.getString("PN2_TITLE")) + " -                                  ");
        this.lblBroadcastAddress = new Label(this.myBundle.getString("PN2_BROADCAST"));
        this.lblDestinationAddress = new Label(this.myBundle.getString("PN2_DESTINATION"));
        this.lblMetricCount = new Label(this.myBundle.getString("PN2_METRIC"));
        this.lblMTU = new Label(this.myBundle.getString("PN2_MTU"));
        this.itfBroadcastAddress = new TextField();
        this.itfDestinationAddress = new TextField();
        this.ntfMetricCount = new TextField();
        this.ntfMTU = new TextField();
        this.centerPanel = new Panel();
        this.leftPanel = new Panel();
        this.rightPanel = new Panel();
        this.setLayout(this.gridBag);
        this.centerPanel.setLayout(this.gridBag);
        this.leftPanel.setLayout(this.gridBag);
        this.rightPanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.leftPanel, this.lblBroadcastAddress, 0, 0, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.leftPanel, this.lblDestinationAddress, 0, 1, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.leftPanel, this.lblMetricCount, 0, 2, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.leftPanel, this.lblMTU, 0, 3, 0, 1, 2, 13, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this.rightPanel, this.itfBroadcastAddress, 1, 0, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.rightPanel, this.itfDestinationAddress, 1, 1, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.rightPanel, this.ntfMetricCount, 1, 2, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.rightPanel, this.ntfMTU, 1, 3, 0, 1, 2, 17, 1.0, 1.0, 0, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.leftPanel, 0, 1, -1, 1, 1, 10, 1.0, 1.0, 0, 20, 0, 0);
        Utility.constrain(this.centerPanel, this.rightPanel, 1, 1, 0, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 2, 2);
    }

    private void doHelpButton() {
    }

    private void doUndoButton() {
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalSetupString = this.toStringSetup();
            this.mySetupData.setUpdated(false);
        }
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.mySetupData = this.myServerProxy.getNotebookProfileDataHandle().getSetupDataHandle();
    }

    public void setDataFromGUI() {
        Integer n;
        LanInterface lanInterface = this.mySetupData.getLanInterface(this.mySetupData.getLanSelectedIndex());
        lanInterface.setBroadcastAddr(this.itfBroadcastAddress.getText());
        lanInterface.setDestinationAddr(this.itfDestinationAddress.getText());
        lanInterface.setBroadcastAddr(this.itfBroadcastAddress.getText());
        if (!Utility.isEmptyTextField(this.ntfMetricCount)) {
            n = new Integer(this.ntfMetricCount.getText());
            lanInterface.setMetric(n);
        }
        if (!Utility.isEmptyTextField(this.ntfMTU)) {
            n = new Integer(this.ntfMTU.getText());
            lanInterface.setMTU(n);
        }
        if (this.myTrace) {
            System.out.println("PgNetwork2 COMPARING Original string = " + this.originalSetupString);
            System.out.println("PgNetwork2 COMPARING Current  string = " + this.toStringSetup());
        }
        if (this.originalSetupString.compareTo(this.toStringSetup()) != 0) {
            if (this.myTrace) {
                System.out.println("PgNetwork2 SetupData has changed!!!");
            }
            this.mySetupData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgNetwork2 SetupData has NOT changed!!!");
        }
        this.originalSetupString = null;
        if (this.mySetupData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgNetwork2 SetupData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        this.itfDestinationAddress.setEnabled(true);
        this.lblDestinationAddress.setEnabled(true);
        this.itfBroadcastAddress.setEnabled(true);
        this.lblBroadcastAddress.setEnabled(true);
        this.lblMetricCount.setEnabled(true);
        this.ntfMetricCount.setEnabled(true);
        this.lblMTU.setEnabled(true);
        this.ntfMTU.setEnabled(true);
        LanInterface lanInterface = this.mySetupData.getLanInterface(this.mySetupData.getLanSelectedIndex());
        ((TextComponent)this.itfBroadcastAddress).setText(lanInterface.getBroadcastAddr());
        ((TextComponent)this.itfDestinationAddress).setText(lanInterface.getDestinationAddr());
        Integer n = new Integer(lanInterface.getMetric());
        ((TextComponent)this.ntfMetricCount).setText(n.toString());
        Integer n2 = new Integer(lanInterface.getMTU());
        ((TextComponent)this.ntfMTU).setText(n2.toString());
        if (lanInterface.isUsingDHCP()) {
            this.itfDestinationAddress.setEnabled(false);
            this.lblDestinationAddress.setEnabled(false);
            this.itfBroadcastAddress.setEnabled(false);
            this.lblBroadcastAddress.setEnabled(false);
        } else {
            this.itfDestinationAddress.setEnabled(true);
            this.lblDestinationAddress.setEnabled(true);
            this.itfBroadcastAddress.setEnabled(true);
            this.lblBroadcastAddress.setEnabled(true);
        }
        String string = lanInterface.getInterfaceName();
        this.lblPageTitle.setText(String.valueOf(this.myBundle.getString("PN2_TITLE")) + " - " + string);
        if (string.compareTo(Cfg2Defines.LOOPBACK_tag) == 0) {
            this.itfDestinationAddress.setEnabled(false);
            this.lblDestinationAddress.setEnabled(false);
            this.itfBroadcastAddress.setEnabled(false);
            this.lblBroadcastAddress.setEnabled(false);
            this.lblMetricCount.setEnabled(false);
            this.ntfMetricCount.setEnabled(false);
            this.lblMTU.setEnabled(false);
            this.ntfMTU.setEnabled(false);
        }
        this.leftPanel.invalidate();
        this.leftPanel.getParent().validate();
        this.leftPanel.repaint();
        this.originalSetupString = this.toStringSetup();
        if (this.myTrace) {
            System.out.println("PgNetwork2 Original string = " + this.originalSetupString);
        }
        if (this.mySetupData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        Integer n;
        String string = null;
        if (!Utility.isEmptyTextField(this.itfBroadcastAddress) && !TcpipValidation.IsValidTcpipAddr((String)this.itfBroadcastAddress.getText())) {
            Object[] objectArray = new Object[]{this.lblBroadcastAddress.getText()};
            string = MessageFormat.format(this.myBundle.getString("IP_INVALID_SUB"), objectArray);
            this.showMessageDialog(string, this);
            return false;
        }
        if (!Utility.isEmptyTextField(this.itfDestinationAddress) && !TcpipValidation.IsValidTcpipAddr((String)this.itfDestinationAddress.getText())) {
            Object[] objectArray = new Object[]{this.lblDestinationAddress.getText()};
            string = MessageFormat.format(this.myBundle.getString("IP_INVALID_SUB"), objectArray);
            this.showMessageDialog(string, this);
            return false;
        }
        if (Utility.isEmptyTextField(this.ntfMetricCount)) {
            this.showMessageDialog(this.myBundle.getString("PN2_INVALID_METRIC_COUNT"), this);
            return false;
        }
        if (Utility.isEmptyTextField(this.ntfMTU)) {
            this.showMessageDialog(this.myBundle.getString("PN2_INVALID_MTU"), this);
            return false;
        }
        if (!Utility.isEmptyTextField(this.ntfMetricCount)) {
            if (!Cfg2Validation.IsValidNumeric(this.ntfMetricCount.getText())) {
                this.showMessageDialog(this.myBundle.getString("PN2_INVALID_METRIC_COUNT"), this);
                return false;
            }
            n = new Integer(this.ntfMetricCount.getText());
            if (n < 1 || n > 15) {
                this.showMessageDialog(this.myBundle.getString("PN2_INVALID_METRIC_COUNT"), this);
                return false;
            }
        }
        if (!Utility.isEmptyTextField(this.ntfMTU)) {
            if (!Cfg2Validation.IsValidNumeric(this.ntfMTU.getText())) {
                this.showMessageDialog(this.myBundle.getString("PN2_INVALID_MTU"), this);
                return false;
            }
            n = new Integer(this.ntfMTU.getText());
            if (n < 0 || n > 99999) {
                this.showMessageDialog(this.myBundle.getString("PN2_INVALID_MTU"), this);
                return false;
            }
        }
        return true;
    }

    public void messageFinished(int n) {
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringSetup() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.itfBroadcastAddress.getText()) + " ");
        stringBuffer.append(String.valueOf(this.itfDestinationAddress.getText()) + " ");
        stringBuffer.append(String.valueOf(this.ntfMetricCount.getText()) + " ");
        stringBuffer.append(this.ntfMTU.getText());
        return stringBuffer.toString();
    }
}

