/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.BorderPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgSecurity3ACD;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.client.PgSecurity3s;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TftpEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;

public class PgSecurity3
extends BasePage
implements ActionListener,
DialogListener,
MessageListener,
MouseListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private PgSecurity3s pgSecurity3s;
    private MulColumn lTFTP;
    private Panel tftpPanel;
    private BorderPanel hostPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private int dialogCommand = -1;
    private String originalUserString = new String();
    private boolean undoTheUpdate = true;
    private UserEntry myUserEntry;
    private UserData myUserData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private static final int TFTP_LIST_MAX_COLUMNS = 2;
    private DlgSecurity3ACD tftpDialog;
    int prevSel = -1;
    private boolean myTrace = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgSecurity3(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgSecurity3.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgSecurity3.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgSecurity3.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgSecurity3.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PSC3_TITLE"));
        this.pgSecurity3s = new PgSecurity3s(this.myOwner);
        this.hostPanel = new BorderPanel(this.myBundle.getString("PSC3_HOST_LIST"));
        this.hostPanel.setLayout(this.gridBag);
        this.tftpPanel = new Panel();
        this.tftpPanel.setLayout(this.gridBag);
        String[] stringArray = new String[]{this.myBundle.getString("PSC3_ACCESS"), this.myBundle.getString("PSC3_DIRECTORY")};
        int[] nArray = new int[]{20, 80};
        this.lTFTP = new MulColumn(stringArray, nArray);
        this.lTFTP.addMouseListener(this);
        this.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.tftpPanel, this.lTFTP, 0, 0, -1, 1, 1, 10, 1.0, 1.0, 0, 5, 0, 5);
        Utility.constrain(this.hostPanel, this.pgSecurity3s, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 0, 5, 0, 5);
        Utility.constrain(this, this.tftpPanel, 0, 1, -1, 1, 1, 10, 3.0, 1.0, 0, 0, 0, 0);
        Utility.constrain(this, this.hostPanel, 1, 1, 0, 1, 1, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.addButtonGUI(0, 2, 5);
    }

    private void doUndoButton() {
        this.myUserData.deCommit(0);
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalUserString = this.toStringUser();
            this.myUserData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    public void commit() {
        this.myUserData.commit(0);
        this.undoTheUpdate = false;
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.myUserData = this.myServerProxy.getNotebookProfileDataHandle().getUserDataHandle();
        if (this.myUserData.getUserEntryListSize() > 0) {
            int n = this.myUserData.getUserSelectedIndex();
            this.myUserEntry = this.myUserData.getUserEntry(n);
        }
    }

    public void loadGuiPage(int n) {
        TftpEntry tftpEntry;
        if (this.myTrace) {
            System.out.println("in PgSecurity3.loadGuiPage()");
        }
        if ((tftpEntry = this.myUserData.getTftpEntry(n)).getHostListSize() > 0) {
            this.pgSecurity3s.setGUIfromData(tftpEntry);
        } else {
            this.pgSecurity3s.setEmptyList();
            this.pgSecurity3s.okToAdd(true);
        }
        this.prevSel = n;
        String[] stringArray = new String[2];
        stringArray[0] = tftpEntry.getDirectory();
        this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + stringArray[0]);
        this.originalUserString = this.toStringUser();
        if (this.myTrace) {
            System.out.println("PgSecurity3 Original string = " + this.originalUserString);
        }
    }

    private void saveListSelection(int n) {
        if (this.myTrace) {
            System.out.println("in PgSecurity3.saveListSelection()");
        }
        String[] stringArray = this.lTFTP.getItem(n);
        TftpEntry tftpEntry = this.myUserData.getTftpEntry(n);
        if (stringArray[0].compareTo(this.myBundle.getString("GLO_READ_WRITE")) == 0) {
            tftpEntry.setDirAccess(this.myBundle.getString("GLO_READ_WRITE"));
        } else {
            tftpEntry.setDirAccess(this.myBundle.getString("GLO_READ_ONLY"));
        }
        tftpEntry.setDirectory(stringArray[1]);
        this.pgSecurity3s.setDataFromGUI(tftpEntry);
        if (this.myTrace) {
            System.out.println("PgSecurity3 COMPARING Original string = " + this.originalUserString);
            System.out.println("PgSecurity3 COMPARING Current  string = " + this.toStringUser());
        }
        if (this.originalUserString.compareTo(this.toStringUser()) != 0) {
            if (this.myTrace) {
                System.out.println("PgSecurity3 UserData has changed!!!");
            }
            this.myUserData.setUpdated(true);
            return;
        }
        if (this.myTrace) {
            System.out.println("PgSecurity3 UserData has NOT changed!!!");
        }
    }

    public void setDataFromGUI() {
        if (this.myTrace) {
            System.out.println("in PgSecurity3.setDataFromGUI()");
        }
        if (!this.isNoEntries(this.lTFTP, 1)) {
            this.saveListSelection(this.lTFTP.getSelectedIndex());
        }
        if (this.myUserData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgSecurity3 UserData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        if (this.myTrace) {
            System.out.println("in PgSecurity3.setGUIfromData()");
        }
        this.lTFTP.removeAll();
        Button[] buttonArray = myButtonPanel.getButtons();
        buttonArray[1].setEnabled(true);
        buttonArray[2].setEnabled(true);
        String[] stringArray = new String[2];
        int n = this.myUserData.getTftpEntryListSize();
        if (n < 1) {
            stringArray[0] = "";
            stringArray[1] = this.myBundle.getString("GLO_NO_ENTRIES");
            this.lTFTP.add(stringArray);
            this.lblPageTitle.setText(this.myBundle.getString("PSC3_TITLE"));
            this.pgSecurity3s.setEmptyList();
            buttonArray[1].setEnabled(false);
            buttonArray[2].setEnabled(false);
            this.hostPanel.setText(this.myBundle.getString("PSC3_HOST_LIST"));
        } else {
            TftpEntry tftpEntry;
            int n2 = 0;
            while (n2 < n) {
                tftpEntry = this.myUserData.getTftpEntry(n2);
                stringArray[0] = tftpEntry.getDirAccess();
                stringArray[1] = tftpEntry.getDirectory();
                this.lTFTP.add(stringArray);
                if (n2 == 0) {
                    this.pgSecurity3s.setGUIfromData(tftpEntry);
                }
                ++n2;
            }
            tftpEntry = this.myUserData.getTftpEntry(0);
            String[] stringArray2 = new String[2];
            stringArray2[0] = tftpEntry.getDirectory();
            this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + stringArray2[0]);
        }
        this.lTFTP.select(0);
        this.prevSel = 0;
    }

    public boolean validatePage() {
        if (!this.isNoEntries(this.lTFTP, 1) && this.pgSecurity3s.isEmptyList()) {
            this.showMessageDialog(this.myBundle.getString("PSC3_HOST_NAME_REQUIRED"), this);
            return false;
        }
        if (!this.isNoEntries(this.lTFTP, 1)) {
            this.setDataFromGUI();
            int n = this.myUserData.getTftpEntryListSize();
            int n2 = 0;
            while (n2 < n) {
                if (this.myUserData.getTftpEntry(n2).getHostListSize() == 0) {
                    this.loadGuiPage(n2);
                    this.lTFTP.select(n2);
                    this.showMessageDialog(this.myBundle.getString("PSC3_HOST_NAME_REQUIRED"), this);
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private void doOKdlgACDadd() {
        Object[] objectArray;
        if (this.isNoEntries(this.lTFTP, 1)) {
            this.lTFTP.remove(0);
            objectArray = myButtonPanel.getButtons();
            objectArray[1].setEnabled(true);
            ((Component)objectArray[2]).setEnabled(true);
        } else {
            this.saveListSelection(this.lTFTP.getSelectedIndex());
        }
        objectArray = new String[2];
        objectArray[1] = this.tftpDialog.getDirectory();
        objectArray[0] = this.tftpDialog.isReadWrite() ? this.myBundle.getString("GLO_READ_WRITE") : this.myBundle.getString("GLO_READ_ONLY");
        this.lTFTP.add((String[])objectArray);
        this.lTFTP.select(this.lTFTP.getItemCount() - 1);
        this.prevSel = this.lTFTP.getItemCount() - 1;
        this.myUserData.setTftpSelectedIndex(this.lTFTP.getItemCount() - 1);
        TftpEntry tftpEntry = new TftpEntry();
        tftpEntry.setDirectory((String)objectArray[1]);
        if (this.tftpDialog.isReadWrite()) {
            tftpEntry.setDirAccess(this.myBundle.getString("GLO_READ_WRITE"));
        } else {
            tftpEntry.setDirAccess(this.myBundle.getString("GLO_READ_ONLY"));
        }
        this.myUserData.addTftpEntry(tftpEntry);
        this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + (String)objectArray[1]);
        this.pgSecurity3s.setEmptyList();
        this.pgSecurity3s.okToAdd(true);
        this.tftpDialog.dispose();
    }

    private void doOKdlgACDchange() {
        int n = this.lTFTP.getSelectedIndex();
        String[] stringArray = this.lTFTP.getItem(n);
        stringArray[1] = this.tftpDialog.getDirectory();
        stringArray[0] = this.tftpDialog.isReadWrite() ? this.myBundle.getString("GLO_READ_WRITE") : this.myBundle.getString("GLO_READ_ONLY");
        this.lTFTP.replaceItem(stringArray, n);
        this.lTFTP.select(n);
        this.myUserData.setTftpSelectedIndex(n);
        TftpEntry tftpEntry = this.myUserData.getTftpEntry(n);
        tftpEntry.setDirectory(stringArray[1]);
        if (this.tftpDialog.isReadWrite()) {
            tftpEntry.setDirAccess(this.myBundle.getString("GLO_READ_WRITE"));
        } else {
            tftpEntry.setDirAccess(this.myBundle.getString("GLO_READ_ONLY"));
        }
        this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + stringArray[1]);
        this.tftpDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        int n = this.lTFTP.getSelectedIndex();
        this.lTFTP.remove(n);
        this.myUserData.deleteTftpEntry(n);
        int n2 = this.lTFTP.getItemCount();
        if (n2 < 1) {
            String[] stringArray = new String[]{"", this.myBundle.getString("GLO_NO_ENTRIES")};
            this.lTFTP.add(stringArray);
            this.lTFTP.select(0);
            this.pgSecurity3s.okToAdd(false);
            this.hostPanel.setText(this.myBundle.getString("PSC3_HOST_LIST"));
            Button[] buttonArray = myButtonPanel.getButtons();
            buttonArray[1].setEnabled(false);
            buttonArray[2].setEnabled(false);
            this.pgSecurity3s.setEmptyList();
            return;
        }
        if (n > 0) {
            --n;
        }
        this.lTFTP.select(n);
        this.loadGuiPage(n);
    }

    private void populateDlgACD() {
        int n = this.lTFTP.getSelectedIndex();
        String[] stringArray = this.lTFTP.getItem(n);
        this.tftpDialog.setDirectory(stringArray[1]);
        if (stringArray[0].compareTo(this.myBundle.getString("GLO_READ_WRITE")) == 0) {
            this.tftpDialog.setReadWrite(true);
            return;
        }
        this.tftpDialog.setReadWrite(false);
    }

    private void showACDdialog(int n) {
        switch (n) {
            case 0: {
                this.tftpDialog = new DlgSecurity3ACD(0, this, this.lTFTP);
                break;
            }
            case 1: {
                this.tftpDialog = new DlgSecurity3ACD(1, this, this.lTFTP);
                this.populateDlgACD();
                break;
            }
            case 2: {
                this.tftpDialog = new DlgSecurity3ACD(2, this, this.lTFTP);
                this.populateDlgACD();
                break;
            }
            default: {
                this.tftpDialog = new DlgSecurity3ACD(0, this, this.lTFTP);
            }
        }
        this.myOwner.setEnabled(false);
        this.tftpDialog.setVisible(true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof MulColumn && object == this.lTFTP && this.prevSel != this.lTFTP.getSelectedIndex() && !this.isNoEntries(this.lTFTP)) {
            int n = this.lTFTP.getSelectedIndex();
            this.myUserData.setTftpSelectedIndex(n);
            String[] stringArray = this.lTFTP.getItem(n);
            this.hostPanel.setText(String.valueOf(this.myBundle.getString("PSC3_HOST_LIST_FOR")) + stringArray[1]);
            this.saveListSelection(this.prevSel);
            this.loadGuiPage(n);
            this.prevSel = n;
            return;
        }
    }

    public void messageFinished(int n) {
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            if (this.isChangeDeleteOk(this.lTFTP, this)) {
                this.dialogCommand = 1;
                this.showACDdialog(1);
                return;
            }
        } else if (button == buttonArray[2]) {
            if (this.isChangeDeleteOk(this.lTFTP, this)) {
                this.dialogCommand = 2;
                this.showACDdialog(2);
                return;
            }
        } else if (button == buttonArray[3] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringUser() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[2];
        int n = this.lTFTP.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.lTFTP.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            stringBuffer.append(String.valueOf(stringArray[1]) + " ");
            ++n2;
        }
        stringBuffer.append(this.pgSecurity3s.toStringUser());
        return stringBuffer.toString();
    }
}

