/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Authorize;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcpauth.client_admin_auth;
import java.awt.Button;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgSecurity4
extends BasePage
implements ActionListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private Label lblPassword;
    private Label lblVerifyPW;
    private TextField tfPassword;
    private TextField tfVerifyPW;
    private Panel centerPanel;
    private static ButtonPanel myButtonPanel = null;
    private static final String[] buttonLabels = new String[]{null};
    private static final int UNDO_BUTTON = 0;
    private static final int MAX_BUTTONS_IN_ROW = 2;
    private UserData myUserData;
    private Authorize myAuthorize;
    private BaseProxy myServerProxy;
    private client_admin_auth myClientAuth;
    GridBagLayout gridBag = new GridBagLayout();
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgSecurity4(Notebook notebook) {
        this.myOwner = notebook;
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgSecurity4.buttonLabels[0] = this.myBundle.getString("GLO_UNDO");
        myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PSC4_TITLE"));
        this.lblPassword = new Label(this.myBundle.getString("PSC4_PASSWORD"));
        this.lblVerifyPW = new Label(this.myBundle.getString("DSC1_VERIFY_PW"));
        this.tfPassword = new TextField();
        this.tfPassword.setEchoChar('*');
        this.tfVerifyPW = new TextField();
        this.tfVerifyPW.setEchoChar('*');
        this.setLayout(this.gridBag);
        this.centerPanel = new Panel();
        this.centerPanel.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.centerPanel, this.lblPassword, 0, 1, -1, 1, 2, 17, 1.0, 1.0, 20, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.tfPassword, 1, 1, 0, 1, 2, 17, 1.0, 1.0, 20, 0, 0, 10);
        Utility.constrain(this.centerPanel, this.lblVerifyPW, 0, 2, -1, 1, 2, 17, 1.0, 1.0, 20, 10, 0, 0);
        Utility.constrain(this.centerPanel, this.tfVerifyPW, 1, 2, 0, 1, 2, 17, 1.0, 1.0, 20, 0, 0, 10);
        Utility.constrain(this, this.centerPanel, 0, 1, 0, 1, 2, 10, 1.0, 1.0, 10, 20, 0, 0);
        this.addButtonGUI(0, 2, 2);
    }

    private void doHelpButton() {
    }

    private void doUndoButton() {
        this.myAuthorize.setUpdated(false);
        this.myAuthorize.setPassword(null, null);
        this.setGUIfromData();
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.myUserData = this.myServerProxy.getNotebookProfileDataHandle().getUserDataHandle();
        this.myAuthorize = this.myServerProxy.getNotebookProfileDataHandle().getAuthorizeHandle();
    }

    public void setDataFromGUI() {
        if (this.myAuthorize.isUpdated()) {
            this.myAuthorize.setPassword(this.tfPassword.getText(), this.myClientAuth);
        }
    }

    public void setGUIfromData() {
        ((TextComponent)this.tfPassword).setText("");
        ((TextComponent)this.tfVerifyPW).setText("");
    }

    public boolean validatePage() {
        if (Utility.isEmptyTextField(this.tfPassword) && Utility.isEmptyTextField(this.tfVerifyPW)) {
            return true;
        }
        if (!this.tfPassword.getText().equals(this.tfVerifyPW.getText())) {
            this.showMessageDialog(this.myBundle.getString("DSC1_PASSWORD_MATCH_ERROR"), this);
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfPassword) && this.tfPassword.getText().length() < 5) {
            this.showMessageDialog(this.myBundle.getString("DSC1_PASSWORD_LENGTH_ERROR"), this);
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfPassword) && this.tfPassword.getText().length() > 20) {
            this.showMessageDialog(this.myBundle.getString("DSC1_PASSWORD_LENGTH_ERROR"), this);
            return false;
        }
        if (!Utility.isEmptyTextField(this.tfPassword)) {
            this.myAuthorize.setUpdated(true);
        }
        return true;
    }

    public void messageFinished(int n) {
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = myButtonPanel.getButtons();
        if (button == buttonArray[0] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }
}

