/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.client;

import COM.ibm.raleigh.tcp.tcpcfg2.client.BasePage;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ButtonPanel;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DialogListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.DlgSecurity4ACD;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MessageListener;
import COM.ibm.raleigh.tcp.tcpcfg2.client.MulColumn;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Notebook;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TftpaEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.awt.Button;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class PgSecurity5
extends BasePage
implements ActionListener,
DialogListener,
MessageListener {
    private ResourceBundle myBundle;
    private Label lblPageTitle;
    private MulColumn myList;
    private Panel TFTPAPanel;
    private ButtonPanel myButtonPanel;
    private static final String[] buttonLabels = new String[]{null, null, null, null};
    private static final int ADD_BUTTON = 0;
    private static final int CHANGE_BUTTON = 1;
    private static final int DELETE_BUTTON = 2;
    private static final int UNDO_BUTTON = 3;
    private static final int MAX_BUTTONS_IN_ROW = 5;
    private int dialogCommand = -1;
    private String originalUserString = new String();
    private boolean undoTheUpdate = true;
    private UserEntry myUserEntry;
    private UserData myUserData;
    private BaseProxy myServerProxy;
    GridBagLayout gridBag = new GridBagLayout();
    private boolean myTrace = false;
    private static final int TFTPA_LIST_MAX_COLUMNS = 3;
    private DlgSecurity4ACD tftpaAuthorizationDialog;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public PgSecurity5(Notebook notebook) {
        this.myOwner = notebook;
        this.myTrace = Utility.isTraceOn();
        this.myBundle = ClientMsg.getBundle();
        this.createMyPage();
    }

    private void addButtonGUI(int n, int n2, int n3) {
        PgSecurity5.buttonLabels[0] = this.myBundle.getString("GLO_ADD");
        PgSecurity5.buttonLabels[1] = this.myBundle.getString("GLO_CHANGE");
        PgSecurity5.buttonLabels[2] = this.myBundle.getString("GLO_DELETE");
        PgSecurity5.buttonLabels[3] = this.myBundle.getString("GLO_UNDO");
        this.myButtonPanel = new ButtonPanel(this, buttonLabels, n3);
        Utility.constrain(this, this.myButtonPanel, n, n2, 0, 1, 2, 10, 1.0, 0.0, 0, 0, 0, 0);
        this.listenToButtons(this.myButtonPanel);
    }

    private void createMyPage() {
        this.setBackground(Utility.NOTEBOOK_COLOR);
        this.lblPageTitle = new Label(this.myBundle.getString("PSC5_TITLE"));
        this.TFTPAPanel = new Panel();
        this.TFTPAPanel.setLayout(this.gridBag);
        String[] stringArray = new String[]{this.myBundle.getString("PSC5_ACCESS"), this.myBundle.getString("PSC5_DIRECTORY"), this.myBundle.getString("PSC5_ALIAS")};
        int[] nArray = new int[]{23, 43, 33};
        this.myList = new MulColumn(stringArray, nArray);
        this.setLayout(this.gridBag);
        Utility.constrain(this, this.lblPageTitle, 0, 0, 0, 1, 0, 10, 1.0, 0.2, 0, 0, 0, 0);
        Utility.constrain(this.TFTPAPanel, this.myList, 0, 0, 0, 1, 1, 10, 1.0, 1.0, 10, 0, 10, 0);
        Utility.constrain(this, this.TFTPAPanel, 0, 1, 0, 1, 1, 10, 1.0, 1.0, 0, 10, 5, 10);
        this.addButtonGUI(0, 2, 5);
    }

    private void doUndoButton() {
        this.myUserData.deCommit(3);
        this.setGUIfromData();
        if (this.undoTheUpdate) {
            this.originalUserString = this.toStringUser();
            this.myUserData.setUpdated(false);
        }
    }

    private void doHelpButton() {
    }

    public void commit() {
        this.myUserData.commit(3);
    }

    public void loadData(BaseProxy baseProxy) {
        this.myServerProxy = baseProxy;
        this.myUserData = this.myServerProxy.getNotebookProfileDataHandle().getUserDataHandle();
        if (this.myUserData.getUserEntryListSize() > 0) {
            int n = this.myUserData.getUserSelectedIndex();
            this.myUserEntry = this.myUserData.getUserEntry(n);
        }
    }

    public void setDataFromGUI() {
        this.myUserData.deleteTftpaEntryList();
        if (!this.isNoEntries(this.myList)) {
            int n = this.myList.getItemCount();
            String[] stringArray = new String[3];
            TftpaEntry tftpaEntry = null;
            int n2 = 0;
            while (n2 < n) {
                stringArray = this.myList.getItem(n2);
                stringArray[0] = stringArray[0].equals(this.myBundle.getString("GLO_ALLOW")) ? "ALLOW" : "DENY";
                tftpaEntry = new TftpaEntry(stringArray[0], stringArray[1], stringArray[2]);
                this.myUserData.addTftpaEntry(tftpaEntry);
                ++n2;
            }
        }
        if (this.myTrace) {
            System.out.println("PgSecurity5 COMPARING Original string = " + this.originalUserString);
            System.out.println("PgSecurity5 COMPARING Current  string = " + this.toStringUser());
        }
        if (this.originalUserString.compareTo(this.toStringUser()) != 0) {
            if (this.myTrace) {
                System.out.println("PgSecurity5 UserData has changed!!!");
            }
            this.myUserData.setUpdated(true);
        } else if (this.myTrace) {
            System.out.println("PgSecurity5 UserData has NOT changed!!!");
        }
        this.originalUserString = null;
        if (this.myUserData.isUpdated()) {
            if (this.myTrace) {
                System.out.println("PgSecurity5 UserData been UPDATED! - setting undoUpdated to false");
            }
            this.undoTheUpdate = false;
        }
    }

    public void setGUIfromData() {
        String[] stringArray = new String[3];
        this.myList.removeAll();
        Button[] buttonArray = this.myButtonPanel.getButtons();
        buttonArray[1].setEnabled(true);
        buttonArray[2].setEnabled(true);
        int n = this.myUserData.getTftpaEntryListSize();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                TftpaEntry tftpaEntry = this.myUserData.getTftpaEntry(n2);
                stringArray[0] = tftpaEntry.getAccess().equals("ALLOW") ? this.myBundle.getString("GLO_ALLOW") : this.myBundle.getString("GLO_DENY");
                stringArray[1] = tftpaEntry.getDirectory();
                stringArray[2] = tftpaEntry.getAlias();
                this.myList.add(stringArray);
                ++n2;
            }
        } else {
            stringArray[0] = this.myBundle.getString("GLO_NO_ENTRIES");
            stringArray[1] = "";
            stringArray[2] = "";
            this.myList.add(stringArray);
            buttonArray[1].setEnabled(false);
            buttonArray[2].setEnabled(false);
        }
        this.myList.select(0);
        this.originalUserString = this.toStringUser();
        if (this.myTrace) {
            System.out.println("PgSecurity5 Original string = " + this.originalUserString);
        }
        if (this.myUserData.isUpdated()) {
            this.undoTheUpdate = false;
        }
    }

    public boolean validatePage() {
        return true;
    }

    private void doOKdlgACDadd() {
        Object object;
        String[] stringArray = new String[3];
        if (this.tftpaAuthorizationDialog.isAllow()) {
            stringArray[0] = this.myBundle.getString("GLO_ALLOW");
            stringArray[2] = this.tftpaAuthorizationDialog.getAlias();
        } else {
            stringArray[0] = this.myBundle.getString("GLO_DENY");
            stringArray[2] = " ";
        }
        stringArray[1] = this.tftpaAuthorizationDialog.getDirectory();
        if (this.isNoEntries(this.myList)) {
            this.myList.remove(0);
            object = this.myButtonPanel.getButtons();
            object[1].setEnabled(true);
            object[2].setEnabled(true);
        }
        this.myList.add(stringArray);
        this.myList.select(this.myList.getItemCount() - 1);
        object = new TftpaEntry();
        ((TftpaEntry)object).setAccess(stringArray[0]);
        ((TftpaEntry)object).setDirectory(stringArray[1]);
        ((TftpaEntry)object).setAlias(stringArray[2]);
        this.myUserData.addTftpaEntry((TftpaEntry)object);
        this.tftpaAuthorizationDialog.dispose();
    }

    private void doOKdlgACDchange() {
        int n = this.myList.getSelectedIndex();
        String[] stringArray = this.myList.getItem(n);
        if (this.tftpaAuthorizationDialog.isAllow()) {
            stringArray[0] = this.myBundle.getString("GLO_ALLOW");
            stringArray[2] = this.tftpaAuthorizationDialog.getAlias();
        } else {
            stringArray[0] = this.myBundle.getString("GLO_DENY");
            stringArray[2] = " ";
        }
        stringArray[1] = this.tftpaAuthorizationDialog.getDirectory();
        this.myList.replaceItem(stringArray, n);
        this.myList.select(n);
        TftpaEntry tftpaEntry = this.myUserData.getTftpaEntry(n);
        tftpaEntry.setAccess(stringArray[0]);
        tftpaEntry.setDirectory(stringArray[1]);
        tftpaEntry.setAlias(stringArray[2]);
        this.tftpaAuthorizationDialog.dispose();
    }

    private void doOKdlgACDdelete() {
        int n = this.myList.getSelectedIndex();
        this.myList.remove(n);
        this.myUserData.deleteTftpaEntry(n);
        int n2 = this.myList.getItemCount();
        if (n2 < 1) {
            String[] stringArray = new String[]{this.myBundle.getString("GLO_NO_ENTRIES"), "", ""};
            Button[] buttonArray = this.myButtonPanel.getButtons();
            buttonArray[1].setEnabled(false);
            buttonArray[2].setEnabled(false);
            this.myList.add(stringArray);
            this.myList.select(0);
            return;
        }
        if (n > 0) {
            --n;
        }
        this.myList.select(n);
    }

    private void populateDlgACD() {
        int n = this.myList.getSelectedIndex();
        String[] stringArray = this.myList.getItem(n);
        if (stringArray[0].equals(this.myBundle.getString("GLO_ALLOW"))) {
            this.tftpaAuthorizationDialog.setAllow(true);
            this.tftpaAuthorizationDialog.setCheckbox(true);
        } else {
            this.tftpaAuthorizationDialog.setDeny(true);
            this.tftpaAuthorizationDialog.setCheckbox(false);
        }
        this.tftpaAuthorizationDialog.setDirectory(stringArray[1]);
        this.tftpaAuthorizationDialog.setAlias(stringArray[2]);
    }

    private void showACDdialog(int n) {
        switch (n) {
            case 0: {
                this.tftpaAuthorizationDialog = new DlgSecurity4ACD(0, this, this.myList);
                break;
            }
            case 1: {
                this.tftpaAuthorizationDialog = new DlgSecurity4ACD(1, this, this.myList);
                this.populateDlgACD();
                break;
            }
            case 2: {
                this.tftpaAuthorizationDialog = new DlgSecurity4ACD(2, this, this.myList);
                this.populateDlgACD();
                break;
            }
            default: {
                this.tftpaAuthorizationDialog = new DlgSecurity4ACD(0, this, this.myList);
            }
        }
        this.myOwner.setEnabled(false);
        this.tftpaAuthorizationDialog.setVisible(true);
    }

    public void messageFinished(int n) {
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void dialogFinished(int n) {
        if (n == 0) {
            if (this.dialogCommand == 1) {
                this.doOKdlgACDchange();
            } else if (this.dialogCommand == 2) {
                this.doOKdlgACDdelete();
            } else if (this.dialogCommand == 0) {
                this.doOKdlgACDadd();
            }
        }
        this.myOwner.setEnabled(true);
        this.myOwner.requestFocus();
        this.requestFocus();
    }

    public void handleButton(Button button) {
        Button[] buttonArray = this.myButtonPanel.getButtons();
        if (button == buttonArray[0]) {
            this.dialogCommand = 0;
            this.showACDdialog(0);
            return;
        }
        if (button == buttonArray[1]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 1;
                this.showACDdialog(1);
                return;
            }
        } else if (button == buttonArray[2]) {
            if (this.isChangeDeleteOk(this.myList, this)) {
                this.dialogCommand = 2;
                this.showACDdialog(2);
                return;
            }
        } else if (button == buttonArray[3] && this.isUndoConfirmed(this)) {
            this.doUndoButton();
        }
    }

    public String toStringUser() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[3];
        int n = this.myList.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            stringArray = this.myList.getItem(n2);
            stringBuffer.append(String.valueOf(stringArray[0]) + " ");
            stringBuffer.append(String.valueOf(stringArray[1]) + " ");
            stringBuffer.append(String.valueOf(stringArray[2]) + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

