/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcpauth.client_admin_auth;
import COM.ibm.raleigh.tcpauth.create_admin_pw;

public class Authorize
extends NotebookData {
    public static final String BDS_tag = new String("Bds");
    public static final String EDS_tag = new String("Eds");
    public static final String DATA_ID = new String("AUTH");
    public static final String SAVE_ID = new String("SAVE_AUTHORIZE");
    private static final String myUpdated_tag = new String("up_yn");
    private static final String myNumPubHigh_tag = new String("nPbH");
    private static final String myNumPubLow_tag = new String("nPbl");
    private static final String myNumPvtHigh_tag = new String("nPvH");
    private static final String myNumPvtLow_tag = new String("nPvl");
    private static final String myPubHigh_tag = new String("pbH");
    private static final String myPubLow_tag = new String("pbl");
    private static final String myPvtHigh_tag = new String("pvH");
    private static final String myPvtLow_tag = new String("pvl");
    private boolean myTrace = Utility.isTraceOn();
    private byte[] myPubPw;
    private byte[] myPvtPw;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public Authorize() {
        if (this.myTrace) {
            System.out.println("in Authorize() constructor");
        }
        this.loadInit();
    }

    public Authorize(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING Authorize from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public byte[] getPubPw() {
        if (this.myTrace) {
            System.out.println("in Authorize.getPubPw  myPubPw = " + this.myPubPw);
        }
        return this.myPubPw;
    }

    public byte[] getPvtPw() {
        if (this.myTrace) {
            System.out.println("in Authorize.getPvtPw  myPvtPw = " + this.myPvtPw);
        }
        return this.myPvtPw;
    }

    private void loadInit() {
        this.myPubPw = null;
        this.myPvtPw = null;
    }

    public void setPassword(String string, client_admin_auth client_admin_auth2) {
        if (string == null) {
            this.myPubPw = null;
            this.myPvtPw = null;
            return;
        }
        create_admin_pw create_admin_pw2 = new create_admin_pw(string);
        this.setPubPw(create_admin_pw2.get_pub());
        this.setPvtPw(create_admin_pw2.get_pvt());
    }

    public void setPubPw(byte[] byArray) {
        if (this.myTrace) {
            System.out.println("in Authorize.setPubPw() key = " + byArray);
        }
        this.myPubPw = byArray;
    }

    public void setPvtPw(byte[] byArray) {
        if (this.myTrace) {
            System.out.println("in Authorize.setPvtPw() key = " + byArray);
        }
        this.myPvtPw = byArray;
    }

    public void fromString(ParsedVector parsedVector) {
        int n;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        String[] stringArray = parsedVector.getKeys();
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            Integer n4;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n2].equals(myUpdated_tag)) {
                parsedObject = parsedVector.getElement(myUpdated_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    if (n4 == 0) {
                        this.setUpdated(false);
                    } else {
                        this.setUpdated(true);
                    }
                }
            } else if (stringArray[n2].equals(myNumPubHigh_tag)) {
                parsedObject = parsedVector.getElement(myNumPubHigh_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n = n4;
                    if (n > 0) {
                        nArray = new int[n];
                        n3 = 1;
                        while (n3 <= n) {
                            parsedObject = parsedVector.get(n2 + n3);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                n4 = Integer.valueOf(string);
                                nArray[n3 - 1] = n4;
                            }
                            ++n3;
                        }
                    } else {
                        nArray = null;
                    }
                } else {
                    nArray = null;
                }
            } else if (stringArray[n2].equals(myNumPubLow_tag)) {
                parsedObject = parsedVector.getElement(myNumPubLow_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n = n4;
                    if (n > 0) {
                        nArray2 = new int[n];
                        n3 = 1;
                        while (n3 <= n) {
                            parsedObject = parsedVector.get(n2 + n3);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                n4 = Integer.valueOf(string);
                                nArray2[n3 - 1] = n4;
                            }
                            ++n3;
                        }
                    } else {
                        nArray2 = null;
                    }
                } else {
                    nArray2 = null;
                }
            } else if (stringArray[n2].equals(myNumPvtHigh_tag)) {
                parsedObject = parsedVector.getElement(myNumPvtHigh_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n = n4;
                    if (n > 0) {
                        nArray3 = new int[n];
                        n3 = 1;
                        while (n3 <= n) {
                            parsedObject = parsedVector.get(n2 + n3);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                n4 = Integer.valueOf(string);
                                nArray3[n3 - 1] = n4;
                            }
                            ++n3;
                        }
                    } else {
                        nArray3 = null;
                    }
                } else {
                    nArray3 = null;
                }
            } else if (stringArray[n2].equals(myNumPvtLow_tag)) {
                parsedObject = parsedVector.getElement(myNumPvtLow_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n4 = Integer.valueOf(string);
                    n = n4;
                    if (n > 0) {
                        nArray4 = new int[n];
                        n3 = 1;
                        while (n3 <= n) {
                            parsedObject = parsedVector.get(n2 + n3);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                n4 = Integer.valueOf(string);
                                nArray4[n3 - 1] = n4;
                            }
                            ++n3;
                        }
                    } else {
                        nArray4 = null;
                    }
                } else {
                    nArray4 = null;
                }
            }
            ++n2;
        }
        if (this.isUpdated()) {
            int n5;
            if (this.myTrace) {
                System.out.println("int Authorize.fromString() - recreating pub and pvt keys");
            }
            if (nArray != null && nArray2 != null && nArray.length == nArray2.length) {
                n = nArray.length;
                this.myPubPw = new byte[n];
                n5 = 0;
                while (n5 < n) {
                    this.myPubPw[n5] = Utility.byteFromInt(nArray[n5], (int)nArray2[n5]);
                    ++n5;
                }
            }
            if (nArray3 != null && nArray4 != null && nArray3.length == nArray4.length) {
                n = nArray3.length;
                this.myPvtPw = new byte[n];
                n5 = 0;
                while (n5 < n) {
                    this.myPvtPw[n5] = Utility.byteFromInt((int)nArray3[n5], (int)nArray4[n5]);
                    ++n5;
                }
            }
        }
        if (this.myTrace) {
            System.out.println("leaving Authorize.fromString()");
        }
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in Authorize.tostring()");
        }
        StringBuffer stringBuffer = new StringBuffer(BDS_tag);
        if (this.isUpdated()) {
            stringBuffer.append("=" + SAVE_ID);
        } else {
            stringBuffer.append("=" + DATA_ID);
        }
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdated_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdated_tag + "=" + 0);
        }
        int n = this.myPubPw.length;
        stringBuffer.append("," + myNumPubHigh_tag + "=" + n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("," + myPubHigh_tag + "=" + Utility.byteHighLowValue(this.myPubPw[n2], true));
            ++n2;
        }
        stringBuffer.append("," + myNumPubLow_tag + "=" + n);
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("," + myPubLow_tag + "=" + Utility.byteHighLowValue(this.myPubPw[n3], false));
            ++n3;
        }
        n = this.myPvtPw.length;
        stringBuffer.append("," + myNumPvtHigh_tag + "=" + n);
        int n4 = 0;
        while (n4 < n) {
            stringBuffer.append("," + myPvtHigh_tag + "=" + Utility.byteHighLowValue(this.myPvtPw[n4], true));
            ++n4;
        }
        stringBuffer.append("," + myNumPvtLow_tag + "=" + n);
        int n5 = 0;
        while (n5 < n) {
            stringBuffer.append("," + myPvtLow_tag + "=" + Utility.byteHighLowValue(this.myPvtPw[n5], false));
            ++n5;
        }
        stringBuffer.append("," + EDS_tag + ',');
        return stringBuffer.toString();
    }
}

