/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCMessageQueue;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCProductInfo;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class ConfigData
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BCO_tag = new String("Bco");
    public static final String ECO_tag = new String("Eco");
    public static final String DATA_ID = new String("CONFIGDATA");
    public static final String SAVE_ID = new String("SAVE_CONFIG_DATA");
    public static final String LOAD_ID = new String("LOAD_CONFIG_DATA");
    private static final String myHostname_tag = new String("CDmm");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private static final String myLprPrinter_tag = new String("CDrp");
    private static final String myLprServer_tag = new String("CDps");
    private static final String myMaxLpdPorts_tag = new String("CDlpp");
    private static final String myUseHostsFirstState_tag = new String("CDsh_yn");
    private static final String myRshLprUsername_tag = new String("CDrshun");
    private static final String myTimeZone_tag = new String("CDtz");
    private OOCProductInfo myProductInfo;
    private OOCConfiguration myConfiguration;
    private OOCMessageQueue myMessageQueue;
    private boolean noExistingData = false;
    private boolean noProductInfo = false;
    private String myHostname;
    private OOCKeyword kwHostname;
    private String myLprPrinter;
    private OOCKeyword kwLprPrinter;
    private String myLprServer;
    private OOCKeyword kwLprServer;
    private int myMaxLpdPorts;
    private OOCKeyword kwMaxLpdPorts;
    private boolean myUseHostsFirstState = false;
    private String myUseHostsFirstStateString;
    private OOCKeyword kwUseHostsFirstState;
    private String myRshLprUsername;
    private OOCKeyword kwRshLprUsername;
    private String myTimeZone;
    private OOCKeyword kwTimeZone;
    private NativeData myNativeData;
    private String myEtcPath;
    private String myBootDrive;
    private String datFile;
    private String logFile;
    private String bakFile;
    private String configFile;
    private static final String parseRules = "CONFIG_SYS";
    private boolean already_closed = false;
    ErrorListController myErrorListController;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();

    public ConfigData() {
        if (this.myTrace) {
            System.out.println("in ConfigData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
    }

    public ConfigData(boolean bl, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in ConfigData() constructor2");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
        if (bl) {
            this.loadFromOOCS();
        }
    }

    public ConfigData(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@ CONSRUCTING ConfigData from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public int getLpdPortsMaxCount() {
        return this.myMaxLpdPorts;
    }

    public String getRemotePrinter() {
        return this.myLprPrinter;
    }

    public String getRemotePrintServer() {
        return this.myLprServer;
    }

    public String getRshLprUsername() {
        return this.myRshLprUsername;
    }

    public String getHostname() {
        return this.myHostname;
    }

    public String getTimeZone() {
        return this.myTimeZone;
    }

    public boolean getSearchHostsListState() {
        return this.myUseHostsFirstState;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of ConfigData");
        }
        this.myHostname = new String("");
        this.myLprPrinter = new String("");
        this.myLprServer = new String("");
        this.myRshLprUsername = new String("");
        this.myTimeZone = new String("");
        this.myMaxLpdPorts = 8;
        this.myUseHostsFirstState = false;
        this.myErrorListController = null;
    }

    public void setLpdPortsMaxCount(int n) {
        this.myMaxLpdPorts = n;
    }

    public void setRemotePrinter(String string) {
        this.myLprPrinter = string;
        if (this.myTrace) {
            System.out.println("myLprPrinter, print = " + this.myLprPrinter + "," + string);
        }
    }

    public void setRemotePrintServer(String string) {
        this.myLprServer = string;
    }

    public void setRshLprUsername(String string) {
        this.myRshLprUsername = string;
    }

    public void setHostname(String string) {
        this.myHostname = string;
    }

    public void setTimeZone(String string) {
        this.myTimeZone = string;
    }

    public void setSearchHostsListState(boolean bl) {
        this.myUseHostsFirstState = bl;
    }

    private void loadFromOOCS() {
        int n;
        if (this.myTrace) {
            System.out.println("***** in loadFromOOCS() of ConfigData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        this.myBootDrive = NativeData.getBootDrive();
        this.datFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "cfgsys.dat";
        this.logFile = String.valueOf(this.myEtcPath) + "tcpcfg2.log";
        this.configFile = String.valueOf(this.myBootDrive) + ":" + File.separator + "config.sys";
        this.bakFile = String.valueOf(this.myBootDrive) + ":" + File.separator + "config.nbk";
        this.myProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(ConfigData.loadFromOOCS) myProductInfo datFile = " + this.datFile);
        }
        if ((n = this.myProductInfo.create(this.datFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(ConfigData.loadFromOOCS) myProductInfo.create successful");
            }
            this.myProductInfo.setFileOpenMode(3);
            this.myProductInfo.setFileShareMode(0);
            this.myProductInfo.setProcessingOptions(1, 0, 0);
            this.myProductInfo.setParsingInfo(parseRules);
            this.myConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(ConfigData.loadFromOOCS) myConfiguration configFile = " + this.configFile);
            }
            if ((n = this.myConfiguration.open(this.myProductInfo, this.configFile)) == 2) {
                n = this.myConfiguration.open(this.myProductInfo, "");
                if (this.myTrace) {
                    System.out.println("ConfigData.loadFromOOCS) returncode = " + n);
                    System.out.println("(ConfigData.loadFromOOCS) myConfiguration.create successful...no preexisting file");
                }
                this.noExistingData = true;
            }
            if (this.myTrace) {
                System.out.println("(ConfigData.loadFromOOCS) myConfiguration.create successful");
            }
        } else {
            this.noProductInfo = true;
            if (this.myTrace) {
                System.out.println("(ConfigData.loadFromOOCS) ERROR: myProductInfo.create failed");
            }
            Object[] objectArray = new Object[]{this.datFile, "config.sys"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            OOCMessageQueue oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(ConfigData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
            return;
        }
        this.myConfiguration.write(this.bakFile, 1, 1, 1, 0, parseRules);
        this.myMessageQueue = this.myConfiguration.getMsgQ();
        this.myMessageQueue.replaceLogFile(0);
        this.myMessageQueue.setLogFileName(this.logFile);
        this.myMessageQueue.setLogOption(1);
        this.myMessageQueue.logQueue();
        this.myProductInfo.close();
        this.kwHostname = this.myConfiguration.get("SET HOSTNAME", "");
        if (this.kwHostname != null) {
            this.myHostname = this.kwHostname.getValue();
            new String(this.myHostname);
        } else {
            this.kwHostname = this.myConfiguration.createKeyword(1, "SET HOSTNAME", "", null);
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.loadFromOOCS) myHostname = " + this.myHostname);
        }
        this.kwLprServer = this.myConfiguration.get("SET LPR_SERVER", "");
        if (this.kwLprServer != null) {
            this.myLprServer = this.kwLprServer.getValue();
            new String(this.myLprServer);
        } else {
            this.kwLprServer = this.myConfiguration.createKeyword(1, "SET LPR_SERVER", "", null);
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.loadFromOOCS) myLprServer = " + this.myLprServer);
        }
        this.kwLprPrinter = this.myConfiguration.get("SET LPR_PRINTER", "");
        if (this.kwLprPrinter != null) {
            this.myLprPrinter = this.kwLprPrinter.getValue();
            new String(this.myLprPrinter);
        } else {
            this.kwLprPrinter = this.myConfiguration.createKeyword(1, "SET LPR_PRINTER", "", null);
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.loadFromOOCS) myLprPrinter = " + this.myLprPrinter);
        }
        this.kwUseHostsFirstState = this.myConfiguration.get("SET USE_HOSTS_FIRST", "");
        if (this.kwUseHostsFirstState != null) {
            this.myUseHostsFirstState = true;
            this.myUseHostsFirstStateString = "1";
        } else {
            this.kwUseHostsFirstState = this.myConfiguration.createKeyword(1, "SET USE_HOSTS_FIRST", "", null);
            this.myUseHostsFirstState = false;
            this.myUseHostsFirstStateString = "0";
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.loadFromOOCS) myUseHostsFirstState = " + this.myUseHostsFirstState);
        }
        this.kwTimeZone = this.myConfiguration.get("SET TZ", "");
        if (this.kwTimeZone != null) {
            this.myTimeZone = this.kwTimeZone.getValue();
            new String(this.myTimeZone);
        } else {
            this.kwTimeZone = this.myConfiguration.createKeyword(1, "SET TZ", "", null);
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.loadFromOOCS) myTimeZone = " + this.myTimeZone);
        }
        this.kwRshLprUsername = this.myConfiguration.get("SET USER", "");
        if (this.kwRshLprUsername != null) {
            this.myRshLprUsername = this.kwRshLprUsername.getValue();
            new String(this.myRshLprUsername);
        } else {
            this.kwRshLprUsername = this.myConfiguration.createKeyword(1, "SET USER", "", null);
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.loadFromOOCS) myRshLprUsername = " + this.myRshLprUsername);
        }
        this.myMaxLpdPorts = NativeData.getMaxports();
        if (this.myMaxLpdPorts == -1) {
            this.myMaxLpdPorts = 8;
            this.setUpdated(true);
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.loadFromOOCS) myMaxLpdPorts = " + this.myMaxLpdPorts);
        }
    }

    public void saveToOOCS() {
        int n = 0;
        if (this.myTrace) {
            System.out.println("***** in saveToOOCS() of ConfigData");
        }
        this.kwLprPrinter.setValue(this.myLprPrinter);
        if (!NotebookData.hasValue(this.myLprPrinter)) {
            this.myConfiguration.deleteKeyword("SET LPR_PRINTER", "");
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.saveToOOCS) setValue.myLprPrinter = " + this.myLprPrinter);
        }
        this.kwRshLprUsername.setValue(this.myRshLprUsername);
        if (!NotebookData.hasValue(this.myRshLprUsername)) {
            this.myConfiguration.deleteKeyword("SET USER", "");
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.saveToOOCS) setValue.myRshLprUsername = " + this.myRshLprUsername);
        }
        this.kwTimeZone.setValue(this.myTimeZone);
        if (!NotebookData.hasValue(this.myTimeZone)) {
            this.myConfiguration.deleteKeyword("SET TZ", "");
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.saveToOOCS) setValue.myTimeZone = " + this.myTimeZone);
        }
        this.kwHostname.setValue(this.myHostname);
        if (!NotebookData.hasValue(this.myHostname)) {
            this.myConfiguration.deleteKeyword("SET HOSTNAME", "");
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.saveToOOCS) setValue.myHostname = " + this.myHostname);
        }
        this.kwLprServer.setValue(this.myLprServer);
        if (!NotebookData.hasValue(this.myLprServer)) {
            this.myConfiguration.deleteKeyword("SET LPR_SERVER", "");
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.saveToOOCS) setValue.myLprServer = " + this.myLprServer);
        }
        NativeData.setLprPortdPorts(this.myMaxLpdPorts);
        if (this.myTrace) {
            System.out.println("(ConfigData.saveToOOCS) myMaxLpdPorts = " + this.myMaxLpdPorts);
        }
        this.myUseHostsFirstStateString = this.myUseHostsFirstState ? "1" : "0";
        this.kwUseHostsFirstState.setValue(this.myUseHostsFirstStateString);
        if (!this.myUseHostsFirstState) {
            this.myConfiguration.deleteKeyword("SET USE_HOSTS_FIRST", "");
        }
        if (this.myTrace) {
            System.out.println("(ConfigData.saveToOOCS) setValue.myUseHostsFirstState = " + this.myUseHostsFirstState);
            System.out.println("(ConfigData.saveToOOCS).....about to write myConfiguration");
        }
        if ((n = this.myConfiguration.write(this.configFile, 1, 1, 1, 0, parseRules)) == 1) {
            if (this.myTrace) {
                System.out.println("(ConfigData.saveToOOCS) Successful write to config.sys");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(ConfigData.saveToOOCS) Unsuccessful write to config.sys");
            }
            Object[] objectArray = new Object[]{"config.sys"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            this.myMessageQueue.logQueue();
        }
        this.closeOOCS();
    }

    public void closeOOCS() {
        if (this.already_closed) {
            return;
        }
        this.already_closed = true;
        int n = this.myConfiguration.close();
        if (this.myTrace) {
            System.out.println("(ConfigData.closeOOCS) rc from myConfiguration.close = " + n);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myHostname_tag)) {
                parsedObject = parsedVector.getElement(myHostname_tag);
                string = (String)parsedObject.getValue();
                this.myHostname = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myLprPrinter_tag)) {
                parsedObject = parsedVector.getElement(myLprPrinter_tag);
                string = (String)parsedObject.getValue();
                this.myLprPrinter = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myLprServer_tag)) {
                parsedObject = parsedVector.getElement(myLprServer_tag);
                string = (String)parsedObject.getValue();
                this.myLprServer = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myMaxLpdPorts_tag)) {
                parsedObject = parsedVector.getElement(myMaxLpdPorts_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myMaxLpdPorts = n2;
                }
            } else if (stringArray[n].equals(myUseHostsFirstState_tag)) {
                parsedObject = parsedVector.getElement(myUseHostsFirstState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myUseHostsFirstState = n2 != 0;
                }
            } else if (stringArray[n].equals(myRshLprUsername_tag)) {
                parsedObject = parsedVector.getElement(myRshLprUsername_tag);
                string = (String)parsedObject.getValue();
                this.myRshLprUsername = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myTimeZone_tag)) {
                parsedObject = parsedVector.getElement(myTimeZone_tag);
                string = (String)parsedObject.getValue();
                this.myTimeZone = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myUpdatedState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myUpdatedState_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                if (n2 == 0) {
                    this.setUpdated(false);
                } else {
                    this.setUpdated(true);
                }
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BCO_tag);
        stringBuffer.append("," + myHostname_tag + "=" + this.myHostname);
        stringBuffer.append("," + myLprPrinter_tag + "=" + this.myLprPrinter);
        stringBuffer.append("," + myLprServer_tag + "=" + this.myLprServer);
        stringBuffer.append("," + myMaxLpdPorts_tag + "=" + this.myMaxLpdPorts);
        if (this.myUseHostsFirstState) {
            stringBuffer.append("," + myUseHostsFirstState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUseHostsFirstState_tag + "=" + 0);
        }
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        stringBuffer.append("," + myRshLprUsername_tag + "=" + this.myRshLprUsername);
        stringBuffer.append("," + myTimeZone_tag + "=" + "\"" + this.myTimeZone + "\"");
        stringBuffer.append("," + ECO_tag);
        return stringBuffer.toString();
    }
}

