/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class ConnectionStatus {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BCS_tag = new String("Bcs");
    public static final String ECS_tag = new String("Ecs");
    public static final String DATA_ID = new String("CSTATUS");
    private static final String myAuthRequired_tag = new String("authreqd_yn");
    private static final String myCancelled_tag = new String("cancel_yn");
    private boolean myAuthRequired = true;
    private boolean myCancelled = false;
    private boolean myTrace = Utility.isTraceOn();
    private String nlsEnabledFileSeparator;

    public ConnectionStatus() {
        if (this.myTrace) {
            System.out.println("in ConnectionStatus() constructor");
        }
        this.loadInit();
    }

    public ConnectionStatus(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING ConnectionStatus from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public String getFileSeparator() {
        return this.nlsEnabledFileSeparator;
    }

    public void setAuthRequired(boolean bl) {
        this.myAuthRequired = bl;
    }

    public void setCancelled(boolean bl) {
        this.myCancelled = bl;
    }

    public void setFileSeparator(String string) {
        this.nlsEnabledFileSeparator = string;
    }

    public boolean isAuthRequired() {
        return this.myAuthRequired;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }

    private void loadInit() {
        this.myAuthRequired = true;
        this.myCancelled = false;
        this.nlsEnabledFileSeparator = "\\";
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        if (this.myTrace) {
            System.out.println("ConnectionStatus.fromString() the num of keys is " + String.valueOf(stringArray.length));
        }
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myAuthRequired_tag)) {
                parsedObject = parsedVector.getElement(myAuthRequired_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myAuthRequired = n2 != 0;
                }
            } else if (stringArray[n].equals(myCancelled_tag) && (string = (String)(parsedObject = parsedVector.getElement(myCancelled_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                this.myCancelled = n2 != 0;
            }
            ++n;
        }
        if (this.myTrace) {
            System.out.println("leaving ConnectionStatus.fromString() = " + this.toString());
        }
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in ConnectionStatus.tostring()");
        }
        StringBuffer stringBuffer = new StringBuffer(BCS_tag);
        stringBuffer.append("=" + DATA_ID);
        if (this.myAuthRequired) {
            stringBuffer.append("," + myAuthRequired_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myAuthRequired_tag + "=" + 0);
        }
        if (this.myCancelled) {
            stringBuffer.append("," + myCancelled_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myCancelled_tag + "=" + 0);
        }
        stringBuffer.append("," + ECS_tag + ',');
        return stringBuffer.toString();
    }
}

