/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.NetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Authorize;
import COM.ibm.raleigh.tcp.tcpcfg2.common.AutostartService;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConfigData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConnectionStatus;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.HostsData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.HostsEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.LanInterface;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSDirEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookProfile;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ResolvData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Route;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SetupData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksRouteEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksServerEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpstartData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TimedData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserData;

public class DDNSNetworkStringParser
extends NetworkStringParser {
    public static final String CStmt1 = new String("Licensed Materials = Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n");
    public static final String CStmt2 = new String("US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.");
    public static final String AppVersion = new String("Dynamic Ip Version 1.0");
    public static final String ModVersion = new String("This Class Version 1.0");
    private static final String CLASS_NAME = "DDNSNetworkStringParser";
    private static final int NO_OBJECT = -1;
    private static final String validReturnCodeKey = "RC";
    private static final String Notebook_BNB_tag = "Bnb";
    private static final String Notebook_ENB_tag = "Enb";
    private static final String[] validStartObjectKeys = new String[]{"Bnb", NotebookProfile.BNP_tag, SetupData.BSE_tag, LanInterface.BLA_tag, Route.BRO_tag, SocksData.BSO_tag, SocksRouteEntry.BDE_tag, SocksServerEntry.BEE_tag, ConfigData.BCO_tag, ResolvData.BRE_tag, HostsData.BHD_tag, HostsEntry.BHO_tag, TcpstartData.BTC_tag, AutostartService.BAU_tag, UserData.BUD_tag, TcpError.BTR_tag, Authorize.BDS_tag, ConnectionStatus.BCS_tag, ErrorListController.BER_tag, NFSData.BNO_tag, NFSDirEntry.BND_tag, TimedData.BTD_tag};
    private static final String[] validEndObjectKeys = new String[]{"Enb", NotebookProfile.ENP_tag, SetupData.ESE_tag, LanInterface.ELA_tag, Route.ERO_tag, SocksData.ESO_tag, SocksRouteEntry.EDE_tag, SocksServerEntry.EEE_tag, ConfigData.ECO_tag, ResolvData.ERE_tag, HostsData.EHD_tag, HostsEntry.EHO_tag, TcpstartData.ETC_tag, AutostartService.EAU_tag, UserData.EUD_tag, TcpError.ETR_tag, Authorize.EDS_tag, ConnectionStatus.ECS_tag, ErrorListController.EER_tag, NFSData.ENO_tag, NFSDirEntry.END_tag, TimedData.ETD_tag};
    private static final String[] validBaseObjectKeys = new String[]{Authorize.BDS_tag, ConnectionStatus.BCS_tag, "Bnb"};
    private ParsedVector ddnsVector;
    private ParsedObject ddnsReturnCode;
    private TraceClient tracer;
    private String thisMethod;

    public DDNSNetworkStringParser(String string, TraceClient traceClient) {
        super(string);
        this.tracer = traceClient;
        this.createParsedVector(super.getParsed());
    }

    public ParsedVector getParsed() {
        return this.ddnsVector;
    }

    public ParsedObject getReturnCode() {
        return this.ddnsReturnCode;
    }

    private void createParsedVector(ParsedVector parsedVector) {
        this.thisMethod = "createParsedVector";
        if (!parsedVector.isEmpty()) {
            String[] stringArray = parsedVector.getKeys();
            int n = this.countObjectKeys(stringArray);
            if (n > 0) {
                this.ddnsVector = new ParsedVector();
                this.separateObjects(parsedVector, stringArray, n);
                return;
            }
            this.ddnsVector = null;
            return;
        }
        this.ddnsVector = null;
    }

    private void separateObjects(ParsedVector parsedVector, String[] stringArray, int n) {
        String string;
        int n2;
        this.thisMethod = "separateObjects";
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        ParsedVector[] parsedVectorArray = null;
        String string2 = null;
        if (n > 0) {
            parsedVectorArray = new ParsedVector[n];
            n2 = 0;
            while (n2 < n) {
                parsedVectorArray[n2] = null;
                ++n2;
            }
        }
        this.ddnsReturnCode = null;
        n2 = 0;
        while (n2 < stringArray.length) {
            string = stringArray[n2];
            if (this.isReturnCodeKey(string)) {
                this.ddnsReturnCode = parsedVector.get(n2);
            } else if (this.isStartObjectKey(string)) {
                n4 = ++n3;
                if (this.isBaseObjectKey(string)) {
                    n6 = n5 = n4;
                    parsedVectorArray[n5] = new ParsedVector();
                    parsedVectorArray[n5].append(parsedVector.get(n2));
                } else {
                    parsedVectorArray[n4] = new ParsedVector();
                    parsedVectorArray[n4].append(parsedVector.get(n2));
                    String string3 = null;
                    if (string2 != null) {
                        parsedVectorArray[n6].removeElementAt(parsedVectorArray[n6].lastIndexOf(parsedVectorArray[n6].lastElement()));
                        string3 = new String(string2);
                        string2 = null;
                    } else {
                        string3 = new String(string);
                    }
                    ParsedObject parsedObject = new ParsedObject(string3, (Object)parsedVectorArray[n4]);
                    parsedVectorArray[n6].append(parsedObject);
                    ++n6;
                }
            } else if (this.isEndObjectKey(string)) {
                parsedVectorArray[n4].append(parsedVector.get(n2));
                n4 = --n6;
            } else if (n4 != -1) {
                parsedVectorArray[n4].append(parsedVector.get(n2));
                string2 = new String(string);
            }
            ++n2;
        }
        this.ddnsVector = parsedVectorArray[n5];
        string = null;
        if (this.ddnsReturnCode != null) {
            string = new String(this.ddnsReturnCode.toString());
        }
    }

    private int countObjectKeys(String[] stringArray) {
        int n = 0;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (this.isStartObjectKey(stringArray[n2])) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    private boolean isStartObjectKey(String string) {
        this.thisMethod = "isStartObjectKey";
        boolean bl = false;
        int n = 0;
        while (n < validStartObjectKeys.length && !bl) {
            if (string.equals(validStartObjectKeys[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean isEndObjectKey(String string) {
        this.thisMethod = "isEndObjectKey";
        boolean bl = false;
        int n = 0;
        while (n < validEndObjectKeys.length && !bl) {
            if (string.equals(validEndObjectKeys[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean isBaseObjectKey(String string) {
        this.thisMethod = "isBaseObjectKey";
        boolean bl = false;
        int n = 0;
        while (n < validBaseObjectKeys.length && !bl) {
            if (string.equals(validBaseObjectKeys[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean isReturnCodeKey(String string) {
        this.thisMethod = "isReturnCodeKey";
        boolean bl = false;
        if (string.equals(validReturnCodeKey)) {
            bl = true;
        }
        return bl;
    }
}

