/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.util.StringTokenizer;

public class FtpAccess
implements Cloneable,
OOCConstants,
CloneableItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BFT_tag = new String("Bft");
    public static final String EFT_tag = new String("Eft");
    public static final String myReadDirectories_tag = new String("ftReadDirs");
    public static final String myWriteDirectories_tag = new String("ftWriteDirs");
    public static final String myEnabledState_tag = new String("ftEnab_yn");
    public static final String myLogAllState_tag = new String("ftLogAll_yn");
    public static final String myLogCdState_tag = new String("ftLogCd_yn");
    public static final String myLogDebugState_tag = new String("ftLogDbg_yn");
    public static final String myLogDelState_tag = new String("ftLogDel_yn");
    public static final String myLogDirState_tag = new String("ftLogDir_yn");
    public static final String myLogGetState_tag = new String("ftLogGet_yn");
    public static final String myLogMdState_tag = new String("ftLogMd_yn");
    public static final String myLogPutState_tag = new String("ftLogPut_yn");
    public static final String myLogRdState_tag = new String("ftLogRd_yn");
    public static final String myLogRenState_tag = new String("ftLogRen_yn");
    public static final String myReadState_tag = new String("ftRead_yn");
    public static final String myWriteState_tag = new String("ftWrite_yn");
    public static final String myIdleTimeout_tag = new String("ftTOut");
    private String myReadDirectories;
    private String myWriteDirectories;
    private String myLogString = "";
    private boolean myEnabledState = false;
    private boolean myLogAllState = false;
    private boolean myLogCdState = false;
    private boolean myLogDebugState = false;
    private boolean myLogDelState = false;
    private boolean myLogDirState = false;
    private boolean myLogGetState = false;
    private boolean myLogMdState = false;
    private boolean myLogPutState = false;
    private boolean myLogRdState = false;
    private boolean myLogRenState = false;
    private boolean myReadState = false;
    private boolean myWriteState = false;
    private OOCKeyword kwActive;
    private OOCKeyword kwReadDirs;
    private OOCKeyword kwCanRead;
    private OOCKeyword kwWriteDirs;
    private OOCKeyword kwCanWrite;
    private OOCKeyword kwLogString;
    private OOCKeyword kwIdleTimeout;
    private int myIdleTimeout;
    private static final String myReadDirDefault = new String("");
    private static final String myWriteDirDefault = new String("");
    private static final boolean myEnabledStateDefault = false;
    private static final boolean myLogAllStateDefault = false;
    private static final boolean myLogCdStateDefault = false;
    private static final boolean myLogDebugStateDefault = false;
    private static final boolean myLogDelStateDefault = false;
    private static final boolean myLogDirStateDefault = false;
    private static final boolean myLogGetStateDefault = false;
    private static final boolean myLogMdStateDefault = false;
    private static final boolean myLogPutStateDefault = false;
    private static final boolean myLogRdStateDefault = false;
    private static final boolean myLogRenStateDefault = false;
    private static final boolean myReadStateDefault = false;
    private static final boolean myWriteStateDefault = false;
    private static final int myIdleTimeoutDefault = 900;
    private boolean myTrace = Utility.isTraceOn();

    FtpAccess() {
        if (this.myTrace) {
            System.out.println("in FtpAccess constructor");
        }
        this.loadInit();
    }

    public FtpAccess(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING FtpAccess from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        if (this.myTrace) {
            System.out.println("in FtpAccess.clone()");
        }
        FtpAccess ftpAccess = new FtpAccess();
        if (this.myTrace) {
            System.out.println("(FtpAccess.clone) myReadDirectories = " + this.myReadDirectories);
            System.out.println("(FtpAccess.clone) myWriteDirectories = " + this.myWriteDirectories);
        }
        ftpAccess.setReadDirectories(new String(this.myReadDirectories));
        ftpAccess.setWriteDirectories(new String(this.myWriteDirectories));
        ftpAccess.setEnableUser(this.myEnabledState);
        ftpAccess.setLogCd(this.myLogCdState);
        ftpAccess.setLogAll(this.myLogAllState);
        ftpAccess.setLogDebug(this.myLogDebugState);
        ftpAccess.setLogDel(this.myLogDelState);
        ftpAccess.setLogDir(this.myLogDirState);
        ftpAccess.setLogGet(this.myLogGetState);
        ftpAccess.setLogMd(this.myLogMdState);
        ftpAccess.setLogPut(this.myLogPutState);
        ftpAccess.setLogRd(this.myLogRdState);
        ftpAccess.setLogRen(this.myLogRenState);
        ftpAccess.setRead(this.myReadState);
        ftpAccess.setWrite(this.myWriteState);
        ftpAccess.setIdleTimeout(this.myIdleTimeout);
        return ftpAccess;
    }

    public boolean getEnableUser() {
        return this.myEnabledState;
    }

    public int getIdleTimeout() {
        return this.myIdleTimeout;
    }

    public String getReadDirectories() {
        return this.myReadDirectories;
    }

    public String getWriteDirectories() {
        return this.myWriteDirectories;
    }

    public boolean isRead() {
        return this.myReadState;
    }

    public boolean isWrite() {
        return this.myWriteState;
    }

    public boolean isConfigured() {
        return this.myEnabledState || this.myLogAllState || this.myLogCdState || this.myLogDebugState || this.myLogDelState || this.myLogDirState || this.myLogGetState || this.myLogMdState || this.myLogPutState || this.myLogRdState || this.myLogRenState || this.myReadState || this.myWriteState || this.myIdleTimeout != 900;
    }

    public boolean isLogAll() {
        return this.myLogAllState;
    }

    public boolean isLogCd() {
        return this.myLogCdState;
    }

    public boolean isLogDebug() {
        return this.myLogDebugState;
    }

    public boolean isLogDel() {
        return this.myLogDelState;
    }

    public boolean isLogDir() {
        return this.myLogDirState;
    }

    public boolean isLogGet() {
        return this.myLogGetState;
    }

    public boolean isLogMd() {
        return this.myLogMdState;
    }

    public boolean isLogPut() {
        return this.myLogPutState;
    }

    public boolean isLogRd() {
        return this.myLogRdState;
    }

    public boolean isLogRen() {
        return this.myLogRenState;
    }

    private void loadInit() {
        this.myReadDirectories = myReadDirDefault;
        this.myWriteDirectories = myWriteDirDefault;
        this.myEnabledState = false;
        this.myLogCdState = false;
        this.myLogDebugState = false;
        this.myLogDelState = false;
        this.myLogDirState = false;
        this.myLogGetState = false;
        this.myLogMdState = false;
        this.myLogPutState = false;
        this.myLogRdState = false;
        this.myLogRenState = false;
        this.myReadState = false;
        this.myWriteState = false;
        this.myIdleTimeout = 900;
    }

    public void setEnableUser(boolean bl) {
        this.myEnabledState = bl;
    }

    public void setIdleTimeout(int n) {
        this.myIdleTimeout = n;
    }

    public void setLogCd(boolean bl) {
        this.myLogCdState = bl;
    }

    public void setLogAll(boolean bl) {
        this.myLogAllState = bl;
    }

    public void setLogDebug(boolean bl) {
        this.myLogDebugState = bl;
    }

    public void setLogDel(boolean bl) {
        this.myLogDelState = bl;
    }

    public void setLogDir(boolean bl) {
        this.myLogDirState = bl;
    }

    public void setLogGet(boolean bl) {
        this.myLogGetState = bl;
    }

    public void setLogMd(boolean bl) {
        this.myLogMdState = bl;
    }

    public void setLogPut(boolean bl) {
        this.myLogPutState = bl;
    }

    public void setLogRd(boolean bl) {
        this.myLogRdState = bl;
    }

    public void setLogRen(boolean bl) {
        this.myLogRenState = bl;
    }

    public void setRead(boolean bl) {
        this.myReadState = bl;
    }

    public void setWrite(boolean bl) {
        this.myWriteState = bl;
    }

    public void setReadDirectories(String string) {
        this.myReadDirectories = string;
    }

    public void setWriteDirectories(String string) {
        this.myWriteDirectories = string;
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myReadDirectories_tag)) {
                parsedObject = parsedVector.getElement(myReadDirectories_tag);
                string = (String)parsedObject.getValue();
                this.myReadDirectories = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myWriteDirectories_tag)) {
                parsedObject = parsedVector.getElement(myWriteDirectories_tag);
                string = (String)parsedObject.getValue();
                this.myWriteDirectories = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myEnabledState_tag)) {
                parsedObject = parsedVector.getElement(myEnabledState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myEnabledState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogAllState_tag)) {
                parsedObject = parsedVector.getElement(myLogAllState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogAllState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogCdState_tag)) {
                parsedObject = parsedVector.getElement(myLogCdState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogCdState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogDebugState_tag)) {
                parsedObject = parsedVector.getElement(myLogDebugState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogDebugState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogDelState_tag)) {
                parsedObject = parsedVector.getElement(myLogDelState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogDelState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogDirState_tag)) {
                parsedObject = parsedVector.getElement(myLogDirState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogDirState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogGetState_tag)) {
                parsedObject = parsedVector.getElement(myLogGetState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogGetState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogMdState_tag)) {
                parsedObject = parsedVector.getElement(myLogMdState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogMdState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogPutState_tag)) {
                parsedObject = parsedVector.getElement(myLogPutState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogPutState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogRdState_tag)) {
                parsedObject = parsedVector.getElement(myLogRdState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogRdState = n2 != 0;
                }
            } else if (stringArray[n].equals(myLogRenState_tag)) {
                parsedObject = parsedVector.getElement(myLogRenState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myLogRenState = n2 != 0;
                }
            } else if (stringArray[n].equals(myReadState_tag)) {
                parsedObject = parsedVector.getElement(myReadState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myReadState = n2 != 0;
                }
            } else if (stringArray[n].equals(myWriteState_tag)) {
                parsedObject = parsedVector.getElement(myWriteState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myWriteState = n2 != 0;
                }
            } else if (stringArray[n].equals(myIdleTimeout_tag) && (string = (String)(parsedObject = parsedVector.getElement(myIdleTimeout_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                this.myIdleTimeout = n2;
            }
            ++n;
        }
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in FtpAccess.toString() ");
        }
        StringBuffer stringBuffer = new StringBuffer(BFT_tag);
        stringBuffer.append("=start");
        stringBuffer.append("," + myReadDirectories_tag + "=" + this.myReadDirectories);
        stringBuffer.append("," + myWriteDirectories_tag + "=" + this.myWriteDirectories);
        if (this.myTrace) {
            System.out.println("myreaddirectories = " + this.myReadDirectories);
        }
        if (this.myEnabledState) {
            stringBuffer.append("," + myEnabledState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myEnabledState_tag + "=" + 0);
        }
        if (this.myLogAllState) {
            stringBuffer.append("," + myLogAllState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogAllState_tag + "=" + 0);
        }
        if (this.myLogCdState) {
            stringBuffer.append("," + myLogCdState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogCdState_tag + "=" + 0);
        }
        if (this.myLogDebugState) {
            stringBuffer.append("," + myLogDebugState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogDebugState_tag + "=" + 0);
        }
        if (this.myLogDelState) {
            stringBuffer.append("," + myLogDelState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogDelState_tag + "=" + 0);
        }
        if (this.myLogDirState) {
            stringBuffer.append("," + myLogDirState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogDirState_tag + "=" + 0);
        }
        if (this.myLogGetState) {
            stringBuffer.append("," + myLogGetState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogGetState_tag + "=" + 0);
        }
        if (this.myLogMdState) {
            stringBuffer.append("," + myLogMdState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogMdState_tag + "=" + 0);
        }
        if (this.myLogPutState) {
            stringBuffer.append("," + myLogPutState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogPutState_tag + "=" + 0);
        }
        if (this.myLogRdState) {
            stringBuffer.append("," + myLogRdState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogRdState_tag + "=" + 0);
        }
        if (this.myLogRenState) {
            stringBuffer.append("," + myLogRenState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myLogRenState_tag + "=" + 0);
        }
        if (this.myReadState) {
            stringBuffer.append("," + myReadState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myReadState_tag + "=" + 0);
        }
        if (this.myWriteState) {
            stringBuffer.append("," + myWriteState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myWriteState_tag + "=" + 0);
        }
        stringBuffer.append("," + myIdleTimeout_tag + "=" + this.myIdleTimeout);
        stringBuffer.append("," + EFT_tag);
        stringBuffer.append("=end");
        return stringBuffer.toString();
    }

    public void loadFtpAccessFromOOCS(OOCKeyword oOCKeyword) {
        String string;
        String string2 = oOCKeyword.getValueOf("active");
        this.myEnabledState = string2.equals("1");
        if (this.myTrace) {
            System.out.println("(FtpAccess.loadFtpAccessFromOOCS) myEnabledState = " + this.myEnabledState);
        }
        this.myReadDirectories = oOCKeyword.getValueOf("read");
        if (this.myTrace) {
            System.out.println("(FtpAccess.loadFtpAccessFromOOCS) myReadDirectories = " + this.myReadDirectories);
        }
        this.myReadState = !(string2 = oOCKeyword.getValueOf("canread")).equals("1");
        if (this.myTrace) {
            System.out.println("(FtpAccess.loadFtpAccessFromOOCS) myReadState = " + this.myReadState);
        }
        this.myWriteDirectories = oOCKeyword.getValueOf("write");
        if (this.myTrace) {
            System.out.println("(FtpAccess.loadFtpAccessFromOOCS) myWriteDirectories = " + this.myWriteDirectories);
        }
        this.myWriteState = !(string2 = oOCKeyword.getValueOf("canwrite")).equals("1");
        if (this.myTrace) {
            System.out.println("(FtpAccess.loadFtpAccessFromOOCS) myWriteState = " + this.myWriteState);
        }
        this.myLogString = oOCKeyword.getValueOf("log");
        if (this.myTrace) {
            System.out.println("(FtpAccess.loadFtpAccessFromOOCS) myLogString = " + this.myLogString);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.myLogString);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (this.myTrace) {
                System.out.println("(FtpAccess.loadFtpAccessFromOOCS) token = " + string);
            }
            if (string.equals("logall")) {
                this.myLogAllState = true;
                if (this.myTrace) {
                    System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogAll true");
                }
            }
            if (string.equals("logcd")) {
                this.myLogCdState = true;
                if (this.myTrace) {
                    System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogCdState true");
                }
            }
            if (string.equals("logdbg")) {
                this.myLogDebugState = true;
                if (this.myTrace) {
                    System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogDebugState true");
                }
            }
            if (string.equals("logdel")) {
                this.myLogDelState = true;
                if (this.myTrace) {
                    System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogDelState true");
                }
            }
            if (string.equals("logdir")) {
                this.myLogDirState = true;
                if (this.myTrace) {
                    System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogDirState true");
                }
            }
            if (string.equals("logget")) {
                this.myLogGetState = true;
                if (this.myTrace) {
                    System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogGetState true");
                }
            }
            if (string.equals("logmkd")) {
                this.myLogMdState = true;
                if (this.myTrace) {
                    System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogMdState true");
                }
            }
            if (string.equals("logput")) {
                this.myLogPutState = true;
                if (this.myTrace) {
                    System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogPutState true");
                }
            }
            if (string.equals("logrmd")) {
                this.myLogRdState = true;
                if (this.myTrace) {
                    System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogRdState true");
                }
            }
            if (!string.equals("logren")) continue;
            this.myLogRenState = true;
            if (!this.myTrace) continue;
            System.out.println("(FtpAccess.loadFtpAccessFromOOCS) Setting myLogRenState true");
        }
        string = oOCKeyword.getValueOf("idletimeout");
        this.myIdleTimeout = Utility.hasValue(string) ? Integer.parseInt(string) : 900;
        if (this.myTrace) {
            System.out.println("(FtpAccess.loadFtpAccessFromOOCS) myIdleTimeout = " + this.myIdleTimeout);
        }
    }

    public void saveFtpAccessToOOCS(OOCKeyword oOCKeyword, OOCKeyword oOCKeyword2) {
        if (this.myTrace) {
            System.out.println("***** in FtpAccess.saveFTPAccessToOOCS");
            System.out.println("(FtpAccess.saveFTPAccessToOOCS) kwFtpd = " + oOCKeyword2);
        }
        if (oOCKeyword2 == null) {
            oOCKeyword2 = oOCKeyword.createKeyword(0, "ftpd", "", null);
            if (this.myTrace) {
                System.out.println("(FtpAccess.saveFtpAccessToOOCS) created new FTPD keyword = " + oOCKeyword2);
            }
        }
        this.kwActive = this.kwActive == null ? oOCKeyword2.createKeyword(1, "active", "", null) : oOCKeyword2.get("active", "");
        if (this.myEnabledState) {
            this.kwActive.setValue("1");
        } else {
            this.kwActive.setValue("0");
        }
        if (this.myTrace) {
            System.out.println("(FtpAccess.saveFtpAccessToOOCS) myEnabledState = " + this.myEnabledState);
        }
        this.kwReadDirs = this.kwReadDirs == null ? oOCKeyword2.createKeyword(1, "read", this.myReadDirectories, null) : oOCKeyword2.get("read", "");
        this.kwReadDirs.setValue(this.myReadDirectories);
        if (this.myTrace) {
            System.out.println("(FtpAccess.saveFtpAccessToOOCS) myReadDirectories = " + this.myReadDirectories);
        }
        this.kwCanRead = this.kwCanRead == null ? oOCKeyword2.createKeyword(1, "canread", "", null) : oOCKeyword2.get("canread", "");
        if (this.myReadState) {
            this.kwCanRead.setValue("0");
        } else {
            this.kwCanRead.setValue("1");
        }
        if (this.myTrace) {
            System.out.println("(FtpAccess.saveFtpAccessToOOCS) myReadState = " + this.myReadState);
        }
        this.kwWriteDirs = this.kwWriteDirs == null ? oOCKeyword2.createKeyword(1, "write", this.myWriteDirectories, null) : oOCKeyword2.get("write", "");
        this.kwWriteDirs.setValue(this.myWriteDirectories);
        if (this.myTrace) {
            System.out.println("(FtpAccess.saveFtpAccessToOOCS) myWriteDirectories = " + this.myWriteDirectories);
        }
        this.kwCanWrite = this.kwCanWrite == null ? oOCKeyword2.createKeyword(1, "canwrite", "", null) : oOCKeyword2.get("canwrite", "");
        if (this.myWriteState) {
            this.kwCanWrite.setValue("0");
        } else {
            this.kwCanWrite.setValue("1");
        }
        if (this.myTrace) {
            System.out.println("(FtpAccess.saveFtpAccessToOOCS) myWriteState = " + this.myWriteState);
        }
        this.kwLogString = this.kwLogString == null ? oOCKeyword2.createKeyword(1, "log", "", null) : oOCKeyword2.get("log ", "");
        this.myLogString = new String();
        if (this.myLogAllState) {
            this.myLogString = String.valueOf(this.myLogString) + "logall ";
        }
        if (this.myTrace) {
            System.out.println("(FtpAccess.saveFtpAccessToOOCS) myLogAllState = " + this.myLogAllState);
        }
        if (this.myLogCdState) {
            this.myLogString = String.valueOf(this.myLogString) + "logcd ";
        }
        if (this.myLogDebugState) {
            this.myLogString = String.valueOf(this.myLogString) + "logdbg ";
        }
        if (this.myLogDelState) {
            this.myLogString = String.valueOf(this.myLogString) + "logdel ";
        }
        if (this.myLogDirState) {
            this.myLogString = String.valueOf(this.myLogString) + "logdir ";
        }
        if (this.myLogGetState) {
            this.myLogString = String.valueOf(this.myLogString) + "logget ";
        }
        if (this.myLogMdState) {
            this.myLogString = String.valueOf(this.myLogString) + "logmkd ";
        }
        if (this.myLogPutState) {
            this.myLogString = String.valueOf(this.myLogString) + "logput ";
        }
        if (this.myLogRdState) {
            this.myLogString = String.valueOf(this.myLogString) + "logrmd ";
        }
        if (this.myLogRenState) {
            this.myLogString = String.valueOf(this.myLogString) + "logren ";
        }
        this.kwLogString.setValue(this.myLogString);
        if (this.myTrace) {
            System.out.println("(FtpAccess.saveFtpAccessToOOCS) myLogString = " + this.myLogString);
        }
        this.kwIdleTimeout = this.kwIdleTimeout == null ? oOCKeyword2.createKeyword(1, "idletimeout", "900", null) : oOCKeyword2.get("idletimeout", "");
        String string = Integer.toString(this.myIdleTimeout);
        this.kwIdleTimeout.setValue(string);
        if (this.myTrace) {
            System.out.println("(FtpAccess.saveFtpAccessToOOCS) myIdleTimeout = " + this.myIdleTimeout);
        }
    }
}

