/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class HostsEntry
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BHO_tag = new String("Bho");
    public static final String EHO_tag = new String("Eho");
    public static final String myIPAddress_tag = new String("HoIp");
    public static final String myHostname_tag = new String("HoHn");
    public static final String myAlias_tag = new String("HoAl");
    public static final String myComment_tag = new String("HoCm");
    private String myIPAddress;
    private String myHostname;
    private String myAlias;
    private String myComment;
    private OOCKeyword kwHosts;
    private OOCKeyword kwIPAddress;
    private OOCKeyword kwHostname;
    private OOCKeyword kwAlias;
    private OOCKeyword kwComment;
    private boolean myTrace = Utility.isTraceOn();

    public HostsEntry() {
        if (this.myTrace) {
            System.out.println("in HostsEntry() constructor");
        }
        this.loadInit();
    }

    public HostsEntry(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING HostsEntry from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public HostsEntry(String string, String string2, String string3, String string4) {
        if (this.myTrace) {
            System.out.println("in HostsEntry constructor3");
        }
        this.myIPAddress = string;
        this.myHostname = string2;
        this.myAlias = string3;
        this.myComment = string4;
    }

    public String getIPAddress() {
        return this.myIPAddress;
    }

    public String getHostname() {
        return this.myHostname;
    }

    public String getAlias() {
        return this.myAlias;
    }

    public String getComment() {
        return this.myComment;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of HostsEntry");
        }
        this.myIPAddress = new String("");
        this.myHostname = new String("");
        this.myAlias = new String("");
        this.myComment = new String("");
    }

    public void setIPAddress(String string) {
        this.myIPAddress = string;
    }

    public void setHostname(String string) {
        this.myHostname = string;
    }

    public void setAlias(String string) {
        this.myAlias = string;
    }

    public void setComment(String string) {
        this.myComment = string;
    }

    public void loadHostsEntryFromOOCS(OOCKeyword oOCKeyword) {
        this.myIPAddress = oOCKeyword.getValueOf("ip_addr");
        if (this.myTrace) {
            System.out.println("(HostsEntry.loadHostsEntryFromOOCS) myIPAddress = " + this.myIPAddress);
        }
        this.myHostname = oOCKeyword.getValueOf("hostname");
        if (this.myTrace) {
            System.out.println("(HostsEntry.loadHostsEntryFromOOCS) myHostname = " + this.myHostname);
        }
        this.myAlias = oOCKeyword.getValueOf("aliases");
        if (this.myTrace) {
            System.out.println("(HostsEntry.loadHostsEntryFromOOCS) myAlias = " + this.myAlias);
        }
        this.myComment = oOCKeyword.getValueOf("comment");
        if (this.myTrace) {
            System.out.println("(HostsEntry.loadHostsEntryFromOOCS) myComment = " + this.myComment);
        }
    }

    public void saveHostsEntryToOOCS(OOCConfiguration oOCConfiguration, OOCKeyword oOCKeyword) {
        if (oOCKeyword != null) {
            this.kwIPAddress = oOCKeyword.get("ip_addr", "");
            if (NotebookData.hasValue(this.myIPAddress)) {
                this.kwIPAddress.setValue(this.myIPAddress);
            } else {
                oOCKeyword.deleteKeyword("ip_addr", "");
            }
            if (this.myTrace) {
                System.out.println("(HostsEntry.saveHostsEntryToOOCS) myIPAddress = " + this.myIPAddress);
            }
            this.kwHostname = oOCKeyword.get("hostname", "");
            if (NotebookData.hasValue(this.myHostname)) {
                this.kwHostname.setValue(this.myHostname);
            } else {
                oOCKeyword.deleteKeyword("hostname", "");
            }
            if (this.myTrace) {
                System.out.println("(HostsEntry.saveHostsEntryToOOCS) myHostname = " + this.myHostname);
            }
            this.kwAlias = oOCKeyword.get("aliases", "");
            if (NotebookData.hasValue(this.myAlias)) {
                this.kwAlias.setValue(this.myAlias);
            } else {
                oOCKeyword.deleteKeyword("aliases", "");
            }
            if (this.myTrace) {
                System.out.println("(HostsEntry.saveHostsEntryToOOCS) myAlias = " + this.myAlias);
            }
            this.kwComment = oOCKeyword.get("comment", "");
            if (NotebookData.hasValue(this.myComment)) {
                this.kwComment.setValue(this.myComment);
            } else {
                oOCKeyword.deleteKeyword("comment", "");
            }
            if (this.myTrace) {
                System.out.println("(HostsEntry.saveHostsEntryToOOCS) myComment = " + this.myComment);
                return;
            }
        } else {
            oOCKeyword = oOCConfiguration.createKeyword(0, "hosts", "", null);
            this.kwIPAddress = oOCKeyword.createKeyword(1, "ip_addr", "", null);
            this.kwIPAddress.setValue(this.myIPAddress);
            if (this.myTrace) {
                System.out.println("(HostsEntry.saveHostsEntryToOOCS) new myIPAddress = " + this.myIPAddress);
            }
            this.kwHostname = oOCKeyword.createKeyword(1, "hostname", "", null);
            this.kwHostname.setValue(this.myHostname);
            if (this.myTrace) {
                System.out.println("(HostsEntry.saveHostsEntryToOOCS) new myHostname = " + this.myHostname);
            }
            this.kwAlias = oOCKeyword.createKeyword(1, "aliases", "", null);
            this.kwAlias.setValue(this.myAlias);
            if (this.myTrace) {
                System.out.println("(HostsEntry.saveHostsEntryToOOCS) new myAlias = " + this.myAlias);
            }
            this.kwComment = oOCKeyword.createKeyword(1, "comment", "", null);
            this.kwComment.setValue(this.myComment);
            if (this.myTrace) {
                System.out.println("(HostsEntry.saveHostsEntryToOOCS) new myComment = " + this.myComment);
            }
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        if (this.myTrace) {
            System.out.println("HostsEntry.fromString() the num of keys is " + String.valueOf(stringArray.length));
        }
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            System.out.flush();
            if (stringArray[n].equals(myIPAddress_tag)) {
                parsedObject = parsedVector.getElement(myIPAddress_tag);
                string = (String)parsedObject.getValue();
                this.myIPAddress = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myHostname_tag)) {
                parsedObject = parsedVector.getElement(myHostname_tag);
                string = (String)parsedObject.getValue();
                this.myHostname = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myAlias_tag)) {
                parsedObject = parsedVector.getElement(myAlias_tag);
                string = (String)parsedObject.getValue();
                this.myAlias = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myComment_tag)) {
                parsedObject = parsedVector.getElement(myComment_tag);
                string = (String)parsedObject.getValue();
                this.myComment = string != null ? new String(string) : new String("");
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BHO_tag);
        if (this.myTrace) {
            System.out.println("in HostsEntry.toString()");
        }
        stringBuffer.append("," + myIPAddress_tag + "=" + this.myIPAddress);
        stringBuffer.append("," + myHostname_tag + "=" + this.myHostname);
        stringBuffer.append("," + myAlias_tag + "=" + this.myAlias);
        stringBuffer.append("," + myComment_tag + "=" + this.myComment);
        stringBuffer.append("," + EHO_tag);
        return stringBuffer.toString();
    }
}

