/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;

public class LanInterface
extends NotebookData
implements CloneableItem,
OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BLA_tag = new String("Bla");
    public static final String ELA_tag = new String("Ela");
    private static final String myDHCPState_tag = new String("DHCP_yn");
    private static final String myDDNSState_tag = new String("DDNS_yn");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private static final String myEnabledState_tag = new String("enab_yn");
    private static final String myAllrsState_tag = new String("allrs_yn");
    private static final String myArpState_tag = new String("arp_yn");
    private static final String myCanonicalState_tag = new String("canon_yn");
    private static final String myEthernetProtocolState_tag = new String("ether_yn");
    private static final String myICMPState_tag = new String("ICMP_yn");
    private static final String myManualState_tag = new String("manual_yn");
    private static final String mySupportState_tag = new String("support_yn");
    private static final String myFormatState_tag = new String("format_yn");
    private static final String myMobileState_tag = new String("mobile_yn");
    private static final String myEncapsulationState_tag = new String("encaps_yn");
    private static final String myInterface_tag = new String("interface");
    private static final String myIPaddress_tag = new String("ipaddr");
    private static final String mySubnetMask_tag = new String("subnet");
    private static final String myMetric_tag = new String("metric");
    private static final String myMTU_tag = new String("MTU");
    private static final String myBroadcastAddr_tag = new String("broadAddr");
    private static final String myDestinationAddr_tag = new String("destAddr");
    private OOCKeyword kwLanInterface;
    private OOCKeyword kwLoopbackInterface;
    private OOCKeyword kwInterfaceNum;
    private OOCKeyword kwEnableInterface;
    private OOCKeyword kwEnableDHCPInterface;
    private OOCKeyword kwAutoDHCP;
    private OOCKeyword kwDHCPMobile;
    private OOCKeyword kwDHCPCDMobile;
    private OOCKeyword kwUseDDNS;
    private OOCKeyword kwUpdateDNS;
    private OOCKeyword kwIPaddress;
    private OOCKeyword kwSubnetMask;
    private OOCKeyword kwBroadcastAddr;
    private OOCKeyword kwDestinationAddr;
    private OOCKeyword kwMetricCount;
    private OOCKeyword kwMTUSize;
    private OOCKeyword kwEnableAllRoutesBroadcast;
    private OOCKeyword kwDHCPEnableAllRoutesBroadcast;
    private OOCKeyword kwDisableArpMapping;
    private OOCKeyword kwDHCPDisableArpMapping;
    private OOCKeyword kwAddRoutesICMPRedirects;
    private OOCKeyword kwDHCPAddRoutesICMPRedirects;
    private OOCKeyword kwDisableSnapFormatHeaders;
    private OOCKeyword kwDHCPDisableSnapFormatHeaders;
    private OOCKeyword kwDisableRoutingFieldSupport;
    private OOCKeyword kwDHCPDisableRoutingFieldSupport;
    private OOCKeyword kwEnableTrailerEncapsulation;
    private OOCKeyword kwDHCPEnableTrailerEncapsulation;
    private OOCKeyword kwEnable802Protocol;
    private OOCKeyword kwDHCPEnable802Protocol;
    private OOCKeyword kwCanonicalFormat;
    private OOCKeyword kwDHCPCanonicalFormat;
    private OOCKeyword kwLoopbackEnableInterface;
    private OOCKeyword kwLoopbackIPAddr;
    private OOCKeyword kwDHCPInterface;
    private OOCKeyword kwUseDNSEnabled;
    private String myInterface;
    private String myIPaddress;
    private String mySubnetMask;
    private String myInterfaceNum;
    private String myEnableInterface = "N";
    private String myAutoDHCP = "N";
    private String myBroadcastAddr;
    private String myDestinationAddr;
    private String myMetricCount;
    private String myMTUSize;
    private String myEnableAllRoutesBroadcast;
    private String myDisableArpMapping;
    private String myAddRoutesICMPRedirects;
    private String myDisableSnapFormatHeaders;
    private String myDisableRoutingFieldSupport;
    private String myEnableTrailerEncapsulation;
    private String myEnable802Protocol;
    private String myCanonicalFormat;
    private boolean myDHCPState = false;
    private boolean myMobileState = true;
    private boolean myDDNSState = false;
    private boolean myEnabledState = false;
    private boolean myAllrsState = false;
    private boolean myArpState = false;
    private boolean myCanonicalState = false;
    private boolean myEthernetProtocolState = false;
    private boolean myICMPState = false;
    private boolean myManualState = true;
    private boolean mySupportState = false;
    private boolean myFormatState = false;
    private boolean myEncapsulationState = false;
    private int myMetric;
    private int myMTU;
    private NativeData myNativeData;
    private boolean myTrace = Utility.isTraceOn();

    LanInterface() {
        if (this.myTrace) {
            System.out.println("in LanInterface() constructor");
        }
        this.loadInit();
    }

    public LanInterface(String string) {
        if (this.myTrace) {
            System.out.println("in LanInterface() constructor2");
        }
        this.loadInit();
        this.myInterface = string;
    }

    public LanInterface(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING LanInterface from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        LanInterface lanInterface = new LanInterface(new String(this.myInterface));
        lanInterface.setAllrsEnabled(this.myAllrsState);
        lanInterface.setArpDisabled(this.myArpState);
        lanInterface.setCanonical(this.myCanonicalState);
        lanInterface.setEnabled(this.myEnabledState);
        lanInterface.setEthernetProtocolEnabled(this.myEthernetProtocolState);
        lanInterface.setICMP(this.myICMPState);
        lanInterface.setManual(this.myManualState);
        lanInterface.setIPaddress(new String(this.myIPaddress));
        lanInterface.setMetric(this.myMetric);
        lanInterface.setMTU(this.myMTU);
        lanInterface.setRoutingFieldSupportDisabled(this.mySupportState);
        lanInterface.setSendingSnapFormatDisabled(this.myFormatState);
        lanInterface.setMobile(this.myMobileState);
        lanInterface.setSubnetMask(new String(this.mySubnetMask));
        lanInterface.setUsingDDNS(this.myDDNSState);
        lanInterface.setUsingDHCP(this.myDHCPState);
        lanInterface.setTrailerEncapsulationEnabled(this.myEncapsulationState);
        lanInterface.setBroadcastAddr(this.myBroadcastAddr);
        lanInterface.setDestinationAddr(this.myDestinationAddr);
        return lanInterface;
    }

    public String getBroadcastAddr() {
        return this.myBroadcastAddr;
    }

    public String getDestinationAddr() {
        return this.myDestinationAddr;
    }

    public String getIPaddress() {
        return this.myIPaddress;
    }

    public String getInterfaceName() {
        return this.myInterface;
    }

    public int getMetric() {
        return this.myMetric;
    }

    public int getMTU() {
        return this.myMTU;
    }

    public String getSubnetMask() {
        return this.mySubnetMask;
    }

    public boolean isEnabled() {
        return this.myEnabledState;
    }

    public boolean isAllrsEnabled() {
        return this.myAllrsState;
    }

    public boolean isArpDisabled() {
        return this.myArpState;
    }

    public boolean isCanonical() {
        return this.myCanonicalState;
    }

    public boolean isEthernetProtocolEnabled() {
        return this.myEthernetProtocolState;
    }

    public boolean isICMP() {
        return this.myICMPState;
    }

    public boolean isManual() {
        return this.myManualState;
    }

    public boolean isMobile() {
        return this.myMobileState;
    }

    public boolean isRoutingFieldSupportDisabled() {
        return this.mySupportState;
    }

    public boolean isSendingSnapFormatDisabled() {
        return this.myFormatState;
    }

    public boolean isTrailerEncapsulationEnabled() {
        return this.myEncapsulationState;
    }

    public boolean isUsingDDNS() {
        return this.myDDNSState;
    }

    public boolean isUsingDHCP() {
        return this.myDHCPState;
    }

    private void loadInit() {
        this.myDHCPState = false;
        this.myDDNSState = false;
        this.myEnabledState = false;
        this.myAllrsState = false;
        this.myArpState = false;
        this.myCanonicalState = false;
        this.myEthernetProtocolState = false;
        this.myICMPState = false;
        this.myManualState = true;
        this.mySupportState = false;
        this.myFormatState = false;
        this.myMobileState = true;
        this.myEncapsulationState = false;
        this.myInterface = new String("");
        this.myIPaddress = new String("");
        this.mySubnetMask = new String("");
        this.myBroadcastAddr = new String("");
        this.myDestinationAddr = new String("");
        this.myMetric = 1;
        this.myMTU = 1500;
    }

    public void setAllrsEnabled(boolean bl) {
        this.myAllrsState = bl;
    }

    public void setArpDisabled(boolean bl) {
        this.myArpState = bl;
    }

    public void setBroadcastAddr(String string) {
        this.myBroadcastAddr = string;
    }

    public void setDestinationAddr(String string) {
        this.myDestinationAddr = string;
    }

    public void setCanonical(boolean bl) {
        this.myCanonicalState = bl;
    }

    public void setEnabled(boolean bl) {
        this.myEnabledState = bl;
    }

    public void setEthernetProtocolEnabled(boolean bl) {
        this.myEthernetProtocolState = bl;
    }

    public void setICMP(boolean bl) {
        this.myICMPState = bl;
    }

    public void setIPaddress(String string) {
        this.myIPaddress = string;
    }

    public void setManual(boolean bl) {
        this.myManualState = bl;
    }

    public void setMetric(int n) {
        this.myMetric = n;
    }

    public void setMobile(boolean bl) {
        this.myMobileState = bl;
    }

    public void setMTU(int n) {
        this.myMTU = n;
    }

    public void setRoutingFieldSupportDisabled(boolean bl) {
        this.mySupportState = bl;
    }

    public void setSendingSnapFormatDisabled(boolean bl) {
        this.myFormatState = bl;
    }

    public void setSubnetMask(String string) {
        this.mySubnetMask = string;
    }

    public void setUsingDDNS(boolean bl) {
        this.myDDNSState = bl;
    }

    public void setUsingDHCP(boolean bl) {
        this.myDHCPState = bl;
    }

    public void setTrailerEncapsulationEnabled(boolean bl) {
        this.myEncapsulationState = bl;
    }

    public void loadLoopbackInterfaceFromOOCS(OOCKeyword oOCKeyword) {
        if (this.myTrace) {
            System.out.println("(LanInterface.loadLoopbackInterfaceFromOOCS) .....just entered");
        }
        this.myEnableInterface = oOCKeyword.getValueOf("enable_interface");
        if (!NotebookData.hasValue(this.myEnableInterface)) {
            this.kwEnableInterface = oOCKeyword.createKeyword(1, "enable_interface", "", null);
            this.myEnableInterface = "Y";
        }
        if (this.myEnableInterface.equals("Y")) {
            this.myEnabledState = true;
            this.myIPaddress = oOCKeyword.getValueOf("ip_addr");
            this.mySubnetMask = oOCKeyword.getValueOf("netmask");
        } else {
            this.myEnabledState = false;
            this.myIPaddress = oOCKeyword.getValueOf("ip_addr");
            this.mySubnetMask = oOCKeyword.getValueOf("netmask");
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.loadLoopbackInterfaceFromOOCS) myEnabledState = " + this.myEnabledState);
            System.out.println("(LanInterface.loadLoopbackInterfaceFromOOCS) myIPaddress = " + this.myIPaddress);
            System.out.println("(LanInterface.loadLoopbackInterfaceFromOOCS) mySubnetMask = " + this.mySubnetMask);
        }
    }

    public void loadInterfaceFromOOCS(OOCKeyword oOCKeyword, OOCKeyword oOCKeyword2, boolean bl, boolean bl2) {
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) .....just entered");
        }
        this.myInterfaceNum = oOCKeyword.getValueOf("interface_num");
        if (this.myTrace) {
            System.out.println("***************(LanInterface.loadFromOOCS) myInterfaceNum = " + this.myInterfaceNum);
        }
        this.myEnableInterface = oOCKeyword.getValueOf("enable_interface");
        this.myEnabledState = this.myEnableInterface.equals("Y");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myEnableInterface = " + this.myEnableInterface);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myEnabledState = " + this.myEnabledState);
        }
        this.myAutoDHCP = oOCKeyword.getValueOf("auto_dhcp");
        if (!NotebookData.hasValue(this.myAutoDHCP)) {
            this.kwAutoDHCP = oOCKeyword.createKeyword(1, "auto_dhcp", "", null);
            this.myAutoDHCP = "N";
        }
        if (this.myAutoDHCP.equals("N")) {
            this.myManualState = true;
            this.myDHCPState = false;
        } else {
            this.myManualState = false;
            this.myDHCPState = true;
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myAutoDHCP = " + this.myAutoDHCP);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myDHCPState = " + this.myDHCPState);
        }
        this.myDDNSState = bl && this.myDHCPState;
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myDDNSState = " + this.myDDNSState);
        }
        this.myMobileState = bl2;
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myMobileState = " + this.myMobileState);
        }
        this.myIPaddress = oOCKeyword.getValueOf("ip_addr");
        if (!TcpipValidation.IsValidTcpipAddr((String)this.myIPaddress)) {
            if (this.myTrace) {
                System.out.println("Bad IP Address found making it Null string");
            }
            this.myIPaddress = "";
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myIPaddress = " + this.myIPaddress);
        }
        this.mySubnetMask = oOCKeyword.getValueOf("netmask");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) mySubnetMask = " + this.mySubnetMask);
        }
        if (this.myDHCPState) {
            this.myBroadcastAddr = oOCKeyword2.getValueOf("broadcast_address");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) DHCP broadcast address = " + this.myBroadcastAddr);
            }
        } else {
            this.myBroadcastAddr = oOCKeyword.getValueOf("broadcast_address");
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myBroadcastAddr = " + this.myBroadcastAddr);
        }
        this.myDestinationAddr = oOCKeyword.getValueOf("destination");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myDestinationAddr = " + this.myDestinationAddr);
        }
        if (this.myDHCPState) {
            this.myMetricCount = oOCKeyword2.getValueOf("metric_count");
            if (NotebookData.hasValue(this.myMetricCount)) {
                this.myMetric = Integer.parseInt(this.myMetricCount);
            }
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) DHCP metric count = " + this.myMetricCount);
            }
        } else {
            this.myMetricCount = oOCKeyword.getValueOf("metric_count");
        }
        if (NotebookData.hasValue(this.myMetricCount)) {
            this.myMetric = Integer.parseInt(this.myMetricCount);
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myMetric = " + this.myMetric);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myMetricCount = " + this.myMetricCount);
        }
        if (this.myDHCPState) {
            this.myMTUSize = oOCKeyword2.getValueOf("mtu_size");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) DHCP mtu size = " + this.myMTUSize);
            }
        } else {
            this.myMTUSize = oOCKeyword.getValueOf("mtu_size");
        }
        if (NotebookData.hasValue(this.myMTUSize)) {
            this.myMTU = Integer.parseInt(this.myMTUSize);
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myMTU = " + this.myMTU);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myMTUSize = " + this.myMTUSize);
        }
        if (this.myDHCPState) {
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) kwDHCPInterface =" + oOCKeyword2);
            }
            this.myEnableAllRoutesBroadcast = oOCKeyword2.getValueOf("enable_all_routes_broadcast");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) DHCP allrs = " + this.myEnableAllRoutesBroadcast);
            }
        } else {
            this.myEnableAllRoutesBroadcast = oOCKeyword.getValueOf("enable_all_routes_broadcast");
        }
        this.myAllrsState = this.myEnableAllRoutesBroadcast.equals("Y");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myEnableAllRoutesBroadcast = " + this.myEnableAllRoutesBroadcast);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myAllrsState = " + this.myAllrsState);
        }
        if (this.myDHCPState) {
            this.myDisableArpMapping = oOCKeyword2.getValueOf("disable_arp_mapping");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) Setting arp from DHCP");
            }
        } else {
            this.myDisableArpMapping = oOCKeyword.getValueOf("disable_arp_mapping");
        }
        this.myArpState = this.myDisableArpMapping.equals("Y");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myDisableArpMapping = " + this.myDisableArpMapping);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myArpState = " + this.myArpState);
        }
        if (this.myDHCPState) {
            this.myAddRoutesICMPRedirects = oOCKeyword2.getValueOf("add_routes_icmp_redirects");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) Setting icmpred from DHCP");
            }
        } else {
            this.myAddRoutesICMPRedirects = oOCKeyword.getValueOf("add_routes_icmp_redirects");
        }
        this.myICMPState = this.myAddRoutesICMPRedirects.equals("Y");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myAddRoutesICMPRedirects = " + this.myAddRoutesICMPRedirects);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myICMPState = " + this.myICMPState);
        }
        if (this.myDHCPState) {
            this.myDisableSnapFormatHeaders = oOCKeyword2.getValueOf("disable_snap_format_headers");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) Setting snap from DHCP");
            }
        } else {
            this.myDisableSnapFormatHeaders = oOCKeyword.getValueOf("disable_snap_format_headers");
        }
        this.myFormatState = this.myDisableSnapFormatHeaders.equals("Y");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myDisableSnapFormatHeaders = " + this.myDisableSnapFormatHeaders);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myFormatState = " + this.myFormatState);
        }
        if (this.myDHCPState) {
            this.myDisableRoutingFieldSupport = oOCKeyword2.getValueOf("disable_routing_field_support");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) Setting bridge from DHCP");
            }
        } else {
            this.myDisableRoutingFieldSupport = oOCKeyword.getValueOf("disable_routing_field_support");
        }
        this.mySupportState = this.myDisableRoutingFieldSupport.equals("Y");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myDisableRoutingFieldSupport = " + this.myDisableRoutingFieldSupport);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) mySupportState = " + this.mySupportState);
        }
        if (this.myDHCPState) {
            this.myEnableTrailerEncapsulation = oOCKeyword2.getValueOf("enable_trailer_encapsulation");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) Setting trailers from DHCP");
            }
        } else {
            this.myEnableTrailerEncapsulation = oOCKeyword.getValueOf("enable_trailer_encapsulation");
        }
        this.myEncapsulationState = this.myEnableTrailerEncapsulation.equals("Y");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myEnableTrailerEncapsulation = " + this.myEnableTrailerEncapsulation);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myEncapsulationState = " + this.myEncapsulationState);
        }
        if (this.myDHCPState) {
            this.myEnable802Protocol = oOCKeyword2.getValueOf("enable_802.3_protocol");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) Setting 802.3 from DHCP");
            }
        } else {
            this.myEnable802Protocol = oOCKeyword.getValueOf("enable_802.3_protocol");
        }
        this.myEthernetProtocolState = this.myEnable802Protocol.equals("Y");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myEnable802Protocol = " + this.myEnable802Protocol);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myEthernetProtocolState = " + this.myEthernetProtocolState);
        }
        if (this.myDHCPState) {
            this.myCanonicalFormat = oOCKeyword2.getValueOf("canonical_format");
            if (this.myTrace) {
                System.out.println("(LanInterface.loadInterfaceFromOOCS) Setting canonical from DHCP");
            }
        } else {
            this.myCanonicalFormat = oOCKeyword.getValueOf("canonical_format");
        }
        this.myCanonicalState = this.myCanonicalFormat.equals("Y");
        if (this.myTrace) {
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myCanonicalFormat = " + this.myCanonicalFormat);
            System.out.println("(LanInterface.loadInterfaceFromOOCS) myCanonicalState = " + this.myCanonicalState);
        }
    }

    public void saveLoopbackInterfaceToOOCS(OOCKeyword oOCKeyword) {
        if (this.myTrace) {
            System.out.println("(LanInterface.saveLoopbackInterfaceFromOOCS) .....just entered");
        }
        this.kwEnableInterface = oOCKeyword.get("enable_interface", "");
        if (this.myEnabledState) {
            this.kwEnableInterface.setValue("Y");
        } else {
            this.kwEnableInterface.setValue("N");
        }
        this.kwIPaddress = oOCKeyword.get("ip_addr", "");
        this.kwIPaddress.setValue(this.myIPaddress);
        if (NotebookData.hasValue(this.mySubnetMask)) {
            this.kwSubnetMask = oOCKeyword.get("netmask", "");
            if (this.kwSubnetMask == null) {
                this.kwSubnetMask = oOCKeyword.createKeyword(1, "netmask", "", null);
            }
            this.kwSubnetMask.setValue(this.mySubnetMask);
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.loadLoopbackInterfaceFromOOCS) myEnabledState = " + this.myEnabledState);
            System.out.println("(LanInterface.loadLoopbackInterfaceFromOOCS) myIPaddress = " + this.myIPaddress);
            System.out.println("(LanInterface.loadLoopbackInterfaceFromOOCS) mySubnetMask = " + this.mySubnetMask);
        }
    }

    public void saveInterfaceToOOCS(OOCConfiguration oOCConfiguration, OOCKeyword oOCKeyword, OOCKeyword oOCKeyword2, LanInterface lanInterface, boolean bl, boolean bl2) {
        String string;
        if (this.myTrace) {
            System.out.println("****** in LanInterface.saveInterfaceToOOCS");
        }
        this.myInterfaceNum = oOCKeyword.getValueOf("interface_num");
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myInterfaceNum = " + this.myInterfaceNum);
        }
        this.kwAutoDHCP = oOCKeyword.get("auto_dhcp", "");
        if (this.myDHCPState) {
            if (this.kwAutoDHCP == null) {
                this.kwAutoDHCP = oOCKeyword.createKeyword(1, "auto_dhcp", "", null);
            }
            this.kwAutoDHCP.setValue("Y");
            string = oOCKeyword.getValueOf("auto_dhcp");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) value of kwAutoDHCP = " + string);
            }
            this.kwInterfaceNum = oOCKeyword2.get("interface_num", "");
            if (this.kwInterfaceNum == null) {
                this.kwInterfaceNum = oOCKeyword2.createKeyword(1, "interface_num", "", null);
            }
            this.kwInterfaceNum.setValue(this.myInterfaceNum);
        } else {
            if (this.kwAutoDHCP == null) {
                this.kwAutoDHCP = oOCKeyword.createKeyword(1, "auto_dhcp", "", null);
            }
            this.kwAutoDHCP.setValue("N");
            string = oOCKeyword.getValueOf("auto_dhcp");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) value of kwAutoDHCP = " + string);
            }
            this.kwInterfaceNum = oOCKeyword2.get("interface_num", "");
            if (this.kwInterfaceNum == null) {
                this.kwInterfaceNum = oOCKeyword2.createKeyword(1, "interface_num", "", null);
            }
            this.kwInterfaceNum.setValue(this.myInterfaceNum);
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myDHCPState = " + this.myDHCPState);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myAutoDHCP = " + this.myAutoDHCP);
        }
        this.kwEnableInterface = oOCKeyword.get("enable_interface", "");
        if (this.kwEnableInterface == null) {
            this.kwEnableInterface = oOCKeyword.createKeyword(1, "enable_interface", "", null);
        }
        if (this.myEnabledState) {
            this.kwEnableInterface.setValue("Y");
        } else {
            this.kwEnableInterface.setValue("N");
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myEnabledState = " + this.myEnabledState);
        }
        this.kwDHCPMobile = oOCKeyword2.get("dhcp_mobile", "");
        if (this.kwDHCPMobile == null) {
            this.kwDHCPMobile = oOCKeyword2.createKeyword(1, "dhcp_mobile", "", null);
        }
        if (this.myMobileState) {
            this.kwDHCPMobile.setValue("Y");
        } else {
            this.kwDHCPMobile.setValue("N");
        }
        string = oOCKeyword2.getValueOf("dhcp_mobile");
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myMobileState = " + this.myMobileState);
            System.out.println("(LanInterface.saveInterfaceToOOCS) value stored in kwDHCPMobile = " + string);
        }
        if (this.myDDNSState) {
            this.kwUpdateDNS = oOCConfiguration.get("update_dns", "");
            if (this.kwUpdateDNS == null) {
                this.kwUpdateDNS = oOCConfiguration.createKeyword(0, "update_dns", "", null);
            }
            this.kwUseDNSEnabled = this.kwUpdateDNS.get("enabled", "");
            if (this.kwUseDNSEnabled == null) {
                this.kwUseDNSEnabled = this.kwUpdateDNS.createKeyword(1, "enabled", "", null);
            }
            this.kwUseDNSEnabled.setValue("Y");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) kwUseDDNS (before get) = " + this.kwUseDDNS);
            }
            this.kwUseDDNS = oOCKeyword.get("update_dns", "");
            string = oOCKeyword.getValueOf("update_dns");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) value stored in kwUseDDNS before create = " + string);
                System.out.println("(LanInterface.saveInterfaceToOOCS) kwUseDDNS (after get) = " + this.kwUseDDNS);
            }
            if (this.kwUseDDNS == null) {
                this.kwUseDDNS = oOCKeyword.createKeyword(1, "update_dns", "", null);
            }
            string = oOCKeyword.getValueOf("update_dns");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) value stored in kwUseDDNS after create = " + string);
            }
            this.kwUseDDNS.setValue("Y");
        } else if (!this.myDDNSState) {
            this.kwUpdateDNS = oOCConfiguration.get("update_dns", "");
            if (this.kwUpdateDNS == null) {
                this.kwUpdateDNS = oOCConfiguration.createKeyword(0, "update_dns", "", null);
            }
            this.kwUseDNSEnabled = this.kwUpdateDNS.get("enabled", "");
            if (this.kwUseDNSEnabled == null) {
                this.kwUseDNSEnabled = this.kwUpdateDNS.createKeyword(1, "enabled", "", null);
            }
            this.kwUseDNSEnabled.setValue("N");
            this.kwUseDDNS = oOCKeyword.get("update_dns", "");
            if (this.kwUseDDNS == null) {
                this.kwUseDDNS = oOCKeyword.createKeyword(1, "update_dns", "", null);
            }
            this.kwUseDDNS.setValue("N");
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myDDNSState = " + this.myDDNSState);
        }
        this.kwIPaddress = oOCKeyword.get("ip_addr", "");
        if (NotebookData.hasValue(this.myIPaddress)) {
            if (this.kwIPaddress == null) {
                this.kwIPaddress = oOCKeyword.createKeyword(1, "ip_addr", "", null);
            }
            this.kwIPaddress.setValue(this.myIPaddress);
        } else {
            oOCKeyword.deleteKeyword("ip_addr", "");
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myIPaddress = " + this.myIPaddress);
        }
        this.kwSubnetMask = oOCKeyword.get("netmask", "");
        if (this.kwSubnetMask == null) {
            this.kwSubnetMask = oOCKeyword.createKeyword(1, "netmask", "", null);
        }
        if (NotebookData.hasValue(this.mySubnetMask)) {
            this.kwSubnetMask.setValue(this.mySubnetMask);
        } else {
            oOCKeyword.deleteKeyword("netmask", "");
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) mySubnetMask = " + this.mySubnetMask);
        }
        if (NotebookData.hasValue(this.myBroadcastAddr)) {
            if (this.myDHCPState) {
                this.kwBroadcastAddr = oOCKeyword2.get("broadcast_address", "");
                if (this.kwBroadcastAddr == null) {
                    this.kwBroadcastAddr = oOCKeyword2.createKeyword(1, "broadcast_address", "", null);
                }
                this.kwBroadcastAddr.setValue(this.myBroadcastAddr);
                oOCKeyword.deleteKeyword("broadcast_address", "");
                if (this.myTrace) {
                    System.out.println("(LanInterface.saveInterfaceToOOCS) Setting broadcast address in dhcpcd.cfg");
                }
            } else {
                this.kwBroadcastAddr = oOCKeyword.get("broadcast_address", "");
                if (this.kwBroadcastAddr == null) {
                    this.kwBroadcastAddr = oOCKeyword.createKeyword(1, "broadcast_address", "", null);
                }
                this.kwBroadcastAddr.setValue(this.myBroadcastAddr);
                oOCKeyword2.deleteKeyword("broadcast_address", "");
                if (this.myTrace) {
                    System.out.println("(LanInterface.saveInterfaceToOOCS) Setting broadcast address in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("broadcast_address", "");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) Deleting broadcast address from dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("broadcast_address", "");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) Deleting broadcast address from setup.cmd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myBroadcastAddr = " + this.myBroadcastAddr);
        }
        if (NotebookData.hasValue(this.myDestinationAddr) && !this.myDHCPState) {
            this.kwDestinationAddr = oOCKeyword.get("destination", "");
            if (this.kwDestinationAddr == null) {
                this.kwDestinationAddr = oOCKeyword.createKeyword(1, "destination", "", null);
            }
            this.kwDestinationAddr.setValue(this.myDestinationAddr);
        } else {
            oOCKeyword.deleteKeyword("destination", "");
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myDestinationAddr = " + this.myDestinationAddr);
        }
        this.myMetricCount = Integer.toString(this.myMetric);
        if (this.myMetric >= 1) {
            if (this.myDHCPState) {
                this.kwMetricCount = oOCKeyword2.get("metric_count", "");
                if (this.kwMetricCount == null) {
                    this.kwMetricCount = oOCKeyword2.createKeyword(1, "metric_count", "", null);
                }
                this.kwMetricCount.setValue(this.myMetricCount);
                oOCKeyword.deleteKeyword("metric_count", "");
                if (this.myTrace) {
                    System.out.println("(LanInterface.saveInterfaceToOOCS) Setting metric count in dhcpcd.cfg");
                }
            } else {
                this.kwMetricCount = oOCKeyword.get("metric_count", "");
                if (this.kwMetricCount == null) {
                    this.kwMetricCount = oOCKeyword.createKeyword(1, "metric_count", "", null);
                }
                this.kwMetricCount.setValue(this.myMetricCount);
                oOCKeyword2.deleteKeyword("metric_count", "");
                if (this.myTrace) {
                    System.out.println("(LanInterface.saveInterfaceToOOCS) Setting metric count in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("metric_count", "");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) Deleting metric count from dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("metric_count", "");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) Deleting metric count from setup.cmd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myMetricCount = " + this.myMetricCount);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myMetric = " + this.myMetric);
        }
        this.myMTUSize = Integer.toString(this.myMTU);
        if (this.myMTU >= 1) {
            if (this.myDHCPState) {
                this.kwMTUSize = oOCKeyword2.get("mtu_size", "");
                if (this.kwMTUSize == null) {
                    this.kwMTUSize = oOCKeyword2.createKeyword(1, "mtu_size", "", null);
                }
                this.kwMTUSize.setValue(this.myMTUSize);
                oOCKeyword.deleteKeyword("mtu_size", "");
                if (this.myTrace) {
                    System.out.println("(LanInterface.saveInterfaceToOOCS) Setting mtu in dhcpcd.cfg");
                }
            } else {
                this.kwMTUSize = oOCKeyword.get("mtu_size", "");
                if (this.kwMTUSize == null) {
                    this.kwMTUSize = oOCKeyword.createKeyword(1, "mtu_size", "", null);
                }
                this.kwMTUSize.setValue(this.myMTUSize);
                oOCKeyword2.deleteKeyword("mtu_size", "");
                if (this.myTrace) {
                    System.out.println("(LanInterface.saveInterfaceToOOCS) Setting mtu in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("mtu_size", "");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) Deleting mtu from dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("mtu_size", "");
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) Deleting mtu from setup.cmd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myMTU = " + this.myMTU);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myMTUSize = " + this.myMTUSize);
        }
        if (this.myAllrsState) {
            if (this.myDHCPState) {
                this.kwDHCPEnableAllRoutesBroadcast = oOCKeyword2.get("enable_all_routes_broadcast", "");
                if (this.kwDHCPEnableAllRoutesBroadcast == null) {
                    this.kwDHCPEnableAllRoutesBroadcast = oOCKeyword2.createKeyword(1, "enable_all_routes_broadcast", "", null);
                }
                this.kwDHCPEnableAllRoutesBroadcast.setValue("Y");
                oOCKeyword.deleteKeyword("enable_all_routes_broadcast", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting allrs in dhcpcd.cfg");
                }
            } else {
                this.kwEnableAllRoutesBroadcast = oOCKeyword.get("enable_all_routes_broadcast", "");
                if (this.kwEnableAllRoutesBroadcast == null) {
                    this.kwEnableAllRoutesBroadcast = oOCKeyword.createKeyword(1, "enable_all_routes_broadcast", "", null);
                }
                this.kwEnableAllRoutesBroadcast.setValue("Y");
                oOCKeyword2.deleteKeyword("enable_all_routes_broadcast", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting allrs in setup.cmd");
                }
            }
        } else {
            if (this.myDHCPState) {
                oOCKeyword2.deleteKeyword("enable_all_routes_broadcast", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Deleting allrs from dhcpcd.cfg");
                }
            } else {
                oOCKeyword.deleteKeyword("enable_all_routes_broadcast", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Deleting allrs from setup.cmd");
                }
            }
            if (this.myTrace) {
                System.out.println("(LanInterface.saveInterfaceToOOCS) myAllrsState = " + this.myAllrsState);
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myEnableAllRoutesBroadcast = " + this.myEnableAllRoutesBroadcast);
        }
        if (this.myArpState) {
            if (this.myDHCPState) {
                this.kwDHCPDisableArpMapping = oOCKeyword2.get("disable_arp_mapping", "");
                if (this.kwDHCPDisableArpMapping == null) {
                    this.kwDHCPDisableArpMapping = oOCKeyword2.createKeyword(1, "disable_arp_mapping", "", null);
                }
                this.kwDHCPDisableArpMapping.setValue("Y");
                oOCKeyword.deleteKeyword("disable_arp_mapping", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting arp in dhcpcd.cfg");
                }
            } else {
                this.kwDisableArpMapping = oOCKeyword.get("disable_arp_mapping", "");
                if (this.kwDisableArpMapping == null) {
                    this.kwDisableArpMapping = oOCKeyword.createKeyword(1, "disable_arp_mapping", "", null);
                }
                this.kwDisableArpMapping.setValue("Y");
                oOCKeyword2.deleteKeyword("disable_arp_mapping", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting arp in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("disable_arp_mapping", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting arp from dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("disable_arp_mapping", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting arp from setup.cmd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myArpState = " + this.myArpState);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myDisableArpMapping = " + this.myDisableArpMapping);
        }
        if (this.myICMPState) {
            if (this.myDHCPState) {
                this.kwDHCPAddRoutesICMPRedirects = oOCKeyword2.get("add_routes_icmp_redirects", "");
                if (this.kwDHCPAddRoutesICMPRedirects == null) {
                    this.kwDHCPAddRoutesICMPRedirects = oOCKeyword2.createKeyword(1, "add_routes_icmp_redirects", "", null);
                }
                this.kwDHCPAddRoutesICMPRedirects.setValue("Y");
                oOCKeyword.deleteKeyword("add_routes_icmp_redirects", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting arp in dhcpcd.cfg");
                }
            } else {
                this.kwAddRoutesICMPRedirects = oOCKeyword.get("add_routes_icmp_redirects", "");
                if (this.kwAddRoutesICMPRedirects == null) {
                    this.kwAddRoutesICMPRedirects = oOCKeyword.createKeyword(1, "add_routes_icmp_redirects", "", null);
                }
                this.kwAddRoutesICMPRedirects.setValue("Y");
                oOCKeyword2.deleteKeyword("add_routes_icmp_redirects", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting icmpred in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("add_routes_icmp_redirects", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting icmpred from dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("add_routes_icmp_redirects", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting icmpred from setup.cmd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myICMPState = " + this.myICMPState);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myAddRoutesICMPRedirects = " + this.myAddRoutesICMPRedirects);
        }
        if (this.myFormatState) {
            if (this.myDHCPState) {
                this.kwDHCPDisableSnapFormatHeaders = oOCKeyword2.get("disable_snap_format_headers", "");
                if (this.kwDHCPDisableSnapFormatHeaders == null) {
                    this.kwDHCPDisableSnapFormatHeaders = oOCKeyword2.createKeyword(1, "disable_snap_format_headers", "", null);
                }
                this.kwDHCPDisableSnapFormatHeaders.setValue("Y");
                oOCKeyword.deleteKeyword("disable_snap_format_headers", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting snap in dhcpcd.cfg");
                }
            } else {
                this.kwDisableSnapFormatHeaders = oOCKeyword.get("disable_snap_format_headers", "");
                if (this.kwDisableSnapFormatHeaders == null) {
                    this.kwDisableSnapFormatHeaders = oOCKeyword.createKeyword(1, "disable_snap_format_headers", "", null);
                }
                this.kwDisableSnapFormatHeaders.setValue("Y");
                oOCKeyword2.deleteKeyword("disable_snap_format_headers", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting snap in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("disable_snap_format_headers", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting snap from dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("disable_snap_format_headers", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting snap from setup.cmd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myFormatState = " + this.myFormatState);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myDisableSnapFormatHeaders = " + this.myDisableSnapFormatHeaders);
        }
        if (this.mySupportState) {
            if (this.myDHCPState) {
                this.kwDHCPDisableRoutingFieldSupport = oOCKeyword2.get("disable_routing_field_support", "");
                if (this.kwDHCPDisableRoutingFieldSupport == null) {
                    this.kwDHCPDisableRoutingFieldSupport = oOCKeyword2.createKeyword(1, "disable_routing_field_support", "", null);
                }
                this.kwDHCPDisableRoutingFieldSupport.setValue("Y");
                oOCKeyword.deleteKeyword("disable_routing_field_support", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting bridge in dhcpcd.cfg");
                }
            } else {
                this.kwDisableRoutingFieldSupport = oOCKeyword.get("disable_routing_field_support", "");
                if (this.kwDisableRoutingFieldSupport == null) {
                    this.kwDisableRoutingFieldSupport = oOCKeyword.createKeyword(1, "disable_routing_field_support", "", null);
                }
                this.kwDisableRoutingFieldSupport.setValue("Y");
                oOCKeyword2.deleteKeyword("disable_routing_field_support", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting bridge in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("disable_routing_field_support", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting bridge from dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("disable_routing_field_support", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting bridge from setyo,cnd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) mySupportState = " + this.mySupportState);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myDisableRoutingFieldSupport = " + this.myDisableRoutingFieldSupport);
        }
        if (this.myEncapsulationState) {
            if (this.myDHCPState) {
                this.kwDHCPEnableTrailerEncapsulation = oOCKeyword2.get("enable_trailer_encapsulation", "");
                if (this.kwDHCPEnableTrailerEncapsulation == null) {
                    this.kwDHCPEnableTrailerEncapsulation = oOCKeyword2.createKeyword(1, "enable_trailer_encapsulation", "", null);
                }
                this.kwDHCPEnableTrailerEncapsulation.setValue("Y");
                oOCKeyword.deleteKeyword("enable_trailer_encapsulation", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting trailers in dhcpcd.cfg");
                }
            } else {
                this.kwEnableTrailerEncapsulation = oOCKeyword.get("enable_trailer_encapsulation", "");
                if (this.kwEnableTrailerEncapsulation == null) {
                    this.kwEnableTrailerEncapsulation = oOCKeyword.createKeyword(1, "enable_trailer_encapsulation", "", null);
                }
                this.kwEnableTrailerEncapsulation.setValue("Y");
                oOCKeyword2.deleteKeyword("enable_trailer_encapsulation", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting trailers in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("enable_trailer_encapsulation", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting trailers from dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("enable_trailer_encapsulation", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting trailers from setup.cmd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myEncapsulationState = " + this.myEncapsulationState);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myEnableTrailerEncapsulation " + this.myEnableTrailerEncapsulation);
        }
        if (this.myEthernetProtocolState) {
            if (this.myDHCPState) {
                this.kwDHCPEnable802Protocol = oOCKeyword2.get("enable_802.3_protocol", "");
                if (this.kwDHCPEnable802Protocol == null) {
                    this.kwDHCPEnable802Protocol = oOCKeyword2.createKeyword(1, "enable_802.3_protocol", "", null);
                }
                this.kwDHCPEnable802Protocol.setValue("Y");
                oOCKeyword.deleteKeyword("enable_802.3_protocol", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting 802.3 in dhcpcd.cfg");
                }
            } else {
                this.kwEnable802Protocol = oOCKeyword.get("enable_802.3_protocol", "");
                if (this.kwEnable802Protocol == null) {
                    this.kwEnable802Protocol = oOCKeyword.createKeyword(1, "enable_802.3_protocol", "", null);
                }
                this.kwEnable802Protocol.setValue("Y");
                oOCKeyword2.deleteKeyword("enable_802.3_protocol", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting 802.3 in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("enable_802.3_protocol", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting 802.3 from dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("enable_802.3_protocol", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting 802.3 from setup.cmd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myEthernetProtocolState = " + this.myEthernetProtocolState);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myEnable802Protocol " + this.myEnable802Protocol);
        }
        if (this.myCanonicalState) {
            if (this.myDHCPState) {
                this.kwDHCPCanonicalFormat = oOCKeyword2.get("canonical_format", "");
                if (this.kwDHCPCanonicalFormat == null) {
                    this.kwDHCPCanonicalFormat = oOCKeyword2.createKeyword(1, "canonical_format", "", null);
                }
                this.kwDHCPCanonicalFormat.setValue("Y");
                oOCKeyword.deleteKeyword("canonical_format", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting canonical in dhcpcd.cfg");
                }
            } else {
                this.kwCanonicalFormat = oOCKeyword.get("canonical_format", "");
                if (this.kwCanonicalFormat == null) {
                    this.kwCanonicalFormat = oOCKeyword.createKeyword(1, "canonical_format", "", null);
                }
                this.kwCanonicalFormat.setValue("Y");
                oOCKeyword2.deleteKeyword("canonical_format", "");
                if (this.myTrace) {
                    System.out.println("LanInterface.saveInterfaceToOOCS) Setting canonical in setup.cmd");
                }
            }
        } else if (this.myDHCPState) {
            oOCKeyword2.deleteKeyword("canonical_format", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting canonical in dhcpcd.cfg");
            }
        } else {
            oOCKeyword.deleteKeyword("canonical_format", "");
            if (this.myTrace) {
                System.out.println("LanInterface.saveInterfaceToOOCS) Deleting canonical in setup.cmd");
            }
        }
        if (this.myTrace) {
            System.out.println("(LanInterface.saveInterfaceToOOCS) myCanonicalState = " + this.myCanonicalState);
            System.out.println("(LanInterface.saveInterfaceToOOCS) myCanonicalFormat " + this.myCanonicalFormat);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myDHCPState_tag)) {
                parsedObject = parsedVector.getElement(myDHCPState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myDHCPState = n2 != 0;
                }
            } else if (stringArray[n].equals(myUpdatedState_tag)) {
                parsedObject = parsedVector.getElement(myUpdatedState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    if (n2 == 0) {
                        this.setUpdated(false);
                    } else {
                        this.setUpdated(true);
                    }
                }
            } else if (stringArray[n].equals(myDDNSState_tag)) {
                parsedObject = parsedVector.getElement(myDDNSState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myDDNSState = n2 != 0;
                }
            } else if (stringArray[n].equals(myEnabledState_tag)) {
                parsedObject = parsedVector.getElement(myEnabledState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myEnabledState = n2 != 0;
                }
            } else if (stringArray[n].equals(myAllrsState_tag)) {
                parsedObject = parsedVector.getElement(myAllrsState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myAllrsState = n2 != 0;
                }
            } else if (stringArray[n].equals(myArpState_tag)) {
                parsedObject = parsedVector.getElement(myArpState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myArpState = n2 != 0;
                }
            } else if (stringArray[n].equals(myCanonicalState_tag)) {
                parsedObject = parsedVector.getElement(myCanonicalState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myCanonicalState = n2 != 0;
                }
            } else if (stringArray[n].equals(myEthernetProtocolState_tag)) {
                parsedObject = parsedVector.getElement(myEthernetProtocolState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myEthernetProtocolState = n2 != 0;
                }
            } else if (stringArray[n].equals(myICMPState_tag)) {
                parsedObject = parsedVector.getElement(myICMPState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myICMPState = n2 != 0;
                }
            } else if (stringArray[n].equals(myManualState_tag)) {
                parsedObject = parsedVector.getElement(myManualState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myManualState = n2 != 0;
                }
            } else if (stringArray[n].equals(mySupportState_tag)) {
                parsedObject = parsedVector.getElement(mySupportState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.mySupportState = n2 != 0;
                }
            } else if (stringArray[n].equals(myFormatState_tag)) {
                parsedObject = parsedVector.getElement(myFormatState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myFormatState = n2 != 0;
                }
            } else if (stringArray[n].equals(myMobileState_tag)) {
                parsedObject = parsedVector.getElement(myMobileState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myMobileState = n2 != 0;
                }
            } else if (stringArray[n].equals(myEncapsulationState_tag)) {
                parsedObject = parsedVector.getElement(myEncapsulationState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myEncapsulationState = n2 != 0;
                }
            } else if (stringArray[n].equals(myInterface_tag)) {
                parsedObject = parsedVector.getElement(myInterface_tag);
                string = (String)parsedObject.getValue();
                this.myInterface = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myIPaddress_tag)) {
                parsedObject = parsedVector.getElement(myIPaddress_tag);
                string = (String)parsedObject.getValue();
                this.myIPaddress = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myBroadcastAddr_tag)) {
                parsedObject = parsedVector.getElement(myBroadcastAddr_tag);
                string = (String)parsedObject.getValue();
                this.myBroadcastAddr = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myDestinationAddr_tag)) {
                parsedObject = parsedVector.getElement(myDestinationAddr_tag);
                string = (String)parsedObject.getValue();
                this.myDestinationAddr = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(mySubnetMask_tag)) {
                parsedObject = parsedVector.getElement(mySubnetMask_tag);
                string = (String)parsedObject.getValue();
                this.mySubnetMask = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myMetric_tag)) {
                parsedObject = parsedVector.getElement(myMetric_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myMetric = n2;
                }
            } else if (stringArray[n].equals(myMTU_tag) && (string = (String)(parsedObject = parsedVector.getElement(myMTU_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                this.myMTU = n2;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BLA_tag);
        if (this.myDHCPState) {
            stringBuffer.append("," + myDHCPState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myDHCPState_tag + "=" + 0);
        }
        if (this.myManualState) {
            stringBuffer.append("," + myManualState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myManualState_tag + "=" + 0);
        }
        if (this.myDDNSState) {
            stringBuffer.append("," + myDDNSState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myDDNSState_tag + "=" + 0);
        }
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        if (this.myEnabledState) {
            stringBuffer.append("," + myEnabledState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myEnabledState_tag + "=" + 0);
        }
        if (this.myAllrsState) {
            stringBuffer.append("," + myAllrsState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myAllrsState_tag + "=" + 0);
        }
        if (this.myArpState) {
            stringBuffer.append("," + myArpState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myArpState_tag + "=" + 0);
        }
        if (this.myCanonicalState) {
            stringBuffer.append("," + myCanonicalState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myCanonicalState_tag + "=" + 0);
        }
        if (this.myEthernetProtocolState) {
            stringBuffer.append("," + myEthernetProtocolState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myEthernetProtocolState_tag + "=" + 0);
        }
        if (this.myICMPState) {
            stringBuffer.append("," + myICMPState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myICMPState_tag + "=" + 0);
        }
        if (this.myICMPState) {
            stringBuffer.append("," + myICMPState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myICMPState_tag + "=" + 0);
        }
        if (this.mySupportState) {
            stringBuffer.append("," + mySupportState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + mySupportState_tag + "=" + 0);
        }
        if (this.myFormatState) {
            stringBuffer.append("," + myFormatState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myFormatState_tag + "=" + 0);
        }
        if (this.myMobileState) {
            stringBuffer.append("," + myMobileState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myMobileState_tag + "=" + 0);
        }
        if (this.myEncapsulationState) {
            stringBuffer.append("," + myEncapsulationState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myEncapsulationState_tag + "=" + 0);
        }
        stringBuffer.append("," + myBroadcastAddr_tag + "=" + this.myBroadcastAddr);
        stringBuffer.append("," + myDestinationAddr_tag + "=" + this.myDestinationAddr);
        stringBuffer.append("," + myInterface_tag + "=" + this.myInterface);
        stringBuffer.append("," + myIPaddress_tag + "=" + this.myIPaddress);
        stringBuffer.append("," + mySubnetMask_tag + "=" + this.mySubnetMask);
        stringBuffer.append("," + myMetric_tag + "=" + this.myMetric);
        stringBuffer.append("," + myMTU_tag + "=" + this.myMTU);
        stringBuffer.append("," + ELA_tag);
        return stringBuffer.toString();
    }
}

