/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ExportsDataLoader;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSDirEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;

public class NFSData
extends NotebookData {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BNO_tag = new String("Bno");
    public static final String ENO_tag = new String("Eno");
    public static final String DATA_ID = new String("NFSDATA");
    public static final String SAVE_ID = new String("SAVE_NFS_DATA");
    public static final String LOAD_ID = new String("LOAD_NFS_DATA");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private static final String myNFSDirEntryCount_tag = new String("Ncnt");
    private static final String myNFSDir_tag = new String("EMBEDDED_BND_BELONGS_TO_BNO");
    private static final String myEnabledState_tag = new String("Est_yn");
    private Vector myNFSDirEntryList;
    private Vector mySavedNFSDirEntryList;
    private int myNFSDirEntryCount;
    private ExportsDataLoader myExportsDataLoader;
    private boolean myEnabledState = false;
    private String myEtcPath;
    private NativeData myNativeData;
    ErrorListController myErrorListController;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();

    NFSData() {
        if (this.myTrace) {
            System.out.println("in NFSData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
    }

    public NFSData(boolean bl, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in NFSData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
        if (bl) {
            this.loadFromOOCS();
        }
    }

    public NFSData(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING NFSData from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public void addNFSDirEntry(NFSDirEntry nFSDirEntry) {
        this.myNFSDirEntryList.addElement(nFSDirEntry);
        this.myNFSDirEntryCount = this.getNFSDirEntryListSize();
    }

    public void commit() {
        if (this.myTrace) {
            System.out.println(" in PgNFS1.commit()");
        }
        this.mySavedNFSDirEntryList.removeAllElements();
        this.mySavedNFSDirEntryList = (Vector)this.myNFSDirEntryList.clone();
        this.cloneVectorContents(this.myNFSDirEntryList, this.mySavedNFSDirEntryList);
    }

    public void initCommit() {
        this.mySavedNFSDirEntryList = new Vector();
        this.commit();
    }

    public void deCommit() {
        if (this.myTrace) {
            System.out.println(" in PgNFS1.deCommit()");
        }
        if (this.myNFSDirEntryList.size() > 0) {
            this.myNFSDirEntryList.removeAllElements();
        }
        this.myNFSDirEntryList = (Vector)this.mySavedNFSDirEntryList.clone();
        this.cloneVectorContents(this.mySavedNFSDirEntryList, this.myNFSDirEntryList);
    }

    public void deleteNFSDirEntry(int n) {
        this.myNFSDirEntryList.removeElementAt(n);
        this.myNFSDirEntryCount = this.getNFSDirEntryListSize();
    }

    public void deleteNFSDirEntryList() {
        this.myNFSDirEntryList.removeAllElements();
        this.myNFSDirEntryCount = this.getNFSDirEntryListSize();
    }

    public NFSDirEntry getNFSDirEntry(int n) {
        return (NFSDirEntry)this.myNFSDirEntryList.elementAt(n);
    }

    public int getNFSDirEntryListSize() {
        if (this.myTrace) {
            if (this.myNFSDirEntryList == null) {
                System.out.println("myNFSDirEntryList == null");
            } else {
                System.out.println("myNFSDirEntryList != null");
            }
        }
        return this.myNFSDirEntryList.size();
    }

    public int isDirCreated(String string) {
        if (!Utility.hasValue(string)) {
            return -1;
        }
        int n = this.getNFSDirEntryListSize();
        int n2 = 0;
        while (n2 < n) {
            NFSDirEntry nFSDirEntry = (NFSDirEntry)this.myNFSDirEntryList.elementAt(n2);
            if (nFSDirEntry.getDirectory().compareTo(string) == 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean isEnabled() {
        return this.myEnabledState;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of NFSData");
        }
        this.myNFSDirEntryList = new Vector();
        this.mySavedNFSDirEntryList = new Vector();
        this.myNFSDirEntryCount = 0;
        this.myEnabledState = false;
        this.myErrorListController = null;
    }

    public void replaceNFSDirEntry(NFSDirEntry nFSDirEntry, int n) {
        this.myNFSDirEntryList.removeElementAt(n);
        this.myNFSDirEntryList.insertElementAt(nFSDirEntry, n);
    }

    public void setEnabled(boolean bl) {
        this.myEnabledState = bl;
    }

    private void loadFromOOCS() {
        if (this.myTrace) {
            System.out.println("in loadFromOOCS() of NFSData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        String string = String.valueOf(this.myEtcPath) + "exports";
        this.myExportsDataLoader = new ExportsDataLoader(string, this, this.myErrorListController);
        this.myExportsDataLoader.loadNFS();
    }

    public void saveToOOCS() {
        if (this.myTrace) {
            System.out.println("in saveToOOCS() of NFSData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        String string = String.valueOf(this.myEtcPath) + "exports";
        this.myExportsDataLoader = new ExportsDataLoader(string, this, this.myErrorListController);
        this.myExportsDataLoader.saveNFS();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myNFSDirEntryCount_tag)) {
                parsedObject = parsedVector.getElement(myNFSDirEntryCount_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myNFSDirEntryCount = n2;
                    if (this.myNFSDirEntryCount > 0) {
                        this.myNFSDirEntryList = new Vector(this.myNFSDirEntryCount);
                        int n3 = 1;
                        while (n3 <= this.myNFSDirEntryCount) {
                            parsedObject = parsedVector.get(n + n3);
                            ParsedVector parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.myNFSDirEntryList.addElement(new NFSDirEntry(parsedVector2));
                            }
                            ++n3;
                        }
                    } else {
                        this.myNFSDirEntryList = new Vector();
                    }
                } else {
                    this.myNFSDirEntryList = new Vector();
                }
            } else if (stringArray[n].equals(myUpdatedState_tag)) {
                parsedObject = parsedVector.getElement(myUpdatedState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    if (n2 == 0) {
                        this.setUpdated(false);
                    } else {
                        this.setUpdated(true);
                    }
                }
            } else if (stringArray[n].equals(myEnabledState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myEnabledState_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                this.myEnabledState = n2 != 0;
            }
            ++n;
        }
        this.initCommit();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BNO_tag);
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        stringBuffer.append("," + myNFSDirEntryCount_tag + "=" + String.valueOf(this.myNFSDirEntryList.size()));
        Enumeration enumeration = this.myNFSDirEntryList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                NFSDirEntry nFSDirEntry = (NFSDirEntry)enumeration.nextElement();
                stringBuffer.append("," + myNFSDir_tag);
                stringBuffer.append("," + nFSDirEntry.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        if (this.myEnabledState) {
            stringBuffer.append("," + myEnabledState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myEnabledState_tag + "=" + 0);
        }
        stringBuffer.append("," + ENO_tag);
        if (this.myTrace) {
            System.out.println("NFSData builtString =" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

