/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Tcpcfg2;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Authorize;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConfigData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.HostsData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ResolvData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SetupData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpstartData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TimedData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;

public class NotebookProfile
implements Cloneable {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BNP_tag = new String("Bnp");
    public static final String ENP_tag = new String("Enp");
    public static final String EMBEDDED_tag = new String("NBPROF");
    private static final String myProfileName_tag = new String("prfName");
    private static final String myLoadedState_tag = new String("loaded_yn");
    private boolean myLoadedState = false;
    private String myProfileName;
    private boolean updated = true;
    private ResourceBundle myBundle = ClientMsg.getBundle();
    private ConfigData myConfigData;
    private HostsData myHostsData;
    private ResolvData myResolvData;
    private SetupData mySetupData;
    private SocksData mySocksData;
    private TcpstartData myTcpstartData;
    private UserData myUserData;
    private NFSData myNFSData;
    private TimedData myTimedData;
    private Authorize myAuthorize;

    public NotebookProfile() {
        this.loadInit();
    }

    public boolean loadDataForLocalClient(Tcpcfg2 tcpcfg2, ErrorListController errorListController) {
        tcpcfg2.showStatusDialog(this.myBundle.getString("SP_LOADING_SETUP"));
        this.mySetupData = new SetupData(true, errorListController);
        this.mySetupData.initCommit();
        tcpcfg2.showStatusDialog(this.myBundle.getString("SP_LOADING_SOCKS"));
        this.mySocksData = new SocksData(true, errorListController);
        tcpcfg2.showStatusDialog(this.myBundle.getString("SP_LOADING_CONFIG"));
        this.myConfigData = new ConfigData(true, errorListController);
        tcpcfg2.showStatusDialog(this.myBundle.getString("SP_LOADING_RESOLV"));
        this.myResolvData = new ResolvData(true, errorListController);
        tcpcfg2.showStatusDialog(this.myBundle.getString("SP_LOADING_HOST"));
        this.myHostsData = new HostsData(true, errorListController);
        tcpcfg2.showStatusDialog(this.myBundle.getString("SP_LOADING_TCPSTART"));
        this.myTcpstartData = new TcpstartData(true, errorListController);
        this.myTcpstartData.initCommit();
        tcpcfg2.showStatusDialog(this.myBundle.getString("SP_LOADING_USER_ACCESS"));
        this.myUserData = new UserData(true, errorListController);
        this.myUserData.initCommit();
        tcpcfg2.showStatusDialog(this.myBundle.getString("SP_LOADING_NFS"));
        this.myNFSData = new NFSData(true, errorListController);
        this.myNFSData.initCommit();
        tcpcfg2.showStatusDialog(this.myBundle.getString("SP_LOADING_TIMED"));
        this.myTimedData = new TimedData(true, errorListController);
        return true;
    }

    public boolean saveDataForLocalClient(Tcpcfg2 tcpcfg2, ErrorListController errorListController) {
        if (this.myAuthorize.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_PASSWORD"));
            String string = NativeData.getEtcPath();
            String string2 = String.valueOf(string) + File.separator + "adminpw.pub";
            String string3 = String.valueOf(string) + File.separator + "adminpw.pvt";
            TcpError tcpError = null;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                fileOutputStream.write(this.myAuthorize.getPubPw());
                fileOutputStream.close();
                FileOutputStream fileOutputStream2 = new FileOutputStream(string3);
                fileOutputStream2.write(this.myAuthorize.getPvtPw());
                fileOutputStream2.close();
            }
            catch (IOException iOException) {
                tcpError = new TcpError(this.myBundle.getString("ERROR_WRITING_PASSWORD"), 0);
                errorListController.addError(tcpError);
            }
        }
        if (this.mySetupData.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_SETUP"));
            this.mySetupData.saveToOOCS();
        }
        if (this.mySocksData.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_SOCKS"));
            this.mySocksData.saveToOOCS();
        }
        if (this.myConfigData.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_CONFIG"));
            this.myConfigData.saveToOOCS();
        }
        if (this.myResolvData.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_RESOLV"));
            this.myResolvData.saveToOOCS();
        }
        if (this.myHostsData.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_HOST"));
            this.myHostsData.saveToOOCS();
        }
        if (this.myTcpstartData.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_TCPSTART"));
            this.myTcpstartData.saveToOOCS();
        }
        if (this.myUserData.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_USER_ACCESS"));
            this.myUserData.saveToOOCS();
        }
        if (this.myNFSData.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_NFS"));
            this.myNFSData.saveToOOCS();
        }
        if (this.myTimedData.isUpdated()) {
            tcpcfg2.showStatusDialog(this.myBundle.getString("SP_SAVING_TIMED"));
            this.myTimedData.saveToOOCS();
        }
        return true;
    }

    public ConfigData getConfigDataHandle() {
        return this.myConfigData;
    }

    public HostsData getHostsDataHandle() {
        return this.myHostsData;
    }

    public ResolvData getResolvDataHandle() {
        return this.myResolvData;
    }

    public SetupData getSetupDataHandle() {
        return this.mySetupData;
    }

    public SocksData getSocksDataHandle() {
        return this.mySocksData;
    }

    public TcpstartData getTcpstartDataHandle() {
        return this.myTcpstartData;
    }

    public UserData getUserDataHandle() {
        return this.myUserData;
    }

    public NFSData getNFSDataHandle() {
        return this.myNFSData;
    }

    public TimedData getTimedDataHandle() {
        return this.myTimedData;
    }

    public Authorize getAuthorizeHandle() {
        return this.myAuthorize;
    }

    public void setUserDataHandle(UserData userData) {
        this.myUserData = userData;
    }

    private void loadInit() {
        this.mySetupData = new SetupData(false, null);
        this.mySocksData = new SocksData(false, null);
        this.myResolvData = new ResolvData(false, null);
        this.myHostsData = new HostsData(false, null);
        this.myConfigData = new ConfigData(false, null);
        this.myTcpstartData = new TcpstartData(false, null);
        this.myUserData = new UserData(false, null);
        this.myNFSData = new NFSData(false, null);
        this.myTimedData = new TimedData(false, null);
        this.myAuthorize = new Authorize();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            ParsedVector parsedVector2;
            ParsedObject parsedObject;
            if (stringArray[n].equals(SetupData.DATA_ID)) {
                parsedObject = parsedVector.getElement(SetupData.DATA_ID);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.mySetupData = parsedVector2 != null ? new SetupData(parsedVector2) : new SetupData(false, null);
            } else if (stringArray[n].equals(SocksData.DATA_ID)) {
                parsedObject = parsedVector.getElement(SocksData.DATA_ID);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.mySocksData = parsedVector2 != null ? new SocksData(parsedVector2) : new SocksData(false, null);
            } else if (stringArray[n].equals(ConfigData.DATA_ID)) {
                parsedObject = parsedVector.getElement(ConfigData.DATA_ID);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.myConfigData = parsedVector2 != null ? new ConfigData(parsedVector2) : new ConfigData(false, null);
            } else if (stringArray[n].equals(ResolvData.DATA_ID)) {
                parsedObject = parsedVector.getElement(ResolvData.DATA_ID);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.myResolvData = parsedVector2 != null ? new ResolvData(parsedVector2) : new ResolvData(false, null);
            } else if (stringArray[n].equals(HostsData.DATA_ID)) {
                parsedObject = parsedVector.getElement(HostsData.DATA_ID);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.myHostsData = parsedVector2 != null ? new HostsData(parsedVector2) : new HostsData(false, null);
            } else if (stringArray[n].equals(TcpstartData.DATA_ID)) {
                parsedObject = parsedVector.getElement(TcpstartData.DATA_ID);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.myTcpstartData = parsedVector2 != null ? new TcpstartData(parsedVector2) : new TcpstartData(false, null);
            } else if (stringArray[n].equals(UserData.DATA_ID)) {
                parsedObject = parsedVector.getElement(UserData.DATA_ID);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.myUserData = parsedVector2 != null ? new UserData(parsedVector2) : new UserData(false, null);
            } else if (stringArray[n].equals(NFSData.DATA_ID)) {
                parsedObject = parsedVector.getElement(NFSData.DATA_ID);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.myNFSData = parsedVector2 != null ? new NFSData(parsedVector2) : new NFSData(false, null);
            } else if (stringArray[n].equals(TimedData.DATA_ID)) {
                parsedObject = parsedVector.getElement(TimedData.DATA_ID);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.myTimedData = parsedVector2 != null ? new TimedData(parsedVector2) : new TimedData(false, null);
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BNP_tag);
        return stringBuffer.toString();
    }
}

