/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCMessageQueue;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCProductInfo;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;

public class ResolvData
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BRE_tag = new String("Bre");
    public static final String ERE_tag = new String("Ere");
    public static final String DATA_ID = new String("RESOLVDATA");
    public static final String SAVE_ID = new String("SAVE_RESOLV_DATA");
    public static final String LOAD_ID = new String("LOAD_RESOLV_DATA");
    private static final String myLocalDomain_tag = new String("RLD");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private static final String myNameServerList_tag = new String("RNSL");
    private static final String myNameServerListCnt_tag = new String("RNSLCnt");
    private static final String mySearchDomainList_tag = new String("RLDL");
    private static final String mySearchDomainListCnt_tag = new String("RLDLCnt");
    private OOCProductInfo myProductInfo;
    private OOCConfiguration myConfiguration;
    private OOCMessageQueue myMessageQueue;
    private String mySearchDomain;
    private String mySearchDomain1;
    private String mySearchDomain2;
    private String mySearchDomain3;
    private String mynameServer;
    private String mynameServer1;
    private String mynameServer2;
    private String mynameServer3;
    OOCKeyword kwLocalDomain;
    OOCKeyword kwSearchDomain;
    OOCKeyword kwDomain;
    OOCKeyword kwnameServers;
    OOCKeyword kwnameServer;
    private NativeData myNativeData;
    private String myEtcPath;
    private String datFile;
    private String logFile;
    private String bakFile;
    private String configFile;
    private static final String parseRules = "RESOLV2_RULES";
    private String dosFile;
    private String mydosEtcPath;
    private String myLocalDomain;
    private Vector myNameServerList;
    private Vector mySearchDomainList;
    private int myNameServerListCnt;
    private int mySearchDomainListCnt;
    private boolean noExistingData = false;
    private boolean noProductInfo = false;
    private boolean already_closed = false;
    ErrorListController myErrorListController;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();

    public ResolvData() {
        if (this.myTrace) {
            System.out.println("in ResolvData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
    }

    public ResolvData(boolean bl, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in ResolvData() constructor2");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
        if (bl) {
            this.loadFromOOCS();
        }
    }

    public ResolvData(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING ResolvData from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public void addSearchDomain(String string) {
        this.mySearchDomainList.addElement(string);
        this.mySearchDomainListCnt = this.getSearchDomainListSize();
    }

    public void addNameServer(String string) {
        this.myNameServerList.addElement(string);
        this.myNameServerListCnt = this.getNameServerListSize();
    }

    public void deleteSearchDomainList() {
        this.mySearchDomainList.removeAllElements();
        this.mySearchDomainListCnt = this.getSearchDomainListSize();
    }

    public void deleteNameServerList() {
        this.myNameServerList.removeAllElements();
        this.myNameServerListCnt = this.getNameServerListSize();
    }

    public String getLocalDomain() {
        return this.myLocalDomain;
    }

    public String getSearchDomain(int n) {
        return (String)this.mySearchDomainList.elementAt(n);
    }

    public int getSearchDomainListSize() {
        return this.mySearchDomainList.size();
    }

    public String getNameServer(int n) {
        return (String)this.myNameServerList.elementAt(n);
    }

    public int getNameServerListSize() {
        return this.myNameServerList.size();
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of ResolvData");
        }
        this.myLocalDomain = new String("");
        this.myNameServerList = new Vector();
        this.mySearchDomainList = new Vector();
        this.myNameServerListCnt = 0;
        this.mySearchDomainListCnt = 0;
        this.myErrorListController = null;
    }

    public void setLocalDomain(String string) {
        this.myLocalDomain = string;
    }

    private void loadFromOOCS() {
        int n;
        if (this.myTrace) {
            System.out.println("***** in loadFromOOCS() of ResolvData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        this.mydosEtcPath = String.valueOf(this.myEtcPath.substring(0, 2)) + "\\TCPIP\\DOS\\ETC\\";
        this.datFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxreslv.dat";
        this.logFile = String.valueOf(this.myEtcPath) + "tcpcfg2.log";
        this.configFile = String.valueOf(this.myEtcPath) + "resolv2";
        this.bakFile = String.valueOf(this.myEtcPath) + "resolv2.nbk";
        this.dosFile = String.valueOf(this.mydosEtcPath) + "resolv";
        this.myProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(ResolvData.loadFromOOCS) myProductInfo datFile = " + this.datFile);
        }
        if ((n = this.myProductInfo.create(this.datFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(ResolvData.loadFromOOCS) myProductInfo.create successful");
            }
            this.myProductInfo.setFileOpenMode(3);
            this.myProductInfo.setFileShareMode(0);
            this.myProductInfo.setProcessingOptions(1, 1, 1);
            this.myProductInfo.setParsingInfo(parseRules);
            this.myConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(ResolvData.loadFromOOCS) mySetupConfiguration configFile = " + this.configFile);
            }
            if ((n = this.myConfiguration.open(this.myProductInfo, this.configFile)) == 2) {
                n = this.myConfiguration.open(this.myProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(ResolvData.loadFromOOCS) myConfiguration.create successful...no preexisting file");
                }
                this.noExistingData = true;
            }
            if (this.myTrace) {
                System.out.println("(ResolvData.loadFromOOCS) myConfiguration.create successful");
            }
        } else {
            this.noProductInfo = true;
            if (this.myTrace) {
                System.out.println("(ResolvData.loadFromOOCS) ERROR: myProductInfo.create failed");
            }
            Object[] objectArray = new Object[]{this.datFile, "resolv2"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            OOCMessageQueue oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
            return;
        }
        this.myConfiguration.write(this.bakFile, 1, 1, 1, 0, parseRules);
        this.myMessageQueue = this.myConfiguration.getMsgQ();
        this.myMessageQueue.replaceLogFile(0);
        this.myMessageQueue.setLogFileName(this.logFile);
        this.myMessageQueue.setLogOption(1);
        this.myMessageQueue.logQueue();
        this.myProductInfo.close();
        this.kwLocalDomain = this.myConfiguration.get("domain", "");
        if (this.kwLocalDomain != null) {
            this.myLocalDomain = this.kwLocalDomain.getValue();
            new String(this.myLocalDomain);
        } else {
            this.kwLocalDomain = this.myConfiguration.createKeyword(1, "DOMAIN", "", null);
        }
        if (this.myTrace) {
            System.out.println("(ResolvData.loadFromOOCS) myLocalDomain = " + this.myLocalDomain);
        }
        this.kwSearchDomain = this.myConfiguration.get("lan_search_domains", "");
        if (this.kwSearchDomain != null) {
            this.mySearchDomain1 = this.kwSearchDomain.getValueOf("domain1");
            this.mySearchDomain2 = this.kwSearchDomain.getValueOf("domain2");
            this.mySearchDomain3 = this.kwSearchDomain.getValueOf("domain3");
            if (!this.mySearchDomain1.equals("")) {
                this.addSearchDomain(this.mySearchDomain1);
                if (this.myTrace) {
                    System.out.println("(ResolvData.loadFromOOCS) Search Domain1 = " + this.mySearchDomain1);
                }
            }
            if (!this.mySearchDomain2.equals("")) {
                this.addSearchDomain(this.mySearchDomain2);
                if (this.myTrace) {
                    System.out.println("(ResolvData.loadFromOOCS) Search Domain2 = " + this.mySearchDomain2);
                }
            }
            if (!this.mySearchDomain3.equals("")) {
                this.addSearchDomain(this.mySearchDomain3);
                if (this.myTrace) {
                    System.out.println("(ResolvData.loadFromOOCS) Search Domain3 = " + this.mySearchDomain3);
                }
            }
        }
        if (this.myTrace) {
            System.out.println("The number of search domains is: " + this.mySearchDomainListCnt);
        }
        this.kwnameServers = this.myConfiguration.get("nameservers", "");
        if (this.kwnameServers != null) {
            this.mynameServer1 = this.kwnameServers.getValueOf("nameserver1");
            this.mynameServer2 = this.kwnameServers.getValueOf("nameserver2");
            this.mynameServer3 = this.kwnameServers.getValueOf("nameserver3");
            if (!this.mynameServer1.equals("")) {
                this.addNameServer(this.mynameServer1);
                if (this.myTrace) {
                    System.out.println("(ResolvData.loadFromOOCS) mynameServer1 = " + this.mynameServer1);
                }
            }
            if (!this.mynameServer2.equals("")) {
                this.addNameServer(this.mynameServer2);
                if (this.myTrace) {
                    System.out.println("(ResolvData.loadFromOOCS) mynameServer2 = " + this.mynameServer2);
                }
            }
            if (!this.mynameServer3.equals("")) {
                this.addNameServer(this.mynameServer3);
                if (this.myTrace) {
                    System.out.println("(ResolvData.loadFromOOCS) mynameServer3 = " + this.mynameServer3);
                }
            }
        }
        if (this.myTrace) {
            System.out.println("(ResolvData.loadFromOOCS) The number of nameservers is: " + this.myNameServerListCnt);
        }
    }

    public void saveToOOCS() {
        int n;
        int n2 = 0;
        if (this.myTrace) {
            System.out.println("***** in saveToOOCS() of ResolvData");
        }
        if (NotebookData.hasValue(this.myLocalDomain)) {
            this.kwLocalDomain.setValue(this.myLocalDomain);
        } else {
            this.myConfiguration.deleteKeyword("DOMAIN", "");
        }
        if (this.myTrace) {
            System.out.println("(ResolvData.saveToOOCS) myLocalDomain = " + this.myLocalDomain);
        }
        this.kwSearchDomain = this.myConfiguration.get("lan_search_domains", "");
        if (this.kwSearchDomain != null) {
            this.kwSearchDomain.deleteKeyword("domain1", "");
            this.kwSearchDomain.deleteKeyword("domain2", "");
            this.kwSearchDomain.deleteKeyword("domain3", "");
        }
        int n3 = this.getSearchDomainListSize();
        if (this.myTrace) {
            System.out.println("(ResolvData.saveToOOCS) totalSearchDoms = " + n3);
        }
        if (n3 > 0) {
            if (this.kwSearchDomain == null) {
                this.kwSearchDomain = this.myConfiguration.createKeyword(0, "lan_search_domains", "", null);
            }
            n = 0;
            while (n < n3) {
                this.mySearchDomain = this.getSearchDomain(n);
                switch (n) {
                    case 0: {
                        this.kwDomain = this.kwSearchDomain.createKeyword(1, "domain1", "", null);
                        this.kwDomain.setValue(this.mySearchDomain);
                        if (!this.myTrace) break;
                        System.out.println("(ResolvData.saveToOOCS) myDomain1 = " + this.mySearchDomain);
                        break;
                    }
                    case 1: {
                        this.kwDomain = this.kwSearchDomain.createKeyword(1, "domain2", "", null);
                        this.kwDomain.setValue(this.mySearchDomain);
                        if (!this.myTrace) break;
                        System.out.println("(ResolvData.saveToOOCS) myDomain2 = " + this.mySearchDomain);
                        break;
                    }
                    case 2: {
                        this.kwDomain = this.kwSearchDomain.createKeyword(1, "domain3", "", null);
                        this.kwDomain.setValue(this.mySearchDomain);
                        if (!this.myTrace) break;
                        System.out.println("(ResolvData.saveToOOCS) myDomain3 = " + this.mySearchDomain);
                        break;
                    }
                }
                ++n;
            }
        }
        this.kwnameServers = this.myConfiguration.get("nameservers", "");
        if (this.kwnameServers != null) {
            this.kwnameServers.deleteKeyword("nameserver1", "");
            this.kwnameServers.deleteKeyword("nameserver2", "");
            this.kwnameServers.deleteKeyword("nameserver3", "");
        }
        n = this.getNameServerListSize();
        if (this.myTrace) {
            System.out.println("(ResolvData.saveToOOCS) totalNameservers = " + n);
        }
        if (n > 0) {
            if (this.kwnameServers == null) {
                this.kwnameServers = this.myConfiguration.createKeyword(0, "nameservers", "", null);
            }
            int n4 = 0;
            while (n4 < n) {
                if (this.myTrace) {
                    System.out.println("(ResolvData.saveToOOCS) loop = " + n4);
                }
                this.mynameServer = this.getNameServer(n4);
                if (n4 == 0) {
                    this.kwnameServer = this.kwnameServers.createKeyword(1, "nameserver1", "", null);
                    this.kwnameServer.setValue(this.mynameServer);
                    if (this.myTrace) {
                        System.out.println("(ResolvData.saveToOOCS) nameServer1 = " + this.mynameServer);
                    }
                }
                if (n4 == 1) {
                    this.kwnameServer = this.kwnameServers.createKeyword(1, "nameserver2", "", null);
                    this.kwnameServer.setValue(this.mynameServer);
                    if (this.myTrace) {
                        System.out.println("(ResolvData.saveToOOCS) nameServer2 = " + this.mynameServer);
                    }
                }
                if (n4 == 2) {
                    this.kwnameServer = this.kwnameServers.createKeyword(1, "nameserver3", "", null);
                    this.kwnameServer.setValue(this.mynameServer);
                    if (this.myTrace) {
                        System.out.println("(ResolvData.saveToOOCS) mynameServer3 = " + this.mynameServer);
                    }
                }
                ++n4;
            }
        }
        if ((n2 = this.myConfiguration.write(this.configFile, 1, 1, 1, 0, parseRules)) == 1) {
            if (this.myTrace) {
                System.out.println("(ResolvData.saveToOOCS) Successful write to resolv2");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(ResolvData.saveToOOCS) Unsuccessful write to resolv2");
            }
            Object[] objectArray = new Object[]{"resolv2"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            this.myMessageQueue.logQueue();
        }
        n2 = this.myConfiguration.write(this.dosFile, 1, 1, 1, 0, parseRules);
        this.closeOOCS();
    }

    public void closeOOCS() {
        if (this.already_closed) {
            return;
        }
        this.already_closed = true;
        int n = this.myConfiguration.close();
        if (this.myTrace) {
            System.out.println("(ResolvData.closeOOCS) rc from myConfiguration.close = " + n);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            Integer n3;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myLocalDomain_tag)) {
                parsedObject = parsedVector.getElement(myLocalDomain_tag);
                string = (String)parsedObject.getValue();
                this.myLocalDomain = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myUpdatedState_tag)) {
                parsedObject = parsedVector.getElement(myUpdatedState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    if (n3 == 0) {
                        this.setUpdated(false);
                    } else {
                        this.setUpdated(true);
                    }
                }
            } else if (stringArray[n].equals(myNameServerListCnt_tag)) {
                parsedObject = parsedVector.getElement(myNameServerListCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myNameServerListCnt = n3;
                    if (this.myNameServerListCnt > 0) {
                        this.myNameServerList = new Vector(this.myNameServerListCnt);
                        n2 = 1;
                        while (n2 <= this.myNameServerListCnt) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.myNameServerList.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.myNameServerList = new Vector();
                    }
                } else {
                    this.myNameServerList = new Vector();
                }
            } else if (stringArray[n].equals(mySearchDomainListCnt_tag)) {
                parsedObject = parsedVector.getElement(mySearchDomainListCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.mySearchDomainListCnt = n3;
                    if (this.mySearchDomainListCnt > 0) {
                        this.mySearchDomainList = new Vector(this.mySearchDomainListCnt);
                        n2 = 1;
                        while (n2 <= this.mySearchDomainListCnt) {
                            parsedObject = parsedVector.get(n + n2);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.mySearchDomainList.addElement(new String(string));
                            }
                            ++n2;
                        }
                    } else {
                        this.mySearchDomainList = new Vector();
                    }
                } else {
                    this.mySearchDomainList = new Vector();
                }
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BRE_tag);
        stringBuffer.append("," + myLocalDomain_tag + "=" + this.myLocalDomain);
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        stringBuffer.append("," + myNameServerListCnt_tag + "=" + String.valueOf(this.myNameServerList.size()));
        Enumeration enumeration = this.myNameServerList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("," + myNameServerList_tag + "=" + string);
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        Enumeration enumeration2 = this.mySearchDomainList.elements();
        stringBuffer.append("," + mySearchDomainListCnt_tag + "=" + String.valueOf(this.mySearchDomainList.size()));
        while (enumeration2.hasMoreElements()) {
            try {
                String string = (String)enumeration2.nextElement();
                stringBuffer.append("," + mySearchDomainList_tag + "=" + string);
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + ERE_tag);
        return stringBuffer.toString();
    }
}

