/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class RexecAccess
extends NotebookData
implements Cloneable,
CloneableItem,
OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BRA_tag = new String("Bra");
    public static final String ERA_tag = new String("Era");
    public static final String myEnabledState_tag = new String("raEnab_yn");
    private boolean myEnabledState = false;
    private OOCKeyword kwActive;
    private boolean myTrace = Utility.isTraceOn();

    RexecAccess() {
        if (this.myTrace) {
            System.out.println("in RexecAccess constructor");
        }
        this.loadInit();
    }

    public RexecAccess(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING RexecAccess from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        if (this.myTrace) {
            System.out.println("in RexecAccess.clone()");
        }
        RexecAccess rexecAccess = new RexecAccess();
        rexecAccess.setEnableUser(this.myEnabledState);
        return rexecAccess;
    }

    public boolean getEnableUser() {
        return this.myEnabledState;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of RexecAccess");
        }
        this.myEnabledState = false;
    }

    public void setEnableUser(boolean bl) {
        this.myEnabledState = bl;
    }

    public boolean isConfigured() {
        return this.myEnabledState;
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            ParsedObject parsedObject;
            String string;
            if (stringArray[n].equals(myEnabledState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myEnabledState_tag)).getValue()) != null) {
                Integer n2 = Integer.valueOf(string);
                this.myEnabledState = n2 != 0;
            }
            ++n;
        }
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in UserEntry.toString() ");
        }
        StringBuffer stringBuffer = new StringBuffer(BRA_tag);
        stringBuffer.append("=start");
        if (this.myEnabledState) {
            stringBuffer.append("," + myEnabledState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myEnabledState_tag + "=" + 0);
        }
        stringBuffer.append("," + ERA_tag);
        stringBuffer.append("=end");
        return stringBuffer.toString();
    }

    public void loadRexecAccessFromOOCS(OOCKeyword oOCKeyword) {
        String string;
        if (this.myTrace) {
            System.out.println("***** in RexecAccess.loadRexecAccessFromOOCS");
        }
        this.myEnabledState = (string = oOCKeyword.getValueOf("active")).equals("1");
        if (this.myTrace) {
            System.out.println("(RexecAccess.loadRexecAccessFromOOCS) myEnabledState = " + this.myEnabledState);
        }
    }

    public void saveRexecAccessToOOCS(OOCKeyword oOCKeyword, OOCKeyword oOCKeyword2) {
        if (this.myTrace) {
            System.out.println("***** in RexecAccess.saveRexecAccessToOOCS");
            System.out.println("(RexecAccess.saveRexecAccessToOOCS) kwRexecd = " + oOCKeyword2);
        }
        if (oOCKeyword2 == null) {
            oOCKeyword2 = oOCKeyword.createKeyword(0, "rexecd", "", null);
            if (this.myTrace) {
                System.out.println("(RexecAccess.saveRexecAccessToOOCS) created new REXECD keyword = " + oOCKeyword2);
            }
        }
        this.kwActive = this.kwActive == null ? oOCKeyword2.createKeyword(1, "active", "", null) : oOCKeyword2.get("active", "");
        if (this.myEnabledState) {
            this.kwActive.setValue("1");
        } else {
            this.kwActive.setValue("0");
        }
        if (this.myTrace) {
            System.out.println("(RexecAccess.saveRexecAccessToOOCS) myEnabledState = " + this.myEnabledState);
        }
    }
}

