/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;

public class Route
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BRO_tag = new String("Bro");
    public static final String ERO_tag = new String("Ero");
    private static final String myRouteType_tag = new String("type");
    private static final String myRouter_tag = new String("router");
    private static final String myDest_tag = new String("dest");
    private static final String myMetric_tag = new String("metric");
    private static final String mySubnetMask_tag = new String("R_snm");
    OOCKeyword kwRoute;
    OOCKeyword kwDest;
    OOCKeyword kwRouter;
    OOCKeyword kwMetricCount;
    OOCKeyword kwSubnetMask;
    OOCKeyword kwPipeToNul;
    private String myMetricCount;
    private String myPipeToNul;
    private String myRouteType;
    private String myDest;
    private String myRouter;
    private String mySubnetMask;
    private int myMetric;
    private boolean myTrace = Utility.isTraceOn();

    Route() {
        if (this.myTrace) {
            System.out.println("in Route() constructor");
        }
        this.loadInit();
    }

    public Route(String string, String string2, String string3, int n, String string4) {
        if (this.myTrace) {
            System.out.println("in Route() constructor2");
        }
        this.myRouteType = string;
        this.myDest = string2;
        this.myRouter = string3;
        this.myMetric = n;
        this.mySubnetMask = string4;
    }

    public Route(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING Route from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public String getDest() {
        return this.myDest;
    }

    public int getMetric() {
        return this.myMetric;
    }

    public String getRouter() {
        return this.myRouter;
    }

    public String getRouteType() {
        return this.myRouteType;
    }

    public String getSubnetMask() {
        return this.mySubnetMask;
    }

    private void loadInit() {
        this.myDest = new String("");
        this.myMetric = 1;
        this.myRouter = new String("");
        this.myRouteType = new String("");
        this.mySubnetMask = new String("");
    }

    public void setDest(String string) {
        this.myDest = string;
    }

    public void setMetric(int n) {
        this.myMetric = n;
    }

    public void setRouter(String string) {
        this.myRouter = string;
    }

    public void setRouteType(String string) {
        this.myRouteType = string;
    }

    public void setSubnetMask(String string) {
        this.myRouteType = string;
    }

    public void loadRouteFromOOCS(OOCKeyword oOCKeyword, String string) {
        if (this.myTrace) {
            System.out.println("(Route.loadRouteFromOOCS) .....just entered");
        }
        this.myRouteType = string;
        this.myDest = oOCKeyword.getValueOf("destination");
        this.myRouter = oOCKeyword.getValueOf("router");
        this.myMetricCount = oOCKeyword.getValueOf("metric_count");
        this.myMetric = NotebookData.hasValue(this.myMetricCount) ? (this.myMetricCount.equals("1") || this.myMetricCount.equals("2") || this.myMetricCount.equals("3") || this.myMetricCount.equals("4") || this.myMetricCount.equals("5") || this.myMetricCount.equals("6") || this.myMetricCount.equals("7") || this.myMetricCount.equals("8") || this.myMetricCount.equals("9") || this.myMetricCount.equals("10") || this.myMetricCount.equals("11") || this.myMetricCount.equals("12") || this.myMetricCount.equals("13") || this.myMetricCount.equals("14") || this.myMetricCount.equals("15") || this.myMetricCount.equals("16") ? Integer.parseInt(this.myMetricCount) : 1) : 1;
        this.mySubnetMask = oOCKeyword.getValueOf("netmask");
        this.myPipeToNul = oOCKeyword.getValueOf("pipe_to_nul");
        if (this.myTrace) {
            System.out.println("(Route.loadRouteFromOOCS) myRouteType = " + this.myRouteType);
            System.out.println("(Route.loadRouteFromOOCS) myDest = " + this.myDest);
            System.out.println("(Route.loadRouteFromOOCS) myRouter = " + this.myRouter);
            System.out.println("(Route.loadRouteFromOOCS) myMetricCount = " + this.myMetricCount);
            System.out.println("(Route.loadRouteFromOOCS) myMetric = " + this.myMetric);
            System.out.println("(Route.loadRouteFromOOCS) mySubnetMask = " + this.mySubnetMask);
            System.out.println("(Route.loadRouteFromOOCS) myPipeToNul = " + this.myPipeToNul);
        }
    }

    public void saveRouteToOOCS(OOCConfiguration oOCConfiguration, Route route) {
        if (this.myTrace) {
            System.out.println("****** in Route.saveRouteToOOCS");
        }
        if (this.myRouteType.equals("default") || this.myRouteType.equals("Default")) {
            this.kwRoute = oOCConfiguration.createKeyword(0, "default_route", this.myRouter, null);
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) kwRoute(default) = " + this.kwRoute);
            }
            this.myMetricCount = Integer.toString(this.myMetric);
            this.kwMetricCount = this.kwRoute.createKeyword(1, "metric_count", "", null);
            if (NotebookData.hasValue(this.myMetricCount)) {
                if (this.myMetric >= 1) {
                    this.kwMetricCount.setValue(this.myMetricCount);
                }
            } else {
                this.kwMetricCount.setValue("1");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) myMetricCount = " + this.myMetricCount);
            }
            this.kwSubnetMask = this.kwRoute.createKeyword(1, "netmask", "", null);
            if (NotebookData.hasValue(this.mySubnetMask)) {
                this.kwSubnetMask.setValue(this.mySubnetMask);
            } else {
                this.kwRoute.deleteKeyword("netmask", "");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) mySubnetMask = " + this.mySubnetMask);
            }
            this.kwPipeToNul = this.kwRoute.createKeyword(1, "pipe_to_nul", "", null);
            if (this.kwPipeToNul == null) {
                this.kwPipeToNul.setValue("Y");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) myPipeToNul = " + this.myPipeToNul);
                return;
            }
        } else if (this.myRouteType.equals("net") || this.myRouteType.equals("Net")) {
            this.kwRoute = oOCConfiguration.createKeyword(0, "net_route", this.myDest, null);
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) kwRoute(net) = " + this.kwRoute);
            }
            this.kwRouter = this.kwRoute.createKeyword(1, "router", "", null);
            if (NotebookData.hasValue(this.myRouter)) {
                this.kwRouter.setValue(this.myRouter);
            } else {
                this.kwRoute.deleteKeyword("router", "");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) myRouter = " + this.myRouter);
            }
            this.kwMetricCount = this.kwRoute.createKeyword(1, "metric_count", "", null);
            this.myMetricCount = Integer.toString(this.myMetric);
            if (NotebookData.hasValue(this.myMetricCount)) {
                if (this.myMetric >= 1) {
                    this.kwMetricCount.setValue(this.myMetricCount);
                }
            } else {
                this.kwMetricCount.setValue("1");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) myMetricCount = " + this.myMetricCount);
            }
            this.kwSubnetMask = this.kwRoute.createKeyword(1, "netmask", "", null);
            if (NotebookData.hasValue(this.mySubnetMask)) {
                this.kwSubnetMask.setValue(this.mySubnetMask);
            } else {
                this.kwRoute.deleteKeyword("netmask", "");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) mySubnetMask = " + this.mySubnetMask);
            }
            this.kwPipeToNul = this.kwRoute.createKeyword(1, "pipe_to_nul", "", null);
            if (this.kwPipeToNul == null) {
                this.kwPipeToNul.setValue("Y");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) myPipeToNul = " + this.myPipeToNul);
                return;
            }
        } else if (this.myRouteType.equals("host") || this.myRouteType.equals("Host")) {
            this.kwRoute = oOCConfiguration.createKeyword(0, "host_route", this.myDest, null);
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) kwRoute(host) = " + this.kwRoute);
            }
            this.kwRouter = this.kwRoute.createKeyword(1, "router", "", null);
            if (NotebookData.hasValue(this.myRouter)) {
                this.kwRouter.setValue(this.myRouter);
            } else {
                this.kwRoute.deleteKeyword("router", "");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) myRouter = " + this.myRouter);
            }
            this.kwMetricCount = this.kwRoute.createKeyword(1, "metric_count", "", null);
            this.myMetricCount = Integer.toString(this.myMetric);
            if (NotebookData.hasValue(this.myMetricCount)) {
                if (this.myMetric >= 1) {
                    this.kwMetricCount.setValue(this.myMetricCount);
                }
            } else {
                this.kwMetricCount.setValue("1");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) myMetricCount = " + this.myMetricCount);
            }
            this.kwSubnetMask = this.kwRoute.createKeyword(1, "netmask", "", null);
            if (NotebookData.hasValue(this.mySubnetMask)) {
                this.kwSubnetMask.setValue(this.mySubnetMask);
            } else {
                this.kwRoute.deleteKeyword("netmask", "");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) mySubnetMask = " + this.mySubnetMask);
            }
            this.kwPipeToNul = this.kwRoute.createKeyword(1, "pipe_to_nul", "", null);
            if (this.kwPipeToNul == null) {
                this.kwPipeToNul.setValue("Y");
            }
            if (this.myTrace) {
                System.out.println("(Route.saveRouteToOOCS) myPipeToNul = " + this.myPipeToNul);
            }
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myRouteType_tag)) {
                parsedObject = parsedVector.getElement(myRouteType_tag);
                string = (String)parsedObject.getValue();
                this.myRouteType = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myRouter_tag)) {
                parsedObject = parsedVector.getElement(myRouter_tag);
                string = (String)parsedObject.getValue();
                this.myRouter = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myDest_tag)) {
                parsedObject = parsedVector.getElement(myDest_tag);
                string = (String)parsedObject.getValue();
                this.myDest = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(mySubnetMask_tag)) {
                parsedObject = parsedVector.getElement(mySubnetMask_tag);
                string = (String)parsedObject.getValue();
                this.mySubnetMask = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myMetric_tag) && (string = (String)(parsedObject = parsedVector.getElement(myMetric_tag)).getValue()) != null) {
                Integer n2 = Integer.valueOf(string);
                this.myMetric = n2;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BRO_tag);
        stringBuffer.append("," + myRouteType_tag + "=" + this.myRouteType);
        stringBuffer.append("," + myRouter_tag + "=" + this.myRouter);
        stringBuffer.append("," + myDest_tag + "=" + this.myDest);
        stringBuffer.append("," + myMetric_tag + "=" + this.myMetric);
        stringBuffer.append("," + mySubnetMask_tag + "=" + this.mySubnetMask);
        stringBuffer.append("," + ERO_tag);
        return stringBuffer.toString();
    }
}

