/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.NetworkHandler;
import COM.ibm.raleigh.ddnssgui.common.NetworkHandlerUser;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import COM.ibm.raleigh.tcp.tcpcfg2.client.ClientMsg;
import COM.ibm.raleigh.tcp.tcpcfg2.client.HelpHandle;
import COM.ibm.raleigh.tcp.tcpcfg2.client.Tcpcfg2;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Authorize;
import COM.ibm.raleigh.tcp.tcpcfg2.common.BaseProxy;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConfigData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ConnectionStatus;
import COM.ibm.raleigh.tcp.tcpcfg2.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.HostsData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NFSData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookProfile;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ResolvData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SetupData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.SocksData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpstartData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TimedData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcpauth.client_admin_auth;
import java.applet.Applet;
import java.io.InterruptedIOException;
import java.util.ResourceBundle;

public class ServerProxy
extends BaseProxy
implements NetworkHandlerUser {
    private ResourceBundle myBundle;
    public static final String BNB_tag = new String("Bnb");
    public static final String ENB_tag = new String("Enb");
    private static final String DATA_tag = new String("DATA");
    public static final String REBOOT_tag = new String("REBOOT");
    public static final int INITIAL_LOAD = 1;
    public static final int SAVE_NOTEBOOK = 2;
    public static final int GET_LOAD_MESSAGES = 3;
    public static final int PROCESS_LOAD_MESSAGES = 4;
    public static final int DISCONNECT = 5;
    public static final int GET_SAVE_MESSAGES = 6;
    public static final int REBOOT_SERVER = 7;
    private String myHostName;
    private NotebookProfile myProfile;
    private ErrorListController myErrorListController;
    private client_admin_auth myClientAuth;
    private TraceClient myClientTraceClient;
    private NetworkHandler dataOut;
    private boolean myTrace = Utility.isTraceOn();
    private Tcpcfg2 myOwner;
    private boolean connectionFailure = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public ServerProxy() {
        this.myProfile = new NotebookProfile();
    }

    public ServerProxy(Tcpcfg2 tcpcfg2, String string, client_admin_auth client_admin_auth2) {
        this.myOwner = tcpcfg2;
        this.myHostName = string;
        this.myClientAuth = client_admin_auth2;
        this.myBundle = ClientMsg.getBundle();
        if (this.myTrace) {
            System.out.println("In ServerProxy constructor - hostname = " + string);
        }
        if (Utility.isRunningAsApplet()) {
            this.myClientTraceClient = new TraceClient("In constructor - Setting up TraceClient", false, (Applet)this.myOwner, 15223, this.myHostName);
            return;
        }
        this.myClientTraceClient = new TraceClient("ServerProxy", "In constructor - Setting up TraceClient", false, 15223, this.myHostName);
    }

    public boolean connectToServer() {
        int n = 0;
        while (n < 6) {
            this.dataOut = Utility.isRunningAsApplet() ? new NetworkHandler((Applet)this.myOwner, (NetworkHandlerUser)this, 5223, this.myClientTraceClient, this.myHostName) : new NetworkHandler(null, (NetworkHandlerUser)this, 5223, this.myClientTraceClient, this.myHostName);
            if (this.dataOut.socketCreated()) break;
            ++n;
        }
        if (this.dataOut.socketCreated()) {
            this.myProfile = new NotebookProfile();
            return true;
        }
        this.connectionFailure = true;
        this.myOwner.showMessageDialog(this.myBundle.getString("TCPCFG2_CANNOT_CONNECT"));
        return false;
    }

    private void init() {
        this.myProfile = null;
        this.myErrorListController = null;
        this.myClientTraceClient = null;
        this.dataOut = null;
        this.myOwner = null;
    }

    private void initTrace() {
    }

    private void doDropServer() {
        if (this.dataOut != null) {
            this.dataOut.closeStreams();
            this.dataOut = null;
        }
        if (this.myClientTraceClient != null) {
            this.stopTrace();
            this.myClientTraceClient.close();
            this.myClientTraceClient = null;
        }
    }

    private ParsedVector doStream(String string) {
        this.dataOut.sendToServer(string);
        DDNSNetworkStringParser dDNSNetworkStringParser = new DDNSNetworkStringParser(this.dataOut.receiveFromServer(true), this.myClientTraceClient);
        return dDNSNetworkStringParser.getParsed();
    }

    public ErrorListController getErrorListControllerDataHandle() {
        return this.myErrorListController;
    }

    public client_admin_auth getClientAdminAuthHandle() {
        return this.myClientAuth;
    }

    public void shutdown() {
        this.doDropServer();
    }

    public void sendConnectionStatus(ConnectionStatus connectionStatus) {
        this.dataOut.setSocketTimeout(30000);
        connectionStatus.fromString(this.doStream(connectionStatus.toString()));
        HelpHandle.setFileSeparator(connectionStatus.getFileSeparator());
        this.dataOut.setSocketTimeout(0);
    }

    public boolean talkToNetwork(int n) {
        switch (n) {
            case 1: {
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_LOADING_SETUP"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + SetupData.LOAD_ID + "," + ENB_tag + ","));
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_LOADING_SOCKS"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + SocksData.LOAD_ID + "," + ENB_tag + ","));
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_LOADING_CONFIG"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + ConfigData.LOAD_ID + "," + ENB_tag + ","));
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_LOADING_RESOLV"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + ResolvData.LOAD_ID + "," + ENB_tag + ","));
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_LOADING_HOST"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + HostsData.LOAD_ID + "," + ENB_tag + ","));
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_LOADING_TCPSTART"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + TcpstartData.LOAD_ID + "," + ENB_tag + ","));
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_LOADING_USER_ACCESS"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + UserData.LOAD_ID + "," + ENB_tag + ","));
                UserData userData = this.myProfile.getUserDataHandle();
                int n2 = userData.getUsersOnDiskCnt();
                if (this.myTrace) {
                    System.out.println("tmpUdata.getUserEntryListSize() = " + userData.getUserEntryListSize() + " tmpUdata.getUsersOnDiskCnt() = " + userData.getUsersOnDiskCnt());
                }
                if (userData.getUserEntryListSize() != n2) {
                    userData = new UserData();
                    userData.setUsersOnDiskCnt(n2);
                    boolean bl = false;
                    while (!bl) {
                        UserData userData2 = this.myProfile.getUserDataHandle();
                        int n3 = userData2.getUserEntryListSize();
                        int n4 = 0;
                        while (n4 < n3) {
                            userData.addUserEntry(userData2.getUserEntry(n4));
                            ++n4;
                        }
                        if (userData.getUserEntryListSize() != userData.getUsersOnDiskCnt()) {
                            if (this.myTrace) {
                                System.out.println("getting another chunk - userChunk.getUserEntryListSize() = " + userData2.getUserEntryListSize() + " userChunk.getUsersOnDiskCnt() = " + userData2.getUsersOnDiskCnt());
                            }
                            this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + UserData.LOAD_ID + "," + ENB_tag + ","));
                            if (this.myTrace) {
                                System.out.println("got another chunk");
                            }
                        } else {
                            bl = true;
                        }
                        if (!this.myTrace) continue;
                        if (bl) {
                            System.out.println("we are done");
                        } else {
                            System.out.println("we are not done");
                        }
                        System.out.println("Userdata has been loaded - tmpUdata.getUserEntryListSize() = " + userData.getUserEntryListSize() + " tmpUdata.getUsersOnDiskCnt() = " + userData.getUsersOnDiskCnt());
                    }
                    this.myProfile.setUserDataHandle(userData);
                }
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_LOADING_NFS"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + NFSData.LOAD_ID + "," + ENB_tag + ","));
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_LOADING_TIMED"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + TimedData.LOAD_ID + "," + ENB_tag + ","));
                break;
            }
            case 3: {
                this.errorListControllerfromString(this.doStream(String.valueOf(BNB_tag) + "=" + ErrorListController.GET_ID + "," + ENB_tag + ","));
                break;
            }
            case 6: {
                this.errorListControllerfromString(this.doStream(String.valueOf(BNB_tag) + "=" + ErrorListController.GET_ID + "," + ENB_tag + ","));
                break;
            }
            case 4: {
                this.errorListControllerfromString(this.doStream(String.valueOf(BNB_tag) + "=" + ErrorListController.PROCESS_ID + "," + this.myErrorListController.toString() + "," + ENB_tag + ","));
                break;
            }
            case 2: {
                NotebookData notebookData;
                if (this.myProfile.getSetupDataHandle().isUpdated() && this.myTrace) {
                    System.out.println("in ServerProxy - SetupData has been updated!!");
                }
                if (this.myProfile.getConfigDataHandle().isUpdated() && this.myTrace) {
                    System.out.println("in ServerProxy - ConfigData has been updated!!");
                }
                if (this.myProfile.getTcpstartDataHandle().isUpdated() && this.myTrace) {
                    System.out.println("in ServerProxy - TcpstartData has been updated!!");
                }
                if (this.myProfile.getAuthorizeHandle().isUpdated()) {
                    this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_PASSWORD"));
                    notebookData = this.myProfile.getAuthorizeHandle();
                    ((Authorize)notebookData).fromString(this.doStream(((Authorize)notebookData).toString()));
                }
                if (this.myProfile.getSetupDataHandle().isUpdated()) {
                    this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_SETUP"));
                    this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + SetupData.SAVE_ID + "," + this.myProfile.getSetupDataHandle().toString() + "," + ENB_tag + ","));
                }
                if (this.myProfile.getSocksDataHandle().isUpdated()) {
                    this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_SOCKS"));
                    this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + SocksData.SAVE_ID + "," + this.myProfile.getSocksDataHandle().toString() + "," + ENB_tag + ","));
                }
                if (this.myProfile.getConfigDataHandle().isUpdated()) {
                    this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_CONFIG"));
                    this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + ConfigData.SAVE_ID + "," + this.myProfile.getConfigDataHandle().toString() + "," + ENB_tag + ","));
                }
                if (this.myProfile.getResolvDataHandle().isUpdated()) {
                    this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_RESOLV"));
                    this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + ResolvData.SAVE_ID + "," + this.myProfile.getResolvDataHandle().toString() + "," + ENB_tag + ","));
                }
                if (this.myProfile.getHostsDataHandle().isUpdated()) {
                    this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_HOST"));
                    this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + HostsData.SAVE_ID + "," + this.myProfile.getHostsDataHandle().toString() + "," + ENB_tag + ","));
                }
                if (this.myProfile.getTcpstartDataHandle().isUpdated()) {
                    this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_TCPSTART"));
                    this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + TcpstartData.SAVE_ID + "," + this.myProfile.getTcpstartDataHandle().toString() + "," + ENB_tag + ","));
                }
                if (this.myProfile.getUserDataHandle().isUpdated()) {
                    this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_USER_ACCESS"));
                    notebookData = this.myProfile.getUserDataHandle();
                    ((UserData)notebookData).setUsersOnDiskCnt(((UserData)notebookData).getUserEntryListSize());
                    if (((UserData)notebookData).getUsersOnDiskCnt() <= 50) {
                        this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + UserData.SAVE_ID + "," + this.myProfile.getUserDataHandle().toString() + "," + ENB_tag + ","));
                    } else {
                        ((UserData)notebookData).setLastUserLoadedCnt(0);
                        int n5 = 0;
                        int n6 = 0;
                        boolean bl = false;
                        int n7 = 0;
                        while (!bl) {
                            n6 = ((UserData)notebookData).getLastUserLoaded();
                            n7 = ((UserData)notebookData).getUsersOnDiskCnt() - n6;
                            n5 = n7 > 50 ? 50 : n7;
                            UserData userData = new UserData();
                            if (this.myTrace) {
                                System.out.println("SAVE OPERATION remainder = " + n7 + " numberOfUsersToLoad = " + n5 + " lastUserLoaded = " + n6);
                            }
                            int n8 = 0;
                            while (n8 < n5) {
                                userData.addUserEntry(((UserData)notebookData).getUserEntry(n6 + n8));
                                ++n8;
                            }
                            ((UserData)notebookData).setLastUserLoadedCnt(n6 + n5);
                            userData.setUsersOnDiskCnt(((UserData)notebookData).getUsersOnDiskCnt());
                            this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + UserData.SAVE_ID + "," + userData.toString() + "," + ENB_tag + ","));
                            if (this.myTrace) {
                                System.out.println("SAVE OPERATION Creating user chunks from  UserData master - tmpUserData.getLastUserLoaded() = " + ((UserData)notebookData).getLastUserLoaded() + " tmpUserData.getUsersOnDiskCnt() = " + ((UserData)notebookData).getUsersOnDiskCnt());
                            }
                            if (((UserData)notebookData).getLastUserLoaded() == ((UserData)notebookData).getUsersOnDiskCnt()) {
                                bl = true;
                            }
                            if (!this.myTrace) continue;
                            if (bl) {
                                System.out.println("SAVE OPERATION we are done");
                                continue;
                            }
                            System.out.println("SAVE OPERATION we are not done");
                        }
                    }
                }
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_NFS"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + NFSData.SAVE_ID + "," + this.myProfile.getNFSDataHandle().toString() + "," + ENB_tag + ","));
                if (!this.myProfile.getTimedDataHandle().isUpdated()) break;
                this.myOwner.showStatusDialog(this.myBundle.getString("SP_SAVING_TIMED"));
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + TimedData.SAVE_ID + "," + this.myProfile.getTimedDataHandle().toString() + "," + ENB_tag + ","));
                break;
            }
            case 7: {
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=" + REBOOT_tag + "," + ENB_tag + ","));
                this.doDropServer();
                break;
            }
            case 5: {
                this.myProfile.fromString(this.doStream(String.valueOf(BNB_tag) + "=DISCONNECT" + "," + ENB_tag + ","));
                this.doDropServer();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public String getHostName() {
        return this.myHostName;
    }

    public NotebookProfile getNotebookProfileDataHandle() {
        return this.myProfile;
    }

    public void setClientTraceState(boolean bl) {
        this.myClientTraceClient.setTraceState(bl);
    }

    public TraceClient getClientTraceClientHandle() {
        return this.myClientTraceClient;
    }

    public boolean isRebootRequired() {
        return this.myProfile.getSetupDataHandle().isUpdated() || this.myProfile.getConfigDataHandle().isUpdated() || this.myProfile.getTcpstartDataHandle().isUpdated();
    }

    public void startTrace() {
        this.myClientTraceClient.setTraceState(true);
    }

    public void stopTrace() {
        this.myClientTraceClient.setTraceState(false);
    }

    public void trace(String string, String string2) {
        this.myClientTraceClient.traceTime(string, string2);
    }

    public void networkExceptionOccurred(Exception exception) {
        this.connectionFailure = true;
        if (exception instanceof InterruptedIOException) {
            this.myOwner.serverIsDown(this.myBundle.getString("TCPCFG2_CANNOT_CONNECT2"));
        } else {
            this.myOwner.serverIsDown(this.myBundle.getString("CONFIRM_NET_ERROR_EXPLANATION_TEXT"));
        }
        if (this.myTrace) {
            System.out.println("in ServerProxy.networkExceptionOccured " + exception);
            System.out.println("in ServerProxy.networkExceptionOccured - calling shutdown");
        }
        this.myOwner.shutDown();
    }

    public boolean isConnectionFailure() {
        return this.connectionFailure;
    }

    public void errorListControllerfromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(ErrorListController.DATA_ID)) {
                ParsedObject parsedObject = parsedVector.getElement(ErrorListController.DATA_ID);
                ParsedVector parsedVector2 = (ParsedVector)parsedObject.getValue();
                this.myErrorListController = parsedVector2 != null ? new ErrorListController(parsedVector2) : new ErrorListController();
            }
            ++n;
        }
    }
}

