/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCMessageQueue;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCProductInfo;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.LanInterface;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Route;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;

public class SetupData
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BSE_tag = new String("Bse");
    public static final String ESE_tag = new String("Ese");
    public static final String DATA_ID = new String("SETUPDATA");
    public static final String SAVE_ID = new String("SAVE_SETUP_DATA");
    public static final String LOAD_ID = new String("LOAD_SETUP_DATA");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private static final String myIPForwardingState_tag = new String("forward_yn");
    private static final String myLanSelectedIndex_tag = new String("lanSel");
    private static final String myNumOfInterfaces_tag = new String("numOfInter");
    private static final String myNumOfRoutes_tag = new String("numOfRoute");
    private static final String myLan_tag = new String("EMBEDDED_BLA_BELONGS_TO_BSE");
    private static final String myRoute_tag = new String("EMBEDDED_BRO_BELONGS_TO_BSE");
    private OOCProductInfo mySetupProductInfo;
    private OOCProductInfo myDHCPProductInfo;
    private OOCConfiguration mySetupConfiguration;
    private OOCConfiguration myDHCPConfiguration;
    private OOCMessageQueue myMessageQueue;
    private OOCKeyword kwIPForwarding;
    private OOCKeyword kwRoute;
    private OOCKeyword kwDHCPInterface;
    private OOCKeyword kwLoopbackInterface;
    private OOCKeyword kwLanInterface;
    private OOCKeyword kwDefaultRoute;
    private OOCKeyword kwNetRoute;
    private OOCKeyword kwHostRoute;
    private OOCKeyword kwUpdateDNS;
    private OOCKeyword kwDHCPMobile;
    private OOCKeyword kwDHCPUpdateDNS;
    private OOCKeyword kwInterfaceNum;
    private OOCKeyword kwDDNSEnabled;
    private OOCKeyword kwUseDDNS;
    private OOCKeyword kwAutoDHCP;
    private OOCKeyword kwIPAddr;
    private String myIPForwarding;
    private String myDHCPMobile;
    private String myUpdateDNSEnabled;
    private boolean myIPForwardingState = false;
    private boolean myLoadedState = false;
    private boolean myUpdateDNSState = false;
    private boolean myMobileState = true;
    private Vector myLanInterfaceList;
    private Vector mySavedLanInterfaceList;
    private Vector myRouteList;
    private int myLanSelectedIndex;
    private int myNumOfInterfaces;
    private int myNumOfRoutes;
    private int numOfRoutes;
    private String routeType;
    ErrorListController myErrorListController;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();
    private NativeData myNativeData;
    private String myEtcPath;
    private String myMptnBinPath;
    private String setupDatFile;
    private String dhcpDatFile;
    private String logFile;
    private String setupconfigFile;
    private String dhcpconfigFile;
    private String setupbakFile;
    private String dhcpbakFile;
    private static final String setupparseRules = "SETUP_CMD_RULES";
    private static final String dhcpparseRules = "DHCPCD_RULES";
    private boolean noExistingSetupData = false;
    private boolean noExistingDHCPData = false;
    private boolean noSetupProductInfo = false;
    private boolean noDHCPProductInfo = false;
    private boolean already_closed = false;

    SetupData() {
        if (this.myTrace) {
            System.out.println("in SetupData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
    }

    public SetupData(boolean bl, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in SetupData() constructor2");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
        if (bl) {
            this.loadFromOOCS();
        }
    }

    public SetupData(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING SetrupData from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public void addLanInterface(LanInterface lanInterface) {
        this.myLanInterfaceList.addElement(lanInterface);
        this.myNumOfInterfaces = this.getLanInterfaceListSize();
    }

    public void addRoute(Route route) {
        this.myRouteList.addElement(route);
        this.myNumOfRoutes = this.getRouteListSize();
    }

    public void commit() {
        this.mySavedLanInterfaceList.removeAllElements();
        this.mySavedLanInterfaceList = (Vector)this.myLanInterfaceList.clone();
        this.cloneVectorContents(this.myLanInterfaceList, this.mySavedLanInterfaceList);
    }

    public void deCommit() {
        if (this.myLanInterfaceList.size() > 0) {
            this.myLanInterfaceList.removeAllElements();
        }
        this.myLanInterfaceList = (Vector)this.mySavedLanInterfaceList.clone();
        this.cloneVectorContents(this.mySavedLanInterfaceList, this.myLanInterfaceList);
    }

    public void deleteLanInterface(int n) {
        this.myLanInterfaceList.removeElementAt(n);
        this.myNumOfInterfaces = this.getLanInterfaceListSize();
    }

    public void deleteRoute(int n) {
        this.myRouteList.removeElementAt(n);
        this.myNumOfRoutes = this.getRouteListSize();
    }

    public void deleteRouteList() {
        this.myRouteList.removeAllElements();
        this.myNumOfRoutes = 0;
    }

    public LanInterface getLanInterface(int n) {
        return (LanInterface)this.myLanInterfaceList.elementAt(n);
    }

    public int getLanInterfaceListSize() {
        return this.myLanInterfaceList.size();
    }

    public int getLanSelectedIndex() {
        return this.myLanSelectedIndex;
    }

    public Route getRoute(int n) {
        return (Route)this.myRouteList.elementAt(n);
    }

    public int getRouteListSize() {
        return this.myRouteList.size();
    }

    public boolean isIPForwarding() {
        return this.myIPForwardingState;
    }

    public void initCommit() {
        this.mySavedLanInterfaceList = new Vector();
        this.commit();
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of SetupData");
        }
        this.myLanInterfaceList = new Vector();
        this.mySavedLanInterfaceList = new Vector();
        this.commit();
        this.myRouteList = new Vector();
        this.myLanSelectedIndex = 0;
        this.myNumOfInterfaces = 0;
        this.myNumOfRoutes = 0;
        this.myIPForwardingState = false;
        this.myUpdateDNSState = false;
    }

    public void setIPForwarding(boolean bl) {
        this.myIPForwardingState = bl;
    }

    public void setLanSelectedIndex(int n) {
        this.myLanSelectedIndex = n;
    }

    private void loadFromOOCS() {
        NotebookData notebookData;
        int n;
        if (this.myTrace) {
            System.out.println("......in SetupData.loadFromOOCS() of SetupData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        this.myMptnBinPath = NativeData.getMptnBinPath();
        this.setupDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxsetup.dat";
        this.dhcpDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxdhcp.dat";
        this.logFile = String.valueOf(this.myEtcPath) + "tcpcfg2.log";
        this.setupconfigFile = String.valueOf(this.myMptnBinPath) + "setup.cmd";
        this.dhcpconfigFile = String.valueOf(this.myEtcPath) + "dhcpcd.cfg";
        this.setupbakFile = String.valueOf(this.myMptnBinPath) + "setup.nbk";
        this.dhcpbakFile = String.valueOf(this.myEtcPath) + "dhcpcd.nbk";
        this.mySetupProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(SetupData.loadFromOOCS) mySetupProductInfo setupDatFile = " + this.setupDatFile);
        }
        if ((n = this.mySetupProductInfo.create(this.setupDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) mySetupProductInfo.create successful");
            }
            this.mySetupProductInfo.setFileOpenMode(3);
            this.mySetupProductInfo.setFileShareMode(0);
            this.mySetupProductInfo.setProcessingOptions(1, 1, 1);
            this.mySetupProductInfo.setParsingInfo(setupparseRules);
            this.mySetupConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) mySetupConfiguration setupconfigFile = " + this.setupconfigFile);
            }
            if ((n = this.mySetupConfiguration.open(this.mySetupProductInfo, this.setupconfigFile)) == 2) {
                n = this.mySetupConfiguration.open(this.mySetupProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(SetupData.loadFromOOCS) mySetupConfiguration.create successful...no preexisting file");
                }
                this.noExistingSetupData = true;
            }
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) mySetupConfiguration.create successful");
            }
        } else {
            this.noSetupProductInfo = true;
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) ERROR: mySetupProductInfo.create failed");
            }
            Object[] objectArray = new Object[]{this.setupDatFile, "setup.cmd"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            OOCMessageQueue oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(1);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
            return;
        }
        this.mySetupConfiguration.write(this.setupbakFile, 1, 1, 1, 0, setupparseRules);
        this.myMessageQueue = this.mySetupConfiguration.getMsgQ();
        this.myMessageQueue.replaceLogFile(1);
        this.myMessageQueue.setLogFileName(this.logFile);
        this.myMessageQueue.setLogOption(1);
        this.myMessageQueue.logQueue();
        this.mySetupProductInfo.close();
        this.myDHCPProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(SetupData.loadFromOOCS) myDHCPProductInfo dhcpDatFile = " + this.dhcpDatFile);
        }
        if ((n = this.myDHCPProductInfo.create(this.dhcpDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) myDHCPProductInfo.create successful");
            }
            this.myDHCPProductInfo.setFileOpenMode(3);
            this.mySetupProductInfo.setFileShareMode(0);
            this.myDHCPProductInfo.setProcessingOptions(1, 1, 0);
            this.myDHCPProductInfo.setParsingInfo(dhcpparseRules);
            this.myDHCPConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) myDHCPConfiguration dhcpconfigFile = " + this.dhcpconfigFile);
            }
            if ((n = this.myDHCPConfiguration.open(this.myDHCPProductInfo, this.dhcpconfigFile)) == 2) {
                n = this.myDHCPConfiguration.open(this.myDHCPProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(SetupData.loadFromOOCS) myDHCPConfiguration.create successful...no preexisting file");
                }
                this.noExistingDHCPData = true;
            }
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) myDHCPConfiguration.create successful");
            }
        } else {
            this.noDHCPProductInfo = true;
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) ERROR: myDHCPProductInfo.create failed");
            }
            Object[] objectArray = new Object[]{this.dhcpDatFile, "dhcpcd.cfg"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            OOCMessageQueue oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(1);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(SetupData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
            return;
        }
        this.myDHCPConfiguration.write(this.dhcpbakFile, 1, 1, 1, 0, dhcpparseRules);
        this.myMessageQueue = this.myDHCPConfiguration.getMsgQ();
        this.myMessageQueue.replaceLogFile(1);
        this.myMessageQueue.setLogFileName(this.logFile);
        this.myMessageQueue.setLogOption(1);
        this.myMessageQueue.logQueue();
        this.myDHCPProductInfo.close();
        this.kwUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
        if (this.myTrace) {
            System.out.println("(SetupData.loadFromOOCS) kwUpdateDNS = " + this.kwUpdateDNS);
        }
        if (this.kwUpdateDNS == null) {
            this.kwUpdateDNS = this.myDHCPConfiguration.createKeyword(0, "update_dns", "", null);
        }
        this.myUpdateDNSEnabled = this.kwUpdateDNS.getValueOf("enabled");
        this.myUpdateDNSState = this.myUpdateDNSEnabled.equals("Y");
        if (this.myTrace) {
            System.out.println("(SetupData.loadFromOOCS myUpdateDNSEnabled = " + this.myUpdateDNSEnabled);
            System.out.println("(SetupData.loadFromOOCS myUpdateDNSState = " + this.myUpdateDNSState);
        }
        this.kwDHCPInterface = this.myDHCPConfiguration.get("dhcp_interface", "");
        if (this.kwDHCPInterface == null) {
            this.kwDHCPInterface = this.myDHCPConfiguration.createKeyword(0, "dhcp_interface", "", null);
        }
        this.kwDHCPMobile = this.kwDHCPInterface.get("dhcp_mobile", "");
        if (this.kwDHCPMobile == null) {
            this.kwDHCPMobile = this.kwDHCPInterface.createKeyword(1, "dhcp_mobile", "", null);
        }
        this.myDHCPMobile = this.kwDHCPInterface.getValueOf("dhcp_mobile");
        this.myMobileState = this.myDHCPMobile != "N" && NotebookData.hasValue(this.myDHCPMobile);
        if (this.myTrace) {
            System.out.println("(SetupData.loadInterfaceFromOOCS) myDHCPMobile = " + this.myDHCPMobile);
            System.out.println("(SetupData.loadInterfaceFromOOCS) myMobileState = " + this.myMobileState);
        }
        int n2 = 0;
        while (n2 <= 8) {
            switch (n2) {
                case 0: {
                    LanInterface lanInterface = new LanInterface(Cfg2Defines.LAN0_tag);
                    this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "0");
                    if (this.kwLanInterface == null) {
                        this.kwLanInterface = this.mySetupConfiguration.createKeyword(0, "lan_interface", "0", null);
                    }
                    lanInterface.loadInterfaceFromOOCS(this.kwLanInterface, this.kwDHCPInterface, this.myUpdateDNSState, this.myMobileState);
                    this.addLanInterface(lanInterface);
                    break;
                }
                case 1: {
                    notebookData = new LanInterface(Cfg2Defines.LAN1_tag);
                    this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "1");
                    if (this.kwLanInterface == null) {
                        this.kwLanInterface = this.mySetupConfiguration.createKeyword(0, "lan_interface", "1", null);
                    }
                    ((LanInterface)notebookData).loadInterfaceFromOOCS(this.kwLanInterface, this.kwDHCPInterface, this.myUpdateDNSState, this.myMobileState);
                    this.addLanInterface((LanInterface)notebookData);
                    break;
                }
                case 2: {
                    LanInterface lanInterface = new LanInterface(Cfg2Defines.LAN2_tag);
                    this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "2");
                    if (this.kwLanInterface == null) {
                        this.kwLanInterface = this.mySetupConfiguration.createKeyword(0, "lan_interface", "2", null);
                    }
                    lanInterface.loadInterfaceFromOOCS(this.kwLanInterface, this.kwDHCPInterface, this.myUpdateDNSState, this.myMobileState);
                    this.addLanInterface(lanInterface);
                    break;
                }
                case 3: {
                    LanInterface lanInterface = new LanInterface(Cfg2Defines.LAN3_tag);
                    this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "3");
                    if (this.kwLanInterface == null) {
                        this.kwLanInterface = this.mySetupConfiguration.createKeyword(0, "lan_interface", "3", null);
                    }
                    lanInterface.loadInterfaceFromOOCS(this.kwLanInterface, this.kwDHCPInterface, this.myUpdateDNSState, this.myMobileState);
                    this.addLanInterface(lanInterface);
                    break;
                }
                case 4: {
                    LanInterface lanInterface = new LanInterface(Cfg2Defines.LAN4_tag);
                    this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "4");
                    if (this.kwLanInterface == null) {
                        this.kwLanInterface = this.mySetupConfiguration.createKeyword(0, "lan_interface", "4", null);
                    }
                    lanInterface.loadInterfaceFromOOCS(this.kwLanInterface, this.kwDHCPInterface, this.myUpdateDNSState, this.myMobileState);
                    this.addLanInterface(lanInterface);
                    break;
                }
                case 5: {
                    LanInterface lanInterface = new LanInterface(Cfg2Defines.LAN5_tag);
                    this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "5");
                    if (this.kwLanInterface == null) {
                        this.kwLanInterface = this.mySetupConfiguration.createKeyword(0, "lan_interface", "5", null);
                    }
                    lanInterface.loadInterfaceFromOOCS(this.kwLanInterface, this.kwDHCPInterface, this.myUpdateDNSState, this.myMobileState);
                    this.addLanInterface(lanInterface);
                    break;
                }
                case 6: {
                    LanInterface lanInterface = new LanInterface(Cfg2Defines.LAN6_tag);
                    this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "6");
                    if (this.kwLanInterface == null) {
                        this.kwLanInterface = this.mySetupConfiguration.createKeyword(0, "lan_interface", "6", null);
                    }
                    lanInterface.loadInterfaceFromOOCS(this.kwLanInterface, this.kwDHCPInterface, this.myUpdateDNSState, this.myMobileState);
                    this.addLanInterface(lanInterface);
                    break;
                }
                case 7: {
                    LanInterface lanInterface = new LanInterface(Cfg2Defines.LAN7_tag);
                    this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "7");
                    if (this.kwLanInterface == null) {
                        this.kwLanInterface = this.mySetupConfiguration.createKeyword(0, "lan_interface", "7", null);
                    }
                    lanInterface.loadInterfaceFromOOCS(this.kwLanInterface, this.kwDHCPInterface, this.myUpdateDNSState, this.myMobileState);
                    this.addLanInterface(lanInterface);
                    break;
                }
                case 8: {
                    LanInterface lanInterface = new LanInterface(Cfg2Defines.LOOPBACK_tag);
                    this.kwLoopbackInterface = this.mySetupConfiguration.get("loop_back", "");
                    if (this.kwLoopbackInterface == null) {
                        this.kwLoopbackInterface = this.mySetupConfiguration.createKeyword(0, "loop_back", "", null);
                        this.kwIPAddr = this.kwLoopbackInterface.createKeyword(1, "ip_addr", "127.0.0.1", null);
                        this.setUpdated(true);
                    }
                    lanInterface.loadLoopbackInterfaceFromOOCS(this.kwLoopbackInterface);
                    this.addLanInterface(lanInterface);
                    break;
                }
            }
            ++n2;
        }
        this.kwDefaultRoute = this.mySetupConfiguration.get("default_route", "");
        this.routeType = "default";
        this.numOfRoutes = this.mySetupConfiguration.numberOf("default_route");
        if (this.kwDefaultRoute != null) {
            int n3 = 0;
            while (n3 < this.numOfRoutes) {
                notebookData = new Route();
                ((Route)notebookData).loadRouteFromOOCS(this.kwDefaultRoute, this.routeType);
                this.addRoute((Route)notebookData);
                this.kwDefaultRoute = this.kwDefaultRoute.nextOf();
                ++n3;
            }
        }
        this.kwNetRoute = this.mySetupConfiguration.get("net_route", "");
        this.routeType = "net";
        this.numOfRoutes = this.mySetupConfiguration.numberOf("net_route");
        if (this.kwNetRoute != null) {
            int n4 = 0;
            while (n4 < this.numOfRoutes) {
                notebookData = new Route();
                ((Route)notebookData).loadRouteFromOOCS(this.kwNetRoute, this.routeType);
                this.addRoute((Route)notebookData);
                this.kwNetRoute = this.kwNetRoute.nextOf();
                ++n4;
            }
        }
        this.kwHostRoute = this.mySetupConfiguration.get("host_route", "");
        this.routeType = "host";
        this.numOfRoutes = this.mySetupConfiguration.numberOf("host_route");
        if (this.kwHostRoute != null) {
            int n5 = 0;
            while (n5 < this.numOfRoutes) {
                notebookData = new Route();
                ((Route)notebookData).loadRouteFromOOCS(this.kwHostRoute, this.routeType);
                this.addRoute((Route)notebookData);
                this.kwHostRoute = this.kwHostRoute.nextOf();
                ++n5;
            }
        }
        this.kwIPForwarding = this.mySetupConfiguration.get("ip_forwarding", "");
        if (this.kwIPForwarding == null) {
            this.kwIPForwarding = this.mySetupConfiguration.createKeyword(1, "ip_forwarding", "", null);
        }
        this.myIPForwarding = this.kwIPForwarding.getValue();
        this.myIPForwardingState = this.myIPForwarding.equals("Y");
        if (this.myTrace) {
            System.out.println("(SetupData.loadFromOOCS) myIPForwarding = " + this.myIPForwarding);
            System.out.println("(SetupData.loadFromOOCS) myIPForwardingState = " + this.myIPForwardingState);
        }
    }

    public void saveToOOCS() {
        if (this.myTrace) {
            System.out.println("***** in saveToOOCS() of SetupData");
        }
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        if (!this.noSetupProductInfo && !this.noDHCPProductInfo) {
            NotebookData notebookData;
            boolean bl2 = this.myMobileState;
            boolean bl3 = this.myUpdateDNSState;
            String string7 = this.myUpdateDNSEnabled;
            int n2 = 0;
            while (n2 <= 8) {
                switch (n2) {
                    case 0: {
                        LanInterface lanInterface = this.getLanInterface(n2);
                        this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "0");
                        if (this.kwLanInterface != null) {
                            lanInterface.saveInterfaceToOOCS(this.myDHCPConfiguration, this.kwLanInterface, this.kwDHCPInterface, lanInterface, bl2, bl3);
                        }
                        string = this.kwLanInterface.getValueOf("auto_dhcp");
                        string2 = this.kwDHCPInterface.getValueOf("dhcp_mobile");
                        this.kwUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
                        string4 = this.kwUpdateDNS.getValueOf("enabled");
                        break;
                    }
                    case 1: {
                        LanInterface lanInterface = this.getLanInterface(n2);
                        this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "1");
                        if (this.kwLanInterface != null) {
                            lanInterface.saveInterfaceToOOCS(this.myDHCPConfiguration, this.kwLanInterface, this.kwDHCPInterface, lanInterface, bl2, bl3);
                        }
                        string = this.kwLanInterface.getValueOf("auto_dhcp");
                        string2 = this.kwDHCPInterface.getValueOf("dhcp_mobile");
                        this.kwUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
                        string4 = this.kwUpdateDNS.getValueOf("enabled");
                        break;
                    }
                    case 2: {
                        LanInterface lanInterface = this.getLanInterface(n2);
                        this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "2");
                        if (this.kwLanInterface != null) {
                            lanInterface.saveInterfaceToOOCS(this.myDHCPConfiguration, this.kwLanInterface, this.kwDHCPInterface, lanInterface, bl2, bl3);
                        }
                        string = this.kwLanInterface.getValueOf("auto_dhcp");
                        string2 = this.kwDHCPInterface.getValueOf("dhcp_mobile");
                        this.kwUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
                        string4 = this.kwUpdateDNS.getValueOf("enabled");
                        break;
                    }
                    case 3: {
                        LanInterface lanInterface = this.getLanInterface(n2);
                        this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "3");
                        if (this.kwLanInterface != null) {
                            lanInterface.saveInterfaceToOOCS(this.myDHCPConfiguration, this.kwLanInterface, this.kwDHCPInterface, lanInterface, bl2, bl3);
                        }
                        string = this.kwLanInterface.getValueOf("auto_dhcp");
                        string2 = this.kwDHCPInterface.getValueOf("dhcp_mobile");
                        this.kwUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
                        string4 = this.kwUpdateDNS.getValueOf("enabled");
                        break;
                    }
                    case 4: {
                        LanInterface lanInterface = this.getLanInterface(n2);
                        this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "4");
                        if (this.kwLanInterface != null) {
                            lanInterface.saveInterfaceToOOCS(this.myDHCPConfiguration, this.kwLanInterface, this.kwDHCPInterface, lanInterface, bl2, bl3);
                        }
                        string = this.kwLanInterface.getValueOf("auto_dhcp");
                        string2 = this.kwDHCPInterface.getValueOf("dhcp_mobile");
                        this.kwUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
                        string4 = this.kwUpdateDNS.getValueOf("enabled");
                        break;
                    }
                    case 5: {
                        LanInterface lanInterface = this.getLanInterface(n2);
                        this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "5");
                        if (this.kwLanInterface != null) {
                            lanInterface.saveInterfaceToOOCS(this.myDHCPConfiguration, this.kwLanInterface, this.kwDHCPInterface, lanInterface, bl2, bl3);
                        }
                        string = this.kwLanInterface.getValueOf("auto_dhcp");
                        string2 = this.kwDHCPInterface.getValueOf("dhcp_mobile");
                        this.kwUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
                        string4 = this.kwUpdateDNS.getValueOf("enabled");
                        break;
                    }
                    case 6: {
                        LanInterface lanInterface = this.getLanInterface(n2);
                        this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "6");
                        if (this.kwLanInterface != null) {
                            lanInterface.saveInterfaceToOOCS(this.myDHCPConfiguration, this.kwLanInterface, this.kwDHCPInterface, lanInterface, bl2, bl3);
                        }
                        string = this.kwLanInterface.getValueOf("auto_dhcp");
                        string2 = this.kwDHCPInterface.getValueOf("dhcp_mobile");
                        this.kwUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
                        string4 = this.kwUpdateDNS.getValueOf("enabled");
                        break;
                    }
                    case 7: {
                        notebookData = this.getLanInterface(n2);
                        this.kwLanInterface = this.mySetupConfiguration.get("lan_interface", "7");
                        if (this.kwLanInterface != null) {
                            ((LanInterface)notebookData).saveInterfaceToOOCS(this.myDHCPConfiguration, this.kwLanInterface, this.kwDHCPInterface, (LanInterface)notebookData, bl2, bl3);
                        }
                        string = this.kwLanInterface.getValueOf("auto_dhcp");
                        string2 = this.kwDHCPInterface.getValueOf("dhcp_mobile");
                        this.kwUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
                        string4 = this.kwUpdateDNS.getValueOf("enabled");
                        break;
                    }
                    case 8: {
                        LanInterface lanInterface = this.getLanInterface(n2);
                        this.kwLoopbackInterface = this.mySetupConfiguration.get("loop_back", "");
                        if (this.kwLanInterface == null) break;
                        lanInterface.saveLoopbackInterfaceToOOCS(this.kwLoopbackInterface);
                        break;
                    }
                }
                if (string.equals("Y")) {
                    this.kwDHCPUpdateDNS = this.myDHCPConfiguration.get("update_dns", "");
                    this.kwDDNSEnabled = this.kwDHCPUpdateDNS.get("enabled", "");
                    this.kwDHCPInterface = this.myDHCPConfiguration.get("dhcp_interface", "");
                    this.kwDHCPMobile = this.kwDHCPInterface.get("auto_dhcp", "");
                    if (this.kwDHCPMobile == null) {
                        this.kwDHCPMobile = this.kwDHCPInterface.createKeyword(1, "dhcp_mobile", "", null);
                    }
                    this.kwAutoDHCP = this.kwLanInterface.get("auto_dhcp", "");
                    if (this.kwAutoDHCP == null) {
                        this.kwAutoDHCP = this.kwLanInterface.createKeyword(1, "auto_dhcp", "", null);
                    }
                    this.kwInterfaceNum = this.kwDHCPInterface.get("interface_num", "");
                    if (this.kwInterfaceNum == null) {
                        this.kwInterfaceNum = this.kwDHCPInterface.createKeyword(1, "interface_num", "", null);
                    }
                    string6 = this.kwDHCPInterface.getValueOf("interface_num");
                    if (this.myTrace) {
                        System.out.println("(SetupData.saveToOOCS) value of DHCP interface = " + string6);
                    }
                    string5 = string4;
                    string3 = string2;
                    this.kwAutoDHCP.setValue(string);
                    if (this.myTrace) {
                        System.out.println("(SetupData.saveToOOCS) tempAutoDHCP = " + string);
                    }
                    bl = true;
                } else {
                    bl = bl;
                }
                ++n2;
            }
            if (!bl) {
                this.myDHCPConfiguration.deleteKeyword("dhcp_interface", "");
                NativeData.removeDDNSObject();
            } else {
                this.kwInterfaceNum.setValue(string6);
                if (this.myTrace) {
                    System.out.println("(SetupData.saveToOOCS) Interface# = " + string6);
                }
                this.kwDHCPMobile.setValue(string3);
                if (this.myTrace) {
                    System.out.println("(SetupData.saveToOOCS) finalDHCPMobile = " + string3);
                    System.out.println("(SetupData.saveToOOCS) finalUseDDNS (before setValue) = " + string5);
                    System.out.println("(SetupData.saveToOOCS) kwDDNSEnabled (before setValue) = " + this.kwDDNSEnabled);
                }
                this.kwDDNSEnabled.setValue(string5);
                if (this.myTrace) {
                    System.out.println("(SetupData.saveToOOCS) finalUseDDNS = " + string5);
                    System.out.println("(SetupData.saveToOOCS) globalDNSEnabled = " + string7);
                }
                if (string5.equals("Y") && !string5.equals(string7)) {
                    NativeData.createDDNSObject(this.myMptnBinPath);
                }
            }
            this.myNumOfRoutes = this.getRouteListSize();
            if (this.myTrace) {
                System.out.println("(SetupData.saveToOOCS) myNumOfRoutes = " + this.myNumOfRoutes);
            }
            int n3 = this.mySetupConfiguration.numberOf("default_route");
            int n4 = this.mySetupConfiguration.numberOf("net_route");
            int n5 = this.mySetupConfiguration.numberOf("host_route");
            int n6 = 1;
            while (n6 <= n3) {
                this.mySetupConfiguration.deleteKeyword("default_route", "");
                ++n6;
            }
            int n7 = 1;
            while (n7 <= n4) {
                this.mySetupConfiguration.deleteKeyword("net_route", "");
                ++n7;
            }
            int n8 = 1;
            while (n8 <= n5) {
                this.mySetupConfiguration.deleteKeyword("host_route", "");
                ++n8;
            }
            int n9 = 0;
            while (n9 < this.myNumOfRoutes) {
                notebookData = this.getRoute(n9);
                ((Route)notebookData).saveRouteToOOCS(this.mySetupConfiguration, (Route)notebookData);
                ++n9;
            }
            this.kwIPForwarding = this.mySetupConfiguration.get("ip_forwarding", "");
            this.mySetupConfiguration.deleteKeyword("ip_forwarding", "");
            this.kwIPForwarding = this.mySetupConfiguration.createKeyword(1, "ip_forwarding", "", null);
            if (this.myIPForwardingState) {
                this.kwIPForwarding.setValue("Y");
                if (this.myTrace) {
                    System.out.println("(SetupData.saveToOOCS) Setting IP Forwarding on");
                }
            } else {
                this.kwIPForwarding.setValue("N");
                if (this.myTrace) {
                    System.out.println("(SetupData.saveToOOCS) Setting IP Forwarding off");
                }
            }
            if (this.myTrace) {
                System.out.println("(SetupData.saveToOOCS) myIPForwardingState = " + this.myIPForwardingState);
            }
        } else {
            return;
        }
        n = this.mySetupConfiguration.write(this.setupconfigFile, 1, 1, 1, 0, setupparseRules);
        if (n == 1) {
            if (this.myTrace) {
                System.out.println("(SetupData.saveToOOCS) Successful write to setup.cmd");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(SetupData.saveToOOCS) Unsuccessful write to setup.cmd");
            }
            Object[] objectArray = new Object[]{"setup.cmd"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            this.myMessageQueue.logQueue();
        }
        if ((n = this.myDHCPConfiguration.write(this.dhcpconfigFile, 1, 1, 1, 0, dhcpparseRules)) == 1) {
            if (this.myTrace) {
                System.out.println("(SetupData.saveToOOCS) Successful write to dhcpcd.cfg");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(SetupData.saveToOOCS) Unsuccessful write to dhcpcd.cfg");
            }
            Object[] objectArray = new Object[]{"dhcpcd.cfg"};
            TcpError tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            this.myMessageQueue.logQueue();
        }
        this.closeOOCS();
    }

    public void closeOOCS() {
        if (this.already_closed) {
            return;
        }
        this.already_closed = true;
        int n = this.mySetupConfiguration.close();
        int n2 = this.myDHCPConfiguration.close();
        if (this.myTrace) {
            System.out.println("(SetupData.closeOOCS) rc from mySetupConfiguration.close = " + n);
            System.out.println("(SetupData.closeOOCS) rc from myDHCPConfiguration.close = " + n2);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            ParsedVector parsedVector2;
            int n2;
            Integer n3;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myUpdatedState_tag)) {
                parsedObject = parsedVector.getElement(myUpdatedState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    if (n3 == 0) {
                        this.setUpdated(false);
                    } else {
                        this.setUpdated(true);
                    }
                }
            } else if (stringArray[n].equals(myIPForwardingState_tag)) {
                parsedObject = parsedVector.getElement(myIPForwardingState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myIPForwardingState = n3 != 0;
                }
            } else if (stringArray[n].equals(myNumOfInterfaces_tag)) {
                parsedObject = parsedVector.getElement(myNumOfInterfaces_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myNumOfInterfaces = n3;
                    if (this.myNumOfInterfaces > 0) {
                        this.myLanInterfaceList = new Vector(this.myNumOfInterfaces);
                        n2 = 1;
                        while (n2 <= this.myNumOfInterfaces) {
                            parsedObject = parsedVector.get(n + n2);
                            parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.myLanInterfaceList.addElement(new LanInterface(parsedVector2));
                            }
                            ++n2;
                        }
                    } else {
                        this.myLanInterfaceList = new Vector();
                    }
                } else {
                    this.myLanInterfaceList = new Vector();
                }
            } else if (stringArray[n].equals(myNumOfRoutes_tag)) {
                parsedObject = parsedVector.getElement(myNumOfRoutes_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n3 = Integer.valueOf(string);
                    this.myNumOfRoutes = n3;
                    if (this.myNumOfRoutes > 0) {
                        if (this.myTrace) {
                            System.out.println("in SetupData.fromString() Num of routes is > 0");
                        }
                        this.myRouteList = new Vector(this.myNumOfRoutes);
                        n2 = 1;
                        while (n2 <= this.myNumOfRoutes) {
                            parsedObject = parsedVector.get(n + n2);
                            parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.myRouteList.addElement(new Route(parsedVector2));
                            }
                            ++n2;
                        }
                    } else {
                        this.myRouteList = new Vector();
                    }
                } else {
                    this.myRouteList = new Vector();
                }
            } else if (stringArray[n].equals(myLanSelectedIndex_tag) && (string = (String)(parsedObject = parsedVector.getElement(myLanSelectedIndex_tag)).getValue()) != null) {
                n3 = Integer.valueOf(string);
                this.myLanSelectedIndex = n3;
            }
            ++n;
        }
        this.initCommit();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BSE_tag);
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        if (this.myIPForwardingState) {
            stringBuffer.append("," + myIPForwardingState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myIPForwardingState_tag + "=" + 0);
        }
        stringBuffer.append("," + myLanSelectedIndex_tag + "=" + this.myLanSelectedIndex);
        stringBuffer.append("," + myNumOfInterfaces_tag + "=" + String.valueOf(this.myLanInterfaceList.size()));
        Enumeration enumeration = this.myLanInterfaceList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                LanInterface lanInterface = (LanInterface)enumeration.nextElement();
                stringBuffer.append("," + myLan_tag);
                stringBuffer.append("," + lanInterface.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + myNumOfRoutes_tag + "=" + String.valueOf(this.myRouteList.size()));
        enumeration = this.myRouteList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Route route = (Route)enumeration.nextElement();
                stringBuffer.append("," + myRoute_tag);
                stringBuffer.append("," + route.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + ESE_tag);
        return stringBuffer.toString();
    }
}

