/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCMessageQueue;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCProductInfo;
import COM.ibm.raleigh.tcp.tcpcfg2.common.AutostartService;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TcpError;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;

public class TcpstartData
extends NotebookData
implements OOCConstants {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BTC_tag = new String("Btc");
    public static final String ETC_tag = new String("Etc");
    public static final String DATA_ID = new String("TCPSTARTDATA");
    public static final String SAVE_ID = new String("SAVE_TCPSTART_DATA");
    public static final String LOAD_ID = new String("LOAD_TCPSTART_DATA");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private static final String myAutostartService_tag = new String("EMBEDDED_BAU_BELONGS_TO_BTC");
    private static final String myNumOfAutostartServices_tag = new String("num_AS");
    private Vector myAutostartServiceList;
    private Vector mySavedAutostartServiceList;
    private int myAutostartServiceCount;
    ErrorListController myErrorListController;
    private OOCProductInfo myTcpstartProductInfo;
    private OOCProductInfo myInetdProductInfo;
    private OOCConfiguration myTcpstartConfiguration;
    private OOCConfiguration myInetdConfiguration;
    private OOCMessageQueue myMessageQueue;
    private NativeData myNativeData;
    private String myEtcPath;
    private String myTcpipBinPath;
    private String myPMXInstalled;
    private String myNFSInstalled;
    private String tcpstartDatFile;
    private String inetdDatFile;
    private String tcpstartConfigFile;
    private String inetdConfigFile;
    private String tcpstartbakFile;
    private String inetdbakFile;
    private String logFile;
    private static final String tcpstartParseRules = "TCPSTART_RULES";
    private static final String inetdParseRules = "INETD_LST_RULES";
    private OOCKeyword kwServer;
    private OOCKeyword kwInetdService;
    private boolean noExistingTcpstartData = false;
    private boolean noExistingInetdData = false;
    private boolean noTcpstartProductInfo = false;
    private boolean noInetdProductInfo = false;
    private boolean inetdExists = false;
    private boolean telnetdExists = false;
    private boolean ftpdExists = false;
    private boolean tftpdExists = false;
    private boolean rexecdExists = false;
    private boolean timedExists = false;
    private boolean rshdExists = false;
    private boolean lpdExists = false;
    private boolean rotuedExists = false;
    private boolean pmxExists = false;
    private boolean talkdExists = false;
    private boolean portmapExists = false;
    private boolean nfsdExists = false;
    private boolean sendmailExists = false;
    private boolean rsvpdExists = false;
    private boolean syslogdExists = false;
    private boolean lprportdExists = false;
    private boolean routedExists = false;
    private boolean already_closed = false;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();

    public TcpstartData() {
        if (this.myTrace) {
            System.out.println("in TcpstartData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
    }

    public TcpstartData(boolean bl, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in TcpstartData() constructor2");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
        if (bl) {
            this.loadFromOOCS();
        }
    }

    public TcpstartData(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING TcpstartData from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public void addAutostartService(AutostartService autostartService) {
        this.myAutostartServiceList.addElement(autostartService);
        this.myAutostartServiceCount = this.getAutostartServiceListSize();
    }

    public void commit() {
        this.mySavedAutostartServiceList.removeAllElements();
        this.mySavedAutostartServiceList = (Vector)this.myAutostartServiceList.clone();
        this.cloneVectorContents(this.myAutostartServiceList, this.mySavedAutostartServiceList);
    }

    public void deCommit() {
        if (this.myAutostartServiceList.size() > 0) {
            this.myAutostartServiceList.removeAllElements();
        }
        this.myAutostartServiceList = (Vector)this.mySavedAutostartServiceList.clone();
        this.cloneVectorContents(this.mySavedAutostartServiceList, this.myAutostartServiceList);
    }

    public int getAutostartServiceListSize() {
        return this.myAutostartServiceList.size();
    }

    public AutostartService getAutostartService(int n) {
        return (AutostartService)this.myAutostartServiceList.elementAt(n);
    }

    public void initCommit() {
        this.mySavedAutostartServiceList = new Vector();
        this.commit();
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of TcpstartData");
        }
        this.myAutostartServiceList = new Vector();
        this.mySavedAutostartServiceList = new Vector();
        this.myAutostartServiceCount = 0;
        this.myErrorListController = null;
        this.commit();
    }

    public void setAutostartService(int n, AutostartService autostartService) {
        this.myAutostartServiceList.removeElementAt(n);
        this.myAutostartServiceList.insertElementAt(autostartService, n);
        this.myAutostartServiceCount = this.getAutostartServiceListSize();
    }

    private void loadFromOOCS() {
        OOCMessageQueue oOCMessageQueue;
        TcpError tcpError;
        Object object;
        int n;
        if (this.myTrace) {
            System.out.println("in loadFromOOCS() of TcpstartData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        this.myTcpipBinPath = NativeData.getTcpipBinPath();
        this.myPMXInstalled = NativeData.getPMXInstalled();
        this.myNFSInstalled = NativeData.getNFSInstalled();
        this.tcpstartDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxtcpst.dat";
        this.inetdDatFile = String.valueOf(this.myEtcPath) + "dat" + File.separator + "toxinetd.dat";
        this.tcpstartConfigFile = String.valueOf(this.myTcpipBinPath) + "tcpstart.cmd";
        this.inetdConfigFile = String.valueOf(this.myEtcPath) + "inetd.lst";
        this.tcpstartbakFile = String.valueOf(this.myTcpipBinPath) + "tcpstart.nbk";
        this.inetdbakFile = String.valueOf(this.myEtcPath) + "inetd.nbk";
        this.logFile = String.valueOf(this.myEtcPath) + "tcpcfg2.log";
        this.myTcpstartProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(TcpstartData.loadFromOOCS) myTcpstartProductInfo tcpstartDatFile = " + this.tcpstartDatFile);
        }
        if ((n = this.myTcpstartProductInfo.create(this.tcpstartDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(TcpstartData.loadFromOOCS) myTcpstartProductInfo.create successful");
            }
            this.myTcpstartProductInfo.setFileOpenMode(3);
            this.myTcpstartProductInfo.setFileShareMode(0);
            this.myTcpstartProductInfo.setProcessingOptions(1, 1, 1);
            this.myTcpstartProductInfo.setParsingInfo(tcpstartParseRules);
            this.myTcpstartConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(TcpstartData.loadFromOOCS) myTcpstartConfiguration tcpstartonfigFile = " + this.tcpstartConfigFile);
            }
            if ((n = this.myTcpstartConfiguration.open(this.myTcpstartProductInfo, this.tcpstartConfigFile)) == 2) {
                n = this.myTcpstartConfiguration.open(this.myTcpstartProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(TcpstartData.loadFromOOCS) myTcpstartConfiguration.create successful...no preexisting file");
                }
                this.noExistingTcpstartData = true;
            }
            if (this.myTrace) {
                System.out.println("(TcpstartData.loadFromOOCS) myTcpstartConfiguration.create successful");
            }
            this.myTcpstartConfiguration.write(this.tcpstartbakFile, 1, 1, 1, 0, tcpstartParseRules);
            this.myMessageQueue = this.myTcpstartConfiguration.getMsgQ();
            this.myMessageQueue.replaceLogFile(0);
            this.myMessageQueue.setLogFileName(this.logFile);
            this.myMessageQueue.setLogOption(1);
            this.myMessageQueue.logQueue();
            this.myTcpstartProductInfo.close();
        } else {
            this.noTcpstartProductInfo = true;
            if (this.myTrace) {
                System.out.println("(TcpstartData.loadFromOOCS) ERROR: myTcpstartProductInfo.create failed");
            }
            object = new Object[]{this.tcpstartDatFile, "tcpstart.cmd"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), (Object[])object), 1);
            this.myErrorListController.addError(tcpError);
            oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
        }
        this.myInetdProductInfo = new OOCProductInfo();
        if (this.myTrace) {
            System.out.println("(TcpstartData.loadFromOOCS) myInetdProductInfo inetdDatFile = " + this.inetdDatFile);
        }
        if ((n = this.myInetdProductInfo.create(this.inetdDatFile)) == 0) {
            if (this.myTrace) {
                System.out.println("(TcpstartData.loadFromOOCS) myInetdProductInfo.create successful");
            }
            this.myInetdProductInfo.setFileOpenMode(3);
            this.myInetdProductInfo.setFileShareMode(0);
            this.myInetdProductInfo.setProcessingOptions(1, 1, 1);
            this.myInetdProductInfo.setParsingInfo(inetdParseRules);
            this.myInetdConfiguration = new OOCConfiguration();
            if (this.myTrace) {
                System.out.println("(TcpstartData.loadFromOOCS) myTcpstartConfiguration inetdConfigFile = " + this.inetdConfigFile);
            }
            if ((n = this.myInetdConfiguration.open(this.myInetdProductInfo, this.inetdConfigFile)) == 2) {
                n = this.myInetdConfiguration.open(this.myInetdProductInfo, "");
                if (this.myTrace) {
                    System.out.println("(TcpstartData.loadFromOOCS) myInetdConfiguration.create successful...no preexisting file");
                }
                this.noExistingInetdData = true;
            }
            if (this.myTrace) {
                System.out.println("(TcpstartData.loadFromOOCS) myInetdConfiguration.create successful");
            }
            this.myInetdConfiguration.write(this.inetdbakFile, 1, 1, 1, 0, inetdParseRules);
            this.myMessageQueue = this.myInetdConfiguration.getMsgQ();
            this.myMessageQueue.replaceLogFile(0);
            this.myMessageQueue.setLogFileName(this.logFile);
            this.myMessageQueue.setLogOption(1);
            this.myMessageQueue.logQueue();
            this.myInetdProductInfo.close();
        } else {
            this.noInetdProductInfo = true;
            if (this.myTrace) {
                System.out.println("(TcpstartData.loadFromOOCS) ERROR: myInetdProductInfo.create failed");
            }
            object = new Object[]{this.inetdDatFile, "inetd.lst"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_FOUND"), (Object[])object), 1);
            this.myErrorListController.addError(tcpError);
            oOCMessageQueue = OOCMessageQueue.getStaticMsgQ();
            oOCMessageQueue.replaceLogFile(0);
            oOCMessageQueue.setLogFileName(this.logFile);
            oOCMessageQueue.setLogOption(2);
            oOCMessageQueue.logQueue();
            if (this.myTrace) {
                System.out.println("(SocksData.loadFromOOCS) Messages were logged to filename " + this.logFile);
            }
        }
        this.kwServer = this.myTcpstartConfiguration.get("inetd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "inetd");
            this.addAutostartService((AutostartService)object);
            this.inetdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("telnetd", "");
        this.kwInetdService = this.myInetdConfiguration.get("telnetd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, this.kwInetdService, "telnetd");
            this.addAutostartService((AutostartService)object);
            this.telnetdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("ftpd", "");
        this.kwInetdService = this.myInetdConfiguration.get("ftpd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, this.kwInetdService, "ftpd");
            this.addAutostartService((AutostartService)object);
            this.ftpdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("tftpd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "tftpd");
            this.addAutostartService((AutostartService)object);
            this.tftpdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("rexecd", "");
        this.kwInetdService = this.myInetdConfiguration.get("rexecd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, this.kwInetdService, "rexecd");
            this.addAutostartService((AutostartService)object);
            this.rexecdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("rshd", "");
        this.kwInetdService = this.myInetdConfiguration.get("rshd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, this.kwInetdService, "rshd");
            this.addAutostartService((AutostartService)object);
            this.rshdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("lpd", "");
        this.kwInetdService = this.myInetdConfiguration.get("lpd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, this.kwInetdService, "lpd");
            this.addAutostartService((AutostartService)object);
            this.lpdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("lprportd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "lprportd");
            this.addAutostartService((AutostartService)object);
            this.lprportdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("routed", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "routed");
            this.addAutostartService((AutostartService)object);
            this.routedExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("talkd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "talkd");
            this.addAutostartService((AutostartService)object);
            this.talkdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("portmap", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "portmap");
            this.addAutostartService((AutostartService)object);
            this.portmapExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("sendmail", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "sendmail");
            this.addAutostartService((AutostartService)object);
            this.sendmailExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("rsvpd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "rsvpd");
            this.addAutostartService((AutostartService)object);
            this.rsvpdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("syslogd", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "syslogd");
            this.addAutostartService((AutostartService)object);
            this.syslogdExists = true;
        }
        this.kwServer = this.myTcpstartConfiguration.get("timed", "");
        this.kwInetdService = this.myInetdConfiguration.get("timed", "");
        if (this.kwServer != null) {
            object = new AutostartService();
            ((AutostartService)object).loadServerFromOOCS(this.kwServer, this.kwInetdService, "timed");
            this.addAutostartService((AutostartService)object);
            this.timedExists = true;
        }
        if (this.myPMXInstalled.equals("Y")) {
            this.kwServer = this.myTcpstartConfiguration.get("xinit.cmd", "");
            if (this.myTrace) {
                System.out.println("(Tcpstart.loadFromOOCS) PMX = Y");
            }
            if (this.kwServer != null) {
                object = new AutostartService();
                ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "pmx");
                this.addAutostartService((AutostartService)object);
                this.pmxExists = true;
            }
        }
        if (this.myNFSInstalled.equals("Y")) {
            this.kwServer = this.myTcpstartConfiguration.get("nfsd", "");
            if (this.myTrace) {
                System.out.println("(Tcpstart.loadFromOOCS) NFS = Y");
            }
            if (this.kwServer != null) {
                object = new AutostartService();
                ((AutostartService)object).loadServerFromOOCS(this.kwServer, null, "nfsd");
                this.addAutostartService((AutostartService)object);
                this.nfsdExists = true;
            }
        }
        this.commit();
    }

    public void saveToOOCS() {
        TcpError tcpError;
        Object[] objectArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n2 = this.getAutostartServiceListSize();
        if (this.myTrace) {
            System.out.println("in saveToOOCS() of TcpstartData");
            System.out.println("(TcpstartData.saveToOOCS) numberOfEntries = " + n2);
        }
        if (this.inetdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("inetd", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "inetd");
            }
            ++n3;
        }
        if (this.telnetdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("telnetd", "");
            this.kwInetdService = this.myInetdConfiguration.get("telnetd", "");
            if (this.kwInetdService == null) {
                this.kwInetdService = this.myInetdConfiguration.createKeyword(0, "telnetd", "", null);
            }
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, this.kwInetdService, "telnetd");
            }
            ++n3;
        }
        if (this.ftpdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("ftpd", "");
            this.kwInetdService = this.myInetdConfiguration.get("ftpd", "");
            if (this.kwInetdService == null) {
                this.kwInetdService = this.myInetdConfiguration.createKeyword(0, "ftpd", "", null);
            }
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, this.kwInetdService, "ftpd");
            }
            ++n3;
        }
        if (this.tftpdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("tftpd", "");
            this.kwInetdService = this.myInetdConfiguration.get("tftpd", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "tftpd");
            }
            ++n3;
        }
        if (this.rexecdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("rexecd", "");
            this.kwInetdService = this.myInetdConfiguration.get("rexecd", "");
            if (this.kwInetdService == null) {
                this.kwInetdService = this.myInetdConfiguration.createKeyword(0, "rexecd", "", null);
            }
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, this.kwInetdService, "rexecd");
            }
            ++n3;
        }
        if (this.rshdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("rshd", "");
            this.kwInetdService = this.myInetdConfiguration.get("rshd", "");
            if (this.kwInetdService == null) {
                this.kwInetdService = this.myInetdConfiguration.createKeyword(0, "rshd", "", null);
            }
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, this.kwInetdService, "rshd");
            }
            ++n3;
        }
        if (this.lpdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("lpd", "");
            this.kwInetdService = this.myInetdConfiguration.get("lpd", "");
            if (this.kwInetdService == null) {
                this.kwInetdService = this.myInetdConfiguration.createKeyword(0, "lpd", "", null);
            }
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, this.kwInetdService, "lpd");
            }
            ++n3;
        }
        if (this.lprportdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("lprportd", "");
            this.kwInetdService = this.myInetdConfiguration.get("lprportd", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "lprportd");
            }
            ++n3;
        }
        if (this.routedExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("routed", "");
            this.kwInetdService = this.myInetdConfiguration.get("routed", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "routed");
            }
            ++n3;
        }
        if (this.talkdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("talkd", "");
            this.kwInetdService = this.myInetdConfiguration.get("talkd", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "talkd");
            }
            ++n3;
        }
        if (this.portmapExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("portmap", "");
            this.kwInetdService = this.myInetdConfiguration.get("portmap", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "portmap");
            }
            ++n3;
        }
        if (this.sendmailExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("sendmail", "");
            this.kwInetdService = this.myInetdConfiguration.get("sendmail", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "sendmail");
            }
            ++n3;
        }
        if (this.rsvpdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("rsvpd", "");
            this.kwInetdService = this.myInetdConfiguration.get("rsvpd", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "rsvpd");
            }
            ++n3;
        }
        if (this.syslogdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("syslogd", "");
            this.kwInetdService = this.myInetdConfiguration.get("syslogd", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "syslogd");
            }
            ++n3;
        }
        if (this.timedExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("timed", "");
            this.kwInetdService = this.myInetdConfiguration.get("timed", "");
            if (this.kwInetdService == null) {
                this.kwInetdService = this.myInetdConfiguration.createKeyword(0, "timed", "", null);
            }
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, this.kwInetdService, "timed");
            }
            ++n3;
        }
        if (this.myPMXInstalled.equals("Y") && this.pmxExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("xinit.cmd", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "pmx");
            }
            ++n3;
        }
        if (this.myNFSInstalled.equals("Y") && this.nfsdExists) {
            objectArray = this.getAutostartService(n3);
            this.kwServer = this.myTcpstartConfiguration.get("nfsd", "");
            this.kwInetdService = this.myInetdConfiguration.get("nfsd", "");
            if (this.kwServer != null) {
                objectArray.saveServerToOOCS(this.kwServer, null, "nfsd");
            }
            ++n3;
        }
        if ((n = this.myTcpstartConfiguration.write(this.tcpstartConfigFile, 1, 1, 1, 0, tcpstartParseRules)) == 1) {
            if (this.myTrace) {
                System.out.println("(TcpstartData.saveToOOCS) Successful write to tcpstart.cmd");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(TcpstartData.saveToOOCS)  Unsuccessful write to tcpstart.cmd");
            }
            objectArray = new Object[]{"tcpstart.cmd"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            this.myMessageQueue.logQueue();
        }
        if ((n = this.myInetdConfiguration.write(this.inetdConfigFile, 1, 1, 1, 0, inetdParseRules)) == 1) {
            if (this.myTrace) {
                System.out.println("(TcpstartData.saveToOOCS) Successful write to inetd.lst");
            }
        } else {
            if (this.myTrace) {
                System.out.println("(TcpstartData.saveToOOCS) Unsuccessful write to inetd.lst");
            }
            objectArray = new Object[]{"inetd.lst"};
            tcpError = new TcpError(MessageFormat.format(this.myBundle.getString("WARNING_FILE_NOT_WRITTEN"), objectArray), 1);
            this.myErrorListController.addError(tcpError);
            this.myMessageQueue.logQueue();
        }
        this.closeOOCS();
    }

    public void closeOOCS() {
        if (this.already_closed) {
            return;
        }
        this.already_closed = true;
        int n = this.myTcpstartConfiguration.close();
        int n2 = this.myInetdConfiguration.close();
        if (this.myTrace) {
            System.out.println("(TcpstartData.closeOOCS) rc from myTcpstartConfiguration.close = " + n);
            System.out.println("(TcpstartData.closeOOCS) rc from myInetdConfiguration.close = " + n2);
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myNumOfAutostartServices_tag)) {
                parsedObject = parsedVector.getElement(myNumOfAutostartServices_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myAutostartServiceCount = n2;
                    if (this.myAutostartServiceCount > 0) {
                        this.myAutostartServiceList = new Vector(this.myAutostartServiceCount);
                        int n3 = 1;
                        while (n3 <= this.myAutostartServiceCount) {
                            parsedObject = parsedVector.get(n + n3);
                            ParsedVector parsedVector2 = (ParsedVector)parsedObject.getValue();
                            if (parsedVector2 != null) {
                                this.myAutostartServiceList.addElement(new AutostartService(parsedVector2));
                            }
                            ++n3;
                        }
                    } else {
                        this.myAutostartServiceList = new Vector();
                    }
                } else {
                    this.myAutostartServiceList = new Vector();
                }
            } else if (stringArray[n].equals(myUpdatedState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myUpdatedState_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                if (n2 == 0) {
                    this.setUpdated(false);
                } else {
                    this.setUpdated(true);
                }
            }
            ++n;
        }
        this.initCommit();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BTC_tag);
        Enumeration enumeration = this.myAutostartServiceList.elements();
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        stringBuffer.append("," + myNumOfAutostartServices_tag + "=" + String.valueOf(this.myAutostartServiceList.size()));
        while (enumeration.hasMoreElements()) {
            try {
                AutostartService autostartService = (AutostartService)enumeration.nextElement();
                stringBuffer.append("," + myAutostartService_tag);
                stringBuffer.append("," + autostartService.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + ETC_tag);
        return stringBuffer.toString();
    }
}

