/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class TftpEntry
extends NotebookData
implements Cloneable,
OOCConstants,
CloneableItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BTF_tag = new String("Btf");
    public static final String ETF_tag = new String("Etf");
    public static final String myDirectory_tag = new String("tfDir");
    public static final String myDirAccess_tag = new String("tfDirAcc");
    public static final String myHostListCnt_tag = new String("tfHstCnt");
    public static final String myHost_tag = new String("tfHost");
    public static final String READ_ONLY = "R/O";
    public static final String READ_WRITE = "R/W";
    private String myHostNames;
    private String myDirectory;
    private String myReadOnlyBit;
    private String myDirAccess;
    private Vector myHostList;
    private int myHostListCnt;
    private OOCKeyword kwTftpDir;
    private OOCKeyword kwDirectory;
    private OOCKeyword kwHostnames;
    private OOCKeyword kwDirAccess;
    private boolean myTrace = Utility.isTraceOn();

    public TftpEntry() {
        if (this.myTrace) {
            System.out.println("in TftpEntry() constructor");
        }
        this.loadInit();
    }

    public TftpEntry(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING TftpEntry from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public Object clone() {
        if (this.myTrace) {
            System.out.println("in TftpEntry.clone()");
        }
        TftpEntry tftpEntry = new TftpEntry();
        tftpEntry.setDirectory(new String(this.myDirectory));
        tftpEntry.setDirAccess(new String(this.myDirAccess));
        int n = this.getHostListSize();
        int n2 = 0;
        while (n2 < n) {
            tftpEntry.addHost(new String(this.getHost(n2)));
            ++n2;
        }
        if (this.myTrace) {
            System.out.println("leaving TftpEntry.clone()");
        }
        return tftpEntry;
    }

    public void addHost(String string) {
        if (this.myTrace) {
            System.out.println("in TftpEntry.addHost() name = " + string);
        }
        this.myHostList.addElement(string);
        this.myHostListCnt = this.getHostListSize();
    }

    public void changeHost(String string, int n) {
        this.myHostList.setElementAt(string, n);
    }

    public void deleteHost(int n) {
        this.myHostList.removeElementAt(n);
        this.myHostListCnt = this.getHostListSize();
    }

    public void deleteHostList() {
        this.myHostList.removeAllElements();
    }

    public String getDirAccess() {
        return this.myDirAccess;
    }

    public String getDirectory() {
        return this.myDirectory;
    }

    public int getHostListSize() {
        if (this.myTrace) {
            System.out.println("in getHostListSize() of TftpEntry");
            System.out.println("in getHostListSize() size = " + this.myHostList.size());
        }
        return this.myHostList.size();
    }

    public String getHost(int n) {
        return (String)this.myHostList.elementAt(n);
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of TftpEntry");
        }
        this.myDirectory = new String("");
        this.myDirAccess = new String("");
        this.myHostList = new Vector();
        this.myHostListCnt = 0;
    }

    public void setDirAccess(String string) {
        this.myDirAccess = string;
    }

    public void setDirectory(String string) {
        this.myDirectory = string;
    }

    public void setHostListSize(int n) {
        this.myHostListCnt = n;
    }

    public void loadTftpAccessFromOOCS(OOCKeyword oOCKeyword) {
        this.myDirectory = oOCKeyword.getValueOf("directory");
        if (this.myTrace) {
            System.out.println("(TftpEntry.loadTftpAccessFromOOCS) myDirectory = " + this.myDirectory);
        }
        this.myReadOnlyBit = oOCKeyword.getValueOf("read_only");
        this.myDirAccess = this.myReadOnlyBit.equals("Y") ? READ_ONLY : READ_WRITE;
        if (this.myTrace) {
            System.out.println("(TftpEntry.loadTftpAccessFromOOCS) myDirAccess = " + this.myDirAccess);
        }
        this.kwHostnames = oOCKeyword.get("hostname", "");
        while (this.kwHostnames != null) {
            this.myHostNames = this.kwHostnames.getValue();
            if (this.myTrace) {
                System.out.println("(TftpEntry.loadTftpAccessFromOOCS) myHostNames = " + this.myHostNames);
            }
            this.addHost(this.myHostNames);
            this.kwHostnames = this.kwHostnames.nextOf();
        }
    }

    public void saveTftpAccessToOOCS(OOCKeyword oOCKeyword) {
        int n;
        if (NotebookData.hasValue(this.myDirectory)) {
            this.kwDirectory = oOCKeyword.createKeyword(1, "directory", "", null);
            this.kwDirectory.setValue(this.myDirectory);
        }
        if (this.myTrace) {
            System.out.println("(TftpEntry.saveRshAccessToOOCS) myDirectory = " + this.myDirectory);
        }
        if (NotebookData.hasValue(this.myDirAccess)) {
            this.kwDirAccess = oOCKeyword.createKeyword(1, "read_only", "", null);
            if (this.myDirAccess.equals(READ_ONLY)) {
                this.kwDirAccess.setValue("Y");
            } else {
                this.kwDirAccess.setValue("N");
            }
            if (this.myTrace) {
                System.out.println("(TftpEntry.saveTftpAccessToOOCS) myDirAccess = " + this.myDirAccess);
            }
        }
        if ((n = this.getHostListSize()) > 0) {
            this.kwHostnames = oOCKeyword.createKeyword(1, "hostname", "", null);
            this.myHostNames = "";
            int n2 = 0;
            while (n2 < n) {
                this.kwHostnames = oOCKeyword.get("hostname", "");
                this.myHostNames = String.valueOf(this.myHostNames) + " " + this.getHost(n2);
                ++n2;
            }
            this.kwHostnames.setValue(this.myHostNames);
            if (this.myTrace) {
                System.out.println("(TftpEntry.saveTftpAccessToOOCS) myHostNames = " + this.myHostNames);
            }
        }
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myDirAccess_tag)) {
                parsedObject = parsedVector.getElement(myDirAccess_tag);
                string = (String)parsedObject.getValue();
                this.myDirAccess = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myDirectory_tag)) {
                parsedObject = parsedVector.getElement(myDirectory_tag);
                string = (String)parsedObject.getValue();
                this.myDirectory = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(myHostListCnt_tag)) {
                parsedObject = parsedVector.getElement(myHostListCnt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    Integer n2 = Integer.valueOf(string);
                    this.myHostListCnt = n2;
                    if (this.myHostListCnt > 0) {
                        this.myHostList = new Vector(this.myHostListCnt);
                        int n3 = 1;
                        while (n3 <= this.myHostListCnt) {
                            parsedObject = parsedVector.get(n + n3);
                            string = (String)parsedObject.getValue();
                            if (string != null) {
                                this.myHostList.addElement(new String(string));
                            }
                            ++n3;
                        }
                    } else {
                        this.myHostList = new Vector();
                    }
                } else {
                    this.myHostList = new Vector();
                }
            }
            ++n;
        }
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in TftpEntry.toString() ");
        }
        StringBuffer stringBuffer = new StringBuffer(BTF_tag);
        stringBuffer.append("=start");
        stringBuffer.append("," + myDirAccess_tag + "=" + this.myDirAccess);
        stringBuffer.append("," + myDirectory_tag + "=" + this.myDirectory);
        Enumeration enumeration = this.myHostList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("," + myHost_tag + "=" + string.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + myHostListCnt_tag + "=" + String.valueOf(this.myHostList.size()));
        stringBuffer.append("," + ETF_tag);
        stringBuffer.append("=end");
        return stringBuffer.toString();
    }
}

