/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TimedDataLoader;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.NativeData;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.util.ResourceBundle;

public class TimedData
extends NotebookData {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String BTD_tag = new String("Btd");
    public static final String ETD_tag = new String("Etd");
    public static final String DATA_ID = new String("TIMEDDATA");
    public static final String SAVE_ID = new String("SAVE_TIMED_DATA");
    public static final String LOAD_ID = new String("LOAD_TIMED_DATA");
    private static final String myServerPort_tag = new String("sPort");
    private static final String myUpdatedState_tag = new String("updated_yn");
    private static final String myNetworkByteOrderState_tag = new String("nbo");
    private static final String myAdjustToLocalTimeState_tag = new String("adj_yn");
    private int myServerPort = 37;
    private boolean myNetworkByteOrderState = false;
    private boolean myAdjustToLocalTimeState = false;
    private NativeData myNativeData;
    private String myEtcPath;
    ErrorListController myErrorListController;
    private TimedDataLoader myTimedDataLoader;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();

    public TimedData() {
        if (this.myTrace) {
            System.out.println("in ConfigData() constructor");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
    }

    public TimedData(boolean bl, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in ConfigData() constructor2");
        }
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
        if (bl) {
            this.loadFromOOCS();
        }
    }

    public TimedData(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@ CONSRUCTING TimedData from a ParsedVector");
        }
        this.fromString(parsedVector);
    }

    public int getServerPort() {
        return this.myServerPort;
    }

    public boolean isNetworkByteOrder() {
        return this.myNetworkByteOrderState;
    }

    public boolean isAdjustToLocalTime() {
        return this.myAdjustToLocalTimeState;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of TimedData");
        }
        this.myServerPort = 37;
        this.myNetworkByteOrderState = false;
        this.myAdjustToLocalTimeState = false;
        this.myErrorListController = null;
    }

    public void setServerPort(int n) {
        this.myServerPort = n;
    }

    public void setNetworkByteOrder(boolean bl) {
        this.myNetworkByteOrderState = bl;
    }

    public void setAdjustToLocalTime(boolean bl) {
        this.myAdjustToLocalTimeState = bl;
    }

    private void loadFromOOCS() {
        if (this.myTrace) {
            System.out.println("***** in loadFromOOCS() of TimedData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        String string = String.valueOf(this.myEtcPath) + "timed";
        this.myTimedDataLoader = new TimedDataLoader(string, this, this.myErrorListController);
        this.myTimedDataLoader.loadTimed();
    }

    public void saveToOOCS() {
        if (this.myTrace) {
            System.out.println("***** in saveToOOCS() of TimedData");
        }
        this.myEtcPath = NativeData.getEtcPath();
        String string = String.valueOf(this.myEtcPath) + "timed.out";
        this.myTimedDataLoader = new TimedDataLoader(string, this, this.myErrorListController);
        this.myTimedDataLoader.saveTimed();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(myServerPort_tag)) {
                parsedObject = parsedVector.getElement(myServerPort_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.myServerPort = n2;
                }
            } else if (stringArray[n].equals(myNetworkByteOrderState_tag)) {
                parsedObject = parsedVector.getElement(myNetworkByteOrderState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    if (n2 == 0) {
                        this.setNetworkByteOrder(false);
                    } else {
                        this.setNetworkByteOrder(true);
                    }
                }
            } else if (stringArray[n].equals(myAdjustToLocalTimeState_tag)) {
                parsedObject = parsedVector.getElement(myAdjustToLocalTimeState_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    if (n2 == 0) {
                        this.setAdjustToLocalTime(false);
                    } else {
                        this.setAdjustToLocalTime(true);
                    }
                }
            } else if (stringArray[n].equals(myUpdatedState_tag) && (string = (String)(parsedObject = parsedVector.getElement(myUpdatedState_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                if (n2 == 0) {
                    this.setUpdated(false);
                } else {
                    this.setUpdated(true);
                }
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(BTD_tag);
        if (this.myNetworkByteOrderState) {
            stringBuffer.append("," + myNetworkByteOrderState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myNetworkByteOrderState_tag + "=" + 0);
        }
        if (this.myAdjustToLocalTimeState) {
            stringBuffer.append("," + myAdjustToLocalTimeState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myAdjustToLocalTimeState_tag + "=" + 0);
        }
        if (this.isUpdated()) {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myUpdatedState_tag + "=" + 0);
        }
        stringBuffer.append("," + myServerPort_tag + "=" + this.myServerPort);
        stringBuffer.append("," + ETD_tag);
        return stringBuffer.toString();
    }
}

