/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.tcp.tcpcfg2.common.ErrorListController;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TimedData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import COM.ibm.raleigh.tcp.tcpcfg2.server.ServerMsg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class TimedDataLoader {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    ErrorListController myErrorListController;
    private TimedData myTimedData;
    private String myTimedFile;
    private ResourceBundle myBundle;
    private boolean myTrace = Utility.isTraceOn();

    public TimedDataLoader(String string, TimedData timedData, ErrorListController errorListController) {
        if (this.myTrace) {
            System.out.println("in TimedDataLoader() constructor2");
        }
        this.myTimedData = timedData;
        this.myTimedFile = string;
        this.loadInit();
        this.myBundle = ServerMsg.getBundle();
        this.myErrorListController = errorListController;
    }

    private void createLine(TimedData timedData, BufferedWriter bufferedWriter) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("serverport=" + String.valueOf(timedData.getServerPort()));
        this.writeIt(bufferedWriter, stringBuffer.toString());
        stringBuffer = new StringBuffer();
        if (timedData.isNetworkByteOrder()) {
            stringBuffer.append("netbyte=1");
        } else {
            stringBuffer.append("netbyte=0");
        }
        this.writeIt(bufferedWriter, stringBuffer.toString());
        stringBuffer = new StringBuffer();
        if (timedData.isAdjustToLocalTime()) {
            stringBuffer.append("adjust=1");
        } else {
            stringBuffer.append("adjust=0");
        }
        this.writeIt(bufferedWriter, stringBuffer.toString());
    }

    private void writeIt(BufferedWriter bufferedWriter, String string) {
        try {
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.flush();
            bufferedWriter.newLine();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of TimedDataLoader");
        }
        this.myErrorListController = null;
    }

    private void parseTokens(String string) {
        String string2;
        if (this.myTrace) {
            System.out.println("in TimedDataLoader.parseTokens(), text = " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (this.myTrace) {
            System.out.println("s.countTokens() = " + stringTokenizer.countTokens());
        }
        String string3 = null;
        try {
            string3 = stringTokenizer.nextToken();
            if (this.myTrace) {
                System.out.println("0 token = " + string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
        if (!(string3.equalsIgnoreCase("serverport") || string3.equalsIgnoreCase("netbyte") || string3.equalsIgnoreCase("adjust"))) {
            return;
        }
        if (this.myTrace) {
            System.out.println("in TimedDataLoader.parseTokens Server port = " + this.myTimedData.getServerPort());
        }
        if (string3.equalsIgnoreCase("serverport")) {
            if (this.myTrace) {
                System.out.println("setting server port");
            }
            this.myTimedData.setServerPort(Integer.parseInt(stringTokenizer.nextToken()));
        }
        if (this.myTrace) {
            System.out.println("in TimedDataLoader.parseTokens Server port = " + this.myTimedData.getServerPort());
        }
        if (string3.equalsIgnoreCase("netbyte")) {
            string2 = stringTokenizer.nextToken();
            if (string2.compareTo("0") == 0) {
                this.myTimedData.setNetworkByteOrder(false);
            } else {
                this.myTimedData.setNetworkByteOrder(false);
            }
        }
        if (string3.equalsIgnoreCase("adjust")) {
            string2 = stringTokenizer.nextToken();
            if (string2.compareTo("0") == 0) {
                this.myTimedData.setAdjustToLocalTime(false);
                return;
            }
            this.myTimedData.setAdjustToLocalTime(false);
        }
    }

    public void loadTimed() {
        if (this.myTrace) {
            System.out.println("in loadTimed() of TimedDataLoader");
            System.out.println("myTimedFile = " + this.myTimedFile);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.myTimedFile));
            String string = null;
            boolean bl = true;
            while (bl) {
                try {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        bl = false;
                        bufferedReader.close();
                        continue;
                    }
                    this.parseTokens(string);
                }
                catch (IOException iOException) {
                    bl = false;
                    iOException.printStackTrace();
                }
            }
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.myTrace) {
                System.out.println("File not found");
            }
            return;
        }
    }

    public void saveTimed() {
        if (this.myTrace) {
            System.out.println("in saveTimed() of TimedDataLoader");
        }
        try {
            BufferedWriter bufferedWriter = null;
            this.myTimedFile = new String("c:\\mptn\\etc\\timed.out");
            bufferedWriter = new BufferedWriter(new FileWriter(this.myTimedFile));
            this.createLine(this.myTimedData, bufferedWriter);
            bufferedWriter.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

