/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.tcp.tcpcfg2.common.Cfg2Defines;
import COM.ibm.raleigh.tcp.tcpcfg2.common.FtpAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NfsAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.RexecAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.RshEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TelnetAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TftpEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TftpaEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.UserEntry;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.util.Vector;

public class UserDataStreamProcessor
implements Cfg2Defines {
    private UserEntry myUserEntry;
    private TftpEntry myTftpEntry;
    private TftpaEntry myTftpaEntry;
    private RshEntry myRshEntry;
    private FtpAccess myFtpAccess;
    private TelnetAccess myTelnetAccess;
    private NfsAccess myNfsAccess;
    private RexecAccess myRexecAccess;
    private Vector pwHiIntVector;
    private Vector pwLowIntVector;
    private UserData myUserData;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    UserDataStreamProcessor(UserData userData) {
        this.myUserData = userData;
    }

    private int convertToInt(String string) {
        Integer n = Integer.valueOf(string);
        return n;
    }

    private void setNull() {
        this.myUserEntry = null;
        this.myFtpAccess = null;
        this.myTelnetAccess = null;
        this.myNfsAccess = null;
        this.myRexecAccess = null;
    }

    private boolean isTrue(String string) {
        return this.convertToInt(string) == 1;
    }

    public boolean processTag(String string, String string2) {
        if (string.equals(UserEntry.EUE_tag)) {
            this.setNull();
            this.myUserEntry = new UserEntry();
            return true;
        }
        if (string.equals(TftpEntry.ETF_tag)) {
            this.myTftpEntry = new TftpEntry();
            return true;
        }
        if (string.equals(TftpaEntry.ETA_tag)) {
            this.myTftpaEntry = new TftpaEntry();
            return true;
        }
        if (string.equals(RshEntry.ERS_tag)) {
            this.myRshEntry = new RshEntry();
            return true;
        }
        if (string.equals(FtpAccess.EFT_tag)) {
            this.myFtpAccess = new FtpAccess();
            return true;
        }
        if (string.equals(TelnetAccess.ETA_tag)) {
            this.myTelnetAccess = new TelnetAccess();
            return true;
        }
        if (string.equals(NfsAccess.ENA_tag)) {
            this.myNfsAccess = new NfsAccess();
            return true;
        }
        if (string.equals(RexecAccess.ERA_tag)) {
            this.myRexecAccess = new RexecAccess();
            return true;
        }
        if (string2 == null) {
            string2 = new String("");
        }
        if (string.equals(UserEntry.BUE_tag)) {
            if (this.pwLowIntVector != null && this.pwHiIntVector != null) {
                this.myUserEntry.setPassword(Utility.byteFromVector(this.pwHiIntVector, this.pwLowIntVector));
            }
            this.myUserData.addUserEntry(this.myUserEntry);
            this.pwLowIntVector = null;
            this.pwHiIntVector = null;
            return true;
        }
        if (string.equals(TftpEntry.BTF_tag)) {
            this.myUserData.addTftpEntry(this.myTftpEntry);
            return true;
        }
        if (string.equals(TftpaEntry.BTA_tag)) {
            this.myUserData.addTftpaEntry(this.myTftpaEntry);
            return true;
        }
        if (string.equals(RshEntry.BRS_tag)) {
            this.myUserData.addRshEntry(this.myRshEntry);
            return true;
        }
        if (string.equals(FtpAccess.BFT_tag)) {
            this.myUserEntry.setFtpAccess(this.myFtpAccess);
            return true;
        }
        if (string.equals(TelnetAccess.BTA_tag)) {
            this.myUserEntry.setTelnetAccess(this.myTelnetAccess);
            return true;
        }
        if (string.equals(NfsAccess.BNA_tag)) {
            this.myUserEntry.setNfsAccess(this.myNfsAccess);
            return true;
        }
        if (string.equals(RexecAccess.BRA_tag)) {
            this.myUserEntry.setRexecAccess(this.myRexecAccess);
            return true;
        }
        if (string.equals(UserEntry.myUserName_tag)) {
            this.myUserEntry.setUserName(string2);
        } else if (string.equals(UserEntry.myPwLength_tag) || string.equals(UserEntry.myHiByte_tag) || string.equals(UserEntry.myLowByte_tag)) {
            if (string.equals(UserEntry.myPwLength_tag)) {
                this.pwLowIntVector = new Vector(this.convertToInt(string2));
                this.pwHiIntVector = new Vector(this.convertToInt(string2));
            } else if (string.equals(UserEntry.myHiByte_tag)) {
                this.pwHiIntVector.addElement(string2);
            } else if (string.equals(UserEntry.myLowByte_tag)) {
                this.pwLowIntVector.addElement(string2);
            }
        } else if (string.equals(UserEntry.myComment_tag)) {
            this.myUserEntry.setComment(string2);
        } else if (string.equals(UserEntry.myHomeDir_tag)) {
            this.myUserEntry.setHomeDir(string2);
        } else if (string.equals(UserEntry.myUserId_tag)) {
            this.myUserEntry.setUserId(this.convertToInt(string2));
        } else if (string.equals(UserEntry.myGroupId_tag)) {
            this.myUserEntry.setGroupId(this.convertToInt(string2));
        } else if (string.equals(UserEntry.myShellProgram_tag)) {
            this.myUserEntry.setShellProgram(string2);
        } else if (string.equals(UserEntry.myShellParameters_tag)) {
            this.myUserEntry.setShellParameters(string2);
        } else if (string.equals(UserEntry.myConnectState_tag)) {
            this.myUserEntry.setConnectedAfterExit(this.isTrue(string2));
        } else if (string.equals(TftpEntry.myDirectory_tag)) {
            this.myTftpEntry.setDirectory(string2);
        } else if (string.equals(TftpEntry.myDirAccess_tag)) {
            this.myTftpEntry.setDirAccess(string2);
        } else if (string.equals(TftpEntry.myHost_tag)) {
            this.myTftpEntry.addHost(string2);
        } else if (string.equals(TftpaEntry.myAccess_tag)) {
            this.myTftpaEntry.setAccess(string2);
        } else if (string.equals(TftpaEntry.myDirectory_tag)) {
            this.myTftpaEntry.setDirectory(string2);
        } else if (string.equals(TftpaEntry.myAlias_tag)) {
            this.myTftpaEntry.setAlias(string2);
        } else if (string.equals(RshEntry.myHostname_tag)) {
            this.myRshEntry.setHostname(string2);
        } else if (string.equals(RshEntry.myDomainName_tag)) {
            this.myRshEntry.setDomainName(string2);
        } else if (string.equals(RshEntry.myUser_tag)) {
            this.myRshEntry.setUser(string2);
        } else if (string.equals(FtpAccess.myReadDirectories_tag)) {
            this.myFtpAccess.setReadDirectories(string2);
        } else if (string.equals(FtpAccess.myWriteDirectories_tag)) {
            this.myFtpAccess.setWriteDirectories(string2);
        } else if (string.equals(FtpAccess.myEnabledState_tag)) {
            this.myFtpAccess.setEnableUser(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogAllState_tag)) {
            this.myFtpAccess.setLogAll(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogCdState_tag)) {
            this.myFtpAccess.setLogCd(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogDebugState_tag)) {
            this.myFtpAccess.setLogDebug(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogDelState_tag)) {
            this.myFtpAccess.setLogDel(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogDirState_tag)) {
            this.myFtpAccess.setLogDir(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogGetState_tag)) {
            this.myFtpAccess.setLogGet(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogMdState_tag)) {
            this.myFtpAccess.setLogMd(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogPutState_tag)) {
            this.myFtpAccess.setLogPut(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogRdState_tag)) {
            this.myFtpAccess.setLogRd(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myLogRenState_tag)) {
            this.myFtpAccess.setLogRen(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myReadState_tag)) {
            this.myFtpAccess.setRead(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myWriteState_tag)) {
            this.myFtpAccess.setWrite(this.isTrue(string2));
        } else if (string.equals(FtpAccess.myIdleTimeout_tag)) {
            this.myFtpAccess.setIdleTimeout(this.convertToInt(string2));
        } else if (string.equals(TelnetAccess.myEnabledState_tag)) {
            this.myTelnetAccess.setEnableUser(this.isTrue(string2));
        } else if (string.equals(NfsAccess.myEnabledState_tag)) {
            this.myNfsAccess.setEnableUser(this.isTrue(string2));
        } else if (string.equals(NfsAccess.myUIDvalue_tag)) {
            this.myNfsAccess.setUID(string2);
        } else if (string.equals(NfsAccess.myGIDvalue_tag)) {
            this.myNfsAccess.setGID(string2);
        } else if (string.equals(RexecAccess.myEnabledState_tag)) {
            this.myRexecAccess.setEnableUser(this.isTrue(string2));
        }
        return true;
    }
}

