/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.tcp.tcpcfg2.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConfiguration;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCConstants;
import COM.ibm.raleigh.tcp.tcpcfg2.OOC.OOCKeyword;
import COM.ibm.raleigh.tcp.tcpcfg2.common.CloneableItem;
import COM.ibm.raleigh.tcp.tcpcfg2.common.FtpAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NfsAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.NotebookData;
import COM.ibm.raleigh.tcp.tcpcfg2.common.RexecAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.TelnetAccess;
import COM.ibm.raleigh.tcp.tcpcfg2.common.Utility;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;

public class UserEntry
extends NotebookData
implements Cloneable,
OOCConstants,
CloneableItem {
    public static final String BUE_tag = new String("Bue");
    public static final String EUE_tag = new String("Eue");
    public static final String myUserName_tag = new String("ueUname");
    public static final String myPassword_tag = new String("uePw");
    public static final String myComment_tag = new String("ueCom");
    public static final String myHomeDir_tag = new String("ueHDir");
    public static final String myShellProgram_tag = new String("taShPgm");
    public static final String myShellParameters_tag = new String("taShParm");
    public static final String myConnectState_tag = new String("taConnect_yn");
    public static final String myUserId_tag = new String("ueUid");
    public static final String myGroupId_tag = new String("ueGid");
    public static final String myPwLength_tag = new String("pwLen");
    public static final String myHiByte_tag = new String("pwHi");
    public static final String myLowByte_tag = new String("pwLo");
    public static final String myFtpAccess_tag = new String("EMBEDDED_BFT_BELONGS_TO_BUE");
    public static final String myTelnetAccess_tag = new String("EMBEDDED_BTA_BELONGS_TO_BUE");
    public static final String myRexecAccess_tag = new String("EMBEDDED_BRA_BELONGS_TO_BUE");
    public static final String myUID_tag = new String("UID");
    public static final String myGID_tag = new String("GID");
    public static final String myNfsAccess_tag = new String("EMBEDDED_BNA_BELONGS_TO_BUE");
    private static final String myShellProgramDefault = new String("telnetd.cmd");
    private static final String myShellParametersDefault = new String("");
    private static final boolean myConnectStateDefault = false;
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private String myUserName;
    private String myPassword;
    private String myComment;
    private String myHomeDir;
    private int myUserId;
    private int myGroupId;
    private String myShellProgram;
    private String myShellParameters;
    private boolean myConnectState = false;
    private byte[] myEncryptedPw;
    private FtpAccess myFtpAccess;
    private TelnetAccess myTelnetAccess;
    private RexecAccess myRexecAccess;
    private NfsAccess myNfsAccess;
    private String myUID;
    private String myGID;
    private OOCKeyword kwUserid;
    private OOCKeyword kwPassword;
    private OOCKeyword kwComment;
    private OOCKeyword kwHomeDir;
    private OOCKeyword kwFtpd;
    private OOCKeyword kwTelnetd;
    private OOCKeyword kwRexecd;
    private OOCKeyword kwNfsd;
    private OOCKeyword kwUID;
    private OOCKeyword kwGID;
    private OOCKeyword kwShellProgram;
    private OOCKeyword kwShellParameters;
    private OOCKeyword kwDisconnect;
    private MessageDigest messDigest;
    private boolean myTrace = Utility.isTraceOn();

    public UserEntry() {
        if (this.myTrace) {
            System.out.println("in UserEntry() constructor");
        }
        this.initSHA();
        this.loadInit();
    }

    public UserEntry(ParsedVector parsedVector) {
        if (this.myTrace) {
            System.out.println("@@@@@@@@@ CONSRUCTING UserEntry from a ParsedVector");
        }
        this.initSHA();
        this.fromString(parsedVector);
    }

    public Object clone() {
        if (this.myTrace) {
            System.out.println("in UserEntry.clone()");
        }
        UserEntry userEntry = new UserEntry();
        userEntry.setUserName(new String(this.myUserName));
        if (this.myEncryptedPw != null) {
            int n = this.myEncryptedPw.length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = this.myEncryptedPw[n2];
                ++n2;
            }
            userEntry.setPassword(byArray);
        }
        userEntry.setComment(new String(this.myComment));
        userEntry.setHomeDir(new String(this.myHomeDir));
        userEntry.setUserId(this.myUserId);
        userEntry.setGroupId(this.myGroupId);
        userEntry.setShellProgram(new String(this.myShellProgram));
        userEntry.setUID(new String(this.myUID));
        userEntry.setGID(new String(this.myGID));
        userEntry.setShellParameters(new String(this.myShellParameters));
        userEntry.setConnectedAfterExit(this.myConnectState);
        userEntry.setFtpAccess((FtpAccess)this.myFtpAccess.clone());
        userEntry.setTelnetAccess((TelnetAccess)this.myTelnetAccess.clone());
        userEntry.setRexecAccess((RexecAccess)this.myRexecAccess.clone());
        userEntry.setNfsAccess((NfsAccess)this.myNfsAccess.clone());
        return userEntry;
    }

    private byte[] encryptPW(String string) {
        if (this.myTrace) {
            System.out.println("UserEntry.encryptPW()  -- Password in = " + string);
        }
        byte[] byArray = this.messDigest.digest(string.getBytes());
        this.messDigest.reset();
        this.myEncryptedPw = byArray;
        if (this.myTrace) {
            System.out.println("UserEntry.encryptPW() myEncryptedPw = " + this.myEncryptedPw + " messagedigest length = " + this.myEncryptedPw.length);
        }
        return this.myEncryptedPw;
    }

    public void initSHA() {
        block3: {
            try {
                this.messDigest = MessageDigest.getInstance("SHA");
                if (this.myTrace) {
                    System.out.println("UserEntry.initSHA()- Got message digest");
                    return;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!this.myTrace) break block3;
                System.out.println("UserEntry.initSHA()");
            }
        }
    }

    public String getComment() {
        return this.myComment;
    }

    public FtpAccess getFtpAccess() {
        return this.myFtpAccess;
    }

    public int getGroupId() {
        return this.myGroupId;
    }

    public String getHomeDir() {
        return this.myHomeDir;
    }

    public String getShellProgram() {
        return this.myShellProgram;
    }

    public String getUID() {
        return this.myUID;
    }

    public String getGID() {
        return this.myGID;
    }

    public String getShellParameters() {
        return this.myShellParameters;
    }

    public boolean isConnectedAfterExit() {
        return this.myConnectState;
    }

    public RexecAccess getRexecAccess() {
        return this.myRexecAccess;
    }

    public NfsAccess getNfsAccess() {
        return this.myNfsAccess;
    }

    public TelnetAccess getTelnetAccess() {
        return this.myTelnetAccess;
    }

    public int getUserId() {
        return this.myUserId;
    }

    public String getUserName() {
        return this.myUserName;
    }

    private void loadInit() {
        if (this.myTrace) {
            System.out.println("in loadInit() of UserEntry");
        }
        this.myUserName = new String("");
        this.myPassword = new String("");
        this.myComment = new String("");
        this.myHomeDir = new String("");
        this.myUserId = 0;
        this.myGroupId = 0;
        this.myShellProgram = myShellProgramDefault;
        this.myShellParameters = myShellParametersDefault;
        this.myConnectState = false;
        this.myFtpAccess = new FtpAccess();
        this.myTelnetAccess = new TelnetAccess();
        this.myRexecAccess = new RexecAccess();
        this.myNfsAccess = new NfsAccess();
        this.myUID = new String("");
        this.myGID = new String("");
        this.myEncryptedPw = null;
        this.loaded = true;
    }

    public void setComment(String string) {
        this.myComment = string;
    }

    public void setFtpAccess(FtpAccess ftpAccess) {
        this.myFtpAccess = ftpAccess;
    }

    public void setGroupId(int n) {
        this.myGroupId = n;
    }

    public void setHomeDir(String string) {
        this.myHomeDir = string;
    }

    public void setPassword(String string) {
        this.myEncryptedPw = this.encryptPW(string);
        if (this.myTrace) {
            System.out.println("in setPassword, String pass = " + string + " encrypted = " + this.myEncryptedPw);
        }
    }

    public void setPassword(byte[] byArray) {
        this.myEncryptedPw = byArray;
        if (this.myTrace) {
            System.out.println("in setPassword, byte pass = " + byArray + " encrypted = " + this.myEncryptedPw);
        }
    }

    public void setRexecAccess(RexecAccess rexecAccess) {
        this.myRexecAccess = rexecAccess;
    }

    public void setNfsAccess(NfsAccess nfsAccess) {
        this.myNfsAccess = nfsAccess;
    }

    public void setTelnetAccess(TelnetAccess telnetAccess) {
        this.myTelnetAccess = telnetAccess;
    }

    public void setUserId(int n) {
        this.myUserId = n;
    }

    public void setUserName(String string) {
        this.myUserName = string;
    }

    public void setConnectedAfterExit(boolean bl) {
        this.myConnectState = bl;
    }

    public void setShellProgram(String string) {
        this.myShellProgram = string;
        this.updated = true;
    }

    public void setUID(String string) {
        this.myUID = string;
        this.updated = true;
    }

    public void setGID(String string) {
        this.myGID = string;
        this.updated = true;
    }

    public void setShellParameters(String string) {
        this.myShellParameters = string;
        this.updated = true;
    }

    public void loadUserEntryFromOOCS(OOCKeyword oOCKeyword) {
        String string;
        String string2;
        if (this.myTrace) {
            System.out.println("***** in UserEntry.loadUserEntryFromOOCS");
        }
        boolean bl = false;
        this.myUserName = oOCKeyword.getValueOf("userid");
        if (this.myTrace) {
            System.out.println("(UserEntry.loadUserEntryFromOOCS) myUserName = " + this.myUserName);
            System.out.println("attempting - String tmpPassword = kwSrvrusr.getValueOf(=password=)");
        }
        if (NotebookData.hasValue(string2 = oOCKeyword.getValueOf("password"))) {
            if (this.myTrace) {
                System.out.println("tmpPassword has a value = " + string2);
            }
        } else if (this.myTrace) {
            System.out.println("tmpPassword does not have a value = " + string2);
        }
        if (NotebookData.hasValue(string2)) {
            this.kwPassword = oOCKeyword.get("password", "");
            if (this.myTrace) {
                System.out.println("attempting - kwPassword = kwSrvrusr.get(=password=, NullString)");
                System.out.println("DONE - kwPassword = kwSrvrusr.get(=password=, NullString) = " + this.kwPassword);
            }
        } else {
            this.kwPassword = null;
        }
        if (this.kwPassword == null) {
            if (this.myTrace) {
                System.out.println("kwPassword is NULL");
            }
            this.myEncryptedPw = null;
        } else {
            if (this.myTrace) {
                System.out.println("kwPassword is not null");
                System.out.println("attempting - kwPassword.getHexValue(myEncryptedPw, 20)");
            }
            this.myEncryptedPw = new byte[20];
            this.kwPassword.getHexValue(this.myEncryptedPw, 20);
            if (this.myTrace) {
                System.out.println("DONE - kwPassword.getHexValue(myEncryptedPw, 20)");
            }
        }
        this.myUID = oOCKeyword.getValueOf("uid");
        if (this.myTrace) {
            System.out.println("(UserEntry.loadUserEntryFromOOCS) myUID = " + this.myUID);
        }
        this.myGID = oOCKeyword.getValueOf("gid");
        if (this.myTrace) {
            System.out.println("(UserEntry.loadUserEntryFromOOCS) myGID = " + this.myGID);
        }
        this.myComment = oOCKeyword.getValueOf("comment");
        if (!NotebookData.hasValue(this.myComment)) {
            this.myComment = "";
        }
        if (this.myTrace) {
            System.out.println("(UserEntry.loadUserEntryFromOOCS) myComment = " + this.myComment);
        }
        this.myHomeDir = oOCKeyword.getValueOf("homedir");
        if (!NotebookData.hasValue(this.myHomeDir)) {
            this.myHomeDir = "";
        }
        if (this.myTrace) {
            System.out.println("(UserEntry.loadUserEntryFromOOCS) myHomeDir = " + this.myHomeDir);
        }
        if (NotebookData.hasValue(string = oOCKeyword.getValueOf("shell"))) {
            StringTokenizer stringTokenizer;
            String string3;
            if (this.myTrace) {
                System.out.println("(UserEntry.loadUserEntryFromOOCS) shell = " + string);
            }
            if ((string3 = (stringTokenizer = new StringTokenizer(string)).nextToken()).equals("/C")) {
                this.myConnectState = true;
            } else {
                this.myConnectState = false;
                this.myShellProgram = string3;
                bl = true;
            }
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (bl) {
                    this.myShellParameters = String.valueOf(this.myShellParameters) + " " + string3;
                    continue;
                }
                this.myShellProgram = string3;
                bl = true;
            }
        } else {
            this.myConnectState = false;
            this.myShellProgram = "";
            this.myShellParameters = "";
        }
        if (this.myTrace) {
            System.out.println("(TelnetAccess.loadTelnetAccessFromOOCS) myConnectState = " + this.myConnectState);
            System.out.println("(TelnetAccess.loadTelnetAccessFromOOCS) myShellProgram = " + this.myShellProgram);
            System.out.println("(TelnetAccess.loadTelnetAccessFromOOCS) myShellParameters = " + this.myShellParameters);
        }
        this.kwFtpd = oOCKeyword.get("ftpd", "");
        this.myFtpAccess = new FtpAccess();
        this.myFtpAccess.loadFtpAccessFromOOCS(this.kwFtpd);
        this.kwTelnetd = oOCKeyword.get("telnetd", "");
        this.myTelnetAccess = new TelnetAccess();
        this.myTelnetAccess.loadTelnetAccessFromOOCS(this.kwTelnetd);
        this.kwRexecd = oOCKeyword.get("rexecd", "");
        this.myRexecAccess = new RexecAccess();
        this.myRexecAccess.loadRexecAccessFromOOCS(this.kwRexecd);
        this.kwNfsd = oOCKeyword.get("nfsd", "");
        this.myNfsAccess = new NfsAccess();
        this.myNfsAccess.loadNfsAccessFromOOCS(this.kwNfsd);
        this.myNfsAccess.setUID(oOCKeyword.getValueOf("uid"));
        this.myNfsAccess.setGID(oOCKeyword.getValueOf("gid"));
    }

    public void saveUserEntryToOOCS(OOCConfiguration oOCConfiguration, OOCKeyword oOCKeyword) {
        if (this.myTrace) {
            System.out.println("***** in UserEntry.saveUserEntryToOOCS");
        }
        String string = "";
        String string2 = "";
        if (oOCKeyword == null) {
            oOCKeyword = oOCConfiguration.createKeyword(0, "srvrusr", this.myUserName, null);
        }
        if (this.kwUserid == null) {
            this.kwUserid = oOCKeyword.createKeyword(1, "userid", this.myUserName, null);
        } else {
            this.kwUserid = oOCKeyword.get("userid", "");
            this.kwUserid.setValue(this.myUserName);
        }
        if (this.myTrace) {
            System.out.println("(UserEntry.saveUserEntryToOOCS) myUserName = " + this.myUserName);
        }
        if (this.myEncryptedPw != null) {
            if (this.myTrace) {
                System.out.println("In UserEntry.saveToOOCS, myEncryptedPw != null, = " + this.myEncryptedPw);
            }
        } else if (this.myTrace) {
            System.out.println("In UserEntry.saveToOOCS, myEncryptedPw == null, = " + this.myEncryptedPw);
        }
        if (this.kwPassword != null) {
            if (this.myTrace) {
                System.out.println("In UserEntry.saveToOOCS, kwPassword != null, = " + this.kwPassword);
            }
        } else if (this.myTrace) {
            System.out.println("In UserEntry.saveToOOCS, kwPassword == null, = " + this.kwPassword);
        }
        this.kwPassword = oOCKeyword.createKeyword(1, "password", "", null);
        if (this.myEncryptedPw != null) {
            if (this.kwPassword == null) {
                this.kwPassword = oOCKeyword.createKeyword(1, "password", "", null);
                this.kwPassword.setHexValue(this.myEncryptedPw, 20);
            } else {
                this.kwPassword.setHexValue(this.myEncryptedPw, 20);
            }
            if (this.myTrace) {
                System.out.println("myEncryptedPw != null (UserEntry.saveUserEntryToOOCS) myPassword = " + this.myEncryptedPw);
            }
        } else {
            this.myEncryptedPw = new byte[20];
            if (this.kwPassword == null) {
                this.kwPassword = oOCKeyword.createKeyword(1, "password", "", null);
                this.kwPassword.setHexValue(this.myEncryptedPw, 0);
            } else {
                this.kwPassword = oOCKeyword.get("password", "");
                this.kwPassword.setHexValue(this.myEncryptedPw, 0);
            }
            if (this.myTrace) {
                System.out.println("myEncryptedPw == null (UserEntry.saveUserEntryToOOCS) myPassword = " + this.myEncryptedPw);
            }
        }
        if (this.kwComment == null) {
            this.kwPassword = oOCKeyword.createKeyword(1, "comment", this.myComment, null);
        } else {
            this.kwComment = oOCKeyword.get("comment", "");
            this.kwComment.setValue(this.myComment);
        }
        if (this.myTrace) {
            System.out.println("(UserEntry.saveUserEntryToOOCS) myComment = " + this.myComment);
        }
        if (this.kwUID == null) {
            this.kwUID = oOCKeyword.createKeyword(1, "uid", this.myUID, null);
        } else {
            this.kwUID = oOCKeyword.get("uid", "");
            this.kwUID.setValue(this.myUID);
        }
        if (this.myTrace) {
            System.out.println("(UserEntry.saveUserEntryToOOCS) myUID = " + this.myUID);
        }
        if (this.kwGID == null) {
            this.kwGID = oOCKeyword.createKeyword(1, "gid", this.myGID, null);
        } else {
            this.kwGID = oOCKeyword.get("gid", "");
            this.kwGID.setValue(this.myGID);
        }
        if (this.myTrace) {
            System.out.println("(UserEntry.saveUserEntryToOOCS) myGID = " + this.myGID);
        }
        if (this.kwShellProgram == null) {
            this.kwShellProgram = oOCKeyword.createKeyword(1, "shell", "", null);
        }
        if (this.myTrace) {
            System.out.println("(UserEntry.saveUserEntryToOOCS) myConnectState = " + this.myConnectState);
        }
        string = this.myConnectState ? "/C" : "";
        this.kwShellProgram = oOCKeyword.get("shell", "");
        string2 = String.valueOf(string) + " " + this.myShellProgram + " " + this.myShellParameters;
        this.kwShellProgram.setValue(string2);
        if (this.myTrace) {
            System.out.println("(UserEntry.saveUserEntryToOOCS) myConnectState = " + this.myConnectState);
            System.out.println("(UserEntry.saveUserEntryToOOCS) tempConnect = " + string);
            System.out.println("(UserEntry.saveUserEntryToOOCS) myShellProgram = " + this.myShellProgram);
            System.out.println("(UserEntry.saveUserEntryToOOCS) myShellParameters = " + this.myShellParameters);
            System.out.println("(UserEntry.saveUserEntryToOOCS) tempShell = " + string2);
        }
        if (this.kwHomeDir == null) {
            this.kwHomeDir = oOCKeyword.createKeyword(1, "homedir", this.myHomeDir, null);
        } else {
            this.kwHomeDir = oOCKeyword.get("homedir", "");
            this.kwHomeDir.setValue(this.myHomeDir);
        }
        if (this.myTrace) {
            System.out.println("(UserEntry.saveUserEntryToOOCS) myHomeDir = " + this.myHomeDir);
        }
        this.kwFtpd = oOCKeyword.get("ftpd", "");
        FtpAccess ftpAccess = this.getFtpAccess();
        ftpAccess.saveFtpAccessToOOCS(oOCKeyword, this.kwFtpd);
        this.kwTelnetd = oOCKeyword.get("telnetd", "");
        TelnetAccess telnetAccess = this.getTelnetAccess();
        telnetAccess.saveTelnetAccessToOOCS(oOCKeyword, this.kwTelnetd);
        this.kwRexecd = oOCKeyword.get("rexecd", "");
        RexecAccess rexecAccess = this.getRexecAccess();
        rexecAccess.saveRexecAccessToOOCS(oOCKeyword, this.kwRexecd);
        this.kwNfsd = oOCKeyword.get("nfsd", "");
        NfsAccess nfsAccess = this.getNfsAccess();
        nfsAccess.saveNfsAccessToOOCS(oOCKeyword, this.kwNfsd);
    }

    public void fromString(ParsedVector parsedVector) {
    }

    public String toString() {
        if (this.myTrace) {
            System.out.println("in UserEntry.toString() ");
        }
        StringBuffer stringBuffer = new StringBuffer(BUE_tag);
        stringBuffer.append("=start");
        stringBuffer.append("," + myUserName_tag + "=" + this.myUserName);
        stringBuffer.append("," + myComment_tag + "=" + this.myComment);
        stringBuffer.append("," + myHomeDir_tag + "=" + this.myHomeDir);
        stringBuffer.append("," + myUserId_tag + "=" + this.myUserId);
        stringBuffer.append("," + myGroupId_tag + "=" + this.myGroupId);
        stringBuffer.append("," + myShellProgram_tag + "=" + this.myShellProgram);
        stringBuffer.append("," + myShellParameters_tag + "=" + this.myShellParameters);
        stringBuffer.append("," + myUID_tag + "=" + this.myUID);
        stringBuffer.append("," + myGID_tag + "=" + this.myGID);
        if (this.myConnectState) {
            stringBuffer.append("," + myConnectState_tag + "=" + 1);
        } else {
            stringBuffer.append("," + myConnectState_tag + "=" + 0);
        }
        stringBuffer.append("," + this.myFtpAccess.toString());
        stringBuffer.append("," + this.myTelnetAccess.toString());
        stringBuffer.append("," + this.myRexecAccess.toString());
        stringBuffer.append("," + this.myNfsAccess.toString());
        if (this.myEncryptedPw != null) {
            int n;
            int n2 = n = this.myEncryptedPw.length - 1;
            while (n2 >= 0) {
                stringBuffer.append("," + myHiByte_tag + "=" + Utility.byteHighLowValue(this.myEncryptedPw[n2], true));
                --n2;
            }
            int n3 = n;
            while (n3 >= 0) {
                stringBuffer.append("," + myLowByte_tag + "=" + Utility.byteHighLowValue(this.myEncryptedPw[n3], false));
                --n3;
            }
            stringBuffer.append("," + myPwLength_tag + "=" + this.myEncryptedPw.length);
        }
        stringBuffer.append("," + EUE_tag);
        stringBuffer.append("=end");
        if (this.myTrace) {
            System.out.println("UserEntry.toString() = " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

